#include	<u.h>
#include	<libc.h>
#include	<libg.h>

/*
 * Note that the `cwidth' field in Fontchar is used in this
 * program with it original Plan 9 `x' semantic
 */

#define XA__P9_SUBFONT_OFFSET "_P9_SUBFONT_OFFSET"

int		_unpackinfo(Fontchar *, uchar *, int);
int		main(int, char*[]);
void		ereshaped(Rectangle);

int		maxw;
int		minchar, height, ascent, n, defaultchar;
Fontchar	*info;
Bitmap		*b;

int
_unpackinfo(Fontchar *i, char *p, int n)
{
	int j;
	int empty;

	maxw = 0;
	empty = 0;
	for(j=0; j<=n; j++,i++,p+=6){
		i->cwidth = BGSHORT(p);
		i->top = p[2];
		i->bottom = p[3];
		i->left = ((signed char *)p)[4];
		i->width = p[5];
		if (i->width > maxw)
			maxw = i->width;
		if (j && i->cwidth == i[-1].cwidth)
			empty++;
	}
	return empty;
}

int
main(int argc, char *argv[])
{
	int		fd;
	char		*_btmp, hdr[50], *_cbuf;
	int		i, j, k, l;
	Bitmap		*c;
	Fontchar	*fc;
	int		empty;
	int		offset;

	if (argc != 3)
	{
		fprintf(stderr, "usage: p9sftobdf font-name min-char\n");
		exit(1);
	}

	xtbinit(0, 0, &argc, argv, 0);
	
	fd = 0;
	b = rdbitmapfile(fd);
	if (read(fd, hdr, 3*12) != 3*12)
		berror("subfont header");
	n = atoi(hdr);
	_btmp = malloc(6*(n+1));
	if (read(fd, _btmp, 6*(n+1)) != 6*(n+1))
		berror("subfont metrics");
	info = malloc(sizeof(Fontchar)*(n+1));
	if (info == 0)
		berror("p9sftobdf malloc");
	empty = _unpackinfo(info, _btmp, n);
	height = atoi(hdr+12);
	ascent = atoi(hdr+24);
	minchar = strtol(argv[2], NULL, 0);
	c = balloc(Rect(0, 0, maxw, height), 0);
	l = (maxw-1)/8+1;
	_cbuf = malloc(height*l);

	defaultchar = -1;
	for (i = minchar, fc = info; i < minchar+n; i++, fc++)
		if (fc->cwidth != (fc+1)->cwidth)
		{
			defaultchar = i;
			break;
		}
	offset = defaultchar - minchar;

	printf("STARTFONT 2.1\n");
	printf("FONT %s\n", argv[1]);
	printf("SIZE %d 72 72\n", height);
	printf("FONTBOUNDINGBOX %d %d 0 %d\n", maxw, height, -(height-ascent));
	printf("STARTPROPERTIES 4\n");
	printf("FONT_DESCENT %d\n", height - ascent);
	printf("FONT_ASCENT %d\n", ascent);
	printf("DEFAULT_CHAR %d\n", (defaultchar == -1)?minchar:defaultchar);
/*
	printf("%s %d\n", XA__P9_SUBFONT_OFFSET, offset);
*/
	printf("ENDPROPERTIES\n");

	printf("CHARS %d\n", n-empty);
	for (i = minchar, fc = info; i < minchar+n; i++, fc++) {
		if ((fc+1)->cwidth-fc->cwidth == 0) {
			if (i == defaultchar) {
				printf("STARTCHAR PJW\n");
				printf("ENCODING %d\n", minchar);
				printf("SWIDTH 562 0\n");
				printf("DWIDTH 9 0\n");
				printf("BBX 9 %d 0 %d\n",
						height, -(height-ascent));
				printf("BITMAP\n");
				for (j = 0; j < ascent - 12; j++)
					printf("0000\n");
				printf("1800\n");
				printf("3e00\n");
				printf("0f00\n");
				printf("8700\n");
				printf("ff00\n");
				printf("8f00\n");
				printf("0f00\n");
				printf("1f00\n");
				printf("0e00\n");
				printf("1c00\n");
				printf("1c00\n");
				printf("0000\n");
				for (j = 0; j < height - ascent; j++)
					printf("0000\n");
				printf("ENDCHAR\n");
			}
			continue;
		}
		printf("STARTCHAR ch-%d\n", i);
		printf("ENCODING %d\n", i);
		printf("SWIDTH %d 0\n", fc->width*1000/height);
		printf("DWIDTH %d 0\n", fc->width);
		printf("BBX %d %d %d %d\n",
			(fc+1)->cwidth-fc->cwidth, height, fc->left, -(height-ascent));
		printf("BITMAP\n");
		bitblt(c, c->r.min, c, c->r, Zero);
		bitblt(c, Pt(0, fc->top),
				b, Rect(fc->cwidth, fc->top, (fc+1)->cwidth, fc->bottom), S);
		bitblt(&screen, Pt(16, 16), c, c->r, S); 
		bflush();
		rdbitmap(c, 0, height, _cbuf);
		for (j = 0; j < height; j++)
		{
			for (k = 0; k < l; k++)
				printf("%02x", _cbuf[j*l+k]);
			printf("\n");
		}
		printf("ENDCHAR\n");
		bflush();
	}
	printf("ENDFONT\n");
	fprintf(stderr, "[ %d + %d = %d @ 0x%x ]\n",
			n-empty, empty, n, minchar);
}

void
ereshaped(Rectangle r)
{
}
