	;
	; Generate TECO V35.
	;
	.;**-
	.;	Module name: TECGEN - GENERATE TECO
	.;
	.;	Version X01.01	Last edit: 01-OCT-80 16:49
	.;	Status: Development/Debugging
	.;
	.;	Revision history:
	.;
	.;		Version X01.00 12-MAR-80 08:10 - 10-SEP-80 11:00
	.;		Created by: K.J. CROSS
	.;
	.;		Version X01.01 10-SEP-80 11:00 - 01-OCT-80 16:49
	.;		Modified by: KJC
	.;		FIXED MINOR BUG. ADDED "FAKE" LOGIC.
	.;
	.;**-
	.ENABLE	SUBSTITUTION
	.ENABLE	GLOBAL
	.;
	.; SAVE STARTING SY: AND UIC
	.;
	.SETS	OLDSY	<SYDISK>+"'<SYUNIT>'"+":"
	.SETS	OLDUIC	<UIC>
	.;
	.; CHECK TO SEE IF WE'RE PRIVILEGED
	.;
	;
	; The following command will fail if your terminal isn''t privileged.
	;
	.SETF	PRIV
	TIM '<DATE>'
	.IF	<EXSTAT> EQ 1	.SETT	PRIV
	;
	; If you have already transferred all the files from tape to disk,
	; answer "NL:" to the following question.
	;
.50:	.ASKS	$INDEV What device is the distribution tape on
	.PARSE	$INDEV	":"	$INDEV	X
	.SETS	X	$INDEV[1:2]
	.SETF	FAKE
	.IF	X = "NL"	.SETT	FAKE
	.IFLOA	'X':	.GOTO	200
	;
	; 'X': is not a valid device - try again.
	;
	.GOTO	50

.200:	.SETS	$INDEV	$INDEV+":"
	.ASK Y Do you want to generate TECO [Y] or just get command files [N]
	.IFF	Y	.GOTO	2000
	.IFT	PRIV	.GOTO	1000
.999:	;
	; Your terminal must be privileged to continue - sorry.
	;
	.GOTO	9999

.1000:	.IFT	FAKE	.GOTO	1050
	.IFF	FAKE	.IFNINS	FLX	INS $FLX
	.IFF	FAKE	.IFINS	FLX	.GOTO	1050
	;
	; FLX must be installed to continue - install it and start again.
	;
	.GOTO	9999

.1050:	.IFF	FAKE	SET /UIC=[43,10]
	.IFF	FAKE	UFD SY:[43,10]
	;
	; The standard distributed version of TECO includes the following:
	;
	;	1.  VTEDIT not automatically started for CRT's.
	;	2.  Memory (TECF00.TMP) is enabled.
	;	3.  Automatic module updating is enabled.
	;	4.  Not linked to any resident libraries (if you
	;	    continue with the TECGEN, then the task builder
	;	    will link TECO to an FCSRES if it''s available).
	;
	; The distributed version of TECO.INI does the following:
	;
	;	1.  Disables automatic file creation.
	;	2.  Sets the edit search flag to 94ES.
	;	3.  Disables module updating for selected UIC's.
	;	4.  Converts commands of the form "TEV ..." to
	;		"TEC .../VT" (TECO is installed with /TASK=...TEV).
	;	5.  If no file type is specified, tries various file
	;		extensions (i.e., .FLE, .FTN, .CMD, .MAC, etc.)
	;
	; The following features are not changable:
	;
	;	1.  The /AL switch is no longer supported.
	;	2.  The CRT scope routines are included (they can
	;		be removed by modifying the ODL file).
	;	3.  It is assumed that the CPU has EIS.
	;	4.  "EIfilspec" default to LB:[201,5] for device and UIC.
	;
	.ASK	Y Is the standard version satisfactory
	.IFT	Y	.GOTO	1300
	.SETS	BLDTYP	"BLD"
	.SETT	EDIT
	.TESTFILE LB:[1,1]FCSRES.STB
	.IF	<FILERR> NE 1	.GOTO	1150
	.ASK	Y Use FCSRES
 	.IFF	Y	.GOTO	1150
	.SETS	BLDTYP	"FCS"
	.ASK	Y Is the only change to link to FCSRES
	.IFT	Y	.SETF	EDIT
.1150:	.IFT	FAKE	.GOTO	1160
	FLX ='$INDEV'[43,10]TEC'BLDTYP'.CMD,TEC'BLDTYP'.ODL,TEC.OLB,PIPUTL.OLB
.1160:	.IFF	EDIT	.GOTO	1200
	;
	; Edit file TEC'BLDTYP'.CMD to reflect your choice of options.
	.PAUSE
.1200:	.;
	.; BUILD TECO
	.;
.1210:	SET /UIC=[1,54]
	.TESTFILE	LB:[0,0]001054.DIR
	.IF	<FILERR> NE 1	UFD LB:[1,54]
	.ASKS	X Delete [D] or Purge [P] old TECO task images (<CR>=neither)
	.IF	X EQ "D"	.GOTO	1250
	.IF	X EQ "P"	.GOTO	1260
	.IF	X EQ ""		.GOTO	1270
	.GOTO	1210

.1250:	PIP LB:[1,54]TEC.TSK;*/DE/NM/LD
	.GOTO	1270

.1260:	PIP LB:[1,54]TEC.TSK/PU/NM/LD

.1270:	ASN NL:=MP:
	ASN LB:=TK:
	.TESTFILE	LB:[1,1]SYSLIB.OLB
	.IF	<FILERR> EQ 1	.GOTO	1275
	;
	; LB:[1,1]SYSLIB.OLB not found - operation terminated.
	;
	.GOTO	2000

.1275:	.IFF	FAKE	TKB @[43,10]TEC'BLDTYP'
	.IFT	FAKE	TKB @'OLDUIC'TEC'BLDTYP'
	.IF	<EXSTAT> NE 1	.GOTO	1990
	.GOTO	1350

	.;
	.; JUST GET THE TASK IMAGE FROM THE TAPE.
	.;
.1300:	.IF	<UIC> NE "[1,54]"	SET /UIC=[1,54]
	.TESTFILE	LB:[0,0]001054.DIR
	.IF	<FILERR> NE 1	UFD LB:[1,54]
	.IFF	FAKE	FLX LB:[1,54]/CO/BL:84.='$INDEV'[43,10]TEC.TSK

.1350:	.ASK	INSTL Install TEC, TEV, MAK and MUN
	.IFF	INSTL	.GOTO	1999
.ASK	INSTLX Install TEC, TEV, MAK, and MUN in saved system image via VMR
	.IFT	INSTLX	.OPEN	LB:[1,54]TECINS.CMD
	.IFT	INSTLX	.DATA RSX11M
	.IFT	INSTLX	.IFINS	TEC	.DATA REM TEC
	.IFINS	TEC	REM TEC
	.IFT	INSTLX	.DATA INS LB:TEC/TASK=...TEC/PRI=55.
	INS $TEC/TASK=...TEC/PRI=55.
	.IFT	INSTLX	.IFINS	TEV	.DATA REM TEV
	.IFINS	TEV	REM TEV
	.IFT	INSTLX	.DATA INS LB:TEC/TASK=...TEV/PRI=55.
	INS $TEC/TASK=...TEV/PRI=55.
	.IFT	INSTLX	.IFINS	MAK	.DATA REM MAK
	.IFINS	MAK	REM MAK
	.IFT	INSTLX	.DATA INS LB:TEC/TASK=...MAK/PRI=55.
	INS $TEC/TASK=...MAK/PRI=55.
	.IFT	INSTLX	.IFINS	MUN	.DATA REM MUN
	.IFINS	MUN	REM MUN
	.IFT	INSTLX	.DATA INS LB:TEC/TASK=...MUN/PRI=50.
	INS $TEC/TASK=...MUN/PRI=50.
	.IFT	INSTLX	.CLOSE
	.IFF	INSTLX	.GOTO	1999
	.SETF	Y
	.IFINS	VMR	.SETT	Y
	.IFF	Y	INS $VMR
	.IFINS	VMR	.GOTO	1250
	;
	; Can''t install VMR - bypassing installation in saved system image.
	;
	.GOTO	1999

.1250:	ASN LB:=SY:
	VMR @TECINS
	PIP TECINS.CMD;*/DE
	ASN 'OLDSY'=SY:
	.IFF	Y	REM VMR
	.GOTO	1999

.1990:	;
	; Task build failed - installation aborted.
	;
.1999:
.2000:	.ASK	Y Get TECO macro files and general-purpose command files
	.IFF	Y	.GOTO	9999
	;
	; All files will be copied.  It is left to the discretion of
	; the system manager what files are needed for each installation.
	; The ".TES" files are the source files to the ".TEC" files.
	;
	; The .TEC files take about 170. blocks on LB:.  The .TES files
	; take an additional 200. blocks.  Any older versions of the files
	; will be deleted before they are transferred.
	;
	SET /UIC='OLDUIC'
	.SETS	X	OLDUIC[1:4]
	.IF	X EQ "[201"	.GOTO	2200
	.IFT	PRIV	.GOTO	2100
	;
	; Sorry - must be privileged or logged onto a [201,*] account.
	;
	.GOTO	9999

.2100:	.TESTFILE	LB:[0,0]201001.DIR
	.IF	<FILERR> EQ 1	.GOTO	2001
	UFD LB:[201,1]
.2001:
	.TESTFILE	LB:[0,0]201005.DIR
	.IF	<FILERR> EQ 1	.GOTO	2005
	UFD LB:[201,5]
.2005:
.2200:	SET /UIC=[201,1]
	ASN LB:=SY:
	.IFF	FAKE	.GOTO	2300
	;
	; TECO is set up to look for indirect command files in LB:[201,1].
	; If you want to use this feature, copy all you .TEC files there.
	;
	.GOTO	9999

.2300:	FLX LB:='$INDEV'[43,10]FILCOP.CMD
	@FILCOP
	.IF	<EXSTAT> NE 1	.GOTO	9999
	PIP LB:[201,1]FILCOP.CMD;*/DE
.9999:	SET /UIC='OLDUIC'
	ASN 'OLDSY'=SY:
