/*****************************************************************************
	DChars.h

	This header file defines identifiers for control characters.
*****************************************************************************/

#define CTRL_A	'\001'		/* SOH - start of heading */
#define CTRL_B	'\002'		/* STX - start of text */
#define CTRL_C	'\003'		/* ETX - end of text */
#define CTRL_D	'\004'		/* EOT - end of transmission */
#define CTRL_E	'\005'		/* ENQ - enquiry */
#define CTRL_F	'\006'		/* ACK - acknowledge */
#define CTRL_G	'\007'		/* BEL - bell */
#define BAKSPC	'\010'		/* BS - backspace		control H */
#define TABCHR	'\011'		/* HT - horizontal tab		control I */
#define LINEFD	'\012'		/* LF - line feed		control J */
#define VRTTAB	'\013'		/* VT - vertical tab		control K */
#define FORMFD	'\014'		/* FF - form feed		control L */
#define CRETRN	'\015'		/* CR - carriage return		control M */
#define CTRL_N	'\016'		/* SO - shift out */
#define CTRL_O	'\017'		/* SI - shift in */
#define CTRL_P	'\020'		/* DLE - data link escape */
#define CTRL_Q	'\021'		/* DC1 - device control 1 */
#define CTRL_R	'\022'		/* DC2 - device control 2 */
#define CTRL_S	'\023'		/* DC3 - device control 3 */
#define CTRL_T	'\024'		/* DC4 - device control 4 */
#define CTRL_U	'\025'		/* NAK - negative acknowledge */
#define CTRL_V	'\026'		/* SYN - synchronous idle */
#define CTRL_W	'\027'		/* ETB - end of transmission block */
#define CTRL_X	'\030'		/* CAN - cancel */
#define CTRL_Y	'\031'		/* EM - end of medium */
#define CTRL_Z	'\032'		/* SUB - substitute */
#define ESCAPE	'\033'		/* ESC - escape			control [ */
#define FSCHAR	'\034'  	/* FS - file separator		control \ */
#define GSCHAR	'\035'  	/* GS - group separator		control ] */
#define RSCHAR	'\036'  	/* RS - record separator	control ^ */
#define USCHAR	'\037'  	/* US - unit separator		control _ */
#define SPACE	'\040'		/* SP - space */
#define DELETE	'\177'		/* DEL - delete */
