/*****************************************************************************

	DefErr.h

	This file defines identifiers for error messages generated by TECOC-C.
The codes that are commented out are those that were defined in TECO-11,  but
are not used by TECOC-C.

	IMPORTANT: if you change this file,  you will need to change
TECOC.RNH, DEFERR.H and ERR.C !!!
*****************************************************************************/

#define ERR_XXX -1	/* no error */

#define ERR_ARG 0	/* improper arguments */
#define ERR_BNI 1	/* > not in iteration */
#define ERR_DTB 2	/* delete too big */
#define ERR_FNF 3	/* file not found "filename" */
#define ERR_ICE 4	/* illegal ^E command in search argument */
#define ERR_IEC 5	/* illegal character "x" after E */
#define ERR_IFC 6	/* illegal character "x" after F */
#define ERR_IIA 7	/* illegal insert argument */
#define ERR_ILL 8	/* illegal command "x" */
#define ERR_ILN 9	/* illegal number */
#define ERR_IPA 10	/* negative or 0 argument to P */
#define ERR_IQC 11	/* illegal character "x" following " */
#define ERR_IQN 12	/* illegal q-register name "x" */
#define ERR_IRA 13	/* illegal radix argument to ^R */
#define ERR_ISA 14	/* illegal search argument */
#define ERR_ISS 15	/* illegal search string */
#define ERR_IUC 16	/* illegal character "x" following ^ */
#define ERR_MAP 17	/* missing ' */
#define ERR_MEM 18	/* memory overflow */
#define ERR_NAB 19	/* no argument before ^_ */
#define ERR_NAC 20	/* no argument before , */
#define ERR_NAE 21	/* no argument before = */
#define ERR_NAP 22	/* no argument before ) */
#define ERR_NAQ 23	/* no argument before " */
#define ERR_NAS 24	/* no argument before ; */
#define ERR_NAU 25	/* no argument before U */
#define ERR_NCA 26	/* negative argument to , */
#define ERR_NFI 27	/* no file for input */
#define ERR_NFO 28	/* no file for output */
#define ERR_NYA 29	/* numeric argument with Y */
#define ERR_NYI 30	/* not yet implemented */
#define ERR_OFO 31	/* output file already open */
#define ERR_PDO 32	/* push-down list overflow */
#define ERR_PES 33	/* attempt to pop empty stack */
#define ERR_POP 34	/* attempt to move pointer off page with "x" */
#define ERR_SNI 35	/* ; not in iteration */
#define ERR_SRH 36	/* search failure "text" */
#define ERR_STL 37	/* string too long */
#define ERR_TAG 38	/* missing tag !tag! */
#define ERR_UTC 39	/* unterminated command "x" */
#define ERR_UTM 40	/* unterminated macro */
#define ERR_XAB 41	/* execution aborted */
#define ERR_YCA 42	/* Y command aborted */

#define ERR_SYS 43	/* %s */
#define ERR_UFI 44	/* unable to open file "x" for input */
#define ERR_UFO 45	/* unable to open file "x" for output */
#define ERR_UCI 46	/* unable to close input file */
#define ERR_UCO 47	/* unable to close output file */
#define ERR_UCD 48	/* unable to close and delete output file */
#define ERR_URL 49	/* unable to read line from input file */
#define ERR_UWL 50	/* unable to write line to output file */
#define ERR_URE 51	/* unable to read TECO command file */
#define ERR_URC 52	/* unable to read character from terminal */

/*
  Standard TECO errors that possibly should be generated by TECOC-C:

?CON	Confused use of conditionals
?FER	File error
?INP	Input error
?OUT	Output error

  Standard TECO errors not used by TECO-C are:

?CCL	CCL.SV not found or EG argument too long
?CPQ	Can't pop into Q-register  (TECO-C uses PES)
?DEV	Invalid device
?ERR	RSTS/E error message    (RSTS/E only)
?FUL	Output Command would have overflowed output device
?IFN	Illegal character "x" in filename
?MLA	Missing Left Angle Bracket
?MLP	Missing (
?MRA	Missing Right Angle Bracket
?MRP	Missing )
?MSC	Missing Start of Conditional
?NPA	Negative or 0 argument to P  (TECO-C uses IPA)
?NRO	No room for output
?UTM	Unterminated macro
?WLO	System Device Write-Locked

?nnn	I/O Error or Directive Error  (RSX-11 only)

%Superseding existing filed  (TECO-11 only)
%Search fail in iter  (TECO-11 only)
*/
