/*****************************************************************************

	ExeV()

	This function executes a V command.

	nV	Type n current lines
	m,nV	Type m before & n after current line
*****************************************************************************/

#include "zport.h"		/* define portability identifiers */
#include "tecoc.h"		/* define general identifiers */
#include "defext.h"		/* define external global variables */

DEFAULT ExeV()			/* execute an V command */
{
	DBGFEN(1,"ExeV",NULL);
	if (EStTop == EStBot) {			/* if no numeric argument */
		NArgmt = 1;			/* default is 1V */
	}
	else {
		UMinus();			/* if it's -V, make it -1V */
		if (GetNmA() == FAILURE) {	/* get numeric argument */
			DBGFEX(1,DbgFNm,"FAILURE");
			return FAILURE;
		}
	}

	if (CmdMod & MARGIS) {			/* if it's m,nV */
		TypBuf(GapBeg+Ln2Chr((LONG)(1-MArgmt)), GapBeg);
	}
	else {
		TypBuf(GapBeg+Ln2Chr((LONG)(1-NArgmt)), GapBeg);
	}
	TypBuf(GapEnd+1, GapEnd+Ln2Chr(NArgmt)+1);

	CmdMod = '\0';				/* clear modifiers flags */

	DBGFEX(1,DbgFNm,"SUCCESS");
	return SUCCESS;
}
