$ verify = 'F$VERIFY(0)'
$ GOTO L1$
$!
$! RADIXCVT.COM
$!
$!+ RADIXCVT
$! Converts the numeric radix of FORTRAN, PASCAL or C symbol definition
$! files from hexadecimal to decimal.
$!
$!	@FERMI$UTIL:RADIXCVT  file_spec  {FORTRAN|PASCAL|C}
$!
$! where the file given by file_spec is a FORTRAN (or PASCAL or C) INCLUDE
$! file, usually produced by SDIFGENR (or PASFRMFOR or C).  The type of
$! the code in the file is determined by the file type (file type .H is
$! recognized as a VAX-11 C file).  If the second parameter is not null,
$! then it determines the code type from the default file type (the file
$! type of ".H" is also recognized as a VAX-11 C file).
$!-
$! Modification History:
$!  13-May-82	FJN	Created
$!  08-Sep-82	FJN	Use VMS V3 DCL features
$!  28-Dec-82	FJN	Add support for C and setup to use file type.
$!  08-Feb-83	FJN	Correct C code to skip over "0X"
$!=============================================================================
$L1$:
$!
$! Get file type to determine code type
$!
$ file_type = F$PARSE(p1,,,"TYPE")
$ pascal = file_type .EQS. ".PAS"
$ vax11c = (file_type .EQS. ".C") .OR. (file_type .EQS. ".H")
$!
$! Check for 2nd parameter
$!
$ IF p2.EQS."" THEN $ GOTO L2$
$ p2 = F$EXTRACT(0,3,p2)
$ pascal = p2.EQS."PAS"
$ vax11c = p2.EQS."C"
$!
$! Setup default file type for file specification
$!
$ file_type = ".FOR"
$ IF pascal THEN file_type = ".PAS"
$ IF vax11c THEN file_type = ".H"	!Default VAX-11 C file type is ".H"
$ p1 = F$PARSE(p1,"SYS$DISK:[]"+file_type) - ";"
$L2$:
$!
$! Open input and output files (same file specification, new version created)
$!
$ keep = 1
$ ON CONTROL_Y THEN $ GOTO BREAK_OUT
$ OPEN/READ  IN:  'p1'
$ OPEN/WRITE OUT: 'p1'
$!
$READ_LOOP:
$ READ/END_OF_FILE=ALL_DONE IN: record
$ l = F$LENGTH(record)
$ IF pascal THEN $ GOTO CVT_PASCAL
$ IF vax11c THEN $ GOTO CVT_C
$!
$! Search for '...'X in the FORTRAN line.
$!
$ m = F$LOCATE("'",record)
$ IF m .LT. l THEN $ GOTO CVT_FORTRAN
$JUST_WRITE:
$ WRITE OUT: record
$ GOTO READ_LOOP
$!
$! Get FORTRAN Hexadecimal value and convert to decimal
$!
$CVT_FORTRAN:
$ r1 = F$EXTRACT(0,m,record)
$ m2 = F$LOCATE("'X",record)
$ m = m + 1
$ n = m2 - m
$ n = %X'F$EXTRACT(m,n,record)'
$ m2 = m2 + 2
$ r2 = F$EXTRACT(m2,99,record)
$ GOTO CVT_WRITE
$!
$! Get PASCAL Hexadecimal value and convert to decimal
$!
$CVT_PASCAL:
$ m = F$LOCATE("%X",record)
$ IF m .GE. l THEN $ GOTO JUST_WRITE
$ r1 = F$EXTRACT(0,m,record)
$ m2 = F$LOCATE(";",record)
$ n = m2 - m
$ n = %X'F$EXTRACT(m,n,record)'
$ r2 = F$EXTRACT(m2,99,record)
$CVT_WRITE:
$ WRITE OUT: r1,n,r2
$ GOTO READ_LOOP
$!
$! Get VAX-11 C Hexadecimal value and convert to decimal
$!
$CVT_C:
$ m = F$LOCATE("0X",record)
$ IF m .GE. l THEN m = F$LOCATE("0x",record)
$ IF m .GE. l THEN $ GOTO JUST_WRITE
$ r1 = F$EXTRACT(0,m,record)
$ m2 = F$LOCATE("	/*",record)
$ m = m + 2		!Skip over "0X" or "0x"
$ n = m2 - m
$ n = %X'F$EXTRACT(m,n,record)'
$ r2 = F$EXTRACT(m2,99,record)
$ GOTO CVT_WRITE
$!
$! Here on completion or Control-Y trap
$!
$BREAK_OUT:
$ keep = 0
$ALL_DONE:
$ CLOSE IN:
$ CLOSE OUT:
$ IF .NOT.keep THEN $ DELETE 'p1';0	!Delete latest version.
$ EXIT	F$VERIFY(verify).OR.1
