$ verify = 'F$VERIFY(0)'
$ GOTO L1$
$!
$! SDIFGENR.COM
$!
$!+ SDIFGENR
$! This command procedure generates a file of symbol definitions to
$! be INCLUDE'd in a FORTRAN program.  The symbol definitions are
$! from a VMS macro stored in a macro library (usually the system
$! macro library, SYS$LIBRARY:STARLET.MLB).  The macro name
$! (including the leading $, if any) is entered as the first parameter
$! and becomes the name of the final output file:
$!
$!	@FERMI$UTIL:SDIFGENR  macro-name,[...]
$!
$! Several additional macros may be listed all of whose symbol
$! definitions are to appear in the same file.  The file name
$! is determined by the name of the first macro only!
$!2 LIB
$! If the macros are to be gotten from the executive macro library
$! (SYS$LIBRARY:LIB.MLB), then the first parameter must be the
$! keyword LIB:
$!
$!	@FERMI$UTIL:SDIFGENR  LIB  macro-name,[...]
$!
$!2 Other_Libraries
$! If a macro is to be gotten from some other macro library, then
$! the first parameter must start with an equals sign ('=') as in:
$!
$!	@FERMI$UTIL:SDIFGENR  =filespec  macro-name,[...]
$!
$! where filespec is the file specification of the macro library
$! and the additional parameters are as above.
$!-
$! Author:	Frank J. Nagy	27-Aug-81	Fermilab Accel/Controls
$!
$! Modified:
$!  01-Sep-81	FJN	Check for P1='LIB' as special flag to use LIB.MLB
$!  02-Sep-81	FJN	Fix single column stripping and remove PASCAL
$!				see the PASFRMFOR.COM file
$!  24-Sep-81	FJN	Replace EDT by EDIT/EDT
$!  26-Jan-82	FJN	Provide for different library names
$!  27-Jan-82	FJN	Added PROC_HOME symbol defining where this command
$!			procedure lives and breathes
$!  25-Mar-82	FJN	Ignore errors in assembly
$!  30-Mar-82	FJN	Many small improvements: change "." to "_" in symbols.
$!			Remove excess zeros in constants.
$!  11-May-82	FJN	Change MACRO source file extension to .TMR
$!  08-Aug-82	FJN	Change home directory for .TEC files to FERMI$LIB:
$!  07-Sep-82	FJN	Change to header information of resulting file
$!  20-Sep-82	FJN	Specify multiple macros via list, also get rid of the
$!			SIZ... symbol
$!  30-Sep-82	FJN	Changes made to header format
$!  04-Oct-82	FJN	More twitches to header/trailer format and delete
$!			definition of SIZ... symbol.
$!  31-Aug-83	FJN	Modified SDFSTRIP3.TEC to eliminate case where (by the
$!			final .LIS file) there are lines with 2 or 3 spaces
$!			between the start of the line and the symbol name and
$!			to take care of spaces between long symbol names and
$!			the following "=".
$!  28-Nov-83	FJN	Moved to FERMI$UTIL as home library
$!=============================================================================
$L1$:
$ TELL := WRITE SYS$OUTPUT
$ libe = F$EXTRACT(0,1,p1)				!get first character
$ replace = 1
$!
$! Check for first character of 1st parameter being an =
$!
$ IF libe .NES. "=" THEN $ GOTO SKIP_ALT_SETUP
$!
$! Transfer file specifier to libe and move down the other parameters
$!
$ libe = F$EXTRACT(1,99,p1)
$ GOTO LIB_SETUP
$SKIP_ALT_SETUP:
$ libe = ""
$ IF p1 .NES. "LIB" THEN GOTO SKIP_LIB_SETUP
$!
$! p1 is LIB, so shift P2-5 into P1-P4 for common code below.
$! library is set to SYS$LIBRARY:LIB as the library file specifier.
$!
$ libe = "SYS$LIBRARY:LIB"
$LIB_SETUP:
$ p1 = p2
$ p2 = p3
$ p3 = p4
$ p4 = p5
$ p5 = p6
$ p6 = p7
$SKIP_LIB_SETUP:
$ IF p1 .EQS. "" THEN INQUIRE p1 "Macros"
$ IF p1 .EQS. "" THEN $ GOTO EXIT_PROC
$ IF p1 .EQS. "$" THEN $ GOTO EXIT_PROC
$!
$! Define a logical name telling where this command procedure and its auxiliary
$! files reside.
$!
$ DEFINE  PROC_HOME  FERMI$UTIL:
$!
$! Get first macro name to form file name.
$!
$ file = p1
$ m = F$LOCATE(",",file)
$ IF m.LT.F$LENGTH(file) THEN file = F$EXTRACT(0,m,file)
$ macro1 = file
$!
$! Strip up to 3 "$" from macro name to get file name, also beware of
$! a "_" in the macro name or a ".".
$!
$ file = (((file - "$" - "_" - ".") - "$" - "_" - ".") - "$" - "_" - ".")
$ IF F$LENGTH(file).GT.9 THEN file = F$EXTRACT(0,9,file)
$!
$! Create temporary file for input to MACRO-32 assembler
$!
$ OPEN/WRITE/ERROR=TRY_ALT_NAME  ASM: 'file'.TMR
$ GOTO WRITE_ASM_FILE
$TRY_ALT_NAME:
$!
$! Open failed, most likely due to file name too long or has bad character in
$! it.
$!
$ INQUIRE file "Enter alternate file name"
$ OPEN/WRITE  ASM:  'file'.TMR
$WRITE_ASM_FILE:
$ macros = p1
$ WRITE ASM: "	.TITLE	file",file
$20$:
$ m = F$LOCATE(",",p1)			!Locate , between 1st and 2nd macros
$ amacro = F$EXTRACT(0,m,p1)		!Get 1st macro name
$ p1 = F$EXTRACT(m+1,255,p1)		!Remove 1st name from list
$ WRITE ASM: "	",amacro
$ IF p1.NES."" THEN $ GOTO 20$
$ WRITE ASM: "	.END"
$ CLOSE ASM:
$!
$ TELL "   Assembling ''file'.TMR to generate symbol definitions"
$!
$! Assemble and produce a listing file (only)
$!
$ SET NOON
$ time = F$EXTRACT(0,11,F$TIME())
$ IF libe .EQS. "" THEN $ MACRO/NOOBJECT/LISTING  'file'.TMR
$ success = $status
$ IF libe .NES. "" THEN  -
$	MACRO/NOOBJECT  'libe'/LIBRARY+SYS$DISK:[]'file'.TMR/LISTING
$ success = success .AND. $status
$ DELETE 'file'.TMR;*
$ IF libe.EQS."" THEN libe = "SYS$LIBRARY:STARLET"
$ SET ON
$ IF success THEN $ GOTO 30$
$ DELETE  'file'.LIS;*
$EXIT_PROC:
$ EXIT	F$VERIFY(verify).OR.1
$!
$30$:
$!
$ TELL "   Stripping symbol definitions from assembly listing file"
$!
$! Now strip out the symbol table from the listing file
$!
$ ASSIGN/USER_MODE  NLA0:  SYS$OUTPUT:
$ TECO 'file'.LIS
E_Symbol table0j5t3k
NPsect synopsis0l-l5t.,ZdP
<E_/NOOBJECT/LISTING;-5t>HKEX
$!
$ ASSIGN/USER_MODE  NLA0:  SYS$OUTPUT:
$ TECO 'file'.LIS
<NSymbol table;0j5t3k>EX
$!
$! Now remove form feeds and produce a single column listing
$!
$ TELL "    Producing single column listing of symbols"
$!
$ ASSIGN/USER_MODE  NLA0:  SYS$OUTPUT:
$ EDIT/EDT/NOCOMMAND 'file'.LIS
SUB///whole
EXIT
$!
$ ASSIGN/USER_MODE  NLA0:  SYS$OUTPUT:
$ TECO 'file'.LIS
EIPROC_HOME:SDFSTRIP3.TEC
$!
$! And remove the lines with the symbols BIT... and GBL...
$!
$ ASSIGN/USER_MODE  NLA0:  SYS$OUTPUT:
$ TECO 'file'.LIS
0j<sGBL...;0lkt>
0j<sBIT...;0lkt>
0j<sSIZ...;0lkt>
EX
$!
$ ASSIGN/USER_MODE  NLA0:  SYS$OUTPUT:
$ TECO 'file'.LIS
EIPROC_HOME:SDFSTRIP3.TEC
$!
$ PURGE 'file'.LIS
$!
$! Sort the symbols by name
$!
$ TELL "    Sorting into alphabetic order by symbol name"
$!
$ ASSIGN/USER_MODE  NLA0:  SYS$OUTPUT:
$ SORT/KEY=(POSITION:1,SIZE:15)  'file'.LIS  'file'.LST
$ DELETE 'file'.LIS;*
$!
$! Generate a temporary EDT command file to add header/trailer comments
$! and to do other minor edits in the file.
$!
$ WED := WRITE EDO:
$ OPEN/WRITE  EDO:  XXXDEF.TED
$ IF replace THEN $ WED "SUB/./_/3:end-3"
$ IF .NOT.replace THEN $ WED "SUB/.//3:end-3"
$ WED "SUB/'000000/'/whole"
$ WED "SUB/'0000/'/whole"
$ WED "INCLUDE XXXHDR.TM1 BEGIN"
$ WED "INCLUDE XXXTLR.TM1 END"
$ WED "EXIT"
$ CLOSE EDO:
$!
$! Generate the include files with the header/trailer
$!
$ OPEN/WRITE  EDO:  XXXHDR.TM1
$ WED "C+ ",macro1
$ WED "C ",file,".FOR defines symbols for"
$ WED "C FERMI$LIB:LCLFORDEF(",macro1,") defines symbols for"
$ WED "C-"
$ WED "C Extracted ",macros," from ",libe," on ",time
$ CLOSE EDO:
$ OPEN/WRITE  EDO:  XXXTLR.TM1
$ WED "C"
$ WED "C End of ",file,".FOR."
$ WED "C End of ",macro1," module."
$ WED "C"
$ CLOSE EDO:
$!
$! Finally convert into an INCLUDE file with FORTRAN PARAMETER statements
$!
$ TELL "  Making ''file'.FOR INCLUDE file"
$!
$ ASSIGN/USER_MODE  NLA0:  SYS$OUTPUT:
$ TECO 'file'.TM9='file'.LST
EIPROC_HOME:FORSYMDEF.TEC
EX
$!
$ ASSIGN/USER_MODE  NLA0:  SYS$OUTPUT:
$ EDIT/EDT/COMMAND=XXXDEF.TED  'file'.TM9/OUTPUT='file'.FOR
$!
$ DELETE XXXDEF.TED;*,XXXHDR.TM1;*,XXXTLR.TM1;*,'file'.TM9;*
$ DEASSIGN PROC_HOME
$ EXIT	F$VERIFY(verify).OR.1
