$!.. EVERYMNTH.COM			Monthly batch job actions
$ SET NOON
$ SUBMIT_JOB := SUBMIT /NOPRINT /USER=SYSMANAGER
$ SUBMIT_CMNJOB := SUBMIT /NOPRINT /LOG_FILE=CMN$MANAGER: /USER=SYSMANAGER
$ MULTIS := @SYS$MGR_UTIL:MULTISUBMIT
$ which = F$GETSYI( "NODENAME")		!Which system are we
$ opsys = which .EQS. "OPER"		!Set to TRUE if Operational system
$ dvsys = which .EQS. "DEVL"		!Set to TRUE if Development system
$ acsys = which .EQS. "ADCALC"		!Set to TRUE if Calculational system
$ devl_cluster = dvsys .OR. acsys	!TRUE if VAXCluster
$ time = F$TIME()
$ IF p1.NES."" THEN time = p1		!Get name of current month & # of days
$ year = F$INTEGER( F$CVTIME( time, "ABSOLUTE", "YEAR")) !Get current year
$ this_month = F$CVTIME( time, "ABSOLUTE", "MONTH")	!Name of current month
$ DELETE/SYMBOL time
$ months = "JAN31FEB28MAR31APR30MAY31JUN30JUL31AUG31SEP30OCT31NOV30DEC31"
$ this_month = F$EDIT( this_month, "UPCASE")	!Eliminate casing problems
$ where = F$LOCATE( F$EDIT( this_month, "UPCASE"), months) + 3
$ days_in_month = F$INTEGER( F$EXTRACT( where, 2, months))
$ DELETE/SYMBOL where
$ DELETE/SYMBOL months
$ IF this_month .NES. "FEB" THEN $ GOTO NOT_FEBRUARY
$!	This is February, check for a leap year...
$!	Leap year is divisible by 4, but the year is not a leap year
$!	if it divisible by 100 and NOT divisible by 400.
$ tmp = year - 4*(year/4)
$ IF tmp.NE.0 THEN $ GOTO NOT_FEBRUARY	! Not divisible by 4
$ tmp = year - 100*(year/100)
$ IF tmp.NE.0 THEN $ GOTO LEAP_YEAR	! Not divisible by 100
$ tmp = year - 400*(year/400)
$ IF tmp.EQ.0 THEN $ GOTO NOT_FEBRUARY	! Divisible by 400
$LEAP_YEAR:
$ days_in_month = 29			! leap year!!
$NOT_FEBRUARY:
$!*****************************************************************************
$!
$! Submit NEWACCJOB to be run every month to create a new accounting file
$! and to generate summary reports from the past month's accounting data.
$!
$ MULTIS  BATCH		"/PRIORITY=31	SYS$MGR_UTIL:NEWACCJOB"
$!
$! On Development VAXCluster run batch job to squeeze VMS libraries of all
$! types in SYS$LIBRARY:, FERMI$LIB: and other areas to recover disk space.
$! Run batch job under SYSMANAGER account.
$!
$ IF .NOT. devl_cluster THEN $ GOTO SKIP_VMSLBRSQU_JOB
$ SUBMIT_CMNJOB /QUEUE=LONG_JOBS /NAME=VMSLBRSQU /AFTER=01:30	-
	SYS$MGR_UTIL:VMSLBRSQU.JOB
$SKIP_VMSLBRSQU_JOB:
$!
$! Submit EVERYMNTH jobs for other users (other than SYSMANAGER/SYSTEM).
$!
$@SYS$MGR_UTIL:USERSEJOBS  EVERYMNTH
$!
$! Truncate OPERATOR.SUM by deleting entries older than 2 weeks...
$!
$ MULTIS	BATCH	SYS$MGR_UTIL:OPRSUMTRU
$!
$ EXIT	1				! End-of-job for this month
$!=============================================================================
$! EVERYMNTH.COM
$!
$!	This command procedure is run at midnight on the 1st of every month
$!	by the EVRYMNTH batch job (with command procedure EVERYMNTH.JOB).
$!	Its purpose is to submit other batch jobs to be run on a monthly
$!	basis.
$!
$!=============================================================================
$! Here is where the real work gets done.  The SUBMIT commands (or @name)
$! commands should go between the two lines of astericks.  Remember that
$! this job is running under the SYSTEM account (UIC [1,4]) as will any
$! batch jobs SUBMIT'ed from here or any command files executed from here.
$! The current default directory is now: SYS$MANAGER:!!
$! If a batch job must be run under a different user either you can:
$!	1. Change the UIC and default directory at the start of the
$!	   command file submitted as a batch job.
$!	2. SPAWN a command file off under a different UIC to do you thing
$!	   or SUBMIT a batch job.  (Or you can insert a detached process
$!	   RUN command into here).
$! Note that the .LOG files for batch jobs submitted from here or detached
$! processes SPAWN'ed from here are placed in SYS$MANAGER:
$!
$! The logical names SYS$LOGIN: and SYS$MANAGER: both point to the system
$! manager's directory.  The SYS$MGR_UTIL: logical name points to the system
$! manager's subdirectory in which many of the utility command procedures are
$! stored.
$!
$! The DCL symbol OPSYS is 1 (TRUE) if this command procedure is being
$! run on the Operational VAX system and 0 (FALSE) otherwise.  Use of this
$! allows a single version of this command procedure to be maintained and
$! yet have different actions on the two systems.
$!
$! The special local symbols defined in this procedure and useable here and
$! in procedures called by this one include:
$!	opsys		TRUE if on Operational VAX system, else FALSE
$!	this_month	3 character name of the current month
$!	days_in_month	number of days in this month
$!=============================================================================
$! Author:	Frank J. Nagy	Fermilab Accelerator/Controls
$! Modifications:
$!  30-Aug-82	FJN	Created from EVERYWEEK.COM
$!  15-Sep-82	FJN	Change to run NEWACCJOB at 5 seconds till midnight
$!  01-Oct-82	FJN	Change to run NEWACCJOB after midnight
$!  24-Sep-83	FJN	Add RSX library squeeze batch job submittal
$!  30-Jan-84	FJN	Modify SETUSER command to add account
$!  05-Mar-84	FJN	Add VMS library squeeze batch job submittal, SPM
$!			disk space check job and OPERATOR.SUM truncation
$!  16-Oct-84	FJN	Submit some or all jobs via LONG_JOBS queue.
$!  12-Nov-84	FJN	Initial testing of handling user-specific jobs via
$!			their own EVERY* jobs and a control database...
$!  28-Dec-84	FJN	Replace OPSYS setting by WHICH.SYS template and
$!			then include ADCALC in customizations
$!  07-Jun-85	FJN	Make use of VMS V4 features, compact and move comments
$!  12-Jun-85	FJN	Changed to USERSEJOBS.COM procedure
$!  18-Oct-85	FJN	Added SUBMIT_CMNJOB to put .LOG file in CMN$MANAGER
$!			and added use of MULTISUBMIT.COM
