$ verify = 'F$VERIFY(0)'
$!.. USCLEANER.COM		Batch job to clean up USR$SCRATCH disk.
$!.. Description/history at end of file
$ PURGE /KEEP=3	USCLEANER.LOG		!Purge old version(s) of job .LOG file
$ self = F$ENVIRONMENT( "PROCEDURE")	!Get file spec for self
$ IF p1 .EQS. "RECALL" THEN $ GOTO 'p2'
$ SET MESSAGE/NOFACILITY/NOIDENTIFCATION/NOSEVERITY
$ SET NOON				!Ignore all errors
$ SET PROCESS/PRIVILEGE=(BYPASS,SYSPRV)	!Bypass the file system protections!
$!
$! Setup some shorthand symbols
$!
$ _KILL_C := DELETE /CREATED /LOG /EXCLUDE=*.DIR
$ _KILL_E := DELETE /EXPIRED /LOG /EXCLUDE=*.DIR
$ _KILL_M := DELETE /MODIFIED /LOG /EXCLUDE=*.DIR
$!
$ KILL_1DAY :=		'_KILL_M'	/BEFORE=TODAY
$ KILL_3DAYS :=		'_KILL_M'	/BEFORE="TODAY-3-00:00"
$ KILL_1WEEK :=		'_KILL_M'	/BEFORE="TODAY-7-00:00"
$ KILL_2WEEKS :=	'_KILL_M'	/BEFORE="TODAY-14-00:00"
$ KILL_1MONTH :=	'_KILL_M'	/BEFORE="TODAY-30-00:00"
$ KILL_6MONTHS :=	'_KILL_M'	/BEFORE="TODAY-180-00:00"
$ KILL_EXPIRED := 	'_KILL_E'	/BEFORE=TODAY
$ EXPEL_1YEAR := 	'_KILL_C'	/BEFORE="TODAY-360-00:00"
$!
$! Make certain we have a scratch disk available to clean up!
$! Check that the logical name USR$SCRATCH exists and points to a device
$! which exists, is available and is mounted with a valid volume (status
$! bit %X0800) and is not in mount verification (status bit %X8000)).
$!
$ IF F$LOGICAL( "USR$SCRATCH") .EQS. "" THEN $ EXIT
$ IF .NOT. F$GETDVI( "USR$SCRATCH", "EXISTS") THEN $ EXIT
$ IF .NOT. F$GETDVI( "USR$SCRATCH", "HOST_AVAIL") THEN $ EXIT
$ IF .NOT. F$GETDVI( "USR$SCRATCH", "MNT") THEN $ EXIT
$ sts = F$GETDVI( "USR$SCRATCH", "STS")
$ IF (sts .AND. %X0800) .EQ. 0 THEN $ EXIT	!Volume not valid
$ IF (sts .AND. %X4000) .NE. 0 THEN $ EXIT	!Volume in mount verification
$!
$ free0 = F$GETDVI( "USR$SCRATCH", "FREEBLOCKS")	!Initial free space
$!
$! First action is to delete all files with creation dates > 1 year
$! and modification dates > 6 months to remove the very oldest files.
$!
$ IF p1 .EQS. "DELETE_OLD" THEN $ EXPEL_1YEAR	USR$SCRATCH:[*...]*.*;*
$ KILL_6MONTHS	USR$SCRATCH:[*...]*.*;*
$!
$! Now calculate current percent of disk space free.
$!
$ freepcnt = (100*F$GETDVI( "USR$SCRATCH", "FREEBLOCKS")) / -
			F$GETDVI( "USR$SCRATCH", "MAXBLOCK")
$ WRITE  SYS$OUTPUT  "	Currently have ",freepcnt,"% free space."
$ IF freepcnt .GE. 50 THEN $ GOTO COMPLETING
$!
$! Now delete older files (how old based on amount of free space left).
$!
$ killing = KILL_1MONTH
$ IF freepcnt .LT. 25 THEN killing = KILL_2WEEKS
$ IF freepcnt .LT. 10 THEN killing = KILL_1WEEK
$ IF freepcnt .LT. 5 THEN killing = KILL_3DAYS
$ IF freepcnt .LT. 1 THEN killing = KILL_1DAY
$ KILLING	USR$SCRATCH:[*...]*.*;*
$!
$! Now, if the amount of free space remains small, purge older versions of
$! files.  The number of file versions kept decreases with the amount of
$! free space left on the disk at this point.
$!
$ freepcnt = (100*F$GETDVI( "USR$SCRATCH", "FREEBLOCKS")) / -
			F$GETDVI( "USR$SCRATCH", "MAXBLOCK")
$ WRITE  SYS$OUTPUT  "	Now have ",freepcnt,"% free space."
$ IF freepcnt .GE. 10 THEN $ GOTO COMPLETING
$ purging := PURGE /KEEP=5
$ IF freepcnt .LT. 5 THEN purging := PURGE /KEEP=3
$ IF freepcnt .LT. 1 THEN purging := PURGE
$ PURGING	USR$SCRATCH:[*...]*.*;*
$!
$COMPLETING:
$!
$! Check for any change in the free space which indicates some files were
$! deleted.  If so, then prune empty directories.
$!
$ delta = free0 - F$GETDVI( "USR$SCRATCH", "FREEBLOCKS")
$ IF delta .EQ. 0 THEN $ EXIT
$TRIM_EMPTIES:
$ SET NOVERIFY
$!
$! Trim empty directories from scratch disk.
$!
$ RESTORE_DEFAULT := SET DEFAULT 'F$ENVIRONMENT( "DEFAULT")'
$ SET NOON
$ DELEMPTY := @FERMI$UTIL:DELEMPTY
$ DIRECTORY /COLUMNS=1 /NOHEADING /NOTRAILING /OUTPUT=D.TMP	-
	USR$SCRATCH:[0,0]*.DIR /EXCLUDE=000000.DIR
$ OPEN /READ	D_LIST	D.TMP
$TRIM_LOOP:
$ READ /END_OF_FILE=TRIM_DONE	D_LIST	aufd
$ _ufd = F$PARSE( aufd,,, "NAME")
$ DELEMPTY  USR$SCRATCH:['_ufd']/LOG
$ GOTO TRIM_LOOP
$TRIM_DONE:
$ CLOSE	D_LIST
$ RESTORE_DEFAULT
$ DELETE D.TMP;*
$ EXIT
$!=============================================================================
$! USCLEANER.COM
$!
$!+ USCLEANER
$! This procedure is executed as a batch job early every morning (the job
$! is submitted by the EVERYNITE batch job) or as needed in order to clean
$! up the system-wide scratch by deleting old files.  A single copy of the
$! batch job log file is left in the SYS$MANAGER area.
$!
$! All files which have not been modified within the last 6 months are
$! always deleted automatically.  All files more than 1 year old (creation
$! date is more than 1 year in the past) are deleted if the P1 parameter is
$! "DELETE_OLD".
$!
$! If the free space (as a percent of the total space) is below a preset
$! limit, the older files as selected by their modification dates are deleted.
$! Additionally, all directories may be purged to a lower number of file
$! versions as indicated:
$!
$!        Free space       Deletes older than       Versions kept
$!        -----------      ------------------       -------------
$!           <50%           1 month (30 days)           all
$!           <25%           2 weeks (14 days)           all
$!           <10%           1 month (30 days)            5
$!           <5%             1 week (7 days)             3
$!           <1%                 1 day                   1
$!-
$!=============================================================================
$! Author:	Frank J. Nagy	Fermilab Accelerator/Controls
$! Modification History:
$!  17-Aug-85	FJN	Created from MADDELETR.COM as a pattern
$!  24-Nov-85	FJN	Modified to keep several .LOG files on disk and fixed
$!			STS check
$!  25-Nov-85	FJN	Fix to do tree pruning on USR$SCRATCH!
$!  26-Nov-85	FJN	Fix tree pruning, change delete on creation date to
$!			1 year and modification date to 6 months
