/* color.c */

#include "conf.h"

#define CNRM  "\x1B[0;0m"
#define CRED  "\x1B[31m"
#define CGRN  "\x1B[32m"
#define CYEL  "\x1B[33m"
#define CBLU  "\x1B[34m"
#define CMAG  "\x1B[35m"
#define CCYN  "\x1B[36m"
#define CWHT  "\x1B[37m"
#define CNUL  ""

#define BRED  "\x1B[1;31m"
#define BGRN  "\x1B[1;32m"
#define BYEL  "\x1B[1;33m"
#define BBLU  "\x1B[1;34m"
#define BMAG  "\x1B[1;35m"
#define BCYN  "\x1B[1;36m"
#define BWHT  "\x1B[1;37m"

#define BKRED  "\x1B[41m"
#define BKGRN  "\x1B[42m"
#define BKYEL  "\x1B[43m"
#define BKBLU  "\x1B[44m"
#define BKMAG  "\x1B[45m"
#define BKCYN  "\x1B[46m"
#define BKWHT  "\x1B[47m"

const char *COLORLIST[] = {CNRM,CRED,CGRN,CYEL,CBLU,CMAG,CCYN,CWHT,
			   BRED,BGRN,BYEL,BBLU,BMAG,BCYN,BWHT,
			   BKRED,BKGRN,BKYEL,BKBLU,BKMAG,BKCYN,BKWHT};
#define MAX_COLORS 21


int isnum(char s)
{
  return( (s>='0') && (s<='9') );
}

void proc_color(char *inbuf, int color)
{
	register int j=0,p=0;
	int c,k,max;
	char out_buf[32768];

	if(inbuf[0] == '\0') return;

	while(inbuf[j]!='\0')
	{
		if(  (inbuf[j]=='\\') && (inbuf[j+1]=='c')
			 && isnum(inbuf[j+2]) && isnum(inbuf[j+3]) )
		{
	      		c=(inbuf[j+2]-'0')*10 + inbuf[j+3]-'0';
			if(c>MAX_COLORS) c = 0;
			max=strlen(COLORLIST[c]);
			j+=4;
			if(color)
			   for(k=0;k<max;k++)
			      { out_buf[p] = COLORLIST[c][k]; p++; }
		 }
		 else {out_buf[p] = inbuf[j]; j++;p++;}
	}

	out_buf[p] = '\0';

	strcpy(inbuf, out_buf);
}
