#ifndef _GUILD_H_
#define _GUILD_H_
#include "spells.h"

#define MAX_GUILD_GUARDS 100
#define PRACS_TO_JOIN	50

#define GUILD_NOBODY	-1
#define GUILD_MEMBER	0
#define GUILD_OFFICER	1
#define GUILD_ELDER	2
#define GUILD_LEADER	3
#define GUILD_PATRON	4

extern struct guild_data *guild_table;
extern int top_of_guild_table;
extern char *pc_guildrank_types[];

struct guild_data {
	char* fullname;		/* full name of guild */
	char* shortname;	/* short name of guild */
	char* abbrev;		/* abbreviation of guild */

	long currentxp;		/* current xp in guild */
        int currentskill;	/* current skill being learned */
	int minstr;		/* min attributes to join */
	int mindex;		
	int mincon;
	int minintel;
	int minwis;
	int mincha;
	int minlevel;		/* min level to join */
	long races;		/* bitvector: races that can join */
};

/* functions in guild.c */
void set_guildguard(int guild_nr, int room_vnum, char dir, int slot);
void set_guildprereq(int guild_nr, char type, int number);
void load_guild(FILE *gld_file, int total_guild);
void show_guilds(struct char_data *ch, int guild_number);

#endif /* _GUILD_H_ */
