#ifndef lint
static char luaY_sccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93";
#endif
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define luaY_clearin (luaY_char=(-1))
#define luaY_errok (luaY_errflag=0)
#define YYRECOVERING (luaY_errflag!=0)
#define YYPREFIX "luaY_"
#line 2 "lua.stx"

char *rcs_luastx = "$Id: parser.c,v 1.1 1996/11/21 16:11:40 lhf Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "luadebug.h"
#include "mem.h"
#include "lex.h"
#include "opcode.h"
#include "hash.h"
#include "inout.h"
#include "tree.h"
#include "table.h"
#include "lua.h"
#include "func.h"

/* to avoid warnings generated by yacc */
int luaY_parse (void);
#define malloc luaI_malloc
#define realloc luaI_realloc
#define free luaI_free

#ifndef LISTING
#define LISTING 0
#endif

#ifndef CODE_BLOCK
#define CODE_BLOCK 256
#endif
static int   maxcode;
static int   maxmain;
static int   maxcurr;
static Byte  *funcCode = NULL;
static Byte **initcode;
static Byte  *basepc;
static int   maincode;
static int   pc;


#define MAXVAR 32
static Long    varbuffer[MAXVAR];    /* variables in an assignment list;
				it's long to store negative Word values */
static int     nvarbuffer=0;	     /* number of variables at a list */

#define MAXLOCALS 32
static TaggedString *localvar[MAXLOCALS];  /* store local variable names */
static int     nlocalvar=0;	     /* number of local variables */

#define MAXFIELDS FIELDS_PER_FLUSH*2
static Word    fields[MAXFIELDS];     /* fieldnames to be flushed */
static int     nfields=0;

int lua_debug = 0;

/* Internal functions */

static void luaY_error (char *s)
{
  luaI_syntaxerror(s);
}

static void check_space (int i)
{
  if (pc+i>maxcurr-1)  /* 1 byte free to code HALT of main code */
    maxcurr = growvector(&basepc, maxcurr, Byte, codeEM, MAX_INT);
}

static void code_byte (Byte c)
{
 check_space(1);
 basepc[pc++] = c;
}

static void code_word (Word n)
{
  check_space(sizeof(Word));
  memcpy(basepc+pc, &n, sizeof(Word));
  pc += sizeof(Word);
}

static void code_float (real n)
{
  check_space(sizeof(real));
  memcpy(basepc+pc, &n, sizeof(real));
  pc += sizeof(real);
}

static void code_code (TFunc *tf)
{
  check_space(sizeof(TFunc *));
  memcpy(basepc+pc, &tf, sizeof(TFunc *));
  pc += sizeof(TFunc *);
}

static void code_word_at (Byte *p, int n)
{
  Word w = n;
  if (w != n)
    luaY_error("block too big");
  memcpy(p, &w, sizeof(Word));
}

static void push_field (Word name)
{
  if (nfields < MAXFIELDS)
    fields[nfields++] = name;
  else
   luaY_error ("too many fields in nested constructors");
}

static void flush_record (int n)
{
  int i;
  if (n == 0) return;
  code_byte(STORERECORD);
  code_byte(n);
  for (i=0; i<n; i++)
    code_word(fields[--nfields]);
}

static void flush_list (int m, int n)
{
  if (n == 0) return;
  if (m == 0)
    code_byte(STORELIST0); 
  else
  if (m < 255)
  {
    code_byte(STORELIST);
    code_byte(m);
  }
  else
   luaY_error ("list constructor too long");
  code_byte(n);
}

static void store_localvar (TaggedString *name, int n)
{
 if (nlocalvar+n < MAXLOCALS)
  localvar[nlocalvar+n] = name;
 else
  luaY_error ("too many local variables");
 if (lua_debug)
   luaI_registerlocalvar(name, lua_linenumber);
}

static void add_localvar (TaggedString *name)
{
  store_localvar(name, 0);
  nlocalvar++;
}

static void add_varbuffer (Long var)
{
 if (nvarbuffer < MAXVAR)
  varbuffer[nvarbuffer++] = var;
 else
  luaY_error ("variable buffer overflow");
}

static void code_number (float f)
{ 
  Word i = (Word)f;
  if (f == (float)i)  /* f has an (short) integer value */
  {
   if (i <= 2) code_byte(PUSH0 + i);
   else if (i <= 255)
   {
    code_byte(PUSHBYTE);
    code_byte(i);
   }
   else
   {
    code_byte(PUSHWORD);
    code_word(i);
   }
  }
  else
  {
   code_byte(PUSHFLOAT);
   code_float(f);
  }
}

/*
** Search a local name and if find return its index. If do not find return -1
*/
static int lua_localname (TaggedString *n)
{
 int i;
 for (i=nlocalvar-1; i >= 0; i--)
  if (n == localvar[i]) return i;	/* local var */
 return -1;		        /* global var */
}

/*
** Push a variable given a number. If number is positive, push global variable
** indexed by (number -1). If negative, push local indexed by ABS(number)-1.
** Otherwise, if zero, push indexed variable (record).
*/
static void lua_pushvar (Long number)
{ 
 if (number > 0)	/* global var */
 {
  code_byte(PUSHGLOBAL);
  code_word(number-1);
 }
 else if (number < 0)	/* local var */
 {
  number = (-number) - 1;
  if (number < 10) code_byte(PUSHLOCAL0 + number);
  else
  {
   code_byte(PUSHLOCAL);
   code_byte(number);
  }
 }
 else
 {
  code_byte(PUSHINDEXED);
 }
}

static void lua_codeadjust (int n)
{
 if (n+nlocalvar == 0)
   code_byte(ADJUST0);
 else
 {
   code_byte(ADJUST);
   code_byte(n+nlocalvar);
 }
}

static void change2main (void)
{
  /* (re)store main values */
  pc=maincode; basepc=*initcode; maxcurr=maxmain;
  nlocalvar=0;
}

static void savemain (void)
{
  /* save main values */
  maincode=pc; *initcode=basepc; maxmain=maxcurr;
}

static void init_func (void)
{
  if (funcCode == NULL)	/* first function */
  {
   funcCode = newvector(CODE_BLOCK, Byte);
   maxcode = CODE_BLOCK;
  }
  savemain();  /* save main values */
  /* set func values */
  pc=0; basepc=funcCode; maxcurr=maxcode; 
  nlocalvar = 0;
  luaI_codedebugline(lua_linenumber);
}

static void codereturn (void)
{
  if (nlocalvar == 0)
    code_byte(RETCODE0);
  else
  {
    code_byte(RETCODE);
    code_byte(nlocalvar);
  }
}

void luaI_codedebugline (int line)
{
  static int lastline = 0;
  if (lua_debug && line != lastline)
  {
    code_byte(SETLINE);
    code_word(line);
    lastline = line;
  }
}

static int adjust_functioncall (Long exp, int i)
{
  if (exp <= 0)
    return -exp; /* exp is -list length */
  else
  {
    int temp = basepc[exp];
    basepc[exp] = i;
    return temp+i;
  }
}

static void adjust_mult_assign (int vars, Long exps, int temps)
{
  if (exps > 0)
  { /* must correct function call */
    int diff = vars - basepc[exps];
    if (diff >= 0)
      adjust_functioncall(exps, diff);
    else
    {
      adjust_functioncall(exps, 0);
      lua_codeadjust(temps);
    }
  }
  else if (vars != -exps)
    lua_codeadjust(temps);
}

static int close_parlist (int dots)
{
  if (!dots)
    lua_codeadjust(0);
  else
  {
    code_byte(VARARGS);
    code_byte(nlocalvar);
    add_localvar(luaI_createfixedstring("arg"));
  }
  return lua_linenumber;
}

static void storesinglevar (Long v)
{
 if (v > 0)		/* global var */
 {
   code_byte(STOREGLOBAL);
   code_word(v-1);
 }
 else if (v < 0)      /* local var */
 {
   int number = (-v) - 1;
   if (number < 10) code_byte(STORELOCAL0 + number);
   else
   {
     code_byte(STORELOCAL);
     code_byte(number);
   }
 }
 else 
   code_byte(STOREINDEXED0);
}

static void lua_codestore (int i)
{
 if (varbuffer[i] != 0)  /* global or local var */
  storesinglevar(varbuffer[i]);
 else				  /* indexed var */
 {
  int j;
  int upper=0;     	/* number of indexed variables upper */
  int param;		/* number of itens until indexed expression */
  for (j=i+1; j <nvarbuffer; j++)
   if (varbuffer[j] == 0) upper++;
  param = upper*2 + i;
  if (param == 0)
   code_byte(STOREINDEXED0);
  else
  {
   code_byte(STOREINDEXED);
   code_byte(param);
  }
 }
}

static void codeIf (Long thenAdd, Long elseAdd)
{
  Long elseinit = elseAdd+sizeof(Word)+1;
  if (pc == elseinit)		/* no else */
  {
    pc -= sizeof(Word)+1;
    elseinit = pc;
  }
  else
  {
    basepc[elseAdd] = JMP;
    code_word_at(basepc+elseAdd+1, pc-elseinit);
  }
  basepc[thenAdd] = IFFJMP;
  code_word_at(basepc+thenAdd+1,elseinit-(thenAdd+sizeof(Word)+1));
}


/*
** Parse LUA code.
*/
void lua_parse (TFunc *tf)
{
 initcode = &(tf->code);
 *initcode = newvector(CODE_BLOCK, Byte);
 maincode = 0; 
 maxmain = CODE_BLOCK;
 change2main();
 if (luaY_parse ()) lua_error("parse error");
 savemain();
 (*initcode)[maincode++] = RETCODE0;
 tf->size = maincode;
#if LISTING
{ static void PrintCode (Byte *c, Byte *end);
 PrintCode(*initcode,*initcode+maincode); }
#endif
}


#line 414 "lua.stx"
typedef union 
{
 int   vInt;
 float vFloat;
 char *pChar;
 Word  vWord;
 Long  vLong;
 TFunc *pFunc;
 TaggedString *pTStr;
} YYSTYPE;
#line 433 "y.tab.c"
#define WRONGTOKEN 257
#define NIL 258
#define IF 259
#define THEN 260
#define ELSE 261
#define ELSEIF 262
#define WHILE 263
#define DO 264
#define REPEAT 265
#define UNTIL 266
#define END 267
#define RETURN 268
#define LOCAL 269
#define FUNCTION 270
#define DOTS 271
#define NUMBER 272
#define STRING 273
#define NAME 274
#define AND 275
#define OR 276
#define EQ 277
#define NE 278
#define LE 279
#define GE 280
#define CONC 281
#define UNARY 282
#define NOT 283
#define YYERRCODE 256
short luaY_lhs[] = {                                        -1,
    0,   24,   24,   24,   28,   22,   22,   23,   31,   31,
   27,   27,   26,   34,   26,   35,   26,   26,   26,   26,
   33,   33,   33,   36,   30,   25,   25,    1,   32,    5,
    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
   38,    5,   39,    5,   40,   37,    4,    8,    8,    7,
    7,    2,    2,    3,   41,    3,   17,   17,   18,   18,
   19,   19,   42,    9,    9,   14,   14,   43,   43,   12,
   12,   13,   13,   44,   15,   15,   16,   16,    6,    6,
   20,   20,   20,   21,   29,   10,   10,   11,   11,
};
short luaY_len[] = {                                         2,
    2,    0,    3,    2,    3,    1,    3,    5,    0,    3,
    0,    1,    8,    0,    8,    0,    6,    3,    1,    3,
    0,    2,    7,    0,    3,    0,    3,    0,    1,    3,
    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
    3,    3,    2,    1,    1,    1,    1,    1,    1,    2,
    0,    5,    0,    5,    0,    4,    2,    1,    3,    3,
    1,    0,    1,    1,    0,    4,    0,    1,    1,    3,
    1,    1,    0,    3,    2,    0,    2,    0,    1,    0,
    2,    1,    3,    3,    0,    2,    1,    3,    1,    3,
    1,    4,    3,    1,    1,    1,    3,    0,    2,
};
short luaY_defred[] = {                                      2,
    0,    0,    0,   14,   16,    0,    0,    0,   94,   19,
    0,    0,    0,   91,    1,    0,    4,    0,   48,   46,
   47,    0,    0,    0,   49,   29,   95,    0,    0,   44,
    0,    0,   24,    0,    0,    0,    0,   96,    0,    0,
    0,    0,    0,    0,    0,   57,   61,   12,    3,    0,
    0,    0,    0,    0,    0,   28,   28,   28,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    9,   27,   65,    0,    0,   20,    0,
    5,    0,    0,    0,    0,    0,   59,    0,   93,   30,
   24,   51,   53,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   73,    0,
    0,   82,   28,    0,    0,    0,    0,   97,   72,   71,
    0,    0,   69,    7,   60,   92,   28,    0,    0,    0,
   56,    0,   75,    0,    0,   86,   24,    0,   25,    0,
    0,   24,    0,    0,    0,    0,    0,    0,   83,    0,
   74,    0,   28,   17,   10,    0,   70,   24,    0,    0,
   77,    0,    0,    8,   22,    0,   13,   81,   15,   28,
   24,   28,    0,   23,
};
short luaY_dgoto[] = {                                       1,
   91,   34,   35,   25,   26,   11,   46,   12,  107,   39,
   79,  161,  108,  151,  109,  110,  121,  122,  123,   27,
   14,   41,   81,    2,   15,   16,   49,   17,   28,   73,
  115,   37,  160,   32,   33,   74,   30,  128,  129,   31,
  116,  134,  133,  112,
};
short luaY_sindex[] = {                                      0,
    0,  332,  -38,    0,    0,  -38, -239, -223,    0,    0,
  -23,   17,    0,    0,    0,    3,    0,  137,    0,    0,
    0,  -38,  -38,  -38,    0,    0,    0,  137,  547,    0,
  -25,  -38,    0,    3,   45,    0,  212,    0,  -22,    0,
   52,  140,  -38, -223,  -38,    0,    0,    0,    0, -166,
  -38, -154,   40,   40,  102,    0,    0,    0,  -38,  -38,
  -38,  -38,  -38,  -38,  -38,  -38,  -38,  -38,  -38,  -38,
  -34,  481, -130,    0,    0,    0,  -38, -129,    0, -194,
    0, -123,   45,    0,  -17,  103,    0,  753,    0,    0,
    0,    0,    0,  -30,  -30,  -30,  -30,  -30,  -30,   95,
   11,   11,   40,   40,   40,   97,   41,  123,    0,  124,
  212,    0,    0,  -38,  -59,  -38,   45,    0,    0,    0,
  128,  131,    0,    0,    0,    0,    0,  -38,  -38,  -38,
    0,  -97,    0,  120,  -38,    0,    0,  212,    0,    3,
    0,    0, -194, -183,  118,  118,  212,   97,    0,  -97,
    0,  212,    0,    0,    0,  -85,    0,    0,  -38,  -82,
    0,  123,  -80,    0,    0, 1105,    0,    0,    0,    0,
    0,    0, -183,    0,
};
short luaY_rindex[] = {                                      0,
    0,  191,   69,    0,    0,  173,    0,    0,    0,    0,
    0,   69,  150,    0,    0,  146,    0,  -36,    0,    0,
    0,   69,   69,   69,    0,    0,    0,    1,    0,    0,
    0,   69,    0,   47,  461,  436,    0,    0,  197,  130,
    0,    0,   69,    0,  -33,    0,    0,    0,    0,    0,
   69,    0,   24,   59, 1181,    0,    0,    0,   69,   69,
   69,   69,   69,   69,   69,   69,   69,   69,   69,   69,
  -50,    0,    0,    0,    0,    0,   69,    0,    0,  152,
    0,    0,  311,  -21,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  746,  776,  799,  821,  844,  866,  505,
  383,  410,   88,  112,  359, 1174,    0,   74,    0,  -40,
  -26,    0,    0,   69, -230,   69,  921,    0,    0,    0,
    0,  160,    0,    0,    0,    0,    0,   69,   69,   69,
    0,   77,    0,   78,   -9,    0,    0,  939,    0,  289,
  474,    0,    0,  -60,  894, 1137,  -16,    0,    0,   89,
    0,  -10,    0,    0,    0,    0,    0,    0,   69,    0,
    0,   74,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  -60,    0,
};
short luaY_gindex[] = {                                      0,
  -31,  171,   85,   -2,   48,    0,    0,    0,    0,    0,
    0,    0,   67,    0,    0,    0,    0,    0,   75,    8,
    0,    0,    0,    0,  104,  107,  -29,    0,   12,  -61,
    0, 1260,   50,    0,    0,    0,  213,    0,    0,    0,
    0,    0, -107,   94,
};
#define YYTABLESIZE 1462
short luaY_table[] = {                                      10,
   45,   24,  136,   58,   75,   24,   22,   62,   85,   13,
   22,   68,   66,   18,   67,   40,   69,   87,   78,   42,
   44,   78,   90,   43,   95,   92,   93,   84,   52,  127,
   26,   26,   87,   88,   38,   26,   26,   43,   77,   90,
   58,   45,   45,   45,   45,   45,   11,   45,   88,   79,
    9,   84,   68,   36,  168,   85,   45,   69,   50,   45,
   45,   48,   45,   70,   43,   43,   43,   43,   43,   95,
   43,   55,   55,   51,   85,  153,  119,  158,  159,  120,
  156,  137,   43,   43,   78,   43,   58,   39,   76,   55,
   36,   80,   36,   45,   45,  144,  165,   71,   87,   50,
   50,   50,   50,   50,   70,   50,  154,   87,   84,  172,
  155,   40,   10,   55,   88,   79,   43,   50,   50,   89,
   50,  163,   13,   58,   36,   45,   18,   83,   39,   39,
   39,   39,   39,   70,   39,  114,   68,   66,  171,   67,
  173,   69,   90,  125,  118,   11,   39,   39,   43,   39,
  124,   50,   40,   40,   40,   40,   40,  130,   40,   68,
   66,  117,   67,  141,   69,  131,  132,  135,  142,    6,
   40,   40,   62,   40,  143,   95,  148,   62,  150,   61,
   39,  164,   52,   50,  167,   52,  169,   95,   70,   95,
   26,   55,   67,   89,   50,   95,   98,   82,   78,    3,
   68,   79,   76,    4,   40,    5,   21,   95,    6,    7,
   89,   70,   39,   80,    9,   86,  162,  157,  139,   19,
   95,  140,  174,   19,   47,  149,    0,   51,    0,    0,
   51,   62,    0,   20,   21,    9,   40,   20,   21,  106,
   95,    0,    0,    0,   23,    0,    0,    0,   23,    0,
   65,    0,    0,   68,   66,   98,   67,    0,   69,   45,
   45,   45,   45,   45,   45,   45,   45,   45,   45,   45,
   45,   62,   95,   61,   45,   45,   45,   45,   45,   45,
   45,   45,   43,   43,   43,   43,   43,   43,   43,   43,
   43,   43,   43,   43,    0,   55,    0,   43,   43,   43,
   43,   43,   43,   43,   43,   70,    0,   11,   11,    0,
   18,    0,   11,   11,    0,    0,    0,   50,   50,   50,
   50,   50,   50,   50,   50,   50,   50,   50,   50,    0,
    0,    0,   50,   50,   50,   50,   50,   50,   50,   50,
    0,    0,    0,    0,    0,    0,   39,   39,   39,   39,
   39,   39,   39,   39,   39,   39,   39,   39,   41,    0,
    0,   39,   39,   39,   39,   39,   39,   39,   39,   18,
   40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
   40,   40,   37,    0,    0,   40,   40,   40,   40,   40,
   40,   40,   40,    0,   59,   60,   63,   64,   65,   41,
   41,   41,   41,   41,   11,   41,    0,    0,   11,   38,
   11,    0,    0,   11,   11,   11,    0,   41,   41,   11,
   41,    0,    0,   37,    0,   37,   37,   37,    0,    0,
    0,    0,    0,   62,   62,   64,    0,    0,   62,   62,
    0,   37,   37,    0,   37,    0,    0,    0,    0,    0,
   38,   41,   38,   38,   38,   98,    0,   98,   98,   98,
   63,   98,   98,   98,   98,   98,   98,    0,   38,   38,
   98,   38,    0,   66,    0,   37,   64,   29,   29,   64,
   29,    0,   29,   41,    0,    0,   57,   58,   59,   60,
   63,   64,   65,    0,   64,   29,    0,   29,    0,    0,
    0,   63,   38,    0,   42,    0,    0,   37,    0,    0,
    0,    0,    0,    0,   66,   29,   29,   66,   29,   63,
   29,    0,   68,   66,    0,   67,    0,   69,    0,   29,
    0,    0,   66,   29,   38,   29,    0,    0,    0,    0,
   62,    0,   61,    0,    0,   42,    0,   11,   42,   11,
   11,   11,    0,   11,   11,   11,   11,   11,    0,    0,
    0,    0,   11,   42,   42,    0,   42,   29,    0,   18,
    0,   18,   18,   18,   70,   18,   18,   18,   18,   18,
   18,    0,    0,    0,   18,    0,    0,    0,   68,   66,
    3,   67,    0,   69,    4,    0,    5,   42,    0,    6,
    7,    8,    0,    0,    0,    9,   62,    0,   61,    0,
    0,    0,    0,    0,    0,    0,    0,   41,   41,   41,
   41,   41,   41,   41,   41,   41,   41,   41,   41,   42,
    0,    0,   41,   41,   41,   41,   41,   41,   41,   41,
   70,   37,   37,   37,   37,   37,   37,   37,   37,   37,
   37,   37,   37,    0,    0,    0,   37,   37,   37,   37,
   37,   37,   37,   37,    0,    0,    0,    0,   38,   38,
   38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
    0,    0,    0,   38,   38,   38,   38,   38,   38,   38,
   38,    0,    0,    0,   64,    0,   64,   64,   64,    0,
   64,   64,   64,   64,   64,   64,    0,    0,    0,   64,
   29,   29,   29,   29,   29,   29,   29,    0,    0,    0,
    0,   63,   63,    0,    0,    0,   63,   63,    0,    0,
    0,    0,   66,    0,   66,   66,   66,    0,   66,   66,
   66,   66,   66,   66,  113,   31,    0,   66,   29,   29,
   29,   29,   29,   29,   29,   57,   58,   59,   60,   63,
   64,   65,    0,   42,   42,   42,   42,   42,   42,   42,
   42,   42,   42,   42,   42,   34,    0,    0,   42,   42,
   42,   42,   42,   42,   42,   42,   31,    0,    0,   31,
    0,    0,    0,    0,   68,   66,    0,   67,   33,   69,
    0,    0,    0,    0,   31,   31,   56,   31,    0,    0,
    0,    0,   62,    0,   61,    0,   34,    0,    0,   34,
   32,   57,   58,   59,   60,   63,   64,   65,    0,    0,
    0,    0,    0,    0,   34,   34,    0,   34,   31,   33,
    0,    0,   33,   35,    0,  126,   70,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   33,   33,    0,
   33,   32,    0,    0,   32,   36,    0,    0,   34,    0,
   31,    0,    0,    0,    0,    0,    0,    0,    0,   32,
   32,    0,   32,    0,   35,    0,    0,   35,    0,    0,
    0,   33,    0,   52,    0,    0,    0,    0,    0,    0,
   34,    0,   35,   35,    0,   35,   36,    0,    0,   36,
    0,    0,    0,   32,    0,    0,    0,    0,    0,    0,
   99,    0,    0,   33,   36,   36,    0,   36,    0,    0,
    0,    0,    0,    0,   52,    0,   35,   52,   28,    0,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
    0,    0,   52,    0,    0,    0,    0,    0,   36,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   35,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   99,
    0,    0,    0,    0,    0,    0,   52,    0,    0,    0,
   36,    0,    0,    0,    0,    0,    0,   28,    0,    0,
    0,    0,    0,    0,   31,   31,   31,   31,   31,   31,
   31,   31,   31,   31,   31,   31,    0,    0,   52,   31,
   31,   31,   31,   31,   31,   31,    0,   57,   58,   59,
   60,   63,   64,   65,   34,   34,   34,   34,   34,   34,
   34,   34,   34,   34,   34,   34,    0,    0,    0,   34,
   34,   34,   34,   34,   34,   34,    0,   33,   33,   33,
   33,   33,   33,   33,   33,   33,   33,   33,   33,    0,
    0,    0,   33,   33,   33,   33,   33,   33,   33,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,    0,    0,    0,   32,   32,   32,   32,   32,   32,
   32,    0,   35,   35,   35,   35,   35,   35,   35,   35,
   35,   35,   35,   35,    0,    0,    0,   35,   35,   35,
   35,   35,   35,   35,   36,   36,   36,   36,   36,   36,
   36,   36,   36,   36,   36,   36,   54,    0,    0,   36,
   36,   36,   36,   36,   36,   36,   68,   66,    0,   67,
    0,   69,   52,   52,   52,   52,   52,   52,   52,   52,
   52,   52,   52,   52,   62,    0,   61,   52,   52,   52,
    0,    0,    0,    0,    0,    0,    0,   54,    0,   99,
   54,   99,   99,   99,    0,   99,   99,   99,   99,   99,
   99,    0,    0,    0,   99,   54,    0,   28,   70,   28,
   28,   28,    0,   28,   28,   28,   28,   28,   28,    0,
    0,    0,   28,   94,    0,   94,   94,   94,   94,   94,
   94,    0,   29,   29,    0,   29,    0,   29,    0,   54,
    0,   94,   94,   94,    0,   94,    0,    0,    0,    0,
   29,    0,   29,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   54,   29,    0,   94,    0,    0,   94,    0,    0,
    0,    0,    0,    0,   29,    0,    0,    0,    0,    0,
    0,   53,   54,    0,    0,    0,    0,    0,    0,    0,
    0,   72,    0,    0,    0,    0,   94,    0,   94,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   88,    0,    0,    0,    0,    0,    0,    0,   94,   95,
   96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
  111,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  170,    0,    0,    0,    0,    0,
    0,    0,    0,  138,    0,    0,    0,    0,    0,   57,
   58,   59,   60,   63,   64,   65,    0,  145,  146,  147,
    0,    0,    0,    0,  152,   54,   54,   54,   54,   54,
   54,   54,   54,   54,   54,   54,   54,    0,    0,    0,
   54,   54,   54,    0,    0,    0,    0,    0,  166,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   94,   94,
   94,   94,   94,   94,   94,   29,   29,   29,   29,   29,
   29,   29,
};
short luaY_check[] = {                                       2,
    0,   40,  110,   40,   34,   40,   45,   41,   59,    2,
   45,   42,   43,    2,   45,    8,   47,   44,   59,    8,
   44,   44,   44,    0,   46,   57,   58,   44,   46,   91,
  261,  262,   59,   44,  274,  266,  267,   61,   61,   61,
   40,   41,   42,   43,   44,   45,    0,   47,   59,   59,
  274,   44,   42,    6,  162,   44,   40,   47,    0,   59,
   60,   59,   62,   94,   41,   42,   43,   44,   45,   91,
   47,   24,  123,   91,  125,  137,  271,  261,  262,  274,
  142,  113,   59,   60,  125,   62,  123,    0,   44,  123,
   43,   40,   45,   93,   94,  127,  158,  123,  125,   41,
   42,   43,   44,   45,   94,   47,  138,  274,  125,  171,
  140,    0,  115,  123,  125,  125,   93,   59,   60,  274,
   62,  153,  115,  123,   77,  125,  115,   43,   41,   42,
   43,   44,   45,   94,   47,  266,   42,   43,  170,   45,
  172,   47,   41,   41,  274,    0,   59,   60,  125,   62,
  274,   93,   41,   42,   43,   44,   45,   61,   47,   42,
   43,   77,   45,  116,   47,  125,   44,   44,   41,   40,
   59,   60,    0,   62,   44,   46,  274,   60,   59,   62,
   93,  267,   46,  125,  267,   46,  267,   58,   94,   40,
    0,  123,   41,   44,   58,   46,    0,   58,  125,  259,
   41,  125,  125,  263,   93,  265,  267,   58,  268,  269,
   61,   94,  125,  125,  274,   45,  150,  143,  115,  258,
   91,  115,  173,  258,   12,  132,   -1,   91,   -1,   -1,
   91,   59,   -1,  272,  273,  274,  125,  272,  273,  274,
   91,   -1,   -1,   -1,  283,   -1,   -1,   -1,  283,   -1,
  281,   -1,   -1,   42,   43,   59,   45,   -1,   47,  259,
  260,  261,  262,  263,  264,  265,  266,  267,  268,  269,
  270,   60,  123,   62,  274,  275,  276,  277,  278,  279,
  280,  281,  259,  260,  261,  262,  263,  264,  265,  266,
  267,  268,  269,  270,   -1,  123,   -1,  274,  275,  276,
  277,  278,  279,  280,  281,   94,   -1,  261,  262,   -1,
    0,   -1,  266,  267,   -1,   -1,   -1,  259,  260,  261,
  262,  263,  264,  265,  266,  267,  268,  269,  270,   -1,
   -1,   -1,  274,  275,  276,  277,  278,  279,  280,  281,
   -1,   -1,   -1,   -1,   -1,   -1,  259,  260,  261,  262,
  263,  264,  265,  266,  267,  268,  269,  270,    0,   -1,
   -1,  274,  275,  276,  277,  278,  279,  280,  281,   59,
  259,  260,  261,  262,  263,  264,  265,  266,  267,  268,
  269,  270,    0,   -1,   -1,  274,  275,  276,  277,  278,
  279,  280,  281,   -1,  277,  278,  279,  280,  281,   41,
   42,   43,   44,   45,  259,   47,   -1,   -1,  263,    0,
  265,   -1,   -1,  268,  269,  270,   -1,   59,   60,  274,
   62,   -1,   -1,   41,   -1,   43,   44,   45,   -1,   -1,
   -1,   -1,   -1,  261,  262,    0,   -1,   -1,  266,  267,
   -1,   59,   60,   -1,   62,   -1,   -1,   -1,   -1,   -1,
   41,   93,   43,   44,   45,  259,   -1,  261,  262,  263,
    0,  265,  266,  267,  268,  269,  270,   -1,   59,   60,
  274,   62,   -1,    0,   -1,   93,   41,   42,   43,   44,
   45,   -1,   47,  125,   -1,   -1,  275,  276,  277,  278,
  279,  280,  281,   -1,   59,   60,   -1,   62,   -1,   -1,
   -1,   41,   93,   -1,    0,   -1,   -1,  125,   -1,   -1,
   -1,   -1,   -1,   -1,   41,   42,   43,   44,   45,   59,
   47,   -1,   42,   43,   -1,   45,   -1,   47,   -1,   94,
   -1,   -1,   59,   60,  125,   62,   -1,   -1,   -1,   -1,
   60,   -1,   62,   -1,   -1,   41,   -1,  259,   44,  261,
  262,  263,   -1,  265,  266,  267,  268,  269,   -1,   -1,
   -1,   -1,  274,   59,   60,   -1,   62,   94,   -1,  259,
   -1,  261,  262,  263,   94,  265,  266,  267,  268,  269,
  270,   -1,   -1,   -1,  274,   -1,   -1,   -1,   42,   43,
  259,   45,   -1,   47,  263,   -1,  265,   93,   -1,  268,
  269,  270,   -1,   -1,   -1,  274,   60,   -1,   62,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  259,  260,  261,
  262,  263,  264,  265,  266,  267,  268,  269,  270,  125,
   -1,   -1,  274,  275,  276,  277,  278,  279,  280,  281,
   94,  259,  260,  261,  262,  263,  264,  265,  266,  267,
  268,  269,  270,   -1,   -1,   -1,  274,  275,  276,  277,
  278,  279,  280,  281,   -1,   -1,   -1,   -1,  259,  260,
  261,  262,  263,  264,  265,  266,  267,  268,  269,  270,
   -1,   -1,   -1,  274,  275,  276,  277,  278,  279,  280,
  281,   -1,   -1,   -1,  259,   -1,  261,  262,  263,   -1,
  265,  266,  267,  268,  269,  270,   -1,   -1,   -1,  274,
  275,  276,  277,  278,  279,  280,  281,   -1,   -1,   -1,
   -1,  261,  262,   -1,   -1,   -1,  266,  267,   -1,   -1,
   -1,   -1,  259,   -1,  261,  262,  263,   -1,  265,  266,
  267,  268,  269,  270,  264,    0,   -1,  274,  275,  276,
  277,  278,  279,  280,  281,  275,  276,  277,  278,  279,
  280,  281,   -1,  259,  260,  261,  262,  263,  264,  265,
  266,  267,  268,  269,  270,    0,   -1,   -1,  274,  275,
  276,  277,  278,  279,  280,  281,   41,   -1,   -1,   44,
   -1,   -1,   -1,   -1,   42,   43,   -1,   45,    0,   47,
   -1,   -1,   -1,   -1,   59,   60,  260,   62,   -1,   -1,
   -1,   -1,   60,   -1,   62,   -1,   41,   -1,   -1,   44,
    0,  275,  276,  277,  278,  279,  280,  281,   -1,   -1,
   -1,   -1,   -1,   -1,   59,   60,   -1,   62,   93,   41,
   -1,   -1,   44,    0,   -1,   93,   94,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   60,   -1,
   62,   41,   -1,   -1,   44,    0,   -1,   -1,   93,   -1,
  125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,
   60,   -1,   62,   -1,   41,   -1,   -1,   44,   -1,   -1,
   -1,   93,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,
  125,   -1,   59,   60,   -1,   62,   41,   -1,   -1,   44,
   -1,   -1,   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,
    0,   -1,   -1,  125,   59,   60,   -1,   62,   -1,   -1,
   -1,   -1,   -1,   -1,   41,   -1,   93,   44,    0,   -1,
   -1,   -1,   -1,   -1,   -1,  125,   -1,   -1,   -1,   -1,
   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   93,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  125,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,
   -1,   -1,   -1,   -1,   -1,   -1,   93,   -1,   -1,   -1,
  125,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,
   -1,   -1,   -1,   -1,  259,  260,  261,  262,  263,  264,
  265,  266,  267,  268,  269,  270,   -1,   -1,  125,  274,
  275,  276,  277,  278,  279,  280,   -1,  275,  276,  277,
  278,  279,  280,  281,  259,  260,  261,  262,  263,  264,
  265,  266,  267,  268,  269,  270,   -1,   -1,   -1,  274,
  275,  276,  277,  278,  279,  280,   -1,  259,  260,  261,
  262,  263,  264,  265,  266,  267,  268,  269,  270,   -1,
   -1,   -1,  274,  275,  276,  277,  278,  279,  280,  259,
  260,  261,  262,  263,  264,  265,  266,  267,  268,  269,
  270,   -1,   -1,   -1,  274,  275,  276,  277,  278,  279,
  280,   -1,  259,  260,  261,  262,  263,  264,  265,  266,
  267,  268,  269,  270,   -1,   -1,   -1,  274,  275,  276,
  277,  278,  279,  280,  259,  260,  261,  262,  263,  264,
  265,  266,  267,  268,  269,  270,    0,   -1,   -1,  274,
  275,  276,  277,  278,  279,  280,   42,   43,   -1,   45,
   -1,   47,  259,  260,  261,  262,  263,  264,  265,  266,
  267,  268,  269,  270,   60,   -1,   62,  274,  275,  276,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   41,   -1,  259,
   44,  261,  262,  263,   -1,  265,  266,  267,  268,  269,
  270,   -1,   -1,   -1,  274,   59,   -1,  259,   94,  261,
  262,  263,   -1,  265,  266,  267,  268,  269,  270,   -1,
   -1,   -1,  274,   40,   -1,   42,   43,   44,   45,   46,
   47,   -1,   42,   43,   -1,   45,   -1,   47,   -1,   93,
   -1,   58,   59,   60,   -1,   62,   -1,   -1,   -1,   -1,
   60,   -1,   62,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  125,    3,   -1,   91,   -1,   -1,   94,   -1,   -1,
   -1,   -1,   -1,   -1,   94,   -1,   -1,   -1,   -1,   -1,
   -1,   22,   23,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   32,   -1,   -1,   -1,   -1,  123,   -1,  125,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   51,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   60,
   61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
   71,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  260,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  114,   -1,   -1,   -1,   -1,   -1,  275,
  276,  277,  278,  279,  280,  281,   -1,  128,  129,  130,
   -1,   -1,   -1,   -1,  135,  259,  260,  261,  262,  263,
  264,  265,  266,  267,  268,  269,  270,   -1,   -1,   -1,
  274,  275,  276,   -1,   -1,   -1,   -1,   -1,  159,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  275,  276,
  277,  278,  279,  280,  281,  275,  276,  277,  278,  279,
  280,  281,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 283
#if YYDEBUG
char *luaY_name[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,"'('","')'","'*'","'+'","','","'-'","'.'","'/'",0,0,0,0,0,0,0,0,0,0,
"':'","';'","'<'","'='","'>'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,"'['",0,"']'","'^'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,"'{'",0,"'}'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"WRONGTOKEN","NIL","IF","THEN","ELSE",
"ELSEIF","WHILE","DO","REPEAT","UNTIL","END","RETURN","LOCAL","FUNCTION","DOTS",
"NUMBER","STRING","NAME","AND","OR","EQ","NE","LE","GE","CONC","UNARY","NOT",
};
char *luaY_rule[] = {
"$accept : chunk",
"chunk : chunklist ret",
"chunklist :",
"chunklist : chunklist stat sc",
"chunklist : chunklist function",
"function : FUNCTION funcname body",
"funcname : var",
"funcname : varexp ':' NAME",
"body : '(' parlist ')' block END",
"statlist :",
"statlist : statlist stat sc",
"sc :",
"sc : ';'",
"stat : IF expr1 THEN PrepJump block PrepJump elsepart END",
"$$1 :",
"stat : WHILE $$1 expr1 DO PrepJump block PrepJump END",
"$$2 :",
"stat : REPEAT $$2 block UNTIL expr1 PrepJump",
"stat : varlist1 '=' exprlist1",
"stat : functioncall",
"stat : LOCAL localdeclist decinit",
"elsepart :",
"elsepart : ELSE block",
"elsepart : ELSEIF expr1 THEN PrepJump block PrepJump elsepart",
"$$3 :",
"block : $$3 statlist ret",
"ret :",
"ret : RETURN exprlist sc",
"PrepJump :",
"expr1 : expr",
"expr : '(' expr ')'",
"expr : expr1 EQ expr1",
"expr : expr1 '<' expr1",
"expr : expr1 '>' expr1",
"expr : expr1 NE expr1",
"expr : expr1 LE expr1",
"expr : expr1 GE expr1",
"expr : expr1 '+' expr1",
"expr : expr1 '-' expr1",
"expr : expr1 '*' expr1",
"expr : expr1 '/' expr1",
"expr : expr1 '^' expr1",
"expr : expr1 CONC expr1",
"expr : '-' expr1",
"expr : table",
"expr : varexp",
"expr : NUMBER",
"expr : STRING",
"expr : NIL",
"expr : functioncall",
"expr : NOT expr1",
"$$4 :",
"expr : expr1 AND PrepJump $$4 expr1",
"$$5 :",
"expr : expr1 OR PrepJump $$5 expr1",
"$$6 :",
"table : $$6 '{' fieldlist '}'",
"functioncall : funcvalue funcParams",
"funcvalue : varexp",
"funcvalue : varexp ':' NAME",
"funcParams : '(' exprlist ')'",
"funcParams : table",
"exprlist :",
"exprlist : exprlist1",
"exprlist1 : expr",
"$$7 :",
"exprlist1 : exprlist1 ',' $$7 expr",
"parlist :",
"parlist : parlist1",
"parlist1 : par",
"parlist1 : parlist1 ',' par",
"par : NAME",
"par : DOTS",
"$$8 :",
"fieldlist : lfieldlist $$8 semicolonpart",
"fieldlist : ffieldlist1 lastcomma",
"semicolonpart :",
"semicolonpart : ';' ffieldlist",
"lastcomma :",
"lastcomma : ','",
"ffieldlist :",
"ffieldlist : ffieldlist1 lastcomma",
"ffieldlist1 : ffield",
"ffieldlist1 : ffieldlist1 ',' ffield",
"ffield : NAME '=' expr1",
"lfieldlist :",
"lfieldlist : lfieldlist1 lastcomma",
"lfieldlist1 : expr1",
"lfieldlist1 : lfieldlist1 ',' expr1",
"varlist1 : var",
"varlist1 : varlist1 ',' var",
"var : singlevar",
"var : varexp '[' expr1 ']'",
"var : varexp '.' NAME",
"singlevar : NAME",
"varexp : var",
"localdeclist : NAME",
"localdeclist : localdeclist ',' NAME",
"decinit :",
"decinit : '=' exprlist1",
};
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int luaY_debug;
int luaY_nerrs;
int luaY_errflag;
int luaY_char;
short *luaY_ssp;
YYSTYPE *luaY_vsp;
YYSTYPE luaY_val;
YYSTYPE luaY_lval;
short luaY_ss[YYSTACKSIZE];
YYSTYPE luaY_vs[YYSTACKSIZE];
#define luaY_stacksize YYSTACKSIZE
#define YYABORT goto luaY_abort
#define YYREJECT goto luaY_abort
#define YYACCEPT goto luaY_accept
#define YYERROR goto luaY_errlab
int
luaY_parse()
{
    register int luaY_m, luaY_n, luaY_state;
#if YYDEBUG
    register char *luaY_s;
    extern char *getenv();

    if (luaY_s = getenv("YYDEBUG"))
    {
        luaY_n = *luaY_s;
        if (luaY_n >= '0' && luaY_n <= '9')
            luaY_debug = luaY_n - '0';
    }
#endif

    luaY_nerrs = 0;
    luaY_errflag = 0;
    luaY_char = (-1);

    luaY_ssp = luaY_ss;
    luaY_vsp = luaY_vs;
    *luaY_ssp = luaY_state = 0;

luaY_loop:
    if (luaY_n = luaY_defred[luaY_state]) goto luaY_reduce;
    if (luaY_char < 0)
    {
        if ((luaY_char = luaY_lex()) < 0) luaY_char = 0;
#if YYDEBUG
        if (luaY_debug)
        {
            luaY_s = 0;
            if (luaY_char <= YYMAXTOKEN) luaY_s = luaY_name[luaY_char];
            if (!luaY_s) luaY_s = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, luaY_state, luaY_char, luaY_s);
        }
#endif
    }
    if ((luaY_n = luaY_sindex[luaY_state]) && (luaY_n += luaY_char) >= 0 &&
            luaY_n <= YYTABLESIZE && luaY_check[luaY_n] == luaY_char)
    {
#if YYDEBUG
        if (luaY_debug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, luaY_state, luaY_table[luaY_n]);
#endif
        if (luaY_ssp >= luaY_ss + luaY_stacksize - 1)
        {
            goto luaY_overflow;
        }
        *++luaY_ssp = luaY_state = luaY_table[luaY_n];
        *++luaY_vsp = luaY_lval;
        luaY_char = (-1);
        if (luaY_errflag > 0)  --luaY_errflag;
        goto luaY_loop;
    }
    if ((luaY_n = luaY_rindex[luaY_state]) && (luaY_n += luaY_char) >= 0 &&
            luaY_n <= YYTABLESIZE && luaY_check[luaY_n] == luaY_char)
    {
        luaY_n = luaY_table[luaY_n];
        goto luaY_reduce;
    }
    if (luaY_errflag) goto luaY_inrecovery;
#ifdef lint
    goto luaY_newerror;
#endif
luaY_newerror:
    luaY_error("syntax error");
#ifdef lint
    goto luaY_errlab;
#endif
luaY_errlab:
    ++luaY_nerrs;
luaY_inrecovery:
    if (luaY_errflag < 3)
    {
        luaY_errflag = 3;
        for (;;)
        {
            if ((luaY_n = luaY_sindex[*luaY_ssp]) && (luaY_n += YYERRCODE) >= 0 &&
                    luaY_n <= YYTABLESIZE && luaY_check[luaY_n] == YYERRCODE)
            {
#if YYDEBUG
                if (luaY_debug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *luaY_ssp, luaY_table[luaY_n]);
#endif
                if (luaY_ssp >= luaY_ss + luaY_stacksize - 1)
                {
                    goto luaY_overflow;
                }
                *++luaY_ssp = luaY_state = luaY_table[luaY_n];
                *++luaY_vsp = luaY_lval;
                goto luaY_loop;
            }
            else
            {
#if YYDEBUG
                if (luaY_debug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *luaY_ssp);
#endif
                if (luaY_ssp <= luaY_ss) goto luaY_abort;
                --luaY_ssp;
                --luaY_vsp;
            }
        }
    }
    else
    {
        if (luaY_char == 0) goto luaY_abort;
#if YYDEBUG
        if (luaY_debug)
        {
            luaY_s = 0;
            if (luaY_char <= YYMAXTOKEN) luaY_s = luaY_name[luaY_char];
            if (!luaY_s) luaY_s = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, luaY_state, luaY_char, luaY_s);
        }
#endif
        luaY_char = (-1);
        goto luaY_loop;
    }
luaY_reduce:
#if YYDEBUG
    if (luaY_debug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, luaY_state, luaY_n, luaY_rule[luaY_n]);
#endif
    luaY_m = luaY_len[luaY_n];
    luaY_val = luaY_vsp[1-luaY_m];
    switch (luaY_n)
    {
case 5:
#line 470 "lua.stx"
{ 
		code_byte(PUSHFUNCTION);
		code_code(luaY_vsp[0].pFunc);
		storesinglevar(luaY_vsp[-1].vLong);
	       }
break;
case 6:
#line 477 "lua.stx"
{ luaY_val.vLong =luaY_vsp[0].vLong; init_func(); }
break;
case 7:
#line 479 "lua.stx"
{
	  code_byte(PUSHSTRING);
	  code_word(luaI_findconstant(luaY_vsp[0].pTStr));
	  luaY_val.vLong = 0;  /* indexed variable */
	  init_func();
	  add_localvar(luaI_createfixedstring("self"));
	}
break;
case 8:
#line 489 "lua.stx"
{
          codereturn();
	  luaY_val.pFunc = new(TFunc);
          luaI_initTFunc(luaY_val.pFunc);
	  luaY_val.pFunc->size = pc;
	  luaY_val.pFunc->code = newvector(pc, Byte);
	  luaY_val.pFunc->fileName = lua_parsedfile;
	  luaY_val.pFunc->lineDefined = luaY_vsp[-3].vInt;
	  memcpy(luaY_val.pFunc->code, basepc, pc*sizeof(Byte));
          if (lua_debug)
            luaI_closelocalvars(luaY_val.pFunc);
	  /* save func values */
	  funcCode = basepc; maxcode=maxcurr;
#if LISTING
                PrintCode(funcCode,funcCode+pc);
#endif
	  change2main();  /* change back to main code */
	}
break;
case 13:
#line 516 "lua.stx"
{ codeIf(luaY_vsp[-4].vLong, luaY_vsp[-2].vLong); }
break;
case 14:
#line 518 "lua.stx"
{luaY_val.vLong=pc;}
break;
case 15:
#line 519 "lua.stx"
{
        basepc[luaY_vsp[-3].vLong] = IFFJMP;
	code_word_at(basepc+luaY_vsp[-3].vLong+1, pc - (luaY_vsp[-3].vLong + sizeof(Word)+1));
        basepc[luaY_vsp[-1].vLong] = UPJMP;
	code_word_at(basepc+luaY_vsp[-1].vLong+1, pc - (luaY_vsp[-6].vLong));
       }
break;
case 16:
#line 526 "lua.stx"
{luaY_val.vLong=pc;}
break;
case 17:
#line 527 "lua.stx"
{
        basepc[luaY_vsp[0].vLong] = IFFUPJMP;
	code_word_at(basepc+luaY_vsp[0].vLong+1, pc - (luaY_vsp[-4].vLong));
       }
break;
case 18:
#line 533 "lua.stx"
{
        {
         int i;
         adjust_mult_assign(nvarbuffer, luaY_vsp[0].vLong, luaY_vsp[-2].vInt * 2 + nvarbuffer);
	 for (i=nvarbuffer-1; i>=0; i--)
	  lua_codestore (i);
	 if (luaY_vsp[-2].vInt > 1 || (luaY_vsp[-2].vInt == 1 && varbuffer[0] != 0))
	  lua_codeadjust (0);
	}
       }
break;
case 20:
#line 545 "lua.stx"
{ nlocalvar += luaY_vsp[-1].vInt;
	  adjust_mult_assign(luaY_vsp[-1].vInt, luaY_vsp[0].vInt, 0);
	}
break;
case 23:
#line 553 "lua.stx"
{ codeIf(luaY_vsp[-3].vLong, luaY_vsp[-1].vLong); }
break;
case 24:
#line 556 "lua.stx"
{luaY_val.vInt = nlocalvar;}
break;
case 25:
#line 557 "lua.stx"
{
	  if (nlocalvar != luaY_vsp[-2].vInt)
	  {
           if (lua_debug)
             for (; nlocalvar > luaY_vsp[-2].vInt; nlocalvar--)
               luaI_unregisterlocalvar(lua_linenumber);
           else
             nlocalvar = luaY_vsp[-2].vInt;
	   lua_codeadjust (0);
	  }
         }
break;
case 27:
#line 572 "lua.stx"
{
	   adjust_functioncall(luaY_vsp[-1].vLong, MULT_RET);
           codereturn();
          }
break;
case 28:
#line 579 "lua.stx"
{ 
	  luaY_val.vLong = pc;
	  code_byte(0);		/* open space */
	  code_word (0);
         }
break;
case 29:
#line 586 "lua.stx"
{ adjust_functioncall(luaY_vsp[0].vLong, 1); }
break;
case 30:
#line 589 "lua.stx"
{ luaY_val.vLong = luaY_vsp[-1].vLong; }
break;
case 31:
#line 590 "lua.stx"
{ code_byte(EQOP);   luaY_val.vLong = 0; }
break;
case 32:
#line 591 "lua.stx"
{ code_byte(LTOP);   luaY_val.vLong = 0; }
break;
case 33:
#line 592 "lua.stx"
{ code_byte(GTOP);   luaY_val.vLong = 0; }
break;
case 34:
#line 593 "lua.stx"
{ code_byte(EQOP); code_byte(NOTOP); luaY_val.vLong = 0; }
break;
case 35:
#line 594 "lua.stx"
{ code_byte(LEOP);   luaY_val.vLong = 0; }
break;
case 36:
#line 595 "lua.stx"
{ code_byte(GEOP);   luaY_val.vLong = 0; }
break;
case 37:
#line 596 "lua.stx"
{ code_byte(ADDOP);  luaY_val.vLong = 0; }
break;
case 38:
#line 597 "lua.stx"
{ code_byte(SUBOP);  luaY_val.vLong = 0; }
break;
case 39:
#line 598 "lua.stx"
{ code_byte(MULTOP); luaY_val.vLong = 0; }
break;
case 40:
#line 599 "lua.stx"
{ code_byte(DIVOP);  luaY_val.vLong = 0; }
break;
case 41:
#line 600 "lua.stx"
{ code_byte(POWOP);  luaY_val.vLong = 0; }
break;
case 42:
#line 601 "lua.stx"
{ code_byte(CONCOP);  luaY_val.vLong = 0; }
break;
case 43:
#line 602 "lua.stx"
{ code_byte(MINUSOP); luaY_val.vLong = 0;}
break;
case 44:
#line 603 "lua.stx"
{ luaY_val.vLong = 0; }
break;
case 45:
#line 604 "lua.stx"
{ luaY_val.vLong = 0;}
break;
case 46:
#line 605 "lua.stx"
{ code_number(luaY_vsp[0].vFloat); luaY_val.vLong = 0; }
break;
case 47:
#line 607 "lua.stx"
{
      code_byte(PUSHSTRING);
      code_word(luaY_vsp[0].vWord);
      luaY_val.vLong = 0;
     }
break;
case 48:
#line 612 "lua.stx"
{code_byte(PUSHNIL); luaY_val.vLong = 0; }
break;
case 49:
#line 613 "lua.stx"
{ luaY_val.vLong = luaY_vsp[0].vLong; }
break;
case 50:
#line 614 "lua.stx"
{ code_byte(NOTOP);  luaY_val.vLong = 0;}
break;
case 51:
#line 615 "lua.stx"
{code_byte(POP); }
break;
case 52:
#line 616 "lua.stx"
{ 
      basepc[luaY_vsp[-2].vLong] = ONFJMP;
      code_word_at(basepc+luaY_vsp[-2].vLong+1, pc - (luaY_vsp[-2].vLong + sizeof(Word)+1));
      luaY_val.vLong = 0;
     }
break;
case 53:
#line 621 "lua.stx"
{code_byte(POP); }
break;
case 54:
#line 622 "lua.stx"
{ 
      basepc[luaY_vsp[-2].vLong] = ONTJMP;
      code_word_at(basepc+luaY_vsp[-2].vLong+1, pc - (luaY_vsp[-2].vLong + sizeof(Word)+1));
      luaY_val.vLong = 0;
     }
break;
case 55:
#line 630 "lua.stx"
{
      code_byte(CREATEARRAY);
      luaY_val.vLong = pc; code_word(0);
     }
break;
case 56:
#line 635 "lua.stx"
{
      code_word_at(basepc+luaY_vsp[-3].vLong, luaY_vsp[-1].vInt);
     }
break;
case 57:
#line 641 "lua.stx"
{
	  code_byte(CALLFUNC);
	  code_byte(luaY_vsp[-1].vInt+luaY_vsp[0].vInt);
	  luaY_val.vLong = pc;
	  code_byte(0);  /* may be modified by other rules */
	}
break;
case 58:
#line 649 "lua.stx"
{ luaY_val.vInt = 0; }
break;
case 59:
#line 651 "lua.stx"
{ 
               code_byte(PUSHSELF); 
	       code_word(luaI_findconstant(luaY_vsp[0].pTStr));
               luaY_val.vInt = 1;
	     }
break;
case 60:
#line 659 "lua.stx"
{ luaY_val.vInt = adjust_functioncall(luaY_vsp[-1].vLong, 1); }
break;
case 61:
#line 660 "lua.stx"
{ luaY_val.vInt = 1; }
break;
case 62:
#line 663 "lua.stx"
{ luaY_val.vLong = 0; }
break;
case 63:
#line 664 "lua.stx"
{ luaY_val.vLong = luaY_vsp[0].vLong; }
break;
case 64:
#line 667 "lua.stx"
{ if (luaY_vsp[0].vLong != 0) luaY_val.vLong = luaY_vsp[0].vLong; else luaY_val.vLong = -1; }
break;
case 65:
#line 668 "lua.stx"
{ luaY_val.vLong = adjust_functioncall(luaY_vsp[-1].vLong, 1); }
break;
case 66:
#line 669 "lua.stx"
{
	  if (luaY_vsp[0].vLong == 0) luaY_val.vLong = -(luaY_vsp[-1].vLong + 1);  /* -length */
	  else
	  {
	    adjust_functioncall(luaY_vsp[0].vLong, luaY_vsp[-1].vLong);
	    luaY_val.vLong = luaY_vsp[0].vLong;
	  }
	}
break;
case 67:
#line 679 "lua.stx"
{ luaY_val.vInt = close_parlist(0); }
break;
case 68:
#line 680 "lua.stx"
{ luaY_val.vInt = close_parlist(luaY_vsp[0].vInt); }
break;
case 69:
#line 683 "lua.stx"
{ luaY_val.vInt = luaY_vsp[0].vInt; }
break;
case 70:
#line 685 "lua.stx"
{
	  if (luaY_vsp[-2].vInt)
            lua_error("invalid parameter list");
          luaY_val.vInt = luaY_vsp[0].vInt;
	}
break;
case 71:
#line 692 "lua.stx"
{ add_localvar(luaY_vsp[0].pTStr); luaY_val.vInt = 0; }
break;
case 72:
#line 693 "lua.stx"
{ luaY_val.vInt = 1; }
break;
case 73:
#line 697 "lua.stx"
{ flush_list(luaY_vsp[0].vInt/FIELDS_PER_FLUSH, luaY_vsp[0].vInt%FIELDS_PER_FLUSH); }
break;
case 74:
#line 699 "lua.stx"
{ luaY_val.vInt = luaY_vsp[-2].vInt+luaY_vsp[0].vInt; }
break;
case 75:
#line 701 "lua.stx"
{ luaY_val.vInt = luaY_vsp[-1].vInt; flush_record(luaY_vsp[-1].vInt%FIELDS_PER_FLUSH); }
break;
case 76:
#line 705 "lua.stx"
{ luaY_val.vInt = 0; }
break;
case 77:
#line 707 "lua.stx"
{ luaY_val.vInt = luaY_vsp[0].vInt; flush_record(luaY_vsp[0].vInt%FIELDS_PER_FLUSH); }
break;
case 80:
#line 714 "lua.stx"
{ luaY_val.vInt = 0; }
break;
case 81:
#line 715 "lua.stx"
{ luaY_val.vInt = luaY_vsp[-1].vInt; }
break;
case 82:
#line 718 "lua.stx"
{luaY_val.vInt=1;}
break;
case 83:
#line 720 "lua.stx"
{
		  luaY_val.vInt=luaY_vsp[-2].vInt+1;
		  if (luaY_val.vInt%FIELDS_PER_FLUSH == 0) flush_record(FIELDS_PER_FLUSH);
		}
break;
case 84:
#line 727 "lua.stx"
{ 
	       push_field(luaI_findconstant(luaY_vsp[-2].pTStr));
	      }
break;
case 85:
#line 732 "lua.stx"
{ luaY_val.vInt = 0; }
break;
case 86:
#line 733 "lua.stx"
{ luaY_val.vInt = luaY_vsp[-1].vInt; }
break;
case 87:
#line 736 "lua.stx"
{luaY_val.vInt=1;}
break;
case 88:
#line 738 "lua.stx"
{
		  luaY_val.vInt=luaY_vsp[-2].vInt+1;
		  if (luaY_val.vInt%FIELDS_PER_FLUSH == 0) 
		    flush_list(luaY_val.vInt/FIELDS_PER_FLUSH - 1, FIELDS_PER_FLUSH);
		}
break;
case 89:
#line 746 "lua.stx"
{
	   nvarbuffer = 0; 
	   add_varbuffer(luaY_vsp[0].vLong);
	   luaY_val.vInt = (luaY_vsp[0].vLong == 0) ? 1 : 0;
	  }
break;
case 90:
#line 752 "lua.stx"
{ 
	   add_varbuffer(luaY_vsp[0].vLong);
	   luaY_val.vInt = (luaY_vsp[0].vLong == 0) ? luaY_vsp[-2].vInt + 1 : luaY_vsp[-2].vInt;
	  }
break;
case 91:
#line 758 "lua.stx"
{ luaY_val.vLong = luaY_vsp[0].vLong; }
break;
case 92:
#line 760 "lua.stx"
{
	   luaY_val.vLong = 0;		/* indexed variable */
	  }
break;
case 93:
#line 764 "lua.stx"
{
	   code_byte(PUSHSTRING);
	   code_word(luaI_findconstant(luaY_vsp[0].pTStr));
	   luaY_val.vLong = 0;		/* indexed variable */
	  }
break;
case 94:
#line 772 "lua.stx"
{
	   int local = lua_localname(luaY_vsp[0].pTStr);
	   if (local == -1)	/* global var */
	    luaY_val.vLong = luaI_findsymbol(luaY_vsp[0].pTStr)+1;  /* return positive value */
           else
	    luaY_val.vLong = -(local+1);		/* return negative value */
	  }
break;
case 95:
#line 781 "lua.stx"
{ lua_pushvar(luaY_vsp[0].vLong); }
break;
case 96:
#line 784 "lua.stx"
{store_localvar(luaY_vsp[0].pTStr, 0); luaY_val.vInt = 1;}
break;
case 97:
#line 786 "lua.stx"
{
	     store_localvar(luaY_vsp[0].pTStr, luaY_vsp[-2].vInt);
	     luaY_val.vInt = luaY_vsp[-2].vInt+1;
	    }
break;
case 98:
#line 792 "lua.stx"
{ luaY_val.vInt = 0; }
break;
case 99:
#line 793 "lua.stx"
{ luaY_val.vInt = luaY_vsp[0].vLong; }
break;
#line 1613 "y.tab.c"
    }
    luaY_ssp -= luaY_m;
    luaY_state = *luaY_ssp;
    luaY_vsp -= luaY_m;
    luaY_m = luaY_lhs[luaY_n];
    if (luaY_state == 0 && luaY_m == 0)
    {
#if YYDEBUG
        if (luaY_debug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        luaY_state = YYFINAL;
        *++luaY_ssp = YYFINAL;
        *++luaY_vsp = luaY_val;
        if (luaY_char < 0)
        {
            if ((luaY_char = luaY_lex()) < 0) luaY_char = 0;
#if YYDEBUG
            if (luaY_debug)
            {
                luaY_s = 0;
                if (luaY_char <= YYMAXTOKEN) luaY_s = luaY_name[luaY_char];
                if (!luaY_s) luaY_s = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, luaY_char, luaY_s);
            }
#endif
        }
        if (luaY_char == 0) goto luaY_accept;
        goto luaY_loop;
    }
    if ((luaY_n = luaY_gindex[luaY_m]) && (luaY_n += luaY_state) >= 0 &&
            luaY_n <= YYTABLESIZE && luaY_check[luaY_n] == luaY_state)
        luaY_state = luaY_table[luaY_n];
    else
        luaY_state = luaY_dgoto[luaY_m];
#if YYDEBUG
    if (luaY_debug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *luaY_ssp, luaY_state);
#endif
    if (luaY_ssp >= luaY_ss + luaY_stacksize - 1)
    {
        goto luaY_overflow;
    }
    *++luaY_ssp = luaY_state;
    *++luaY_vsp = luaY_val;
    goto luaY_loop;
luaY_overflow:
    luaY_error("yacc stack overflow");
luaY_abort:
    return (1);
luaY_accept:
    return (0);
}
