/* ************************************************************************
*   File: Guild.h                                                         *
*  Usage: GuildMaster's: Definition for everything needed by shop.c       *
*                                                                         *
* Written by Jason Goodwin.   jgoodwin@expert.cc.purdue.edu               *
************************************************************************ */
 
struct guild_master_data {
int num;             /* number of the guild */
int skills_and_spells[MAX_SKILLS+1];  /*array to keep track of which things we'll train */
float charge;             /* charge * skill level = how much we'll charge */
char *no_such_skill;  /* message when we don't teach that skill */
char *not_enough_gold;  /* message when the student doesn't have enough gold */
int type;   /* does GM teach skills or spells? */
int gm;    /* GM's vnum */
int with_who;  /* whom we dislike */
int open, close;  /*when we will train */
SPECIAL(*func);  /* secondary spec_proc for the GM */
};

/* Whom will we not train  */
#define TRAIN_NOGOOD		1
#define TRAIN_NOEVIL			2
#define TRAIN_NONEUTRAL		4
#define TRAIN_NOMAGE		8
#define TRAIN_NOCLERIC		16
#define TRAIN_NOTHIEF		32
#define TRAIN_NOWARRIOR		64

#define GM_NUM(i)  (gm_index[i].num)
#define GM_CHARGE(i) (gm_index[i].charge)
#define GM_TYPE(i) (gm_index[i].type)
#define GM_TRAINER(i) (gm_index[i].gm)
#define GM_WITH_WHO(i) (gm_index[i].with_who)
#define GM_OPEN(i) (gm_index[i].open)
#define GM_CLOSE(i) (gm_index[i].close)
#define GM_FUNC(i) (gm_index[i].func)
#define GM_COST(i,j,k) (int) (GM_CHARGE(i)*\
                              spell_info[j].min_level[(int)GET_CLASS(k)])

#define NOTRAIN_GOOD(i)		(IS_SET((GM_WITH_WHO(i)),TRAIN_NOGOOD))
#define NOTRAIN_EVIL(i)		(IS_SET((GM_WITH_WHO(i)),TRAIN_NOEVIL))
#define NOTRAIN_NEUTRAL(i)	(IS_SET((GM_WITH_WHO(i)),TRAIN_NONEUTRAL))
#define NOTRAIN_MAGE(i)		(IS_SET((GM_WITH_WHO(i)),TRAIN_NOMAGE))
#define NOTRAIN_CLERIC(i)	(IS_SET((GM_WITH_WHO(i)),TRAIN_NOCLERIC))
#define NOTRAIN_THIEF(i)	(IS_SET((GM_WITH_WHO(i)),TRAIN_NOTHIEF))
#define NOTRAIN_WARRIOR(i)	(IS_SET((GM_WITH_WHO(i)), TRAIN_NOWARRIOR))

#define GM_SPLSKL(i) (GM_TYPE(i) ?  "spell" : "skill")

#define MSG_TRAINER_NOT_OPEN 	 "I'm busy! Come back later!"
#define MSG_TRAINER_NO_SEE_CH 	 "I don't train someone I can't see!"
#define MSG_TRAINER_DISLIKE_ALIGN  "Get out of here before I get angry!"
#define MSG_TRAINER_DISLIKE_CLASS "I don't like your kind!"

#define LEARNED_LEVEL   0       /* % known which is considered "learned" */
#define MAX_PER_PRAC    1       /* max percent gain in skill per practice */
#define MIN_PER_PRAC    2       /* min percent gain in skill per practice */
#define PRAC_TYPE       3       /* should it say 'spell' or 'skill'?     */


#define LEARNED(ch) (prac_params[LEARNED_LEVEL][(int)GET_CLASS(ch)])
#define MINGAIN(ch) (prac_params[MIN_PER_PRAC][(int)GET_CLASS(ch)])
#define MAXGAIN(ch) (prac_params[MAX_PER_PRAC][(int)GET_CLASS(ch)])
#define SPLSKL(ch) (prac_types[prac_params[PRAC_TYPE][(int)GET_CLASS(ch)]])

