#ifndef lint
static char *RCSid = "$Header: load.c,v 1.15 90/03/19 11:09:53 mr-frog Exp $";
#endif /* not lint */

/*
 * load.c
 *
 * load (unload) goods from a sector onto a ship
 *
 * from PSL Empire, 1985
 *
 * hacked to allow planes/missiles to be loaded onto carriers/subs
 * by David Sharnoff 1987 
 * XXX needs to be told "plane" or commodity before amount.
 */

#include "misc.h"
#include "xy.h"
#include "file.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "plane.h"	
#include "item.h"
#include "nsc.h"
#include "nat.h"

/*
 * The values 1 and -1 are important below, don't change them.
 */
#define	LOAD	1
#define	UNLOAD	-1

int
load()
{
	extern	char *argp[];
	register struct ichrstr *ich;
	register int item;
	register int max_amt;
	register int move_amt;
	register int ship_amt;
	register int sect_amt;
	struct shpstr ship;
	struct sctstr sect;
	struct plnstr pln;	/* for nuke subs */
	int     load_unload;
	int     ship_num;
	int     amount;
	int     is_plane;
	int     nplanes;
	struct nstr_item nbst;
	char	*p;
	char	*i;
	int	nships;

	if (!(p = getstarg(argp[1], "Ship(s): ")))
		return RET_SYN;
	if (!snxtitem(&nbst, EF_SHIP, p))
		return RET_SYN;
#ifdef	ALLYHARBOR
	nbst.flags &= ~(EFF_OWNER);
#endif	ALLYHARBOR
	load_unload = **argp == 'l' ? LOAD : UNLOAD;
	p = getstarg(argp[2], "Amount or plane #: ");
	if (p == 0 || *p == 0)
		return RET_SYN;
	amount = atoi(p);
	if (amount < 0) {	/* plane 0 is a valid plane number */
		pr("Amount must be non-negative.\n");
		return RET_SYN;
	}
	i = getstarg(argp[3], "What commodity ('plane' for a plane): ");
	if (i == 0 || i[0] == '\0')
		return RET_SYN;
	is_plane = !strncmp(i, "plane", 5);	/* XXX */
	if (!is_plane) {
		ich = whatitem(i, (char *)0);
		if (ich == 0) {
			pr("Bad commodity.\n");
			return RET_SYN;
		}
		if (amount == 0) {
			pr("Amount must be positive\n");
			return RET_SYN;
		}
	}
	if (is_plane) {	/* plane sanity */
		if (!getplane(amount, &pln))
			return RET_SYN;
		if (pln.pln_own != cnum) {
			pr("Not your plane\n");
			return RET_FAIL;
		}
		if (!(plchr[pln.pln_type].pl_flags & P_L)) {
			pr(
	"You can only load light missiles or light planes onto ships.\n");
			return RET_FAIL;
		}
		if (load_unload == LOAD && pln.pln_ship > -1) {
			pr(fmt("Plane #%d is already on ship #%d!\n",
				pln.pln_uid, pln.pln_ship));
			return RET_FAIL;
		}
	}
	nships = 0;
	while (nxtitem(&nbst, (char *)&ship)) {
#ifdef	ALLYHARBOR
		if (!ship.shp_own)
#else
		if (!owner)
#endif	ALLYHARBOR
			continue;
#ifdef	ALLYHARBOR
		if (!owner && (load_unload == UNLOAD)) {
			continue;
		}
#endif	ALLYHARBOR
		ship_num = ship.shp_uid;
#ifdef	ALLYHARBOR
		if (!getsect(ship.shp_x, ship.shp_y, &sect)) /* XXX */
			continue;
		if ((sect.sct_own != cnum) && (ship.shp_own != cnum))
			continue;
#endif	ALLYHARBOR
#ifdef	SHIPNAMES
		pr(fmt("\t%s %s(#%d) at %s\n", mchr[ship.shp_type].m_name,
			ship.shp_name, ship_num, xyas(ship.shp_x, ship.shp_y,
			cnum)));
#else
		pr(fmt("\t%s #%d at %s\n", mchr[ship.shp_type].m_name,
			ship_num, xyas(ship.shp_x, ship.shp_y, cnum)));
#endif	SHIPNAMES
#ifdef	ALLYHARBOR
		if ((sect.sct_own != cnum) && (load_unload == LOAD)) {
			pr(fmt("You don't own %s \n",
#else
		if (!getsect(ship.shp_x, ship.shp_y, &sect)) /* XXX */
			continue;
		if (sect.sct_own != ship.shp_own) {
			pr(fmt("Sector %s is not yours.\n",
#endif	ALLYHARBOR
				xyas(ship.shp_x, ship.shp_y, cnum)));
			continue;
		}
		if (sect.sct_type != SCT_HARBR) {
			pr(fmt("Sector %s is not a harbor.\n",
				xyas(ship.shp_x, ship.shp_y, cnum)));
			continue;
		}
		if (sect.sct_effic < 2) {
			pr(fmt("The harbor at %s is not 2%% efficient yet.\n",
				xyas(ship.shp_x, ship.shp_y, cnum)));
			continue;
		}
		if (is_plane) {
			/* Note that there is only one plane per transaction */
			/* Plane sanity done */
			/* Find the right ship */
			if (load_unload == UNLOAD) {
				if (pln.pln_ship != ship.shp_uid)
					continue;
			} else if (ship.shp_x != pln.pln_x
			    || ship.shp_y != pln.pln_y)
				continue;
			/* ship to (plane or missle) sanity */
			if (plchr[pln.pln_type].pl_flags & P_M) {
				if (!(mchr[ship.shp_type].m_flags & M_MSL)) {
#ifdef	SHIPNAMES
					pr(fmt("%s %s(#%d) cannot carry missles.\n",
						mchr[ship.shp_type].m_name,
						ship.shp_name,
#else
					pr(fmt("%s #%d cannot carry missles.\n",
						mchr[ship.shp_type].m_name,
#endif	SHIPNAMES
						ship.shp_uid));
					return RET_FAIL;
				}
			} else if (plchr[pln.pln_type].pl_flags & P_L) {
				if (!(mchr[ship.shp_type].m_flags & M_FLY)) {
#ifdef	SHIPNAMES
					pr(fmt("%s %s(#%d) cannot carry planes.\n",
						mchr[ship.shp_type].m_name,
						ship.shp_name,
#else
					pr(fmt("%s #%d cannot carry planes.\n",
						mchr[ship.shp_type].m_name,
#endif	SHIPNAMES
						ship.shp_uid));
					return RET_FAIL;
				}
			} /* else cannot happen */
			/* Fit plane on ship */
			nplanes = ship.shp_nplane + load_unload;
			if (nplanes < 0) { /* XXX cannot happen */
				pr("Something is wrong with your ship!\n");
				logerror(
	"load: country #%d: %s plane %d on ship %d when ship held %d planes.\n",
					cnum,
					(load_unload == UNLOAD) ? "unload"
								: "load",
					pln.pln_uid,
					ship.shp_uid,
					ship.shp_nplane);
				nplanes = 0;
				/* But go on anyway */
			}
			if (nplanes > mchr[ship.shp_type].m_nplanes) {
				pr(fmt(
		"A ship or sub can carry at most %d planes or missiles.\n",
				    mchr[ship.shp_type].m_nplanes));
				return RET_FAIL;	/* XXX */
			}

			/* Perform transaction */
			ship.shp_nplane = nplanes;
			pln.pln_ship = (load_unload==UNLOAD)?-1:ship.shp_uid;
			if (!putplane(pln.pln_uid, &pln)) {
				pr("Couldn't save plane; get help!\n");
				return RET_SYS;
			}
			if (!putship(ship.shp_uid, &ship)) {
				pr("Couldn't save ship; get help!\n");
				return RET_SYS;
			}
			pr(fmt("%s #%d %s ship #%d.\n",
				plchr[pln.pln_type].pl_flags & P_M ?
					"Missile" : "Plane",
				pln.pln_uid,
				(load_unload==UNLOAD)?
					"unloaded from":"loaded onto",
				ship.shp_uid,
				xyas(ship.shp_x, ship.shp_y, cnum)));
			return RET_OK;	/* remember, only one plane */
		}
		item = ich->i_vtype;
		ship_amt = getvar(item, (char *)&ship, EF_SHIP);
		sect_amt = getvar(item, (char *)&sect, EF_SECTOR);
		if (sect.sct_oldown != cnum && item == V_CIVIL) {
			pr(fmt("%s civilians refuse to %s at %s!\n",
				load_unload == UNLOAD ? "Your" : "Foreign",
				load_unload == UNLOAD ?
					"disembark" : "board",
				xyas(sect.sct_x, sect.sct_y, cnum)));
			continue;
		}
		if (load_unload == UNLOAD) {
			max_amt = min(999 - sect_amt, ship_amt);
		} else {
			struct mchrstr *vbase;
			vbase = &mchr[ship.shp_type];
			max_amt = vl_find(item, vbase->m_vtype,
				vbase->m_vamt, (int) vbase->m_nv);
			max_amt = min(sect_amt, max_amt - ship_amt);
		}
		if (max_amt <= 0)
			continue;
		move_amt = load_unload * min(amount, max_amt);
		if (move_amt == 0)
			continue;
		putvar(item, sect_amt - move_amt, (char *)&sect, EF_SECTOR);
		putvar(item, ship_amt + move_amt, (char *)&ship, EF_SHIP);
		/* load/unload plague */
		if (getvar(V_PSTAGE, (char *)&sect, EF_SECTOR) == PLG_INFECT &&
		    getvar(V_PSTAGE, (char *)&ship, EF_SHIP) == PLG_HEALTHY)
			putvar(V_PSTAGE, PLG_EXPOSED, (char *)&ship, EF_SHIP);
		if (getvar(V_PSTAGE, (char *)&ship, EF_SHIP) == PLG_INFECT &&
		    getvar(V_PSTAGE, (char *)&sect, EF_SECTOR) == PLG_HEALTHY)
			putvar(V_PSTAGE, PLG_EXPOSED, (char *)&sect, EF_SECTOR);

		putsect(&sect);
		putship(ship_num, &ship);
		nships++;
	}
	if (nships == 0)
		pr("No ships affected\n");
	else
		pr(fmt("%d ship%s %sloaded\n", nships, splur(nships),
			load_unload == UNLOAD ? "un" : ""));
	return RET_OK;
}
