#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/nati.c,v 1.9 89/07/02 21:05:33 mr-frog Exp $";
#endif /* not lint */

/*
 * nati.c
 *
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "nat.h"
#include "sect.h"
#include "file.h"
#include "xy.h"

int
nati()
{
	extern	char *argp[];
	struct	natstr *natp;
	struct	sctstr sect;
	int	mil;
	int	civ;
	struct	range absrange;
	struct	range relrange;
	struct	boundstr *b;
	int	i;

	if ((natp = getnatp(cnum)) == 0) {
		pr(fmt("Bad country number %d\n", cnum));
		return RET_SYN;
	}
	pr(fmt("\n\t%s (#%d) Nation Report\t", cname(cnum), cnum));
	prdate();
	pr(fmt("Nation status is %s", natstate(natp)));
	pr(fmt("     Bureaucratic Time Units: %d\n", natp->nat_btu));
	if (natp->nat_stat & STAT_INUSE) {
		getsect(natp->nat_xcap, natp->nat_ycap, &sect);
		if (!owner || (sect.sct_type != SCT_CAPIT &&
		    sect.sct_type != SCT_SANCT))
			pr(fmt("No capital. (was at %s)\n",
				xyas(sect.sct_x, sect.sct_y, cnum)));
		else {
			civ = getvar(V_CIVIL, (char *)&sect, EF_SECTOR);
			mil = getvar(V_MILIT, (char *)&sect, EF_SECTOR);
			pr(fmt("%d%% eff capital at %s has %d civilian%s & %d military\n",
			       sect.sct_effic,
			       xyas(sect.sct_x, sect.sct_y, cnum), civ,
			       splur(civ), mil));
		}
	}
	absrange.width = 0;
	absrange.height = 0;
#ifndef CARNAGE
	for (i = 0; i < MAXNOR; i++) {
		b = &natp->nat_b[i];
		absrange.lx = b->b_xl;
		absrange.ly = b->b_yl;
		absrange.hx = b->b_xh;
		absrange.hy = b->b_yh;
		xyrelrange(natp, &absrange, &relrange);
		pr(fmt("#%2d  %d:%d,%d:%d%s", i,
			relrange.lx, relrange.hx,
			relrange.ly, relrange.hy,
		        (i % 3) != 2 ? "    " : "\n"));
	}
#endif CARNAGE
	pr(fmt(" The treasury has $%.2f", (double) natp->nat_money));
	pr(fmt("     Military reserves: %d\n", natp->nat_reserve));
	pr(fmt("Education..........%6.2f       Happiness.......%6.2f\n",
		(double) natp->nat_level[NAT_ELEV],
		(double) natp->nat_level[NAT_HLEV]));
	pr(fmt("Technology.........%6.2f       Research........%6.2f\n",
		(double) natp->nat_level[NAT_TLEV],
		(double) natp->nat_level[NAT_RLEV]));
	pr(fmt("Technology factor :%6.2f%%", tfact(cnum, 100.)));
	pr(fmt("      Plague factor : %6.2f%%\n",
	       ((double) natp->nat_level[NAT_TLEV] + 100.) /
	       ((double) natp->nat_level[NAT_RLEV] + 100.)));
	return RET_OK;
}
