#ifndef lint
static char *RCSid = "$Header: rea.c,v 1.8 90/03/19 11:06:29 mr-frog Exp $";
#endif

/*
 * rea.c
 *
 * read from telegram file
 * modified to use stdio -- no sense in having
 * too many syscalls
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "tel.h"
#include "deity.h"

#include <stdio.h>
#include <fcntl.h>
#include <sys/file.h>

rea()
{
	extern char *argp[];
	extern	char *telnames[];
	register char *p;
	register char *mbox;
	struct	telstr tgm;
	FILE   *telfp;
	int     teles;
	int     size;
	int     nbytes;
	char    buf[4096];
	int     lasttype;
	int     lastcnum;
	time_t  lastdate;
	int     header;
	int	filelen;
#ifdef MERC
	natid	nat;
	int	n;
	int	num;
#endif

#ifdef MERC
        if (god && argp[1] != 0) {
                if ((n = natarg(argp[1], "")) < 0)
                        return RET_SYN;
                num = n;
        } else
                num = cnum;
        mbox = mailbox(num);
#else
	mbox = mailbox(cnum);
#endif
	if ((telfp = fopen(mbox, "r+")) == 0) {
		logerror("telegram file %s", mbox);
		return RET_FAIL;
	}
	teles = 0;
	fseek(telfp, 0L, 0);
	size = fsize(fileno(telfp));
more:
	lastdate = 0;
	lastcnum = -1;
	lasttype = -1;
	while (fread((char *) &tgm, sizeof(tgm), 1, telfp) == 1) {
		if (tgm.tel_length < 0) {
			logerror("bad telegram file header in %s", mbox);
			break;
		}
		header = 0;
		if (tgm.tel_type != lasttype || tgm.tel_from != lastcnum)
			header++;
		if (abs((int)(tgm.tel_date - (long)lastdate)) > 60)
			header++;
		if (header) {
			pr("> ");
			lastcnum = tgm.tel_from;
			lasttype = tgm.tel_type;
			pr(fmt("%s ", telnames[tgm.tel_type]));
			if ((tgm.tel_type == TEL_NORM) ||
			    (tgm.tel_type == TEL_ANNOUNCE)) {
				pr(fmt("from %s, (#%d)",
				       cname(tgm.tel_from),
				       tgm.tel_from));
			}
			pr(fmt("  dated %s", ctime(&tgm.tel_date)));
			lastdate = tgm.tel_date;
		}
		while (tgm.tel_length > 0) {
			nbytes = tgm.tel_length;
			if (nbytes > sizeof(buf)-1)
				nbytes = sizeof(buf)-1;
			(void) fread(buf, sizeof(char), nbytes, telfp);
			buf[nbytes] = 0;
			pr(buf);
			tgm.tel_length -= nbytes;
		}
		pr("\n");
		teles++;
	}
#ifdef MERC
	if (teles > 0 && cnum == num) { /* } */
#else
	if (teles > 0) {
#endif
		if (teles == 1) {
			if (chance(0.25))
				p = "Forget this one? ";
			else
				p = "Shall I burn it? ";
		} else {
			if (chance(0.25))
				p = "Into the shredder, boss? ";
			else
				p = "Can I throw away these old love letters? ";
		}
#ifdef MERC
		if(god)
			p = getstarg(argp[2], p);
		else
			p = getstarg(argp[1], p);
#else
		p = getstarg(argp[1], p);
#endif
		if (p && *p == 'y') {
			if (!file_lock(fileno(telfp))) {
				fclose(telfp);
				return RET_SYS;
			}
			if ((filelen = fsize(fileno(telfp))) > size) {
				pr("Wait a sec!  A new telegram has arrived...\n");
				/* force stdio to re-read tel file */
				(void) fflush(telfp);
				(void) fseek(telfp, (long)size, L_SET);
				size = filelen;
				(void) file_unlock(fileno(telfp));
				goto more;
			}
			ftruncate(fileno(telfp), 0);
			(void) file_unlock(fileno(telfp));
		}
	}
	if (teles <= 0) {
#ifdef MERC
		if(cnum == num)
			pr("No telegrams for you at the moment...\n");
		else
                        pr(fmt("No telegrams for %s at the moment...\n",
			       cname(num)));
#else
		pr("No telegrams for you at the moment...\n");
#endif
	}
/*	else
		NAT_DELTA(nat_tgms, cnum, -teles); */
	(void) fclose(telfp);
	return RET_OK;
}
