#ifndef lint
static char *RCSid = "$Header: torp.c,v 1.10 89/09/28 02:08:49 mr-frog Exp $";
#endif /* not lint */

/*
 * torp.c
 *
 * fire torpedoes at enemy shipping.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "ship.h"
#include "file.h"
#include "xy.h"
#include "nat.h"
#include "nsc.h"
#include "news.h"

torp()
{
	extern	char *argp[];
	natid	vshipown;
	int	range;
	int	dam;
	int	shells;
	int	subno;
	int	victno;
	double	erange;
	double	hitchance;
	struct	nstr_item ni;
	struct	shpstr vship;
	struct	shpstr sub;
	struct	shpstr dd;
	char 	*ptr;

	if ((ptr = getstarg(argp[1], "Victim ship #? ")) == 0)
		return RET_SYN;
	if ((victno = atoi(ptr)) < 0)
		return RET_SYN;
	if (!getship(victno, &vship))
		return RET_FAIL;
	if ((ptr = getstarg(argp[2], "From sub #? ")) == 0)
		return RET_SYN;
	if ((subno = atoi(ptr)) < 0)
		return RET_SYN;
	if (!getship(subno, &sub))
		return RET_FAIL;
	if (sub.shp_own != cnum) {
		pr("Not your sub!\n");
		return RET_FAIL;
	}
	if (victno == subno) {
		pr("Shooting yourself, eh?  How strange...\n");
		return RET_FAIL;
	}
	if ((mchr[sub.shp_type].m_flags & M_TORP) == 0) {
		pr(fmt("A %s can't fire torpedoes!\n",
		       mchr[sub.shp_type].m_name));
		return RET_FAIL;
	}
	shells = getvar(V_SHELL, (char *)&sub, EF_SHIP);
	if (getvar(V_GUN, (char *)&sub, EF_SHIP) == 0 || shells < 3) {
		pr("Insufficient armament\n");
		return RET_FAIL;
	}
	if (sub.shp_effic < 60) {
		pr("Torpedo tubes inoperative.\n");
		return RET_FAIL;
	}
	if (sub.shp_mobil <= 0) {
		pr("Insufficient mobility\n");
		return RET_FAIL;
	}
	erange = sub.shp_effic * techfact(sub.shp_tech, 2.0) / 100.0;
	pr(fmt("Effective torpedo range is %.1f\n", erange));
	putvar(V_SHELL, shells - 3, (char *)&sub, EF_SHIP);
	sub.shp_mobil -= 20;
	pr("Whooosh... ");
	getship(victno, &vship);
	vshipown = vship.shp_own;
	range = mapdist(sub.shp_x, sub.shp_y, vship.shp_x, vship.shp_y);
	hitchance = 0.90 / (range + 1);
	if (range > erange) {
		pr("Out of range\n");
	} else if (chance(hitchance)) {
		pr("BOOM!...\n");
#ifdef MERC
		if(vshipown != 0)
#endif
#ifdef	SHIPNAMES
		wu(0, vshipown, fmt("%s %s(#%d) @%s torpedoed %s %s(#%d)",
			mchr[sub.shp_type].m_name, sub.shp_name,
#else
		wu(0, vshipown, fmt("%s #%d @%s torpedoed %s %d",
			mchr[sub.shp_type].m_name,
#endif	SHIPNAMES
			subno, xyas(sub.shp_x, sub.shp_y, vshipown),
#ifdef	SHIPNAMES
			mchr[vship.shp_type].m_name, vship.shp_name, victno));
#else
			mchr[vship.shp_type].m_name, victno));
#endif	SHIPNAMES
		dam = 50 + (random() % 50);
		dam = (100 * dam) / (mchr[vship.shp_type].m_armor + 50);
		shipdamage(&vship, dam);
		putship(victno, &vship);
		nreport(vshipown, N_TORP_SHIP, 0, 1);
	} else {
		pr("Missed\n");
#ifdef MERC
		if(vshipown != 0)
#endif
#ifdef	SHIPNAMES
		wu(0, vshipown, fmt("Torpedo sighted @%s by %s %s(#%d)",
#else
		wu(0, vshipown, fmt("Torpedo sighted @%s by %s #%d",
#endif	SHIPNAMES
			xyas(sub.shp_x, sub.shp_y, vshipown),
#ifdef	SHIPNAMES
			mchr[vship.shp_type].m_name, vship.shp_name, victno));
#else
			mchr[vship.shp_type].m_name, victno));
#endif	SHIPNAMES
	}
	snxtitem_dist(&ni, EF_SHIP, sub.shp_x, sub.shp_y, 0);
	while (nxtitem(&ni, (char *)&dd) && sub.shp_effic >= 20) {
		if (dd.shp_own != vshipown)
			continue;
		if ((mchr[dd.shp_type].m_flags & M_DCH) == 0)
			continue;
		if (dd.shp_x != sub.shp_x)
			continue;
		if (dd.shp_y != sub.shp_y)
			continue;
		if ((shells = getvar(V_SHELL, (char *)&dd, EF_SHIP)) < 2)
			continue;
		if (getvar(V_GUN, (char *)&dd, EF_SHIP) < 1)
			continue;
		pr("\nCAPTAIN!  !!Depth charges!!...\n");
#ifdef MERC
		if(vshipown != 0)
#endif
		wu(0, vshipown,
			fmt("Destroyer #%d dropped a depth charge on sub #%d",
			ni.cur, subno));
		putvar(V_SHELL, shells - 2, (char *)&dd, EF_SHIP);
		putship(ni.cur, &dd);
		dam = (random() % 30) + 30;
		pr(fmt("click...WHAM!  %d%% damage!\n", dam));
		shipdamage(&sub, dam);
	}
	putship(subno, &sub);
	return RET_OK;
}
