#ifndef lint
static char *RCSid = "$Header: /u/dhay/stan/kent/player/commands/RCS/zdon.c,v 1.1 91/03/19 23:33:47 dhay Exp Locker: dhay $";
#endif /* not lint */

/*
 * zdon.c
 *
 * Quick update stuff.
 *
 * Syntax:
 *  Normal player:   zdone [Y|N|C]
 *  Deity        :   zdone [country_num [Y|N|C]]
 *
 *  Where:
 *         Y  = Yes, wants an update.
 *         N  = No, change status to not wanting an update.
 *         C  = Check (the default), check how many want an update.
 *
 * Sets/Unsets a nation flag.
 *
 * Only considers NORMAL, active countries.  No Deities or sanctuaries.
 *
 * After the change, send a message to the "tm" for it to check
 * if an update should occur.
 *
 * Doug Hay, Dec 2, 1990.
 */

#include <stdio.h>
#include "misc.h"
#ifdef	DEMANDUPDATE
#include "nat.h"
#include "file.h"
#include "deity.h"

zdon()
{
	extern	char *argp[];
	extern	int aborted;
	natid	cn, whichcnum;
	struct	natstr *natp;
	register char *p;

	int	update;
	int	checking;
	int	wantupd;
	int	totpop;
	int	totwant;
	int	dowant;

	whichcnum = cnum;
	p = NULL;
	if (god) {
		/* Deity syntax "country what" */
		whichcnum = onearg(argp[1], "Which country no.? ");
		if ((whichcnum > 0)  && (getnatp(whichcnum)))
			p = getstarg(argp[2], "Want update? [Yes|No|Check] ");
	} else {
		p = getstarg(argp[1], "Want update? [Yes|No|Check] ");
	}
	if (aborted)
		return RET_FAIL;

	if (!p) {
		/* Default response is checking only */
		checking = 1;
	} else {
		checking = 0;
		if (*p == 'n' || *p == 'N') {
			wantupd = 0;
		} else if (*p == 'y' || *p == 'Y') {
			wantupd = 1;
		} else {
			/* Default response is checking only */
			checking = 1;
		}
	}

	if (!checking) {
		if (!(natp = getnatp(whichcnum))) {
			pr(fmt("Unable to find country. %d\n", whichcnum));
			pr("Notify the Deity.\n");
			return RET_FAIL;
		}
		if (wantupd) {
			update = natp->nat_update | WUPD_WANT;
			pr(fmt("You (%d) now want an update.\n",
				whichcnum));
		} else {
			update = natp->nat_update & ~WUPD_WANT;
			pr(fmt("You (%d) now DON'T want an update.\n",
				whichcnum));
		}
		natp->nat_update = update;
		NAT_SET(nat_update, whichcnum, update);
	}

	dowant = demand_update_want(&totwant, &totpop, whichcnum);
	if (checking) {
		if (dowant) {
			pr("You want an update.\n");
		} else
			pr("You DON'T want an update, yet.\n");
	}

	pr(fmt("%d of a total of %d lunatics want an update.\n",
			totwant, totpop));

	/* Tell the tm to check for an update */
	if (!checking && wantupd)
		tm_updatecheck();

	return RET_OK;
}
#endif	DEMANDUPDATE
