#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/subs/RCS/plnsub.c,v 1.10 89/09/18 00:00:59 mr-frog Exp $";
#endif

/*
 * plnsub.c
 *
 * Plane subroutine stuff
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "item.h"
#include "plane.h"
#include "nuke.h"
#include "xy.h"
#include "nsc.h"
#include "news.h"
#include "file.h"
#include "nat.h"
#include "path.h"

int
pln_onewaymission(target, shipno, flagp)
	struct	sctstr *target;
	int	*shipno;
	int	*flagp;
{
	int	nships;
	char	*p;
	int	cno;
	int	flags;
	int	n;
	struct	shpstr ship;

	flags = *flagp;
	if (target->sct_own && target->sct_own != cnum) {
		pr(fmt("You don't own %s!\n",
			xyas(target->sct_x, target->sct_y, cnum)));
		return -1;
	}
	if (target->sct_type == SCT_MOUNT) {
		pr("Planes can't land in mountains!\n");
		return -1;
	}
	cno = -1;
	if (target->sct_type != SCT_AIRPT || target->sct_effic < 60)
		flags |= P_V;
	if (target->sct_type == SCT_WATER || target->sct_type == SCT_HARBR) {
		nships = shipsatxy(target->sct_x, target->sct_y, M_FLY, 0);
		if (nships <= 0) {
			pr(fmt("You don't own %s!\n",
				xyas(target->sct_x, target->sct_y, cnum)));
			return -1;
		}
		cno = -1;
		while (cno < 0) {
			if ((p = getstring("Carrier #? ")) == 0 || *p == 0)
				break;
			n = atoi(p);
			if (n < 0 || !getship(n, &ship) || !owner) {
				pr("Not yours\n");
				continue;
			}
			if (ship.shp_x != target->sct_x ||
			    ship.shp_y != target->sct_y) {
				pr(fmt("Ship #%d not in %s\n", n,
				    xyas(target->sct_x, target->sct_y, cnum)));
				continue;
			}
			if ((mchr[ship.shp_type].m_flags & M_FLY) == 0){
#ifdef	SHIPNAMES
				pr(fmt("Can't land on %s %s(#%d).\n",
					mchr[ship.shp_type].m_name,
					ship.shp_name, n));
#else
				pr(fmt("Can't land on %s #%d.\n",
					mchr[ship.shp_type].m_name, n));
#endif	SHIPNAMES
				continue;
			}
			cno = n;
			flags &= ~P_V;
			flags |= P_L;
		}
	}
	*shipno = cno;
	*flagp = flags;
	return 0;
}

pln_newlanding(list, tx, ty, cno)
	struct	qelem *list;
	coord	tx, ty;
	int	cno;
{
	struct	qelem *qp;
	struct	plist *plp;
	struct	shpstr ship;

	if (cno >= 0)
		getship(cno, &ship);
	for (qp = list->q_forw; qp != list; qp = qp->q_forw) {
		plp = (struct plist *)qp;
		if (cno >= 0)
		/* XXX - need to restrict # of planes per ship */
			ship.shp_nplane++;
		plp->plane.pln_x = tx;
		plp->plane.pln_y = ty;
		plp->plane.pln_ship = cno;
	}
	if (cno >= 0)
		putship(cno, &ship);
}

pln_return(list)
	struct	qelem *list;
{
	struct	qelem *qp;
	struct	plist *plp;
	struct	shpstr ship;
	int	cno;

	for (qp = list->q_forw; qp != list; qp = qp->q_forw) {
		plp = (struct plist *)qp;
		cno = plp->plane.pln_ship;

		if (cno >= 0) {
			getship(cno, &ship);
		/* XXX - need to restrict # of planes per ship */
			ship.shp_nplane++;
			putship(cno, &ship);
		}
	}
}

pln_dropoff(list, ip, tx, ty, ptr, type)
	struct	qelem *list;
	struct	ichrstr *ip;
	coord	tx, ty;
	char	*ptr;
	int	type;
{
	struct	qelem *qp;
	struct	plist *plp;
	int	amt;
	struct	shpstr *ship;
	int	there;
	int	max;
	struct	mchrstr *mp;

	if (ip == 0)
		return;
	amt = 0;
	for (qp = list->q_forw; qp != list; qp = qp->q_forw) {
		plp = (struct plist *)qp;
		amt += plp->misc;
	}
	there = getvar(ip->i_vtype, ptr, type) + amt;
	max = 32767;
	if (type == EF_SHIP) {
		ship = (struct shpstr *) ptr;
		mp = &mchr[ship->shp_type];
		max = vl_find(ip->i_vtype, mp->m_vtype,
			mp->m_vamt, (int)mp->m_nv);
	}
	if (there > max) {
		pr(fmt("%d excess %s discarded\n",
			max-there, ip->i_name));
		amt = max - there;
		there = max;
	}
	putvar(ip->i_vtype, there, ptr, type);
	pr(fmt("%d %s landed safely", amt, ip->i_name));
	if (type == EF_SECTOR) {
		pr(fmt(" at %s\n", xyas(tx, ty, cnum)));
		putsect((struct sctstr *) ptr);
	} else {
		pr(fmt(" on carrier #%d\n", ship->shp_uid));
		putship(ship->shp_uid, ship);
	}
}

pln_sel(ni, list, ap, ap_to_target, rangemult, wantflags, nowantflags)
	struct	nstr_item *ni;
	struct	qelem *list;
	struct	sctstr *ap;
	int	ap_to_target;
	int	rangemult;
	int	wantflags;
	int	nowantflags;
{
	struct	plnstr plane;
	struct	shpstr ship;
	struct	sctstr sect;
	int	range;
	struct	plchrstr *pcp;
	struct	plist *plp;

	initque(list);
	while (nxtitem(ni, (char *)&plane)) {
		if (!owner)
			continue;
		if (plane.pln_mobil <= 0)
			continue;
		range = mapdist(plane.pln_x, plane.pln_y, ap->sct_x, ap->sct_y);
		if (range > 4) {
			pr(fmt("%d too far from assembly point\n", ni->cur));
			continue;
		}
		range += ap_to_target;
		pcp = &plchr[plane.pln_type];
		if (wantflags) {
			if ((pcp->pl_flags & wantflags) != wantflags)
				continue;
		}
		if (nowantflags) {
			if (pcp->pl_flags & nowantflags)
				continue;
		}
		range *= rangemult;
		if (plane.pln_range < range) {
			pr(fmt("%d out of range (%d:%d)\n", ni->cur,
				plane.pln_range, range));
			continue;
		}
		if (plane.pln_ship >= 0) {
			if (!getship(plane.pln_ship, &ship) ||
			    plane.pln_own != cnum) {
	shipsunk:
				plane.pln_effic = 0;
				pr(fmt("(note) ship not valid for #%d\n",
					ni->cur));
				putplane(ni->cur, &plane);
				continue;
			}
			if ((mchr[ship.shp_type].m_flags & M_FLY) == 0)
				goto shipsunk;
			if (ship.shp_effic < 20)
				goto shipsunk;
			if (ship.shp_effic < 50)
				continue;
		}
		/*
		 * if not vtol and not at an airport, you lose!
		 */
		if ((pcp->pl_flags & P_V) == 0 && plane.pln_ship < 0) {
			if (!getsect(plane.pln_x, plane.pln_y, &sect) ||
			    sect.sct_type != SCT_AIRPT) {
				pr(fmt("%d not at airport\n", ni->cur));
				continue;
			}
			if (sect.sct_effic < 40)
				continue;
		}
		pr(fmt("(#%d) %s standing by\n", ni->cur,
			plchr[plane.pln_type].pl_name));
		plp = (struct plist *) malloc(sizeof(struct plist));
		plp->state = P_OK;
		plp->misc = 0;
		plp->bombs = 0;
		plp->pcp = pcp;
		bcopy((char *)&plane, (char *)&plp->plane,
			sizeof(struct plnstr));
		insque(&plp->queue, list);
	}
}

int
pln_arm(list, mission, ip, flags, mission_flags)
	struct	qelem *list;
	int	mission;
	struct	ichrstr *ip;
	int	flags;
	int	mission_flags;
{
	struct	qelem *qp;
	struct	qelem *next;
	struct	plist *plp;
	int	tech;

	tech = mission_flags >> 16;
	for (qp = list->q_forw; qp != list; qp = next) {
		next = qp->q_forw;
		plp = (struct plist *) qp;
		if (pln_equip(plp, ip, flags, mission) < 0) {
			remque(qp);
			free((char *)qp);
			continue;
		}
		if (flags & (P_S|P_I)) {
			if(plp->pcp->pl_flags & P_S)
				mission_flags |= P_S;
			if(plp->pcp->pl_flags & P_I)
				mission_flags |= P_I;
		}
		if (plp->pcp->pl_flags & P_X) {
			if (tech > plp->plane.pln_tech)
				tech = plp->plane.pln_tech;
		} else {
			/* no stealth on this mission */
			mission_flags &= ~P_X;
		}
#ifdef MERC
		if (flags & P_F)
			plp->plane.pln_mobil -= (char) min(32 + plp->plane.pln_mobil,(12 * 100 / (char) plp->plane.pln_effic));
		else
			plp->plane.pln_mobil -= (char) min(32 + plp->plane.pln_mobil,(20 * 100 / (char) plp->plane.pln_effic));
#else
		if (flags & P_F)
			plp->plane.pln_mobil -= 12;
		else
			plp->plane.pln_mobil -= 20;
#endif
		pr(fmt("(#%d) %s equipped\n", plp->plane.pln_uid,
			plp->pcp->pl_name));
	}
	mission_flags &= 0x0000ffff;
	mission_flags |= (tech << 16);
	return mission_flags;
}

int
pln_equip(plp, ip, flags, mission)
	struct	plist *plp;
	struct	ichrstr *ip;
	int	flags;
	char	mission;
{
	register struct plchrstr *pcp;
	struct	plnstr *pp;
	int	needed;
	struct	shpstr ship;
	struct	sctstr sect;
	int	type;
	char	*ptr;
	int	item;
	int	rval;
	int	vec[I_MAX+1];

	pp = &plp->plane;
	pcp = plp->pcp;
	if (pp->pln_ship >= 0) {
		getship(pp->pln_ship, &ship);
		type = EF_SHIP;
		ptr = (char *) &ship;
	} else {
		getsect(pp->pln_x, pp->pln_y, &sect);
		type = EF_SECTOR;
		ptr = (char *) &sect;
	}
	getvec(VT_ITEM, vec, ptr, type);
	if (pcp->pl_fuel > vec[I_PETROL]) {
		pr(fmt("(#%d) %s not enough petrol there!\n",
			pp->pln_uid, plp->pcp->pl_name));
		return -1;
	}
	vec[I_PETROL] -= pcp->pl_fuel;
	rval = 0;
	if ((flags & P_F) == 0) {
		item = 0;
		needed = 0;
		switch (mission) {
		case 's':
		case 'p':
			item = I_SHELL;
			needed = pcp->pl_load;
			break;
		case 't':
			if ((pcp->pl_flags & P_C) == 0 || ip == 0)
				break;
			item = ip - ichr;
			needed = (pcp->pl_load * 2) / ip->i_lbs;
			break;
		case 'd':
			if ((pcp->pl_flags & P_C) == 0 || ip == 0)
				break;
			item = ip - ichr;
			needed = (pcp->pl_load * 2) / ip->i_lbs;
			break;
		case 'a':
			if ((pcp->pl_flags & (P_V|P_C)) == 0)
				break;
			item = I_MILIT;
			needed = pcp->pl_load / ip->i_lbs;
			break;
		case 'n':
			if (pp->pln_nukeamt == 0)
				rval = -1;
			break;
		default:
			break;
		}
		if (rval < 0 || (item && needed <= 0)) {
			pr(fmt("%s #%d can't contribute to mission\n",
				pcp->pl_name, pp->pln_uid));
			return -1;
		}
		if (vec[item] < needed) {
			pr(fmt("Not enough %s for plane #%d\n",
				ichr[item].i_name, pp->pln_uid));
			return -1;
		} else {
			vec[item] -= needed;
		}
		if (item == I_SHELL && (mission == 's' || mission == 'p'))
			plp->bombs = needed;
		else
			plp->misc = needed;
	}
	putvec(VT_ITEM, vec, ptr, type);
	if (type == EF_SHIP) {
		/* subtract a plane from the ship and do a sanity check */
		ship.shp_nplane -= 1;
		if (ship.shp_nplane < 0)
			ship.shp_nplane = 0;
		putship(ship.shp_uid, &ship);
	} else
		putsect(&sect);
	return rval;
}

pln_put(list)
	struct	qelem *list;
{
	register struct qelem *qp;
	register struct qelem *newqp;
	struct	plist *plp;

	qp = list->q_forw;
	while (qp != list) { 
		plp = (struct plist *) qp;
		putplane(plp->plane.pln_uid, &plp->plane);
		newqp = qp->q_forw;
		remque(qp);
		free((char *)qp);
		qp = newqp;
	}
}

pln_removedupes(bomb_list, esc_list)
	struct	qelem *bomb_list;
	struct	qelem *esc_list;
{
	struct	qelem *bomb;
	struct	qelem *esc;
	struct	plist *bombp;
	struct	plist *escp;

	if (QEMPTY(bomb_list) || QEMPTY(esc_list))
		return;
	bomb = bomb_list->q_forw;
	while (bomb != bomb_list) {
		if (QEMPTY(esc_list)) {
			bomb = bomb_list;
			continue;
		}
		esc = esc_list->q_forw;
		bombp = (struct plist *) bomb;
		while (esc != esc_list) {
			escp = (struct plist *) esc;
			if (escp->plane.pln_uid == bombp->plane.pln_uid) {
				remque(esc);
				free((char *)esc);
				esc = esc_list;
			} else
				esc = esc->q_forw;
		}
		bomb = bomb->q_forw;
	}
}
