/*
 * nat.h
 *
 * things having to do with nations
 *
 * from PSL Empire, 1985
 * $Revision: 1.2 $ $Date: 91/03/19 03:03:28 $
 */

#define	MAXNOR		18              /* max # realms */

struct	boundstr {
	short	b_xl, b_xh;		/* horizontal bounds */
	short	b_yl, b_yh;		/* vertical bounds */
};

struct	natstr {
	char	nat_cnam[20];		/* country name */
	char	nat_pnam[20];		/* representative */
	coord	nat_xcap, nat_ycap;	/* cap location in abs coords */
	coord	nat_xorg, nat_yorg;	/* origin location in abs coords */
	char	nat_stat;		/* inuse, norm, god, abs */
	char	nat_dayno;		/* day of the year mod 128 */
	char	nat_login;		/* logged in or not? */
#ifdef	DEMANDUPDATE
	char	nat_update;		/* Want an update or not. */
#endif	DEMANDUPDATE
	int	nat_tgms;		/* # of telegrams to be announced */
	int	nat_minused;		/* number of minutes used today */
	int	nat_btu;		/* bureaucratic time units */
	long	nat_reserve;		/* military reserves */
	long	nat_money;		/* moola */
	time_t	nat_date;		/* last logoff */
	time_t	nat_newstim;		/* date news last read */
	float	nat_level[4];		/* technology, etc */
	struct	boundstr nat_b[MAXNOR];	/* realm bounds */
	short	nat_relate[(MAXNOC+7)/8];	/* two bits for each country */
#ifdef	REJECTS				/* 3/17/90 bailey@mcs.kent.edu */
	short	nat_rejects[(MAXNOC+3)/4];	/* four bits for each country */
#endif	REJECTS
};

	/* nation status types */
#define STAT_INUSE	bit(0)		/* cnum in use */
#define STAT_SANCT	bit(1)		/* country in sanctuary */
#define STAT_NORM	bit(2)		/* normal country */
#define STAT_GOD	bit(3)		/* deity powers */
#define STAT_ABS	bit(4)		/* abs coords */
#define STAT_NEW	bit(5)		/* just initialized */

#ifdef	DEMANDUPDATE
	/* Update fields. */
#define	WUPD_WANT	bit(0)
#endif	DEMANDUPDATE

	/* nstat values */
#define VIS		STAT_INUSE
#define	NORM		(STAT_INUSE|STAT_NORM)
#define	GOD		(STAT_INUSE|STAT_GOD)
#define	SANCT		(STAT_INUSE|STAT_SANCT)
#define	CAP		bit(6)
#define	MONEY		bit(7)

	/* nation relation codes */
#define	NEUTRAL		0
#define	ALLIED		1
#define	HOSTILE		2
#define	AT_WAR		3

#ifdef	REJECTS
	/* nation reject codes */
#define	REJ_TELE	bit(0)		/* dont allow telegrams to be sent */
#define	REJ_TREA	bit(1)		/* dont allow treaties to be offered */
#define	REJ_ANNO	bit(2)		/* don't receive announcements */
#ifdef MERC
#define	REJ_LOAN	bit(3)		/* don't allow loans to be offered */
#endif
#endif	REJECTS

#define	NAT_TLEV	0
#define	NAT_RLEV	1
#define	NAT_ELEV	2
#define	NAT_HLEV	3

#define	NF_DELTA	1
#define NF_SET		2

	/* yuck; nation modify macros to send stuff to tm */

#define	NAT_DELTA(field, coun, value) \
	(nat_value(OFFSET(natstr, field), coun, 0, NF_DELTA, value))
#define	NAT_SET(field, coun, value) \
	(nat_value(OFFSET(natstr, field), coun, 0, NF_SET, value))
#define	NAT_SETARY(field, coun, i, value) \
	(nat_value(OFFSET(natstr, field), coun, i, NF_SET, value))
#define	NAT_DELTARY(field, coun, i, value) \
	(nat_value(OFFSET(natstr, field), coun, i, NF_DELTA, value))

#define	NF_CHAR		1
#define	NF_UCHAR	2
#define	NF_SHORT	3
#define	NF_LONG		4
#define	NF_STRING	5
#define	NF_FLOAT	6
#define	NF_DOUBLE	7
#define	NF_BOUND	8

#define NF_NOTIFY	1
#define NF_PRIVATE	2

#define NF_NATID	NF_UCHAR
#define NF_COORD	NF_SHORT

struct fixnat {
	char *name;
	int type;
	int index;
	int notify;
	int offset;
};

/* procedures relating to nation stuff */

#define getnatp(n) \
	(struct natstr *) ef_ptr(EF_NATION, (int)n)

extern	double techfact();
extern	double tfact();
extern	double reltech();
extern	double multread();

extern	char *natstate();
extern	char *cname();
extern	char *relatename();
#ifdef	REJECTS
extern	char *rejectname();
#endif	REJECTS
extern	struct fixnat *natfield();

extern	natid cnum;
extern	int owner;
extern	int nstat;
extern	double dolcost;
extern	int nbtu;
extern	int broke;
