#ifndef lint
static char *RCSid = "$Header: boar.c,v 1.8 90/03/19 11:14:48 mr-frog Exp $";
#endif /* not lint */

/*
 * boar.c
 *
 * board an enemy ship
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "nat.h"
#include "ship.h"
#include "news.h"
#include "file.h"
#include "treaty.h"

boar()
{
	extern	char *argp[];
	int	btused;
	int	dshpno;		/* defending shipno */
	int	ashpno;		/* attacking shipno */
	int	amil;		/* # attacking mil */
	int	dmil;		/* # defending mil */
	natid	d_cnum;		/* defender cnum */
	coord	a_x;		/* attacker x */
	coord	a_y;		/* attacker y */
	coord	d_x;		/* defender x */
	coord	d_y;		/* defender y */
	int	acas;		/* attacker casualties */
	int	dcas;		/* defender casualties */
	int	dam;		/* damage from shipdef() */
	struct	shpstr aship;	/* attacking ship */
	struct	shpstr dship;	/* defending ship */
	double	aspeed;
	double	dspeed;
	char	*ptr;

	if ((ptr = getstarg(argp[1], "Victim ship #? ")) == 0)
		return RET_SYN;
	if ((dshpno = atoi(ptr)) < 0 || !getship(dshpno, &dship)) {
		pr("No such ship\n");
		return RET_FAIL;
	}
	if ((ptr = getstarg(argp[2], "Boarding party from ship #")) == 0)
		return RET_SYN;
	if ((ashpno = atoi(ptr)) < 0 || !getship(ashpno, &aship) ||
	    aship.shp_own != cnum)
		return RET_FAIL;
	getship(dshpno, &dship);
	d_cnum = dship.shp_own;
	if (!trechk(cnum, d_cnum, SEAATT))
		return RET_FAIL;
	d_x = dship.shp_x;
	d_y = dship.shp_y;
	a_x = aship.shp_x;
	a_y = aship.shp_y;
	if (a_x != d_x || a_y != d_y) {
		pr("Not in same sector!\n");
		return RET_FAIL;
	}

	if ((amil = getvar(V_MILIT, (char *)&aship, EF_SHIP)) == 0) {
#ifdef	SHIPNAMES
		pr(fmt("No military on %s %s(#%d)\n",
		       mchr[aship.shp_type].m_name, aship.shp_name, ashpno));
#else
		pr(fmt("No military on %s #%d\n",
		       mchr[aship.shp_type].m_name, ashpno));
#endif	SHIPNAMES
		return RET_FAIL;
	}
	if (aship.shp_mobil <= 0) {
#ifdef	SHIPNAMES
		pr(fmt("%s %s(#%d) has no mobility!\n",
			mchr[aship.shp_type].m_name, aship.shp_name, ashpno));
#else
		pr(fmt("%s #%d has no mobility!\n",
			mchr[aship.shp_type].m_name, ashpno));
#endif	SHIPNAMES
		return RET_FAIL;
	}
	if (mchr[dship.shp_type].m_flags & M_SUB) {
		pr("You can't board a submarine!\n");
		return RET_FAIL;
	}

	if ((dam = shipdef(d_cnum, seadef(aship.shp_type), a_x, a_y)) > 0) {
#ifdef MERC
		if(d_cnum != 0)
#endif
#ifdef	SHIPNAMES
		wu(0, d_cnum, fmt("Return fire did %d%% damage to %s %s(#%d)",
			dam, mchr[aship.shp_type].m_name, aship.shp_name,
			ashpno));
#else
		wu(0, d_cnum, fmt("Return fire did %d%% damage to %s #%d",
			dam, mchr[aship.shp_type].m_name, ashpno));
#endif	SHIPNAMES
		shipdamage(&aship, dam);
		putship(ashpno, &aship);
		if (aship.shp_effic < 20) {
#ifdef MERC
			if(d_cnum != 0)
#endif
			wu(0, d_cnum,
#ifdef	SHIPNAMES
				fmt("Country #%d lost %s %s(#%d) trying to board %s %s(#%d)",
				cnum, mchr[aship.shp_type].m_name,
				aship.shp_name, ashpno,
				mchr[dship.shp_type].m_name, dship.shp_name,
				dshpno));
#else
				fmt("Country #%d lost %s #%d trying to board %s #%d",
				cnum, mchr[aship.shp_type].m_name, ashpno,
				mchr[dship.shp_type].m_name, dshpno));
#endif	SHIPNAMES
			nreport(cnum, N_SHP_LOSE, d_cnum, 1);
			return RET_OK;
		}
	}
	getship(ashpno, &aship);
	getship(dshpno, &dship);
	if (dship.shp_mobil > 0) {
		aspeed = mchr[aship.shp_type].m_speed *
			aship.shp_effic / 100.0;
		dspeed = mchr[dship.shp_type].m_speed * 
			dship.shp_effic / 100.0;
		aspeed = techfact(aship.shp_tech, 1.0) * aspeed;
		dspeed = techfact(dship.shp_tech, 1.0) * dspeed;
		aship.shp_mobil -= (int) (127.0 / aspeed);
		dship.shp_mobil -= (int) (127.0 / aspeed);
		if (aspeed < dspeed) {
			pr("Victim ship moves faster than you do!");
			pr("  You can't catch him!\n");
#ifdef MERC
			if(dship.shp_own != 0)
#endif
			wu(0, dship.shp_own,
#ifdef	SHIPNAMES
				fmt("%s (#%d) %s %s(#%d) failed to catch %s %s(#%d)\n",
				cname(aship.shp_own), aship.shp_own,
				mchr[aship.shp_type].m_name, aship.shp_name,
				ashpno, mchr[dship.shp_type].m_name,
				dship.shp_name, dshpno));
#else
				fmt("%s (#%d) %s #%d failed to catch %s #%d\n",
				cname(aship.shp_own), aship.shp_own,
				mchr[aship.shp_type].m_name, ashpno,
				mchr[dship.shp_type].m_name, dshpno));
#endif	SHIPNAMES
			putship(ashpno, &aship);
			putship(dshpno, &dship);
			return RET_OK;
		}
	}
	amil = getvar(V_MILIT, (char *)&aship, EF_SHIP);
	dmil = getvar(V_MILIT, (char *)&dship, EF_SHIP);
	pr(fmt("%d attempting to board ship #%d\n", amil, dshpno));
	acas = amil;
	dcas = dmil;
	while (1) {
		if (chance(0.33) || dmil <= 0) {
			pr("!");
			if (--dmil <= 0)
				break;
		} else { 
			pr("@");
			if (--amil <= 0)
				break;
		}
	}
	acas -= amil;
	dcas -= dmil;
	if (amil > 0) {
		struct mchrstr *vbase;

		pr("Boarding successful!\n");
#ifdef MERC
		if(d_cnum != 0)
#endif
#ifdef	SHIPNAMES
		wu(0, d_cnum, fmt("Country #%d boarded %s %s(#%d)\n", cnum,
			mchr[dship.shp_type].m_name, dship.shp_name, dshpno));
#else
		wu(0, d_cnum, fmt("Country #%d boarded %s #%d\n", cnum,
			mchr[dship.shp_type].m_name, dshpno));
#endif	SHIPNAMES
		nreport(cnum, N_BOARD_SHIP, d_cnum, 1);
		takeover_ship(&dship, cnum, 1);
		dship.shp_fleet = ' ';

		vbase = &mchr[dship.shp_type];
		dmil = min(amil / 2, vl_find(V_MILIT, vbase->m_vtype,
			vbase->m_vamt, (int) vbase->m_nv));
		amil -= dmil;
		pr(fmt("%d of your troops hold%s ship %d\n", dmil,
			splur(dmil != 1), dshpno));
		pr(fmt("%d return%s to ship %d\n", amil, splur(amil != 1),
			ashpno));
		if (getvar(V_PSTAGE, (char *)&dship, EF_SHIP) == PLG_INFECT) {
			if (getvar(V_PSTAGE, (char *)&aship, EF_SHIP) == 0)
				putvar(V_PSTAGE, PLG_EXPOSED, (char *)&aship,
				       EF_SHIP);
		}
		else if (getvar(V_PSTAGE, (char *)&aship, EF_SHIP) ==
			 PLG_INFECT) {
			if (getvar(V_PSTAGE, (char *)&dship, EF_SHIP) == 0)
				putvar(V_PSTAGE, PLG_EXPOSED, (char *)&dship,
				       EF_SHIP);
		}
	} else {
		pr("\nYou have been repelled...\n");
#ifdef MERC
		if(d_cnum != 0)
#endif
#ifdef	SHIPNAMES
		wu(0, d_cnum, fmt("Country #%d %s %s(#%d) tried to board %s %s(#%d)",
			cnum, mchr[aship.shp_type].m_name, aship.shp_name,
			ashpno, mchr[dship.shp_type].m_name, dship.shp_name,
			dshpno));
#else
		wu(0, d_cnum, fmt("Country #%d %s #%d tried to board %s #%d",
			cnum, mchr[aship.shp_type].m_name, ashpno,
			mchr[dship.shp_type].m_name, dshpno));
#endif	SHIPNAMES
		nreport(cnum, N_SHP_LOSE, d_cnum, 1);
	}
	putvar(V_MILIT, amil, (char *)&aship, EF_SHIP);
	putship(ashpno, &aship);
	putvar(V_MILIT, dmil, (char *)&dship, EF_SHIP);
	putship(dshpno, &dship);
	pr(fmt("Casualties :\nYours ... %d\n", acas));
	pr(fmt("Theirs .. %d\n", dcas));
	btused = roundavg((dcas + acas) * 0.15 + 0.5);
	pr(fmt("Papershuffling ... %d B.T.U\n", btused));
	NAT_DELTA(nat_btu, cnum, -btused);
	return RET_OK;
}
