#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/SUBS/RCS/mtch.c,v 1.1 89/05/17 20:51:59 mr-frog Exp $";
#endif

/*
 * mtch.c
 *
 * Matching operations on structures and commands.
 *
 * XXX These routines gamble that structures are all longword-aligned.
 * If this is not true, they will BREAK!
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "com.h"
#include "deity.h"
#include "match.h"

/*
 * find a matching string from a member string pointer
 * in a structure "str".  Pointer is incremented by
 * the (passed) size of the structure.
 */
int
stmtch(obj, base, off, size)
	register char *obj;
	char	*base;
	int	off;
	int     size;
{
	register char *str;
	register int stat2;
	register int i;
	register int n;

	stat2 = M_NOTFOUND;
	str = base + off;
	for (i=0; *(char **)str; i++, str += size) {
		if ((n = mineq(obj, *(char **)str)) == ME_MISMATCH)
			continue;
		if (n == ME_EXACT)
			return i;
		if (stat2 != M_NOTFOUND)
			return M_NOTUNIQUE;
		stat2 = i;
	}
	return stat2;
}

/*
 * find a matching integer from a member of a structure.
 * Inspired by stmtch above.
 */
int
intmatch(value, ptr, size)
	register int value;
	register int *ptr;
	int     size;
{
	register int i;

	size /= sizeof(*ptr);
	for (i=0; *ptr; i++, ptr += size)
		if (value == *ptr)
			return i;
	return -1;
}

/*
 * find a matching command from coms[].  Return status is:
 *  >= 0: match found, value is array entry in coms[]
 */
int
comtch(command)
	register char *command;
{
	register struct comstr *com;
	register int status;
	register int i;

	if (command == 0 || *command == 0)
		return M_NOTFOUND;
	status = M_NOTFOUND;
	for (com=coms; com->c_form != 0; com++) {
		if ((com->c_permit & ncomstat) != com->c_permit && !god)
			continue;
		if ((i = mineq(command, com->c_form)) == ME_MISMATCH)
			continue;
		if (i == ME_EXACT)
			return com - coms;
		/* partial */
		if (status != M_NOTFOUND)
			return M_NOTUNIQUE;
		status = com - coms;
	}
	return status;
}

/*
 * do partial match comparison.
 */
int
mineq(a, b)
	register char *a;
	register char *b;
{
	do {
		if (*a++ != *b++)
			return ME_MISMATCH;
	} while (*b != ' ' && *a != 0);
	if (*a == 0 && (*b == ' ' || *b == 0))
		return ME_EXACT;
	return ME_PARTIAL;
}
