#ifndef lint
static char *RCSid = "$Header: /SRX/empite/EMP/player/commands/scut.c 1.0 90/03/23 19:47:24 bailey Exp $";
#endif /* not lint */

/*
 * scut.c
 *
 * Scuttle ships or planes
 * Taken from scra.c
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "ship.h"
#include "plane.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"

#ifdef	SCUTTLE

union item_u {
	struct shpstr ship;
	struct plnstr plane;
};

scut()
{
	extern	char *argp[];
	struct	nstr_item ni;
	union	item_u item;
	int	type;
	struct	mchrstr *mp;
	struct	plchrstr *pp;
	char	*p;

	if ((p = getstarg(argp[1], "Ship or plane? ")) == 0)
		return RET_SYN;
	type = ef_byname(p);
	if (type == EF_SECTOR)
		type = EF_SHIP;
	if (type != EF_SHIP && type != EF_PLANE) {
		pr("Ships or planes only!\n");
		return RET_SYN;
	}
	if (!snxtitem(&ni, type, argp[2]))
		return RET_SYN;
	while (nxtitem(&ni, (char *)&item)) {
		if (!owner)
			continue;
		if (type == EF_SHIP) {
			mp = &mchr[item.ship.shp_type];
			pr(mp->m_name);
#ifdef	SHIPNAMES
			pr(" ");
			pr(item.ship.shp_name);
#endif	SHIPNAMES
			item.ship.shp_own = 0;
			putship(item.ship.shp_uid, (char *)&item.ship);
		} else {
			pp = &plchr[item.plane.pln_type];
			pr(pp->pl_name);
			item.plane.pln_own = 0;
			putplane(item.plane.pln_uid, (char *)&item.plane);
		}
#ifdef	SHIPNAMES
		pr(fmt("(#%d) scuttled in %s\n", ni.cur,
#else
		pr(fmt(" #%d scuttled in %s\n", ni.cur,
#endif	SHIPNAMES
			xyas(item.ship.shp_x, item.ship.shp_y , cnum)));
	}
	return RET_OK;
}

#endif	SCUTTLE
