/****************************************************************
*  program: distributor
*
*  Calculates optimal distribution paths for a region.
*  Current options:
*
*        -a       Redo all dist paths; default state only puts dist
*                 paths on sectors that have none
*
*        -f       Specify input file. Defaults to "dump"
*
*        -o       Specify output file. Defaults to "dist.out"
*
*        -v       Verbose output to the terminal.
*
*        -w       Connect warehouses with dist paths. Default is to
*                 leave warehouses unconnected, serving autonomous regions
*                                       
****************************************************************/

#include <string.h>
#include <stdio.h>
#include "sve.h"

#define OPTIONS "af:o:vw"

extern struct maptype Map[XWIDTH][YHEIGHT];
extern struct Secdata *Sector;

main(argc, argv)
int argc;
char *argv[];
{
  int i;
  int sectorcount;
  char *distpath;
  int c;
  int targx, targy;
  int x,y;
  char *newpath;
  FILE *fp, *fopen();

  extern char *optarg;			/* initialize default options */
  extern int optind;
  int verbose = 0;
  int do_all_paths = 0;
  int link_warehouse = 0;
  char infile[15];
  char outfile[15];

  distpath = (char *) malloc (12);

  strcpy(infile, "dump");
  strcpy(outfile, "dist.out");

#ifdef DEBUG
  printf("Begin...\n");
#endif

  while ((c = getopt(argc, argv, OPTIONS)) != EOF) /* get options */
    {
      switch(c) {
      case 'a':
	do_all_paths = 1;
	break;

      case 'f':
	strcpy(infile, optarg);
	break;
	
      case 'o':
	strcpy(outfile, optarg);
	break;

      case 'v':
	verbose = 1;
	break;

      case 'w':
	link_warehouse = 1;
	break;

      default:
	printf("Usage: distributor [ -a -f infile -o outfile -v -w]\n");
	exit(0);
      }
#ifdef DEBUG
      printf("Options have been processed. \n");
#endif
	  
    }

#ifdef DEBUG
  printf("Beginning getdump. \n");
#endif

  sectorcount= getdump(infile);		/* get the data from infile */

#ifdef DEBUG
  printf("End getdump. \n");
  printf("Beginning weemapmaker. \n");
#endif

  weemapmaker(sectorcount);		/* make a temporary map */

#ifdef DEBUG
  printf("End weemapmaker.\n");
#endif

  fp = fopen(outfile, "w");

#ifdef DEBUG
  printf("sectorcount is returning: %d \n", sectorcount);
#endif

  for (i=0; i < sectorcount; i++)	/* for every sector in the infile: */
    {
      if (verbose)
	printf("Looking at sector %d \n", i);

      if ((Sector[i].Census.Des == 'w') && (!link_warehouse))
	continue;

      if ((strcmp(Sector[i].Level.Dist_path, "_") != 0) && (!do_all_paths))
	continue;
      
      strcpy(distpath, "");
      targx = targy = 999;
      x = Sector[i].Census.X;
      y = Sector[i].Census.Y;
      recoordinate(&x,&y);

      strcpy(distpath, (pathfinder(x, y, &targx, &targy, 'w', 10)));
      if (strcmp(distpath, "NULL") == 0)
	{
	  printf("Warning: no dist path found for %d, %d \n", 
		 Sector[i].Census.X, Sector[i].Census.Y);
	  continue;
	}

      if (verbose)
	printf("\tHow's a distpath of %s?\n", distpath);

      if (strcmp(distpath, Sector[i].Level.Dist_path) == 0)
	{
	  if (verbose)
	    printf("Sector %d, %d already has the dist path %s. No change.\n",
		   Sector[i].Census.X, Sector[i].Census.Y, distpath);

	  continue;
	}

      fprintf(fp, "dist %d,%d %sh \n", Sector[i].Census.X, 
	      Sector[i].Census.Y, distpath);

    }
  fclose(fp);
}
  
