
/****************************************************************
*  function:  needfinder.c
*
*  finds a path from a given sector to a needy sector
*  modified from pathfinder.c       
*
*  assumes that it can access the global data-structure Map
*  returns a pointer to the path if successful;
*  returns NULL if it can't find a path
*
****************************************************************/

#include "sve.h"
#include <stdio.h>
#include <string.h>

#define MAXPATH 64
#define CIVFILLTO 400
#define UWFILLTO 300
#define NEEDFOOD 35		/* won't populate if no food */

struct pathinfo {		/* create a doubly linked list */
    struct pathinfo *next;	/* pointer to next structure */
    struct pathinfo *last;	/* pointer to last structure */
    char path[MAXPATH+1];	/* the path itself; allow for null terminator*/
    int end_x;			/* where the x-coord is now */
    int end_y;			/* where the y-coord is now */
    int badsectors;		/* how many "bad sectors" path goes thru */
  };	

struct pathinfo *pathlist;
int gotciv[XWIDTH][YHEIGHT], gotuw[XWIDTH][YHEIGHT];
extern char Direction[6];
extern struct maptype Map[XWIDTH][YHEIGHT];
extern struct Secdata *Sector;

char *
needfinder(from_x, from_y, target_x, target_y, findciv)

int from_x;			/* from x-coord */
int from_y;			/* from y-coord */
int *target_x;			/* to x_coord */
int *target_y;			/* to y_coord */
int findciv;			/* if 1, moving civs; if 0, moving uw's */

{ /*main*/
  struct pathinfo *temp;
  struct pathinfo *current;
  struct pathinfo *putbefore;	/* used as a pointer to sort paths */
  int i, j;
  int used[XWIDTH][YHEIGHT];	/* array of flags: 0 if available to
                                   a path, toggle to 1 when used */
  int length;			/* length of current paths */
  char *answer;
  int dir;
  int max_badsectors;

  answer = NULL;

for (max_badsectors=0; max_badsectors < (findciv+1); max_badsectors++)
  {  /*badsector loop*/

    if (answer != NULL)		/* get out if answer is found */
      break;

    for (i=0; i<XWIDTH; i++)	/* clear array of "used" flags */
      for (j=0; j<YHEIGHT; j++)
	used[i][j] = 0;
    used[from_x][from_y] = 1;	/* flag the starting sector */

    if ((pathlist = (struct pathinfo *) malloc (sizeof(struct pathinfo))) == NULL)
      {
	printf("Memory allocation error at pathlist.\n");
	exit(0);
      }
    pathlist->next = NULL;
    pathlist->last = NULL;	/* starts a new linked list of paths */
    strcpy(pathlist->path, "");
    pathlist->end_x = from_x;
    pathlist->end_y = from_y;
    pathlist->badsectors = 0;

    length = 0;

    while ((length < MAXPATH) && 
	   (answer == NULL) && 
	   (pathlist != NULL))

      { /*reach out one more sector*/

	current = pathlist;
 
	while ((current != NULL) && (answer == NULL))
	  { /*expand each path in list*/
	    
	    for (dir=0; dir < 6; dir++)
	      { /*expand in six directions*/

		if ((temp = (struct pathinfo *) malloc   /* allocate a new */
		     (sizeof(struct pathinfo))) == NULL) /* structure    */
		  {
		    printf("Memory allocation error.\n");
		    exit(0);
		  }

		translocate(dir, current->end_x, current->end_y,
			    &(temp->end_x), &(temp->end_y));
		
		strcpy(temp->path, current->path);
		catachar(temp->path, Direction[dir]);
		temp->badsectors = current->badsectors;
		
		if (used[temp->end_x][temp->end_y])
		  {
		    free(temp);
		    continue;
		  }

		used[temp->end_x][temp->end_y] = 1;

		if (!is_sector(temp->end_x, temp->end_y))
		  {
		    free(temp);
		    continue;
		  }
		
		if (end_path(temp->end_x, temp->end_y, findciv))
		  {
		    if ((answer = (char *) malloc (length+4)) == NULL)
		      {
			printf("Memory allocation error at answer.\n");
			exit(0);
		      }

		    strcpy(answer, temp->path);
		    *target_x = temp->end_x;
		    *target_y = temp->end_y;
		    free(temp);
		    break;
		  }

		if ((temp->badsectors += 
		     is_badsector(temp->end_x, temp->end_y)) <= max_badsectors)
		  {
				/* this next section of code sorts */
				/* the pathlist; new path is inserted */
				/* before sectors with higher badsector */
				/* counts. This way, low badsector paths */
				/* will be expanded before high badsector */
				/* paths, preventing screw-ups caused by */
				/* the immediate flagging of "used" even */
				/* if a low badsector path could have used */
				/* the sector successfully... */

		    putbefore = current;
		    while ( (putbefore->last != NULL) && 
			   ((putbefore->last)->badsectors > temp->badsectors))
		      putbefore = putbefore->last;
				/* so: it slides the pointer putbefore */
				/* back (starting at current) until it */
				/* points at an element with equal or less */
				/* badsectors; now insert temp there. */

		    insertpath(&temp, &(putbefore->last), &putbefore);
		  }
		else
		  free(temp);
	      }

	    temp = current->next;
	    deletepath(&current, &(current->last), &(current->next));
	    current = temp;

	  }
    length++;
   }
   
    while (pathlist != NULL)	/* remove the entire pathlist when done */
      {
	temp = pathlist->next;
	free(pathlist);
	pathlist = temp;
      }


  }
		    
  if (answer != NULL)
      return(answer);
  else
    {
      if ((answer = (char *) malloc (5)) == NULL)
	{
	  printf("Memory allocation error leaving pathfinder.\n");
	  exit(0);
	}
      strcpy(answer, "NULL");
      return(answer);
    }
}



/****************************************************************
*  function: insertpath
*
*  insert a path into pathfinder's dynamic linked list
****************************************************************/

insertpath(path, after, before)
struct pathinfo **path;
struct pathinfo **after;
struct pathinfo **before;
{
  extern struct pathinfo *pathlist;
  
  if ((*before)->last == NULL)
    {
      pathlist = *path;
      (*path)->last = NULL;
    }
  else
    {
      (*path)->last = *after;
      (*after)->next = *path;
    }
      
  (*path)->next = *before;
  (*before)->last = *path;
   
}


/****************************************************************
*  function: deletepath
*
*  delete a path from pathfinder's dynamic linked list, and free
*  its pointer
****************************************************************/

deletepath(path, isafter, isbefore)
struct pathinfo **path;
struct pathinfo **isafter;
struct pathinfo **isbefore;
{
  extern struct pathinfo *pathlist;

  if (*isafter != NULL)
    (*isafter)->next = *isbefore;
  else
    pathlist = (*path)->next;

  if (*isbefore != NULL)
    (*isbefore)->last = *isafter;

  free(*path);
}

  
/****************************************************************
*  function: is_sector
*
*  returns 1 if sector x,y is either active or a dummy
*  expects to find global Map[][] structures
****************************************************************/

is_sector(x, y)

int x;				/* sve coords */
int y;
{
  if ((Map[x][y].status == 1) || (Map[x][y].status == 2))
    return(1);
  else
    return(0);
}


/****************************************************************
*  function: is_badsector
*
*  returns an approximate mobility cost
*        +, = return 0
*        ^ return 10
*        everything else returns 1
*
*  expects to find the global structures Map[][]
****************************************************************/

is_badsector(x,y)

int x;				/* sve coords */
int y;
{
  if ((Map[x][y].designation == '+') || (Map[x][y].designation == '='))
    return(0);
  else if (Map[x][y].designation == '^')
    return(10);
  else
    return(1);
}



/****************************************************************
*  function: end_path
*
*  checks for success of needfinder algorithm
*  returns 1 if success; 0 otherwise
*
*  assumes existence of global structures Map[][]
*  needs to find the gotciv[][] and gotuw[][] arrays
****************************************************************/

end_path(x, y, findciv)
int x;
int y;
int findciv;
{
  extern int gotciv[XWIDTH][YHEIGHT], gotuw[XWIDTH][YHEIGHT];
  int sectorindex;

  sectorindex = Map[x][y].secnumber;

  if (findciv)
    {
      if (((Sector[sectorindex].Census.Civ + gotciv[x][y]) > CIVFILLTO) ||
	  (Sector[sectorindex].Census.Occupied == '*') ||
	  (Sector[sectorindex].Census.Des == '^') ||
	  (Sector[sectorindex].Commod.Comm[1] < NEEDFOOD))
	return(0);
      else
	return(1);
    }
  else
    {
      if (((Sector[sectorindex].Commod.Comm[0] + gotuw[x][y]) > UWFILLTO) ||
	  (Sector[sectorindex].Census.Occupied == '*') ||
	  (Sector[sectorindex].Census.Des == '^') ||
	  (Sector[sectorindex].Commod.Comm[1] < NEEDFOOD))
	return(0);
      else
	return(1);
    }
}


/****************************************************************
* function: catachar(s1, c)
* 
* concatenates a char c onto a string f
****************************************************************/

catachar(s1, c)
char *s1;
char c;
{
  int index = 0;

  for (index=0; s1[index] != '\0'; index++)
    ;

  s1[index] = c;
  s1[index+1] = '\0';

}


#ifdef DEBUG
/****************************************************************
*  function: showpaths
*
*  debugging tool: prints out all paths in pathlist
****************************************************************/

showpaths()
extern struct pathinfo *pathlist;
{
  struct pathinfo *current;

  current = pathlist;
  while (current != NULL)
    {
      printf("%s \n", current->path);
      current = current->next;
    }
}
#endif
