;;;;;;;;;;;;;;;;;;;;;;;;;;; -*- Mode: Emacs-Lisp -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;
;; emp-mouse.el -- Support for sun or X mouse for Gnu Emacs Empire Tool (GEET)
;; 
;; Copyright (c) 1990 Lynn Randolph Slater, Jr
;; 
;; Author          : Lynn Slater  (lrs@indetech.com), and
;;                   Darryl Okahata (darrylo%hpnmd@hpcea.hp.com)
;; Created On      : Thu Jan 31 09:03:39 1991
;; Last Modified By: Lynn Slater x2048
;; Last Modified On: Thu Feb 14 19:16:44 1991
;; Update Count    : 10
;; Status          : GEET General Release 2d Patch 0
;; 
;; PURPOSE
;; 	This file supplies the mouse bindings and related functions for empire.
;; HISTORY
;; 31-Jan-1991		Lynn Slater x2048	
;;    Split out from emp-modes
;; TABLE OF CONTENTS
;;   empire-mouse -- Makes the empire mouse bindings work in the buffer
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The contents of this file ARE copyrighted but permission to use, modify,
;; and distribute this code is granted as described in the file
;; emp-install.el which should have been distributed with this file. These
;; terms constitute what the Free Software Foundation calls a COPYLEFT.
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(provide 'emp-mouse)
(require 'emp-shell)

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Sun emacstool Mouse Support
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Stub out mouse code for non sun folks
(if (not (and (fboundp 'define-mouse) (fboundp 'sm::event-bindings)))
    (progn
      (defun define-mouse (a b c) nil)
      (defun use-local-mousemap (a) nil)
      (defun make-mousemap() nil)
      (defun sm::event-bindings (region) nil)
      ))

(if (and empire-use-mousep
	 window-system
	 (equal window-system 'x)
	 (equal window-system-version '11))
    (condition-case nil
	(require 'x-misc)
      nil
      )
  )

;; copy part of global mousemap
(defvar empire-current-global-mousemap (make-mousemap)
  "Subset of current-global-mousemap. Has only modeline and scrollbar bindings")
;;(setq empire-current-global-mousemap (make-mousemap))

(mapcar '(lambda (pair)
	   (define-mouse empire-current-global-mousemap
	     (car (cdr pair))
	     (car pair)))
	(append (sm::event-bindings 'modeline)
		(sm::event-bindings 'scrollbar))
	)
(define-mouse empire-current-global-mousemap
  '(text control right)
  'mouse-help-region)
(define-mouse empire-current-global-mousemap
  '(text shift right)
  'mouse-help-region)
(define-mouse empire-current-global-mousemap
  '(text control shift meta right)
  'mouse-help-region)
(define-mouse empire-current-global-mousemap
  '(text meta right)
  'mouse-help-region)

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Mouse
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar empire-shell-local-mousemap
  (if (fboundp 'make-mousemap) (make-mousemap))
  "Mouse map for empire shell buffer")

(define-mouse empire-shell-local-mousemap
  '(text left)	      
  'mouse-drag-move-point)

(define-mouse empire-shell-local-mousemap
  '(text up left)	      
  'mouse-drag-set-mark-stuff)

(define-mouse empire-shell-local-mousemap
  '(text middle)	      
  'mouse-set-mark-and-stuff)

(define-mouse empire-shell-local-mousemap
  '(text right)	      
  'empire-mouse-show-where)


;; Map
(defvar empire-map-local-mousemap
  (if (fboundp 'make-mousemap) (make-mousemap))
  "Mouse map for empire map buffer")

(define-mouse empire-map-local-mousemap
  '(text left)	      
  'empire-map-mouse-move-point)

(define-mouse empire-map-local-mousemap
  '(text middle)	      
  'empire-path-to-mouse-move-point)

(define-mouse empire-map-local-mousemap
  '(text right)	      
  'empire-mouse-set-corner)

(define-mouse empire-map-local-mousemap
  '(text right up)	      
  'empire-mouse-insert-corner)

(define-mouse empire-map-local-mousemap
  '(modeline control left)	      
  'w-scroll-left-half-page)

(define-mouse empire-map-local-mousemap
  '(modeline control right)	      
  'w-scroll-right-half-page)

(define-mouse empire-map-local-mousemap
  '(modeline control middle)	      
  'w-point-wysiwig)

(define-mouse empire-map-local-mousemap
  '(modeline meta left)	      
  'w-scroll-left-half-page)

(define-mouse empire-map-local-mousemap
  '(modeline meta right)	      
  'w-scroll-right-half-page)

(define-mouse empire-map-local-mousemap
  '(modeline meta middle)	      
  'w-point-wysiwig)

(define-mouse empire-map-local-mousemap
  '(modeline shift left)	      
  'w-scroll-left-half-page)

(define-mouse empire-map-local-mousemap
  '(modeline shift right)	      
  'w-scroll-right-half-page)

(define-mouse empire-map-local-mousemap
  '(modeline shift middle)	      
  'w-point-wysiwig)

(defun w-scroll-left-half-page (window x y)
  "Scrolls window left 1/2 page."
  (select-window window)
  (scroll-left-half-page))

(defun w-scroll-right-half-page (window x y)
  "Scrolls window right 1/2 page."
  (select-window window)
  (scroll-right-half-page))

(defun w-point-wysiwig (window x y)
  "Scrolls window to make point visible"
  (select-window window)
  (point-wysiwyg))


;; display
(defvar empire-display-local-mousemap
  (if (fboundp 'make-mousemap) (make-mousemap))
  "Mouse map for empire status information buffers")

(define-mouse empire-display-local-mousemap
  '(text left)	      
  'mouse-drag-move-point)

(define-mouse empire-display-local-mousemap
  '(text up left)	      
  'mouse-drag-set-mark-stuff)

(define-mouse empire-display-local-mousemap
  '(text middle)	      
  'empire-mouse-unbound)

(define-mouse empire-display-local-mousemap
  '(text right)	      
  'empire-mouse-show-where)


;; mouse commands
(defun empire-mouse-unbound (window x y) 
  "This mouse key is unused."
  (error "This mouse key does nothing in this window")
  )

(defun empire-mouse-show-where (window x y);; right mouse, use in shell 
  "Move point, show sector in map whose coords are at or after point.
Describe it in the message line."
  (let (there)
    (save-excursion
      (empire-save-window-excursion
       (select-window window)
       (move-to-loc x y)
       (setq there (empire-get-next-where))
       )
      )
    (show-pt there)
    )
  )

(defun empire-mouse-set-corner (window x y);; left mouse, use on *map*
  "Sets upper corner of a box. Drag and release for other corner"
  (select-window window)
  (move-to-loc x y)
  (let ((x (map-x))
	(y (map-y))
	)
    (setq empire-map-corner (cons x y))
    ))

(defun empire-mouse-insert-corner (window x y);; left mouse, use on *map*
  "Insert sector coord range (x1:x2,y1:y2) of this box."
  (let ((cw (selected-window))
	(cb (current-buffer))
	)
    (select-window window)
    (move-to-loc x y)
    (let ((x (map-x))
	  (y (map-y))
	  )
      (setq empire-last-sectors (format " %s:%s,%s:%s"
					(min x (car empire-map-corner))
					(max x (car empire-map-corner))
					(min y (cdr empire-map-corner))
					(max y (cdr empire-map-corner))
					))
      (if (eq cw (minibuffer-window))
	  (progn
	    (select-window cw)
	    (insert empire-last-sectors)
	    )
	(visible-insert-in-empire-buffer empire-last-sectors t)
	))))


;; directly bind show-where for mouseless operation equivilent to the above.

(defun empire-map-mouse-move-point (window x y) ;; left mouse, use on *map*
  "Move point, describe sector. If clicked twice, insert sector coords
into the other window. (This yields census by click, and sector number by
click.)"
  (let ((old-window (selected-window)) )
    (select-window window)
    (move-to-loc x y)
    ;;
    (fixup-map-cursor-location (map-x) (map-y))
    (setq x (map-x)
	  y (map-y))
    (record-current-map-xy x y)
    (if (and (eql (point) highlighted-map) (eq old-window window))
	(select-this-sector)
      (show-map (point))
      )
    (describe-sect x y)
    ))

;;(defun empire-map-describe ();; key equivilent to left mouse, use on *Map*
;;  "Takes sector at point on the map and describe the selected sector."
;;  (interactive)
;;  (let ((x (map-x))
;;	(y (map-y))
;;	)
;;    (message "%s" (describe-sect x y))
;;    ))

(defun empire-path-to-mouse-move-point (window x y)
  "Insert into shell buffer empire route from last sector named in shell to
point."
  (let ((cw (selected-window))
	(cb (current-buffer)))
    (select-window window)
    (move-to-loc x y)
    (if (not (eql (current-buffer) empire-map-buffer))
	(error "This only works from the empire map"))
    (let ((x (map-x))
	  (y (map-y))
	  (pt (switch-to-empire-buffer-if-necessary (last-sector-reference)))
	  )
      (record-current-map-xy x y)
      (message "Looking from %s,%s to %s,%s" (car pt) (cdr pt) x y)
      (show-map (point))
      (visible-insert-in-empire-buffer (r-to-spath (find-route pt (cons x y)))
				       t)
      (message "")
      (set-buffer cb)
      (select-window cw)
      )))

(defun empire-mouse (&optional buffer)
  "Makes the empire mouse bindings work in the buffer"
  (interactive)
  ;; Only set mouse if we are capable
  (if empire-display-local-mousemap
      (if (not buffer)
	  (progn
	    (make-local-variable 'current-global-mousemap)
	    (setq current-global-mousemap empire-current-global-mousemap)
	    (use-local-mousemap empire-display-local-mousemap))
	(let ((cb (current-buffer)))
	  (set-buffer buffer)
	  (make-local-variable 'current-global-mousemap)
	  (setq current-global-mousemap empire-current-global-mousemap)
	  (use-local-mousemap empire-display-local-mousemap)
	  (set-buffer cb)))))
