/*
 * This software was written by Christos S. Zoulas and may be distributed
 * freely as long as the author's name remains attached
 */


/* $Header: /tmp_mnt/home/hyperion/mu/christos/src/mine/lib/alloc/RCS/alloc.c,v 1.9 90/10/02 18:11:24 christos Exp $ */
/*
 *
 * alloc.c : Memory checked Malloc special for lint
 *	     until lint becomes intelligent. This malloc
 *	     keeps track of memory usage.
 *
 * Routines:
 *	char * 		Malloc();
 *	char *		Realloc();
 *	void 		Free();
 *	unsigned	MemStat();
 *	unsigned	MemPtr();
 *
 * $Log:	alloc.c,v $
 * Revision 1.9  90/10/02  18:11:24  christos
 * Another Realloc() bug!
 * 
 * Revision 1.8  90/10/02  17:32:45  christos
 * Fixed Realloc() bug.
 * 
 * Revision 1.7  90/08/24  02:28:15  christos
 * Changed bigstruct_t to align_t
 * for lint.
 * 
 * Revision 1.6  90/07/15  17:31:33  christos
 * Fixed MemPtr Bug
 * 
 * Revision 1.5  90/07/11  16:19:31  christos
 * Added Realloc()
 * 
 * Revision 1.4  90/03/21  12:58:44  christos
 * Fixed void buggy computations.
 * 
 * Revision 1.3  90/02/26  02:15:11  christos
 * ANSI conformance.
 * 
 * Revision 1.2  89/08/29  14:08:25  christos
 * Fixed.
 * 
 * Revision 1.1  89/03/27  14:23:40  christos
 * Initial revision
 * 
 */
#ifndef lint
static char rcsid[] = "$Id: alloc.c,v 1.9 90/10/02 18:11:24 christos Exp $";
#endif /* lint */
#include <stdio.h>
#include "util.h"


#define SET_GOOD_SIGNATURE(a) 	{ \
				    (a)[4] = '0'; \
				    (a)[5] = '1'; \
				    (a)[6] = '2'; \
				    (a)[7] = '3'; \
				}
#define SET_FREE_SIGNATURE(a) 	{ \
				    (a)[4] = '4'; \
				    (a)[5] = '5'; \
				    (a)[6] = '6'; \
				    (a)[7] = '7'; \
				}
#define TEST_GOOD_SIGNATURE(a)	( \
				    (a)[4] == '0' && (a)[5] == '1' && \
				    (a)[6] == '2' && (a)[7] == '3'    \
				)
#define TEST_FREE_SIGNATURE(a)	( \
				    (a)[4] == '4' && (a)[5] == '5' && \
				    (a)[6] == '6' && (a)[7] == '7'    \
				)

private unsigned memused = 0;

#ifdef lint
/* Malloc():
 *	Fake alloc for lint
 */
public align_t *
Malloc(n)
unsigned n;
{
	if ( n )
		return(NIL(align_t));
	return(NIL(align_t));
} /* end Malloc */

#else

#ifdef __STDC__
extern void *malloc(unsigned s);
#else
extern char *malloc();
#endif

/* Malloc():
 *	real alloc 
 */
#ifndef __STDC__
public char *
Malloc(n)
unsigned n;
#else
public void *
Malloc(unsigned n)
#endif
{
    char *ptr;

    ASSERT(n != 0, "Attempt to allocate zero length block");

#ifdef STRICT
    if ( (ptr = (char *) malloc(n+8)) == NIL(char) ) {
#else
    if ( (ptr = (char *) malloc(n+4)) == NIL(char) ) {
#endif /* STRICT */
	(void) fprintf(stderr, 
	    "Out of memory (memory in use %d current allocation %d).\n", 
	    MemStat(), n);
	exit(0);
	return(ptr);
    }
    memused += (*((unsigned *) &ptr[0]) = n);

#ifdef STRICT
    SET_GOOD_SIGNATURE(ptr);
    ptr += 8;
#else
    ptr += 4;
#endif /* STRICT */

#ifdef __STDC__
    return((void *) ptr);
#else
    return(ptr);
#endif
} /* end Malloc */
#endif /* lint */

/* Free():
 *	free memory counting the number of bytes freed
 */
#ifndef __STDC__
public void
Free(ptr)
char *ptr;
#else
public void
Free(void *ptr)
#endif
{
    unsigned n;
    char *tptr;
    tptr = ptr;


    ASSERT(tptr != NIL(char), "Attempt to free nil pointer");

#ifdef STRICT
    tptr -= 8;
    ASSERT(TEST_FREE_SIGNATURE(tptr) != TRUE,"Freeing free block");
    ASSERT(TEST_GOOD_SIGNATURE(tptr) == TRUE,"Missing signature in free block");
    SET_FREE_SIGNATURE(tptr);
#else
    tptr -= 4;
#endif /* STRICT */

    n = *((unsigned *) tptr);
    free(tptr);
    memused -= n;
} /* end Free */

/* MemStat():
 *	return the amount of memory in use
 */
#ifndef __STDC__
public unsigned
MemStat()
#else
public unsigned
MemStat(void)
#endif
{
    return(memused);
} /* end MemStat */

/* MemPtr():
 *	return the amount of memory in use
 */
#ifndef __STDC__
public unsigned
MemPtr(ptr)
char *ptr;
#else
public unsigned
MemPtr(void *ptr)
#endif
{
    char *tptr;

    tptr = ptr;
#ifdef STRICT
    tptr -= 8;
    if ( ! TEST_GOOD_SIGNATURE(tptr) )
	return(0);
#else
    tptr -= 4;
#endif /* STRICT */

    return(*((unsigned *) tptr));
} /* end MemPtr */


#ifdef lint
/* Realloc():
 *	Fake alloc for lint
 */
public align_t *
Realloc(n)
unsigned n;
{
	if ( n )
		return(NIL(align_t));
	return(NIL(align_t));
} /* end Realloc */

#else

#ifdef __STDC__
extern void *realloc(void *o, unsigned s);
#else
extern char *realloc();
#endif

/* Realloc():
 *	real alloc 
 */
#ifndef __STDC__
public char *
Realloc(obj, n)
char *obj;
unsigned n;
#else
public void *
Realloc(void *obj, unsigned n)
#endif
{
    char *ptr, *tptr;

    tptr = obj;
    ASSERT(n != 0, "Attempt to re-allocate zero length block");
    ASSERT(tptr != NIL(char), "Pointer to re-allocate is nil");

#ifdef STRICT
    tptr -= 8;
    ASSERT(TEST_FREE_SIGNATURE(tptr) != TRUE,
	   "Reallocating free block");
    ASSERT(TEST_GOOD_SIGNATURE(tptr) == TRUE, 
	   "Missing signature in block to reallocate");
    SET_FREE_SIGNATURE(tptr);
#else
    tptr -= 4;
#endif /* STRICT */

    memused -= *((unsigned *) tptr);

#ifdef STRICT
    if ( (ptr = (char *) realloc(tptr, n+8)) == NIL(char) ) {
#else
    if ( (ptr = (char *) realloc(tptr, n+4)) == NIL(char) ) {
#endif /* STRICT */
	(void) fprintf(stderr, 
	    "Out of memory (memory in use %d current allocation %d).\n", 
	    MemStat(), n);
	exit(0);
	return(ptr);
    }
    memused += (*((unsigned *) &ptr[0]) = n);

#ifdef STRICT
    SET_GOOD_SIGNATURE(ptr);
    ptr += 8;
#else
    ptr += 4;
#endif /* STRICT */

#ifdef __STDC__
    return((void *) ptr);
#else
    return(ptr);
#endif
} /* end Realloc */
#endif /* lint */
