#include "constants.h"
#include "config.h"
#include "types.h"

/* Following are creature arrays and variables			*/
	/* Creatures must be defined here				*/
	/*       See TYPES.INC under creature_type for a complete list
		of all variables for creatures.  Some of the less obvious
		are explained below.

	Hit points:	'#1d#2' where #2 is the range of each roll and
			#1 is the number of added up rolls to make.
			Example: a creature with 5 eight-sided hit die
			is given '5d8'.

		Attack types:
		1       Normal attack
		2       Poison Strength
		3       Confusion attack
		4       Fear attack
		5       Fire attack
		6       Acid attack
		7       Cold attack
		8       Lightning attack
		9       Corrosion attack
		10      Blindness attack
		11      Paralysis attack
		12      Steal Money
		13      Steal Object
		14      Poison
		15      Lose dexterity
		16      Lose constitution
		17      Lose intelligence
		18      Lose wisdom
		19      Lose experience
		20      Aggravation
		21      Disenchants
		22      Eats food
		23      Eats light
		24      Eats charges
		99      Blank

		Attack descriptions:
		1       hits you.
		2       bites you.
		3       claws you.
		4       stings you.
		5       touches you.
		6       kicks you.
		7       gazes at you.
		8       breathes on you.
		9       spits on you.
		10      makes a horrible wail.
		11      embraces you.
		12      crawls on you.
		13      releases a cloud of spores.
		14      begs you for money.
		15      You've been slimed.
		16      crushes you.
		17      tramples you.
		18      drools on you.
		19      insults you.
		99      is repelled.

	Example:  For a creature which bites for 1d6, then stings for
		  2d4 and loss of dex you would use:
			'1 2 1d6|15 4 2d4'

		CMOVE flags:
Movement.       00000001        Move only to attack
	.       00000002        Move, attack normal
	.       00000008        20% random movement
	.       00000010        40% random movement
	.       00000020        75% random movement
Special +       00010000        Invisible movement
	+       00020000        Move through door
	+       00040000        Move through wall
	+       00080000        Move through creatures
	+       00100000        Picks up objects
	+       00200000        Multiply monster
Carries =       01000000        Carries objects.
	=       02000000        Carries gold.
	=       04000000        Has 60% of time.
	=       08000000        Has 90% of time.
	=       10000000        1d2 objects/gold.
	=       20000000        2d2 objects/gold.
	=       40000000        4d2 objects/gold.
Special ~       80000000        Win-the-Game creature.

		SPELL Flags:
Frequency       000001    1     These add up to x.  Then
(1 in x).       000002    2     if RANDINT(X) = 1 the
	.       000004    4     creature casts a spell.
	.       000008    8
Spells  =       000010  Teleport short (blink)
	=       000020  Teleport long
	=       000040  Teleport player to monster
	=       000080  Cause light wound
	=       000100  Cause serious wound
	=       000200  Hold person (Paralysis)
	=       000400  Cause blindness
	=       000800  Cause confusion
	=       001000  Cause fear
	=       002000  Summon monster
	=       004000  Summon undead
	=       008000  Slow Person
	=       010000  Drain Mana
	=       020000  Not Used
	=       040000  Not Used
Breaths +       080000  Breath Lightning
	+       100000  Breath Gas
	+       200000  Breath Acid
	+       400000  Breath Frost
	+       800000  Breath Fire

		CDEFENSE flags:
		0001    Hurt by Slay Dragon.
		0002    Hurt by Slay Monster.
		0004    Hurt by Slay Evil.
		0008    Hurt by Slay Undead.
		0010    Hurt by Frost.
		0020    Hurt by Fire.
		0040    Hurt by Poison.
		0080    Hurt by Acid.
		0100    Hurt by Light-Wand.
		0200    Hurt by Stone-to-Mud.
		0400    Not used.
		0800    Not used.
		1000    Cannot be charmed or slept.
		2000    Can be seen with infra-vision.
		4000    Max Hit points.
		8000    Not used.


	Sleep (sleep)	:	A measure in turns of how fast creature
				will notice player (on the average).
	Area of affect (aaf) :  Max range that creature is able to "notice"
				the player.
									*/

creature_type c_list[MAX_CREATURES] = {
{"Filthy Street Urchin"     ,0x0012000A,0x00000000,0x2034,  400,    0,
   4,   1, 1, 'p', "1d4"   , "1 14 0d0|12 5 0d0"              ,    0},
{"Blubbering Idiot"         ,0x0012000A,0x00000000,0x2030,  000,    0,
   6,   1, 1, 'p', "1d2"   , "1 18 0d0"                       ,    0},
{"Pitiful-Looking Beggar"   ,0x0012000A,0x00000000,0x2030,  400,    0,
  10,   1, 1, 'p', "1d4"   , "1 14 0d0"                       ,    0},
{"Mangy-Looking Leper"      ,0x0012000A,0x00000000,0x2030,  500,    0,
  10,   1, 1, 'p', "1d1"   , "1 14 0d0"                       ,    0},
{"Squint-Eyed Rogue"        ,0x07120002,0x00000000,0x2034,  999,    0,
  10,   8, 1, 'p', "2d8"   , "1 1 1d6|13 5 0d0"               ,    0},
{"Singing, Happy Drunk"     ,0x06120038,0x00000000,0x2030,    0,    0,
  10,   1, 1, 'p', "2d3"   , "1 14 0d0"                       ,    0},
{"Mean-Looking Mercenary"   ,0x0B12000A,0x00000000,0x2034,25000,    0,
  10,  20, 1, 'p', "5d8"   , "1 1 1d10"                       ,    0},
{"Battle-Scarred Veteran"   ,0x0B12000A,0x00000000,0x2030,25000,    0,
  10,  30, 1, 'p', "7d8"   , "1 1 2d6"                        ,    0},
{"Grey Mushroom patch"      ,0x00000001,0x00000000,0x10A0,    0,    1,
   2,   1, 1, ',', "1d2"   , "3 13 1d4"                       ,    1},
{"Giant Yellow Centipede"   ,0x00000002,0x00000000,0x0002,  300,    2,
   8,  12, 1, 'c', "2d6"   , "1 2 1d3|1 4 1d3"                ,    1},
{"Giant White Centipede"    ,0x0000000A,0x00000000,0x0002,  400,    2,
   7,  10, 1, 'c', "3d5"   , "1 2 1d2|1 4 1d2"                ,    1},
{"White Icky-Thing"         ,0x00000012,0x00000000,0x0022,  100,    2,
  12,   7, 1, 'i', "3d5"   , "1 5 1d2"                        ,    1},
{"Clear Icky-Thing"         ,0x00010002,0x00000000,0x0022,  100,    1,
  12,   6, 1, 'i', "2d5"   , "1 5 1d2"                        ,    1},
{"Giant White Mouse"        ,0x0020000A,0x00000000,0x2070,  200,    1,
   8,   4, 1, 'r', "1d3"   , "1 2 1d2"                        ,    1},
{"Large Brown Snake"        ,0x0000000A,0x00000000,0x00B0,  999,    3,
   4,  35, 0, 'R', "4d6"   , "1 2 1d3|1 16 1d4"               ,    1},
{"Large White Snake"        ,0x00000012,0x00000000,0x00B0,  999,    2,
   4,  30, 1, 'R', "3d6"   , "1 2 1d1"                        ,    1},
{"Kobold"                   ,0x07020002,0x00000000,0x2032,  100,    5,
  20,  16, 1, 'k', "3d7"   , "1 1 1d6"                        ,    1},
{"White Worm mass"          ,0x00200022,0x00000000,0x01B0,    1,    2,
   6,   1, 0, 'w', "4d4"   , "14 12 1d2"                      ,    1},
{"Floating Eye"             ,0x00000001,0x0001000D,0x2102,  100,    1,
   2,   6, 1, 'e', "3d6"   , "11 7 0d0"                       ,    1},
{"Shrieker Mushroom patch"  ,0x00000001,0x00000000,0x10A0,    0,    1,
   2,   1, 1, ',', "1d1"   , "20 10 0d0"                      ,    2},
{"Blubbering Icky-Thing"    ,0x0B180012,0x00000000,0x0022,  100,    8,
  10,   4, 1, 'i', "5d8"   , "14 12 1d4|22 12 0d0"            ,    2},
{"Metallic Green Centipede" ,0x00000012,0x00000000,0x0000,  100,    3,
   5,   4, 2, 'c', "4d4"   , "1 12 1d1"                       ,    2},
{"Novice Warrior"           ,0x07020002,0x00000000,0x2030,   50,    6,
  20,  16, 1, 'p', "9d4"   , "1 1 1d7"                        ,    2},
{"Novice Rogue"             ,0x07020002,0x00000000,0x2030,   50,    6,
  20,  12, 1, 'p', "8d4"   , "1 1 1d6|12 5 0d0"               ,    2},
{"Novice Priest"            ,0x07020002,0x0000108C,0x2030,  100,    7,
  20,  10, 1, 'p', "7d4"   , "1 1 1d5"                        ,    2},
{"Novice Mage"              ,0x07020002,0x0000089C,0x2030,   50,    7,
  20,   6, 1, 'p', "6d4"   , "1 1 1d4"                        ,    2},
{"Yellow Mushroom patch"    ,0x00000001,0x00000000,0x10A0,    0,    2,
   2,   1, 1, ',', "1d1"   , "4 13 1d6"                       ,    2},
{"White Jelly"              ,0x0B000001,0x00000000,0x01A0,  999,   10,
   2,   1, 2, 'J', "8d8"   , "14 5 1d2"                       ,    2},
{"Giant Green Frog"         ,0x0000000A,0x00000000,0x0082,  300,    6,
  14,   8, 1, 'f', "2d8"   , "1 2 1d3"                        ,    2},
{"Giant Black Ant"          ,0x0000000A,0x00000000,0x0002,  400,    8,
  14,  20, 1, 'a', "3d6"   , "1 2 1d4"                        ,    2},
{"White Harpy"              ,0x00000012,0x00000000,0x2036,  100,    5,
  16,  17, 1, 'h', "2d5"   , "1 3 1d1|1 3 1d1|1 2 1d2"        ,    2},
{"Blue Yeek"                ,0x07020002,0x00000000,0x2030,  100,    4,
  18,  14, 1, 'y', "2d6"   , "1 1 1d5"                        ,    2},
{"Green Worm mass"          ,0x00200022,0x00000000,0x01B0,  100,    3,
   7,   3, 0, 'w', "6d4"   , "9 12 1d3"                       ,    2},
{"Large Black Snake"        ,0x0000000A,0x00000000,0x00B0,  750,    9,
   5,  38, 0, 'R', "4d8"   , "1 2 1d4|1 16 1d6"               ,    2},
{"Poltergeist"              ,0x0F15003A,0x0000001F,0x100C,  750,    6,
   8,  15, 3, 'G', "2d5"   , "4 1 1d1"                        ,    3},
{"Metallic Blue Centipede"  ,0x00000012,0x00000000,0x0000,  150,    7,
   6,   6, 2, 'c', "4d5"   , "1 12 1d2"                       ,    3},
{"Giant White Louse"        ,0x00200022,0x00000000,0x01F0,  100,    1,
   6,   5, 2, 'l', "1d1"   , "1 2 1d1"                        ,    3},
{"Black Naga"               ,0x0710000A,0x00000000,0x20E6, 1200,   20,
  16,  40, 1, 'n', "6d8"   , "1 16 1d8"                       ,    3},
{"Spotted Mushroom patch"   ,0x00000001,0x00000000,0x10A0,    0,    3,
   2,   1, 1, ',', "1d1"   , "14 13 2d4"                      ,    3},
{"Yellow Jelly"             ,0x0B000001,0x0001000F,0x01A0,  999,   12,
   2,   1, 2, 'J', "10d8"  , "14 5 1d3"                       ,    3},
{"Scruffy-Looking Hobbit"   ,0x05020002,0x00000000,0x2030,  100,    4,
  16,   8, 1, 'p', "3d5"   , "1 1 1d4|12 5 0d0"               ,    3},
{"Huge Brown Bat"           ,0x00000022,0x00000000,0x2160,  400,    4,
   8,  12, 3, 'b', "2d6"   , "1 2 1d2"                        ,    3},
{"Giant White Ant"          ,0x00000002,0x00000000,0x0002,  800,    7,
   8,  16, 1, 'a', "3d6"   , "1 2 1d4"                        ,    3},
{"Yellow Mold"              ,0x0B000001,0x00000000,0x10A0,  999,    9,
   2,  10, 1, 'm', "8d8"   , "1 1 1d4"                        ,    3},
{"Metallic Red Centipede"   ,0x0000000A,0x00000000,0x0000,  200,   12,
   8,   9, 2, 'c', "4d8"   , "1 12 1d2"                       ,    3},
{"Yellow Worm mass"         ,0x00200022,0x00000000,0x01B0,  100,    4,
   7,   4, 0, 'w', "4d8"   , "15 12 1d3"                      ,    3},
{"Large Grey Snake"         ,0x0000000A,0x00000000,0x00B0,  700,   10,
   5,  40, 0, 'R', "6d8"   , "1 2 1d4|1 16 1d6"               ,    3},
{"Radiation Eye"            ,0x00000001,0x0001000B,0x2102,  100,    6,
   2,   6, 1, 'e', "3d6"   , "2 7 1d6"                        ,    3},
{"Drooling Harpy"           ,0x00000012,0x00000000,0x2036,  100,    7,
  16,  22, 1, 'h', "2d8"   , "1 3 1d1|1 3 1d1|1 2 1d2|1 18 0d0",   3},
{"Silver Mouse"             ,0x0020000A,0x00000000,0x2072,  100,    1,
   8,   5, 1, 'r', "1d1"   , "23 1 1d1"                       ,    4},
{"Black Mushroom patch"     ,0x00000001,0x00000000,0x10A0,    0,    8,
   2,   1, 1, ',', "8d8"   , "1 13 1d3"                       ,    4},
{"Blue Jelly"               ,0x0B000001,0x00000000,0x01A0,  999,   14,
   2,   1, 1, 'J', "12d8"  , "7 5 1d6"                        ,    4},
{"Creeping Copper Coins"    ,0x00000002,0x00000000,0x0002,  100,    9,
   3,  24, 0, '$', "7d8"   , "1 2 1d4|14 8 2d4"               ,    4},
{"Giant White Rat"          ,0x0020000A,0x00000000,0x2070,  300,    1,
   8,   7, 1, 'r', "2d2"   , "14 2 1d3"                       ,    4},
{"Giant Black Centipede"    ,0x00000022,0x00000000,0x0002,  300,   11,
   8,  20, 1, 'c', "5d8"   , "1 2 1d2|1 4 1d2"                ,    4},
{"Giant Blue Centipede"     ,0x00000002,0x00000000,0x0002,  500,   10,
   8,  20, 1, 'c', "4d8"   , "1 2 1d3|1 4 1d4"                ,    4},
{"Blue Worm mass"           ,0x00200022,0x00000000,0x01B0,  100,    5,
   7,  12, 0, 'w', "5d8"   , "7 12 1d4"                       ,    4},
{"Large Grey Snake"         ,0x0000000A,0x00000000,0x00B0,  500,   14,
   6,  41, 0, 'R', "6d8"   , "1 2 1d5|1 16 1d8"               ,    4},
{"Jackal"                   ,0x00000012,0x00000000,0x2030,  300,    8,
  12,  16, 1, 'j', "3d8"   , "1 2 1d6"                        ,    4},
{"Green Naga"               ,0x0710000A,0x00000000,0x2066, 1200,   30,
  20,  40, 1, 'n', "9d8"   , "1 16 1d8|6 9 2d6"               ,    5},
{"Green Glutton Ghost"      ,0x0F150032,0x0000003F,0x100C,  100,   15,
  10,  20, 3, 'G', "3d6"   , "22 15 1d1"                      ,    5},
{"White Mushroom patch"     ,0x00000001,0x00000000,0x10A0,    0,    5,
   2,   1, 1, ',', "1d1"   , "11 13 2d4"                      ,    5},
{"Green Jelly"              ,0x0B000001,0x00000000,0x01A0,  999,   18,
   2,   1, 2, 'J', "22d8"  , "9 5 1d2"                        ,    5},
{"Skeleton Kobold"          ,0x00020002,0x00000000,0x000C,  400,   12,
  20,  26, 1, 's', "5d8"   , "1 1 1d6"                        ,    5},
{"Silver Jelly"             ,0x0B000001,0x00000000,0x00B0,    1,   15,
   2,  25, 1, 'J', "20d8"  , "23 5 1d3"                       ,    5},
{"Giant Black Frog"         ,0x0000000A,0x00000000,0x00A2,  400,   12,
  12,  18, 1, 'f', "4d8"   , "1 2 1d6"                        ,    5},
{"Grey Icky-Thing"          ,0x00000012,0x00000000,0x0022,  150,   10,
  14,  12, 1, 'i', "4d8"   , "1 5 1d5"                        ,    5},
{"Disenchanter Eye"         ,0x00000009,0x00010009,0x2102,  100,   20,
   4,  10, 0, 'e', "7d8"   , "21 7 0d0"                       ,    5},
{"Black Yeek"               ,0x07020002,0x00000000,0x2030,  100,    8,
  18,  16, 1, 'y', "2d8"   , "1 1 1d5"                        ,    5},
{"Red Worm mass"            ,0x00200022,0x00000000,0x21B0,  100,    6,
   7,  12, 0, 'w', "5d8"   , "5 12 1d6"                       ,    5},
{"Giant House Fly"          ,0x00000022,0x00000000,0x0062,  200,   10,
  12,  16, 3, 'F', "3d8"   , "1 2 1d2"                        ,    5},
{"Copperhead Snake"         ,0x00000012,0x00000000,0x00B0,    1,   15,
   6,  20, 1, 'R', "4d6"   , "14 2 2d4"                       ,    5},
{"Rot Jelly"                ,0x0B000001,0x00000000,0x00B0,    1,   15,
   2,  30, 1, 'J', "20d8"  , "22 5 2d3"                       ,    5},
{"Purple Mushroom patch"    ,0x00000001,0x00000000,0x10A0,    0,   12,
   2,   1, 2, ',', "1d1"   , "16 13 1d2"                      ,    6},
{"Brown Mold"               ,0x0B000001,0x00000000,0x10A0,  999,   20,
   2,  12, 1, 'm', "15d8"  , "3 1 1d4"                        ,    6},
{"Giant Brown Bat"          ,0x0000001A,0x00000000,0x2160,  300,   10,
  10,  15, 3, 'b', "3d8"   , "1 2 1d3"                        ,    6},
{"Creeping Silver Coins"    ,0x00000002,0x00000000,0x0002,  100,   18,
   4,  30, 0, '$', "12d8"  , "1 2 1d6|14 8 2d6"               ,    6},
{"Orc"                      ,0x0B020002,0x00000000,0x2036,  300,   16,
  20,  32, 1, 'o', "9d8"   , "1 1 1d8"                        ,    6},
{"Grey Harpy"               ,0x00000012,0x00000000,0x2036,  100,   14,
  16,  20, 2, 'h', "3d8"   , "1 3 1d2|1 3 1d2|1 2 1d2"        ,    6},
{"Blue Icky-Thing"          ,0x00000012,0x00000000,0x0022,  200,   12,
  18,  14, 1, 'i', "4d8"   , "7 5 2d3"                        ,    6},
{"Rattlesnake"              ,0x00000012,0x00000000,0x00B0,    1,   20,
   6,  24, 1, 'R', "6d7"   , "14 2 2d5"                       ,    6},
{"Bloodshot Eye"            ,0x00000001,0x00010007,0x2102,  100,   15,
   2,   6, 1, 'e', "4d8"   , "10 7 2d6"                       ,    7},
{"Red Naga"                 ,0x0710000A,0x00000000,0x20E6, 1200,   40,
  20,  40, 1, 'n', "11d8"  , "1 16 1d10|2 2 1d4"              ,    7},
{"Red Jelly"                ,0x0B000001,0x00000000,0x01A0,  999,   26,
   2,   1, 1, 'J', "26d8"  , "2 5 1d5"                        ,    7},
{"Giant Red Frog"           ,0x0000000A,0x00000000,0x00A2,  500,   16,
  12,  16, 1, 'f', "5d8"   , "2 2 2d4"                        ,    7},
{"Green Icky-Thing"         ,0x00000012,0x00000000,0x0022,  200,   18,
  14,  12, 1, 'i', "5d8"   , "9 5 2d5"                        ,    7},
{"Zombie Kobold"            ,0x00020002,0x00000000,0x002E,  300,   14,
  20,  14, 1, 'z', "6d8"   , "1 1 1d2|1 1 1d2"                ,    7},
{"Lost Soul"                ,0x0015001A,0x0001002F,0x100C,  100,   18,
   4,  10, 1, 'G', "2d8"   , "1 1 2d2|18 5 0d0"               ,    7},
{"Greedy little Gnome"      ,0x0B020002,0x00000000,0x2030,  100,   13,
  18,  14, 1, 'p', "3d8"   , "1 1 1d7|13 5 0d0"               ,    7},
{"Giant Green Fly"          ,0x00000022,0x00000000,0x0062,  500,   15,
  12,  14, 2, 'F', "3d8"   , "1 2 1d4"                        ,    7},
{"Brown Yeek"               ,0x07020002,0x00000000,0x2030,  100,   11,
  18,  18, 1, 'y', "3d8"   , "1 1 1d6"                        ,    8},
{"Green Mold"               ,0x0B000001,0x00000000,0x10A0,  750,   28,
   2,  14, 1, 'm', "21d8"  , "4 1 1d4"                        ,    8},
{"Skeleton Orc"             ,0x00020002,0x00000000,0x100C,  400,   26,
  20,  36, 1, 's', "10d8"  , "1 1 2d5"                        ,    8},
{"Seedy looking Human"      ,0x13020002,0x00000000,0x2034,  200,   22,
  20,  26, 1, 'p', "8d8"   , "1 1 3d4"                        ,    8},
{"Red Icky-Thing"           ,0x00000012,0x00000000,0x0022,  200,   22,
  14,  18, 2, 'i', "4d8"   , "1 5 1d3|6 8 1d5"                ,    8},
{"Bandit"                   ,0x13020002,0x00000000,0x2030,  999,   26,
  20,  24, 1, 'p', "8d8"   , "1 1 2d4|12 5 0d0"               ,    8},
{"Yeti"                     ,0x00020002,0x00000000,0x2024,  100,   30,
  20,  24, 1, 'Y', "11d8"  , "1 3 1d3|1 3 1d3|1 2 1d4"        ,    9},
{"Bloodshot Icky-Thing"     ,0x0000000A,0x0001000B,0x2022,  800,   24,
  14,  18, 1, 'i', "7d8"   , "1 5 1d4|9 8 2d4"                ,    9},
{"Giant Grey Rat"           ,0x0020000A,0x00000000,0x2070,  200,    2,
  10,  12, 1, 'r', "2d3"   , "14 2 1d4"                       ,    9},
{"Black Harpy"              ,0x0000000A,0x00000000,0x2036,  100,   19,
  16,  22, 2, 'h', "3d8"   , "1 3 1d2|1 3 1d2|1 2 1d3"        ,    9},
{"Giant Black Bat"          ,0x00000012,0x00000000,0x2060,  250,   16,
  12,  18, 3, 'b', "2d8"   , "1 2 1d6"                        ,    9},
{"Clear Yeek"               ,0x07030002,0x00000000,0x0030,  100,   14,
  18,  24, 1, 'y', "3d6"   , "1 1 1d5"                        ,    9},
{"Orc Shaman"               ,0x0B020002,0x00008085,0x2036,  200,   30,
  20,  15, 1, 'o', "7d8"   , "1 1 1d6"                        ,    9},
{"Giant Red Ant"            ,0x00000002,0x00000000,0x0002,  600,   22,
  12,  34, 1, 'a', "4d8"   , "1 2 1d4|2 4 1d4"                ,    9},
{"King Cobra"               ,0x00000012,0x00000000,0x00B0,    1,   28,
   8,  30, 1, 'R', "8d8"   , "10 9 1d2|14 2 3d4"              ,    9},
{"Clear Mushroom patch"     ,0x00210001,0x00000000,0x00A0,    0,    1,
   4,   1, 2, ',', "1d1"   , "1 13 1d1"                       ,   10},
{"Giant White Tick"         ,0x0000000A,0x00000000,0x0022,  200,   27,
  12,  40, 0, 't', "15d8"  , "14 2 2d6"                       ,   10},
{"Hairy Mold"               ,0x0B000001,0x00000000,0x10A0,  700,   32,
   2,  15, 1, 'm', "15d8"  , "14 1 1d3"                       ,   10},
{"Disenchanter Mold"        ,0x0B000001,0x0001000B,0x10A0,  100,   40,
   2,  20, 1, 'm', "16d8"  , "21 5 1d6"                       ,   10},
{"Giant Red Centipede"      ,0x00000002,0x00000000,0x0082,  500,   24,
  12,  26, 2, 'c', "3d8"   , "1 2 1d2|14 4 1d2"               ,   10},
{"Creeping Gold Coins"      ,0x00000002,0x00000000,0x0002,  100,   32,
   5,  36, 0, '$', "18d8"  , "1 2 2d5|14 8 3d5"               ,   10},
{"Giant Fruit Fly"          ,0x00200022,0x00000000,0x0062,  500,    4,
   8,  14, 2, 'F', "2d2"   , "1 2 1d2"                        ,   10},
{"Brigand"                  ,0x13020002,0x00000000,0x2030,  100,   35,
  20,  32, 1, 'p', "9d8"   , "1 1 2d4|13 5 0d0"               ,   10},
{"Orc Zombie"               ,0x00020002,0x00000000,0x102E,  250,   30,
  20,  24, 1, 'z', "11d8"  , "1 1 1d4|1 1 1d4"                ,   11},
{"Orc Warrior"              ,0x0F020002,0x00000000,0x2036,  250,   34,
  20,  36, 1, 'o', "11d8"  , "1 1 2d6"                        ,   11},
{"Vorpal Bunny"             ,0x0020000A,0x00000000,0x2070,  300,    2,
   8,  10, 2, 'r', "2d3"   , "1 2 1d5"                        ,   11},
{"Nasty little Gnome"       ,0x0B020002,0x000020B5,0x2030,   10,   32,
  18,  10, 1, 'p', "4d8"   , "1 1 1d5"                        ,   11},
{"Hobgoblin"                ,0x0F020002,0x00000000,0x2036,  300,   38,
  20,  38, 1, 'H', "12d8"  , "1 1 1d10"                       ,   11},
{"Black Mamba"              ,0x00000012,0x00000000,0x00B0,    1,   40,
  20,  32, 2, 'R', "10d8"  , "14 2 4d4"                       ,   12},
{"Grape Jelly"              ,0x0B000001,0x0001000B,0x01A0,  999,   60,
   2,   1, 1, 'J', "52d8"  , "19 5 5d8"                       ,   12},
{"Master Yeek"              ,0x07020002,0x00008018,0x2030,  100,   28,
  18,  24, 1, 'y', "5d8"   , "1 1 1d8"                        ,   12},
{"Priest"                   ,0x13020002,0x00000285,0x2030,  400,   36,
  20,  22, 1, 'p', "7d8"   , "1 1 2d3"                        ,   12},
{"Giant Clear Ant"          ,0x00010002,0x00000000,0x0102,  600,   24,
  12,  18, 1, 'a', "3d7"   , "1 2 1d4"                        ,   12},
{"Air Spirit"               ,0x00030022,0x00000000,0x0010,  200,   40,
  12,  20, 3, 'E', "5d8"   , "1 1 1d3"                        ,   12},
{"Skeleton Human"           ,0x00020002,0x00000000,0x100C,  300,   38,
  20,  30, 1, 's', "12d8"  , "1 1 1d8"                        ,   12},
{"Human Zombie"             ,0x00020002,0x00000000,0x102E,  200,   34,
  20,  24, 1, 'z', "11d8"  , "1 1 1d4|1 1 1d4"                ,   12},
{"Moaning Spirit"           ,0x0F15000A,0x0001002E,0x100C,  300,   44,
   6,  20, 1, 'G', "4d8"   , "4 10 0d0|15 5 1d8"              ,   12},
{"Swordsman"                ,0x13020002,0x00000000,0x2030,  999,   40,
  20,  34, 1, 'p', "11d8"  , "1 1 3d5"                        ,   12},
{"Killer Brown Beetle"      ,0x0000000A,0x00000000,0x0002,  300,   38,
  10,  40, 1, 'K', "13d8"  , "1 2 3d4"                        ,   13},
{"Ogre"                     ,0x07020002,0x00000000,0x2036,  300,   42,
  20,  32, 1, 'o', "13d8"  , "1 1 2d8"                        ,   13},
{"Giant Red Speckled Frog"  ,0x0000000A,0x00000000,0x00A2,  300,   32,
  12,  20, 1, 'f', "6d8"   , "1 2 3d4"                        ,   13},
{"Magic User"               ,0x13020002,0x00002413,0x2030,  100,   35,
  20,  10, 1, 'p', "7d8"   , "1 1 2d2"                        ,   13},
{"Black Orc"                ,0x0B020002,0x00000000,0x2036,  200,   40,
  20,  36, 1, 'o', "12d8"  , "1 1 3d4"                        ,   13},
{"Giant Long-Eared Bat"     ,0x0000001A,0x00000000,0x2160,  200,   20,
  12,  20, 3, 'b', "5d8"   , "1 2 1d4|1 3 1d2|1 3 1d2"        ,   13},
{"Giant Gnat"               ,0x00200022,0x00000000,0x0062,  100,    1,
   8,   4, 3, 'F', "1d2"   , "1 2 1d1"                        ,   13},
{"Killer Green Beetle"      ,0x00000012,0x00000000,0x0002,  300,   46,
  12,  45, 1, 'K', "16d8"  , "1 2 4d4"                        ,   14},
{"Giant Flea"               ,0x00200022,0x00000000,0x0062,  100,    1,
   8,  25, 2, 'F', "2d2"   , "1 2 1d2"                        ,   14},
{"Giant White Dragon Fly"   ,0x00000012,0x0040000A,0x0060,  500,   54,
  20,  20, 1, 'F', "5d8"   , "7 2 1d6"                        ,   14},
{"Hill Giant"               ,0x07020002,0x00000000,0x2034,  500,   52,
  20,  36, 1, 'P', "16d8"  , "1 1 3d6"                        ,   14},
{"Skeleton Hobgoblin"       ,0x00020002,0x00000000,0x100C,  300,   46,
  20,  34, 1, 's', "13d8"  , "1 1 2d5"                        ,   14},
{"Flesh Golem"              ,0x00020002,0x00000000,0x11B0,  100,   48,
  12,  10, 1, 'g', "12d8"  , "1 1 1d6|1 1 1d6"                ,   14},
{"White Dragon Bat"         ,0x00000012,0x00400004,0x2150,  500,   40,
  12,  20, 3, 'b', "2d6"   , "7 2 1d3"                        ,   14},
{"Giant Black Louse"        ,0x00200012,0x00000000,0x01F2,  100,    1,
   6,   7, 2, 'l', "1d1"   , "1 2 1d2"                        ,   14},
{"Guardian Naga"            ,0x1710000A,0x00000000,0x20E6, 1200,   60,
  20,  50, 1, 'n', "24d8"  , "1 16 2d8|1 2 1d8"               ,   15},
{"Giant Grey Bat"           ,0x00000012,0x00000000,0x2160,  150,   22,
  12,  22, 3, 'b', "4d8"   , "1 2 1d6|1 3 1d2|1 3 1d2"        ,   15},
{"Giant Clear Centipede"    ,0x00010002,0x00000000,0x0002,  300,   30,
  10,  30, 1, 'c', "5d8"   , "1 2 2d4|1 4 2d4"                ,   15},
{"Giant Yellow Tick"        ,0x0000000A,0x00000000,0x0022,  200,   48,
  12,  48, 0, 't', "20d8"  , "14 2 3d9"                       ,   15},
{"Giant Ebony Ant"          ,0x00200002,0x00000000,0x0002,  600,    3,
  12,  24, 1, 'a', "3d4"   , "1 2 2d3"                        ,   15},
{"Frost Giant"              ,0x07020002,0x00000000,0x0024,  500,   54,
  20,  38, 1, 'P', "17d8"  , "7 1 3d6"                        ,   15},
{"Clay Golem"               ,0x00020002,0x00000000,0x1200,  100,   50,
  12,  20, 1, 'g', "14d8"  , "1 1 1d8|1 1 1d8"                ,   15},
{"Huge White Bat"           ,0x00200012,0x00000000,0x2160,  400,    3,
   7,  12, 2, 'b', "3d8"   , "1 2 1d6"                        ,   15},
{"Giant Tan Bat"            ,0x00000012,0x00000000,0x2160,  400,   18,
  12,  18, 2, 'b', "3d8"   , "4 2 1d2|1 3 1d1|1 3 1d1"        ,   15},
{"Violet Mold"              ,0x0B000001,0x00010009,0x10A0,  700,   50,
   2,  15, 1, 'm', "17d8"  , "11 1 1d2"                       ,   15},
{"Umber Hulk"               ,0x00020002,0x00000000,0x2126,  100,   75,
  20,  20, 1, 'U', "20d8"  , "3 7 0d0|1 1 1d6|1 1 1d6|1 2 2d6",   16},
{"Gelatinous Cube"          ,0x2F18000A,0x00000000,0x00A2,    1,   36,
  12,  18, 0, 'C', "45d8"  , "6 5 1d10"                       ,   16},
{"Giant Black Rat"          ,0x0020000A,0x00000000,0x2070,  200,    3,
   8,  16, 1, 'r', "3d4"   , "14 2 1d5"                       ,   16},
{"Giant Green Dragon Fly"   ,0x00000012,0x0010000A,0x0070,  500,   58,
  20,  20, 1, 'F', "5d8"   , "14 2 1d6"                       ,   16},
{"Fire Giant"               ,0x07020002,0x00000000,0x2014,  500,   62,
  20,  40, 1, 'P', "20d8"  , "5 1 3d7"                        ,   16},
{"Green Dragon Bat"         ,0x00000012,0x00100004,0x2150,  500,   44,
  12,  22, 3, 'b', "2d7"   , "14 2 1d3"                       ,   16},
{"Quasit"                   ,0x1103000A,0x000010FA,0x0004,  200,   48,
  20,  30, 1, 'q', "5d8"   , "15 2 1d6|1 3 1d3|1 3 1d3"       ,   16},
{"Troll"                    ,0x07020002,0x00000000,0x2026,  400,   64,
  20,  40, 1, 'T', "17d8"  , "1 1 1d4|1 1 1d4|1 2 1d6"        ,   17},
{"Water Spirit"             ,0x0000000A,0x00000000,0x0020,  400,   58,
  12,  28, 2, 'E', "8d8"   , "1 1 2d4"                        ,   17},
{"Giant Brown Scorpion"     ,0x0000000A,0x00000000,0x0002,  200,   62,
  14,  44, 1, 'S', "11d8"  , "1 2 2d4|2 4 1d7"                ,   17},
{"Earth Spirit"             ,0x0000000A,0x00000000,0x0200,  500,   64,
  10,  40, 1, 'E', "13d8"  , "1 1 1d8|1 1 1d8"                ,   17},
{"Fire Spirit"              ,0x00000002,0x00000000,0x2010,  200,   66,
  20,  30, 2, 'E', "10d8"  , "5 1 2d6"                        ,   18},
{"Urik-Hai Orc"             ,0x0B020002,0x00000000,0x2036,  200,   68,
  20,  42, 1, 'o', "14d8"  , "1 1 3d5"                        ,   18},
{"Stone Giant"              ,0x07020002,0x00000000,0x2204,  500,   80,
  20,  40, 1, 'P', "22d8"  , "1 1 3d8"                        ,   18},
{"Stone Golem"              ,0x00020002,0x00000000,0x1200,  100,  100,
  12,  75, 0, 'g', "28d8"  , "1 1 1d10|1 1 1d10"              ,   19},
{"Grey Ooze"                ,0x071A0022,0x00000000,0x00A2,    1,   40,
  15,  10, 1, 'O', "6d8"   , "7 5 2d6"                        ,   19},
{"Disenchanter Ooze"        ,0x071A0022,0x00000000,0x00A2,    1,   50,
  15,  15, 1, 'O', "6d8"   , "21 5 0d0"                       ,   19},
{"Giant Spotted Rat"        ,0x0020000A,0x00000000,0x2070,  200,    3,
   8,  20, 1, 'r', "4d3"   , "14 2 1d5"                       ,   19},
{"Mummified Kobold"         ,0x0B020002,0x00000000,0x102C,  750,   46,
  20,  24, 1, 'M', "13d8"  , "1 1 1d6|1 1 1d6"                ,   19},
{"Killer Black Beetle"      ,0x0000000A,0x00000000,0x0002,  300,   75,
  14,  46, 1, 'K', "18d8"  , "1 2 4d5"                        ,   19},
{"Red Mold"                 ,0x0B000001,0x00000000,0x30A0,  700,   64,
   2,  16, 1, 'm', "17d8"  , "5 5 4d4"                        ,   19},
{"Quylthulg"                ,0x00010000,0x00002017,0x5000,    0,  200,
  10,   1, 1, 'Q', "4d8"   , "0 0 0d0"                        ,   20},
{"Giant Red Bat"            ,0x0000000A,0x00000000,0x2060,  200,   40,
  12,  24, 2, 'b', "5d8"   , "1 2 1d7|1 3 1d3|1 3 1d3"        ,   20},
{"Giant Black Dragon Fly"   ,0x00000012,0x00200009,0x0072,  500,   58,
  20,  22, 1, 'F', "4d8"   , "10 2 1d6"                       ,   20},
{"Cloud Giant"              ,0x07020002,0x00000000,0x2134,  500,  125,
  20,  44, 1, 'P', "24d8"  , "8 1 3d8"                        ,   20},
{"Black Dragon Bat"         ,0x00000012,0x00200004,0x2150,  500,   50,
  12,  24, 3, 'b', "2d8"   , "6 2 1d3"                        ,   21},
{"Blue Dragon Bat"          ,0x00000012,0x00080004,0x2150,  500,   54,
  12,  26, 3, 'b', "3d6"   , "8 2 1d3"                        ,   21},
{"Mummified Orc"            ,0x0B020002,0x00000000,0x102C,  750,   56,
  20,  28, 1, 'M', "14d8"  , "1 1 2d4|1 1 2d4"                ,   21},
{"Killer Boring Beetle"     ,0x00000002,0x00000000,0x0002,  300,   70,
  12,  48, 1, 'K', "18d8"  , "1 2 4d5"                        ,   21},
{"Killer Stag Beetle"       ,0x0000000A,0x00000000,0x0002,  300,   80,
  12,  50, 1, 'K', "20d8"  , "1 2 3d4|1 1 1d12"               ,   22},
{"Black Mold"               ,0x0B000081,0x00000000,0x10A0,  500,   68,
   2,  18, 1, 'm', "15d8"  , "1 1 4d3"                        ,   22},
{"Iron Golem"               ,0x00020002,0x00000000,0x1080,  100,  160,
  12,  99,-1, 'g', "80d8"  , "1 1 1d12|1 1 1d12"              ,   22},
{"Giant Yellow Scorpion"    ,0x0000000A,0x00000000,0x0002,  200,   60,
  12,  38, 1, 'S', "12d8"  , "1 2 1d8|14 4 2d5"               ,   22},
{"Green Ooze"               ,0x00200001,0x00000000,0x00B2,    1,    6,
  15,   5, 0, 'O', "4d8"   , "6 5 2d3"                        ,   22},
{"Black Ooze"               ,0x003A0012,0x0001000B,0x0192,    1,    7,
  10,   6,-1, 'O', "6d8"   , "9 5 2d6"                        ,   23},
{"Warrior"                  ,0x13120002,0x00000000,0x2030,  400,   60,
  20,  40, 1, 'p', "15d8"  , "1 1 3d5"                        ,   23},
{"Red Dragon Bat"           ,0x00000012,0x00800004,0x2150,  500,   60,
  12,  28, 3, 'b', "3d8"   , "5 2 1d3"                        ,   23},
{"Killer Blue Beetle"       ,0x0000000A,0x00000000,0x0002,  300,   85,
  15,  50, 1, 'K', "20d8"  , "1 2 4d5"                        ,   23},
{"Giant Silver Ant"         ,0x0000000A,0x00000000,0x0002,  600,   45,
  15,  38, 1, 'a', "6d8"   , "6 2 4d4"                        ,   23},
{"Crimson Mold"             ,0x0B000001,0x00000000,0x10A0,  500,   65,
   2,  18, 1, 'm', "16d8"  , "1 1 1d3|4 5 0d0"                ,   23},
{"Forest Wight"             ,0x0F00000A,0x0000100F,0x112E,  300,  140,
  20,  30, 1, 'W', "12d8"  , "1 1 1d6|1 1 1d6|19 5 12d8"      ,   24},
{"Berzerker"                ,0x07020002,0x00000000,0x2030,  100,   65,
  20,  20, 1, 'p', "15d8"  , "1 1 1d8|1 1 1d8"                ,   24},
{"Mummified Human"          ,0x0B020002,0x00000000,0x102C,  600,   70,
  20,  34, 1, 'M', "17d8"  , "1 1 2d4|1 1 2d4"                ,   24},
{"Banshee"                  ,0x0F15001A,0x0001002F,0x100C,  100,   60,
  20,  24, 2, 'G', "6d8"   , "4 10 0d0|19 5 14d8"             ,   24},
{"Giant Troll"              ,0x0F020002,0x00000000,0x2026,  500,   85,
  20,  40, 1, 'T', "19d8"  , "1 1 1d6|1 1 1d6|1 2 3d4"        ,   25},
{"Giant Brown Tick"         ,0x00000012,0x00000000,0x0022,  200,   70,
  12,  50, 0, 't', "18d8"  , "14 2 1d10|10 4 1d1"             ,   25},
{"Killer Red Beetle"        ,0x00000012,0x00000000,0x0002,  300,   85,
  15,  50, 1, 'K', "20d8"  , "2 2 4d4"                        ,   25},
{"Wooden Mold"              ,0x00000001,0x00000000,0x10A0,  999,  100,
   2,  50, 1, 'm', "25d8"  , "14 8 2d6"                       ,   25},
{"Giant Blue Dragon Fly"    ,0x00000012,0x00080009,0x0030,  500,   75,
  20,  24, 1, 'F', "6d8"   , "1 2 1d6"                        ,   25},
{"Giant Grey Ant Lion"      ,0x0008000A,0x00000000,0x0032,  400,   90,
  10,  40, 1, 'A', "19d8"  , "1 2 2d12"                       ,   26},
{"Disenchanter Bat"         ,0x00000012,0x00000000,0x2060,    1,   75,
  14,  24, 3, 'b', "4d8"   , "21 1 0d0"                       ,   26},
{"Giant Fire Tick"          ,0x0000000A,0x00000000,0x2012,  200,   90,
  14,  54, 1, 't', "16d8"  , "5 9 3d7"                        ,   26},
{"White Wraith"             ,0x0F02000A,0x00000000,0x112E,  100,  165,
  20,  40, 1, 'W', "15d8"  , "1 1 1d6|1 1 1d6|19 5 15d8"      ,   26},
{"Giant Black Scorpion"     ,0x00000002,0x00000000,0x0002,  200,   85,
  12,  50, 1, 'S', "13d8"  , "1 2 1d10|14 4 2d5"              ,   26},
{"Clear Ooze"               ,0x000B000A,0x00000000,0x00B2,    1,   12,
  10,  14, 1, 'O', "4d8"   , "3 5 1d8"                        ,   26},
{"Killer Fire Beetle"       ,0x00000012,0x00000000,0x2012,  300,   95,
  14,  45, 1, 'K', "13d8"  , "1 2 3d4|5 9 4d5"                ,   27},
{"Vampire"                  ,0x17000002,0x00001209,0x112E,  100,  175,
  20,  45, 1, 'V', "20d8"  , "1 1 1d6|1 1 1d6|19 5 18d8"      ,   27},
{"Giant Red Dragon Fly"     ,0x00000012,0x00800008,0x2050,  500,   75,
  20,  24, 1, 'F', "7d8"   , "4 2 1d6"                        ,   27},
{"Shimmering Mold"          ,0x0B000081,0x00000000,0x10A0,  100,  180,
   2,  24, 1, 'm', "32d8"  , "8 5 5d4"                        ,   27},
{"Black Knight"             ,0x17020002,0x0000010F,0x2030,  100,  140,
  20,  60, 1, 'p', "25d8"  , "1 1 5d5"                        ,   28},
{"Mage"                     ,0x13020002,0x00002C73,0x2030,  100,  150,
  20,  30, 1, 'p', "10d8"  , "1 1 2d5"                        ,   28},
{"Ice Troll"                ,0x0F020002,0x00000000,0x0026,  500,  160,
  20,  46, 1, 'T', "22d8"  , "1 1 1d5|1 1 1d5|7 2 3d6"        ,   28},
{"Giant Purple Worm"        ,0x0000000A,0x00000000,0x2030,  300,  400,
  14,  65, 1, 'w', "65d8"  , "1 1 1d8|6 2 2d8|14 4 1d8"       ,   29},
{"Young Blue Dragon"        ,0x1F00000A,0x0008100B,0x2005,  700,  300,
  20,  50, 1, 'd', "33d8"  , "1 3 1d4|1 3 1d4|1 2 1d6"        ,   29},
{"Young White Dragon"       ,0x1F00000A,0x0040100B,0x2005,  700,  275,
  20,  50, 1, 'd', "32d8"  , "1 3 1d4|1 3 1d4|1 2 1d6"        ,   29},
{"Young Green Dragon"       ,0x1F00000A,0x0010100B,0x2005,  700,  290,
  20,  50, 1, 'd', "32d8"  , "1 3 1d4|1 3 1d4|1 2 1d6"        ,   29},
{"Giant Fire Bat"           ,0x00000012,0x00000000,0x2050,  100,   85,
  14,  30, 2, 'b', "5d8"   , "5 2 3d6|1 3 1d4|1 3 1d4"        ,   29},
{"Giant Glowing Rat"        ,0x0020000A,0x00000000,0x2070,  200,    4,
   8,  24, 1, 'r', "3d3"   , "8 2 2d6"                        ,   29},
	/* Now things are going to get tough...                  */
	/* Some of the creatures have Max hit points, denoted in */
	/* their CDEFENSE flags as the '4000' bit set            */
{"Skeleton Troll"           ,0x00020002,0x00000000,0x500C,  400,  225,
  20,  55, 1, 's', "14d8"  , "1 1 1d6|1 1 1d6|1 2 3d4"        ,   30},
{"Giant Lightning Bat"      ,0x0000000A,0x00000000,0x2042,  100,   80,
  15,  34, 2, 'b', "8d8"   , "8 2 3d8|1 3 1d5|1 3 1d5"        ,   30},
{"Giant Static Ant"         ,0x0000000A,0x00000000,0x0002,  600,   80,
  10,  40, 1, 'a', "8d8"   , "8 2 5d5"                        ,   30},
{"Grave Wight"              ,0x0F02000A,0x0000190A,0x512E,  300,  325,
  20,  35, 1, 'W', "12d8"  , "1 1 1d7|1 1 1d7|19 5 20d8"      ,   30},
{"Killer Slicer Beetle"     ,0x0000000A,0x00000000,0x0012,  300,  200,
  14,  55, 1, 'K', "22d8"  , "1 2 5d8"                        ,   30},
{"Giant White Ant Lion"     ,0x0008000A,0x00000000,0x0022,  400,  175,
  12,  45, 1, 'A', "20d8"  , "7 2 3d10"                       ,   30},
{"Ghost"                    ,0x1715000A,0x0001002F,0x500C,  100,  350,
  20,  30, 2, 'G', "13d8"  , "4 7 0d0|19 5 22d8|17 3 1d10"    ,   31},
{"Giant Black Ant Lion"     ,0x0008000A,0x00000000,0x0032,  400,  170,
  14,  45, 1, 'A', "23d8"  , "1 2 2d12|6 9 3d6"               ,   31},
{"Death Watch Beetle"       ,0x0000000A,0x00000000,0x0012,  300,  190,
  16,  60, 1, 'K', "25d8"  , "1 2 5d4|1 10 5d6"               ,   31},
{"Ogre Magi"                ,0x07020002,0x0000A356,0x403C,  300,  250,
  20,  42, 1, 'o', "14d8"  , "1 1 3d6"                        ,   31},
{"Crystal Ooze"             ,0x07390009,0x00000000,0x0092,  600,    8,
   5,  30,-1, 'O', "12d8"  , "7 5 4d4"                        ,   31},
{"Two-Headed Troll"         ,0x0F020002,0x00000000,0x6026,  500,  275,
  20,  48, 1, 'T', "14d8"  , "1 1 1d8|1 1 1d8|1 2 1d6|1 2 1d6",   32},
{"Invisible Stalker"        ,0x00030022,0x00000000,0x0000,  200,  200,
  20,  46, 3, 'E', "19d8"  , "1 1 1d6"                        ,   32},
{"Giant Hunter Ant"         ,0x00000002,0x00000000,0x0002,   10,  150,
  16,  40, 1, 'a', "12d8"   , "1 2 4d8"                        ,   32},
{"Ninja"                    ,0x0F020002,0x00000000,0x6030,  100,  300,
  20,  65, 1, 'p', "15d8"  , "14 1 3d4|2 1 3d4"               ,   32},
{"Barrow Wight"             ,0x0F02000A,0x00001308,0x512E,  100,  375,
  20,  40, 1, 'W', "13d8"  , "1 1 1d8|1 1 1d8|19 5 26d8"      ,   33},
{"Skeleton 2-Headed Troll"  ,0x00020002,0x00000000,0x500C,  200,  325,
  20,  48, 1, 's', "20d8"  , "1 1 1d9|1 1 1d9|1 2 1d5|1 2 1d5",   33},
{"Water Elemental"          ,0x0000000A,0x00000000,0x0020,  500,  325,
  12,  36, 1, 'E', "25d8"  , "1 1 1d10|1 1 1d10"              ,   33},
{"Fire Elemental"           ,0x000A0012,0x00000000,0x2010,  700,  350,
  16,  40, 0, 'E', "25d8"  , "5 1 4d6"                        ,   33},
{"Lich"                     ,0x1F020002,0x00019F75,0x500C,  600,  750,
  20,  50, 1, 'L', "25d8"  , "15 5 2d8|19 5 30d8|24 5 0d0"    ,   34},
{"Master Vampire"           ,0x17000002,0x00001307,0x512E,  100,  700,
  20,  55, 1, 'V', "23d8"  , "1 1 1d6|1 1 1d6|19 5 32d8"      ,   34},
{"Spirit Troll"             ,0x00040002,0x00000000,0x402E,  100,  425,
  20,  56, 1, 'T', "15d8"  , "1 3 1d5|1 3 1d5|1 2 1d6"        ,   34},
{"Giant Red Scorpion"       ,0x0000000A,0x00000000,0x0002,  400,  275,
  12,  50, 2, 'S', "18d8"  , "1 2 1d6|14 4 1d4"               ,   34},
{"Earth Elemental"          ,0x001A0002,0x00000000,0x0200,  900,  375,
  10,  60, 0, 'E', "30d8"  , "1 1 4d6|1 1 4d6"                ,   34},
{"Young Black Dragon"       ,0x1F00000A,0x0020100B,0x6005,  500,  600,
  20,  55, 1, 'd', "32d8"  , "1 3 1d5|1 3 1d5|1 2 1d6"        ,   35},
{"Young Red Dragon"         ,0x1F00000A,0x0080100A,0x6015,  500,  650,
  20,  60, 1, 'd', "36d8"  , "1 3 1d8|1 3 1d8|1 2 2d8"        ,   35},
{"Necromancer"              ,0x13020002,0x00005762,0x6030,  100,  600,
  20,  40, 1, 'p', "17d8"  , "1 1 2d6"                        ,   35},
{"Mummified Troll"          ,0x0F020002,0x00000000,0x502C,  500,  400,
  20,  38, 1, 'M', "18d8"  , "1 1 2d6|1 1 2d6"                ,   35},
{"Giant Red Ant Lion"       ,0x00080009,0x00000000,0x0032,  400,  350,
  14,  48, 1, 'A', "23d8"  , "5 2 3d12"                       ,   35},
{"Mature White Dragon"      ,0x2F00000A,0x0040100A,0x4005,  700, 1000,
  20,  65, 1, 'd', "48d8"  , "1 3 1d8|1 3 1d8|1 2 2d8"        ,   35},
{"Xorn"                     ,0x00160002,0x00000000,0x4200,  100,  650,
  20,  80, 1, 'X', "20d8"  , "1 1 1d6|1 1 1d6|1 1 1d6"        ,   36},
{"Giant Mottled Ant Lion"   ,0x0008000A,0x00000000,0x0032,  400,  350,
  14,  50, 2, 'A', "24d8 " , "1 2 2d10"                       ,   36},
{"Grey Wraith"              ,0x0F02000A,0x00011308,0x512E,  100,  700,
  20,  50, 1, 'W', "23d8"  , "1 1 1d10|1 1 1d10|19 5 34d8"    ,   36},
{"Young Multi-Hued Dragon"  ,0x7F00000A,0x00F81005,0x6005,  500, 1250,
  20,  55, 1, 'd', "40d8"  , "1 3 1d9|1 3 1d9|1 2 2d10"       ,   36},
{"Mature Blue Dragon"       ,0x2F00000A,0x00081009,0x6005,  400, 1200,
  20,  75, 1, 'd', "48d8"  , "1 3 1d8|1 3 1d8|1 2 2d10"       ,   36},
{"Mature Green Dragon"      ,0x1F00000A,0x0010100A,0x6005,  700, 1100,
  20,  70, 1, 'd', "48d8"  , "1 3 1d4|1 3 1d4|1 2 1d6"        ,   36},
{"Iridescent Beetle"        ,0x0000000A,0x00000000,0x0012,  300,  850,
  16,  60, 1, 'K', "32d8"  , "1 2 4d6|1 1 1d12|11 7 0d0"      ,   37},
{"King Vampire"             ,0x17000002,0x00001307,0x512E,  100, 1000,
  20,  65, 1, 'V', "38d8"  , "1 1 1d6|1 1 1d6|19 5 38d8"      ,   37},
{"King Lich"                ,0x1F020002,0x00019F73,0x500C,  500, 1400,
  20,  65, 1, 'L', "52d8"  , "15 5 2d10|19 5 36d8|24 5 0d0"   ,   37},
{"Mature Red Dragon"        ,0x2F00000A,0x00801808,0x6015,  300, 1400,
  20,  80, 1, 'd', "60d8"  , "1 3 1d10|1 3 1d10|1 2 2d12"     ,   37},
{"Mature Black Dragon"      ,0x2F00000A,0x00201009,0x6005,  700, 1350,
  20,  55, 1, 'd', "58d8"  , "1 3 1d8|1 3 1d8|1 2 2d10"       ,   37},
{"Mature Multi-Hued Dragon" ,0x7F00000A,0x00F81A05,0x6005,  500, 1650,
  20,  65, 1, 'd', "80d8"  , "1 3 1d10|1 3 1d10|1 2 2d12"     ,   38},
{"Ancient White Dragon"     ,0x4F000002,0x00401A08,0x4005,  800, 1500,
  20,  80, 2, 'D', "88d8"  , "1 3 1d8|1 3 1d8|1 2 2d8"        ,   38},
{"Emperor Wight"            ,0x1B02000A,0x00001306,0x512E,  100, 1600,
  20,  40, 2, 'W', "48d8"  , "1 1 1d12|1 1 1d12|19 5 42d8"    ,   38},
{"Black Wraith"             ,0x1F02000A,0x00001307,0x512E,  100, 1700,
  20,  55, 1, 'W', "50d8"  , "1 1 1d12|1 1 1d12|19 5 44d8"    ,   38},
{"Nether Wraith"            ,0x1F07000A,0x00005316,0x512E,  100, 2100,
  20,  55, 1, 'W', "58d8"  , "1 1 1d12|1 1 1d12|19 5 52d8"    ,   39},
{"Sorcerer"                 ,0x13020002,0x0000FF73,0x6030,  100, 2150,
  20,  50, 2, 'p', "30d8"  , "1 1 2d8"                        ,   39},
{"Ancient Blue Dragon"      ,0x4F000002,0x00081A08,0x6005,  800, 2500,
  20,  90, 2, 'D', "87d8"  , "1 3 1d9|1 3 1d9|1 2 2d12"       ,   39},
{"Ancient Green Dragon"     ,0x4F000002,0x00101A09,0x6005,  700, 2400,
  20,  85, 2, 'D', "90d8"  , "1 3 1d8|1 3 1d8|1 2 2d10"       ,   39},
{"Ancient Black Dragon"     ,0x4F000002,0x00201A07,0x6005,  700, 2500,
  20,  90, 2, 'D', "90d8"  , "1 3 1d9|1 3 1d9|1 2 2d10"       ,   39},
{"Disenchanter Worm"        ,0x00200022,0x00000000,0x01B0,  100,   30,
   5,   5, 0, 'w', "10d8"  , "21 12 1d4"                      ,   40},
{"Rotting Quylthulg"        ,0x00010000,0x00004014,0x5000,    0, 1000,
  20,   1, 2, 'Q', "12d8"  , "0 0 0d0"                        ,   40},
{"Ancient Red Dragon"       ,0x7F000002,0x00801E06,0x6015,  500, 2750,
  20, 100, 2, 'D', "105d8" , "1 3 1d10|1 3 1d10|1 2 2d14"     ,   40},
{"Death Quasit"             ,0x1103000A,0x000010FA,0x0004,    0, 1000,
  20,  80, 3, 'q', "55d8"  , "15 2 3d6|1 3 3d3|1 3 3d3"       ,   40},
{"Emperor Lich"             ,0x2F020002,0x00019F72,0x500C,  500,10000,
  20,  75, 2, 'L', "190d8" , "15 5 2d12|19 5 46d8|24 5 0d0"   ,   40},
{"Ancient Multi-Hued Dragon",0x7F000002,0x00F89E05,0x6005,  500,12000,
  20, 100, 2, 'D', "260d8" , "1 3 1d12|1 3 1d12|1 2 3d12"     ,   40},
	/* Winning creatures should follow here.                         */
	/* Winning creatures are denoted by the 32 bit in CMOVE          */
	/* Iggy is not a win creature, just a royal pain in the ass...   */
{"Evil Iggy"                ,0x7F130002,0x0001D713,0x5004,    0,18000,
  20,  80, 2, 'p', "300d8" , "2 1 4d6|13 19 0d0"               ,   50},
	/* Here is the only actual win creature...                       */
{"Balrog"                   ,0xFF1F0002,0x0081C743,0x5004,    0,55000,
  20, 125, 3, 'B', "375d8" , "5 1 10d12|1 17 8d12|24 5 0d0"    ,  100}
};

monster_type m_list[MAX_MALLOC];
int m_level[MAX_MONS_LEVEL+1];
/* Blank monster values	*/
monster_type blank_monster = {0,0,0,0,0,0,0,0,0,FALSE,FALSE};	
int muptr;	                /* Cur used monster ptr	*/
int mfptr;	                /* Cur free monster ptr	*/
int mon_tot_mult;	        /* # of repro's of creature	*/

