/* source/player.c: player specific variable definitions

   Copyright (c) 1989-92 James E. Wilson, Robert A. Koeneke

   This software may be copied and distributed for educational, research, and
   not for profit purposes provided that this copyright and statement are
   included in all such copies. */

#include "config.h"
#include "constant.h"
#include "types.h"

/* Player record for most player related info */
player_type py;
/* player location in dungeon */
int16 char_row;
int16 char_col;
/* calculated base hp values for player at each level, store them so that
   drain life + restore life does not affect hit points */
int16u player_hp[MAX_PLAYER_LEVEL];

/* Class titles for different levels				*/
#ifdef MACGAME
char *(*player_title)[MAX_PLAYER_LEVEL];
#else
char *player_title[MAX_CLASS][MAX_PLAYER_LEVEL] = {
	/* Warrior	 */
{"Rookie","Private","Soldier","Mercenary","Veteran(1st)","Veteran(2nd)",
"Veteran(3rd)","Warrior(1st)","Warrior(2nd)","Warrior(3rd)","Warrior(4th)",
"Swordsman-1","Swordsman-2","Swordsman-3","Hero","Swashbuckler","Myrmidon",
"Champion-1","Champion-2","Champion-3","Superhero","Knight","Superior Knt",
"Gallant Knt","Knt Errant","Guardian Knt","Baron","Duke","Lord (1st)",
"Lord (2nd)","Lord (3rd)","Lord (4th)","Lord (5th)","Lord (6th)","Lord (7th)",
"Lord (8th)","Lord (9th)","Lord Gallant","Lord Keeper","Lord Noble"},
	/* Mage		 */
{"Novice","Apprentice","Trickster-1","Trickster-2","Trickster-3","Cabalist-1",
"Cabalist-2","Cabalist-3","Visionist","Phantasmist","Shadowist","Spellbinder",
"Illusionist","Evoker (1st)","Evoker (2nd)","Evoker (3rd)","Evoker (4th)",
"Conjurer","Theurgist","Thaumaturge","Magician","Enchanter","Warlock",
"Sorcerer","Necromancer","Mage (1st)","Mage (2nd)","Mage (3rd)","Mage (4th)",
"Mage (5th)","Wizard (1st)","Wizard (2nd)","Wizard (3rd)","Wizard (4th)",
"Wizard (5th)","Wizard (6th)","Wizard (7th)","Wizard (8th)","Wizard (9th)",
"Wizard Lord"},
	/* Priests	 */
{"Believer","Acolyte(1st)","Acolyte(2nd)","Acolyte(3rd)","Adept (1st)",
"Adept (2nd)","Adept (3rd)","Priest (1st)","Priest (2nd)","Priest (3rd)",
"Priest (4th)","Priest (5th)","Priest (6th)","Priest (7th)","Priest (8th)",
"Priest (9th)","Curate (1st)","Curate (2nd)","Curate (3rd)","Curate (4th)",
"Curate (5th)","Curate (6th)","Curate (7th)","Curate (8th)","Curate (9th)",
"Canon (1st)","Canon (2nd)","Canon (3rd)","Canon (4th)","Canon (5th)",
"Low Lama","Lama-1","Lama-2","Lama-3","High Lama","Great Lama","Patriarch",
"High Priest","Great Priest","Noble Priest"},
	/* Rogues	 */
{"Vagabond","Footpad","Cutpurse","Robber","Burglar","Filcher","Sharper",
"Magsman","Common Rogue","Rogue (1st)","Rogue (2nd)","Rogue (3rd)",
"Rogue (4th)","Rogue (5th)","Rogue (6th)","Rogue (7th)","Rogue (8th)",
"Rogue (9th)","Master Rogue","Expert Rogue","Senior Rogue","Chief Rogue",
"Prime Rogue","Low Thief","Thief (1st)","Thief (2nd)","Thief (3rd)",
"Thief (4th)","Thief (5th)","Thief (6th)","Thief (7th)","Thief (8th)",
"Thief (9th)","High Thief","Master Thief","Executioner","Low Assassin",
"Assassin","High Assassin","Guildsmaster"},
	/* Rangers	 */
{"Runner (1st)","Runner (2nd)","Runner (3rd)","Strider (1st)","Strider (2nd)",
"Strider (3rd)","Scout (1st)","Scout (2nd)","Scout (3rd)","Scout (4th)",
"Scout (5th)","Courser (1st)","Courser (2nd)","Courser (3rd)","Courser (4th)",
"Courser (5th)","Tracker (1st)","Tracker (2nd)","Tracker (3rd)",
"Tracker (4th)","Tracker (5th)","Tracker (6th)","Tracker (7th)",
"Tracker (8th)","Tracker (9th)","Guide (1st)","Guide (2nd)","Guide (3rd)",
"Guide (4th)","Guide (5th)","Guide (6th)","Guide (7th)","Guide (8th)",
"Guide (9th)","Pathfinder-1","Pathfinder-2","Pathfinder-3","Ranger",
"High Ranger","Ranger Lord"},
	/* Paladins	 */
{"Gallant","Keeper (1st)","Keeper (2nd)","Keeper (3rd)","Keeper (4th)",
"Keeper (5th)","Keeper (6th)","Keeper (7th)","Keeper (8th)","Keeper (9th)",
"Protector-1","Protector-2","Protector-3","Protector-4","Protector-5",
"Protector-6","Protector-7","Protector-8","Defender-1","Defender-2",
"Defender-3","Defender-4","Defender-5","Defender-6","Defender-7","Defender-8",
"Warder (1st)","Warder (2nd)","Warder (3rd)","Warder (4th)","Warder (5th)",
"Warder (6th)","Warder (7th)","Warder (8th)","Warder (9th)","Guardian",
"Chevalier","Justiciar","Paladin","High Lord"},
        /* Merchants */
{"Loner","Searcher-1","Searcher-2","Searcher-3","Searcher-4",
 "Searcher-5","Searcher-6","Searcher-7","Searcher-8","Searcher-9",
 "Sailor (1st)","Sailor (2nd)","Sailor (3rd)","Sailor (4th)","Sailor (5th)",
 "Sailor (6th)","Sailor (7th)","Sailor (8th)","Sailor (9th)","Seaman",
 "Trader (1st)","Trader (2nd)","Trader (3rd)","Trader (4th)","Trader (5th)",
 "Trader (6th)","Trader (7th)","Trader (8th)","Trader (9th)","Master Trader",
 "Merchant-1","Merchant-2","Merchant-3","Merchant-4","Merchant-5",
 "Merchant-6","Merchant-7","Merchant-8","Merchant-9","Shopkeeper"
},
       /* Sages    */
{"Neophyte","Learner-1","Learner-2","Learner-3","Learner-4",
 "Learner-5","Learner-6","Learner-7","Learner-8","Learner-9",
 "Explorer-1","Explorer-2","Explorer-3","Explorer-4","Explorer-5",
 "Explorer-6","Explorer-7","Explorer-8","Explorer-9","Sage (1st)",
 "Sage (2nd)","Sage (3rd)","Sage (4th)","Sage (5th)","Sage (6th)",
 "Sage (7th)","Sage (8th)","Sage (9th)","High Sage","Wise One",
 "Visionary-1","Visionary-2","Visionary-3","Visionary-4","Visionary-5",
 "Visionary-6","Visionary-7","Visionary-8","Visionary-9","Enlightened"
},
      /* Jesters  */
{"Serf","Stooge (1st)","Stooge (2nd)","Stooge (3rd)","Stooge (4th)",
 "Stooge (5th)","Stooge (6th)","Stooge (7th)","Stooge (8th)","Stooge (9th)",
 "Performer-1","Performer-2","Performer-3","Performer-4","Performer-5",
 "Performer-6","Performer-7","Performer-8","Performer-9","Bard (1st)",
 "Bard (2nd)","Bard (3rd)","Bard (4th)","Bard (5th)","Bard (6th)",
 "Bard (7th)","Bard (8th)","Bard (9th)","Cad (1st)","Cad (2nd)",
 "Cad (3rd)","Cad (4th)","Cad (5th)","Cad (6th)","Cad (7th)",
 "Cad (8th)","Cad (9th)","Low Jester","Jester","High Jester"
},
      /* Ninjas  */
{"Sapling","Student (1st)","Student (2nd)","Student (3rd)","Student (4th)",
 "Student (5th)","Student (6th)","Student (7th)","Student (8th)","Student (9th)",
 "Trainee-1","Trainee-2","Trainee-3","Trainee-4","Trainee-5",
 "Trainee-6","Trainee-7","Trainee-8","Trainee-9","Journeyer",
 "Questor-1","Questor-2","Questor-3","Questor-4","Questor-5",
 "Questor-6","Questor-7","Questor-8","Questor-9","Low Ninja",
 "Ninja (1st)","Ninja (2nd)","Ninja (3rd)","Ninja (4th)","Ninja (5th)",
 "Ninja (6th)","Ninja (7th)","Ninja (8th)","Ninja (9th)","Ninja Lord"
 },
     /* Healers */
{"Charlatan","Student-1","Student-2","Student-3","Student-4",
 "Student-5","Student-6","Student-7","Student-8","Student-9",
 "Intern-1","Intern-2","Intern-3","Intern-4","Intern-5",
 "Intern-6","Intern-7","Intern-8","Intern-9","Healer (1st)",
 "Healer (2nd)","Healer (3rd)","Healer (4th)","Healer (5th)","Healer (6th)",
 "Healer (7th)","Healer (8th)","Healer (9th)","Doctor (1st)","Doctor (2nd)",
 "Doctor (3rd)","Doctor (4th)","Doctor (5th)","Doctor (6th)","Doctor (7th)",
 "Doctor (8th)","Doctor (9th)","Surgeon","Specialist","Practitioner"
 },
	/* Wizards */
{"Novice","Apprentice","Trickster-1","Trickster-2","Trickster-3","Cabalist-1",
"Cabalist-2","Cabalist-3","Visionist","Phantasmist","Shadowist","Spellbinder",
"Illusionist","Evoker (1st)","Evoker (2nd)","Evoker (3rd)","Evoker (4th)",
"Conjurer","Theurgist","Thaumaturge","Magician","Enchanter","Warlock",
"Sorcerer","Necromancer","Mage (1st)","Mage (2nd)","Mage (3rd)","Mage (4th)",
"Mage (5th)","Wizard (1st)","Wizard (2nd)","Wizard (3rd)","Wizard (4th)",
"Wizard (5th)","Wizard (6th)","Wizard (7th)","Wizard (8th)","Wizard (9th)",
"Wizard Lord"},
        /* Monks */
{"Believer","Pupil (1st)","Pupil (2nd)","Pupil (3rd)","Pupil (4th)",
 "Pupil (5th)","Pupil (6th)","Pupil (7th)","Pupil (8th)","Pupil (9th)",
 "Pupil (10th)","Roamer-1","Roamer-2","Roamer-3","Roamer-4",
 "Roamer-5","Roamer-6","Roamer-7","Roamer-8","Roamer-9",
 "Roamer-10","Minor Monk","Monk (1st)","Monk (2nd)","Monk (3rd)",
 "Monk (4th)","Monk (5th)","Monk (6th)","Monk (7th)","Monk (8th)", 
 "Monk (9th)","Monk (10th)","High Monk","Sensai (1st)","Sensai (2nd)",
 "Sensai (3rd)","Sensai (4th)","Sensai (5th)","Insightor","Enlightened"}
};
#endif

/* Base experience levels, may be adjusted up for race and/or class*/
int32u player_exp[MAX_PLAYER_LEVEL] = {
      10,      25,	45,	 70,	  100,	    140,      200,	280,
     380,     500,     650,	850,	 1100,	   1400,     1800,     2300,
    2900,    3600,    4400,    5400,	 6800,	   8400,    10200,    12500,
   17500,   25000,  35000L,  50000L,   75000L,	100000L,  150000L,  200000L,
 300000L, 400000L, 500000L, 750000L, 1500000L, 2500000L, 5000000L, 10000000L
};

/*Race	STR,INT,WIS,DEX,CON,CHR,
	Ages, heights, and weights (male then female)
	Racial Bases for: dis,srh,stl,fos,bth,bthb,bsav,hitdie,
	infra, exp base, choice-classes */
#ifdef MACGAME
race_type *race;
#else

/* Note:  Race descriptor text starts at ((race-1)*3)+1 in the array */

race_type race[MAX_RACES] = {
   {"Human",	 0,  0,	 0,  0,	 0,  0,
      14,  6, 72,  6,180, 25, 66,  4,150, 20,
      0,  0,  0,  0,  0,  0,  0, 10,  0, 100, 0x1FFF,   0,
      0,  0,  0,  0,  0
    },
   {"Half-Elf", -1,  1,	 0,  1, -1,  1,
      24, 16, 66,  6,130, 15, 62,  6,100, 10,
      2,  6,  1, -1, -1,  5,  3,  9,  2, 110, 0x1FFF,   1,
      0,  0,  0,  0,  0
    },
   {"Elf",	-1,  2,	 1,  1, -2,  1,
      75, 75, 60,  4,100,  6, 54,  4, 80,  6,
      5,  8,  1, -2, -5, 15,  6,  8,  3, 120, 0x15CF,   2,
      0,  0,  0,  0,  0
    },
   {"Halfling", -3,  2,	 1,  3,	 1,  1,
      21, 12, 36,  3, 60,  3, 33,  3, 50,  3,
      15, 12, 4, -6,-10, 20,  8,  6,  4, 110, 0x07CB,  3,
      0,  0,  0,  0,  0
    },
   {"Spectre",  -5,  4,  2,  2,  3, -5,
     255,200,80, 20,40,10, 75, 15, 30, 10,
      6, 20,   7, 20,-10,-10,20,  4,  7, 110, 0x088D, 20,
     20, 20, 20, 20, 20
    }, 
   {"Dwarf",	 2, -3,	 1, -2,	 2, -3,
      35, 15, 48,  3,150, 10, 46,  3,120, 10,
      2,  7,  -1,  0, 15,  0, 9,  9,  5, 120, 0x00C5,  0,
     -5,  5,  0, -5,  5
    },
   {"Half-Orc",	 2, -1,	 0,  0,	 1, -4,
      11,  4, 66,  1,150,  5, 62,  1,120,  5,
      -3,  0, -1,  3, 12, -5, -3, 10,  3, 110, 0x01CD,  0,
     -5,  5,  0,-5,  5
    },
   {"Half-Troll",4, -4, -2, -4,	 3, -6,
      20, 10, 96, 10,255, 50, 84,  8,225, 40,
      -5, -1, -2,  5, 24,-10, -8, 15,  3, 120, 0x0145,  0,
     -20, 20,  0,-20, 20
    },
   {"Avion",     1,  2, -5,  1,  1,  0,
      40, 15,120, 15,90, 20, 100, 20, 70, 10,
       2,  5,  1, -3, 10, 18,  5, 11,  7, 120, 0x044F,  0,
     -20,  5,-20,  5,  0
   },
   {"Sage Elf", -3,  1,  3,  0, -3, -1,
     255, 90, 50,  3, 80,  9, 45,  3, 60,  5,
      10,  6,  3, -1,-10, 10, 12,  7,  2, 120, 0x17CF,  3,
      10, 10, 10, -5, 10
   }
 };
#endif

/* Background information					*/
#ifdef MACGAME
background_type *background;
#else
background_type background[MAX_BACKGROUND] = {
{"You are the illegitimate and unacknowledged child ",		 10, 1, 2, 25},
{"You are the illegitimate but acknowledged child ",		 20, 1, 2, 35},
{"You are one of several children ",				 95, 1, 2, 45},
{"You are the first child ",					100, 1, 2, 50},
{"of a Serf.  ",						 40, 2, 3, 65},
{"of a Yeoman.  ",						 65, 2, 3, 80},
{"of a Townsman.  ",						 80, 2, 3, 90},
{"of a Guildsman.  ",						 90, 2, 3,105},
{"of a Landed Knight.  ",					 96, 2, 3,120},
{"of a Titled Noble.  ",					 99, 2, 3,130},
{"of a Royal Blood Line.  ",					100, 2, 3,140},
{"You are the black sheep of the family.  ",			 20, 3,50, 20},
{"You are a credit to the family.  ",				 80, 3,50, 55},
{"You are a well liked child.  ",				100, 3,50, 60},
{"Your mother was a Green-Elf.  ",				 40, 4, 1, 50},
{"Your father was a Green-Elf.  ",				 75, 4, 1, 55},
{"Your mother was a Grey-Elf.  ",				 90, 4, 1, 55},
{"Your father was a Grey-Elf.  ",				 95, 4, 1, 60},
{"Your mother was a High-Elf.  ",				 98, 4, 1, 65},
{"Your father was a High-Elf.  ",				100, 4, 1, 70},
{"You are one of several children ",				 60, 7, 8, 50},
{"You are the only child ",					100, 7, 8, 55},
{"of a Green-Elf ",						100, 8,10, 50},
{"You were once a",                                             100, 9,71,  0},
{"of a Grey-Elf ",						 95, 9,10, 55},
{"of a High-Elf ",						100, 9,10, 60},
{"Archer.  ",							 70,10,54, 90},
{"Warrior.  ",							 87,10,54,110},
{"Mage.  ",							 95,10,54,125},
{"Prince.  ",							 99,10,54,140},
{"King.  ",							100,10,54,145},
{"You are one of several children of a Halfling ",		 85,11,12, 45},
{"You are the only child of a Halfling ",			100,11,12, 55},
{"Bum.  ",							 20,12, 3, 55},
{"Tavern Owner.  ",						 30,12, 3, 80},
{"Miller.  ",							 40,12, 3, 90},
{"Home Owner.  ",						 50,12, 3,100},
{"Burglar.  ",							 80,12, 3,110},
{"Warrior.  ",							 95,12, 3,115},
{"Mage.  ",							 99,12, 3,125},
{"Clan Elder.  ",						100,12, 3,140},
{"You were created by a wizard.",                               100,13, 0,  0},
{"You are one of two children of a Dwarven ",			 25,16,17, 40},
{"You are the only child of a Dwarven ",			100,16,17, 50},
{"Thief.  ",							 10,17,18, 60},
{"Prison Guard.  ",						 25,17,18, 75},
{"Miner.  ",							 75,17,18, 90},
{"Warrior.  ",							 90,17,18,110},
{"Priest.  ",							 99,17,18,130},
{"King.  ",							100,17,18,150},
{"You are the black sheep of the family.  ",			 15,18,57, 10},
{"You are a credit to the family.  ",				 85,18,57, 50},
{"You are a well liked child.  ",				100,18,57, 55},
{"Your mother was an Orc, but it is unacknowledged.  ",		 25,19,20, 25},
{"Your father was an Orc, but it is unacknowledged.  ",		100,19,20, 25},
{"You are the adopted child ",					100,20, 2, 50},
{"Your mother was a Cave-Troll ",				 30,22,23, 20},
{"Your father was a Cave-Troll ",				 60,22,23, 25},
{"Your mother was a Hill-Troll ",				 75,22,23, 30},
{"Your father was a Hill-Troll ",				 90,22,23, 35},
{"Your mother was a Water-Troll ",				 95,22,23, 40},
{"Your father was a Water-Troll ",				100,22,23, 45},
{"Cook.  ",							  5,23,62, 60},
{"Warrior.  ",							 95,23,62, 55},
{"Shaman.  ",							 99,23,62, 65},
{"Clan Chief.  ",						100,23,62, 80},
{"Your father was a Sparrow.  ",                                 40,25,70, 30},
{"Your father was a Hawk.  ",                                    80,25,70, 50},
{"Your father was an Eagle.  ",                                 100,25,70, 60},
{"",                                                            100,28, 4, 50},
{"You have dark brown eyes, ",					 20,50,51, 50},
{"You have brown eyes, ",					 60,50,51, 50},
{"You have hazel eyes, ",					 70,50,51, 50},
{"You have green eyes, ",					 80,50,51, 50},
{"You have blue eyes, ",					 90,50,51, 50},
{"You have blue-gray eyes, ",					100,50,51, 50},
{"straight ",							 70,51,52, 50},
{"wavy ",							 90,51,52, 50},
{"curly ",							100,51,52, 50},
{"black hair, ",						 30,52,53, 50},
{"brown hair, ",						 70,52,53, 50},
{"auburn hair, ",						 80,52,53, 50},
{"red hair, ",							 90,52,53, 50},
{"blond hair, ",						100,52,53, 50},
{"and a very dark complexion.",					 10,53, 0, 50},
{"and a dark complexion.",					 30,53, 0, 50},
{"and an average complexion.",					 80,53, 0, 50},
{"and a fair complexion.",					 90,53, 0, 50},
{"and a very fair complexion.",					100,53, 0, 50},
{"You have light grey eyes, ",					 85,54,55, 50},
{"You have light blue eyes, ",					 95,54,55, 50},
{"You have light green eyes, ",					100,54,55, 50},
{"straight ",							 75,55,56, 50},
{"wavy ",							100,55,56, 50},
{"black hair, and a fair complexion.",				 75,56, 0, 50},
{"brown hair, and a fair complexion.",				 85,56, 0, 50},
{"blond hair, and a fair complexion.",				 95,56, 0, 50},
{"silver hair, and a fair complexion.",				100,56, 0, 50},
{"You have dark brown eyes, ",					 99,57,58, 50},
{"You have glowing red eyes, ",					100,57,58, 60},
{"straight ",							 90,58,59, 50},
{"wavy ",							100,58,59, 50},
{"black hair, ",						 75,59,60, 50},
{"brown hair, ",						100,59,60, 50},
{"a one foot beard, ",						 25,60,61, 50},
{"a two foot beard, ",						 60,60,61, 51},
{"a three foot beard, ",					 90,60,61, 53},
{"a four foot beard, ",						100,60,61, 55},
{"and a dark complexion.",					100,61, 0, 50},
{"You have slime green eyes, ",					 60,62,63, 50},
{"You have puke yellow eyes, ",					 85,62,63, 50},
{"You have blue-bloodshot eyes, ",				 99,62,63, 50},
{"You have glowing red eyes, ",					100,62,63, 55},
{"dirty ",							 33,63,64, 50},
{"mangy ",							 66,63,64, 50},
{"oily ",							100,63,64, 50},
{"sea-weed green hair, ",					 33,64,65, 50},
{"bright red hair, ",						 66,64,65, 50},
{"dark purple hair, ",						100,64,65, 50},
{"and green ",							 25,65,66, 50},
{"and blue ",							 50,65,66, 50},
{"and white ",							 75,65,66, 50},
{"and black ",							100,65,66, 50},
{"ulcerous skin.",						 33,66, 0, 50},
{"scabby skin.",						 66,66, 0, 50},
{"leprous skin.",						100,66, 0, 50},
{"Your mother was a White dragon.  ",                            40,70,71, 40},
{"Your mother was a Red dragon.  ",                              70,70,71, 50},
{"Your mother was a Blue dragon.  ",                             90,70,71, 60},
{"Your mother was a Golden dragon.  ",                          100,70,71,120},
{"You have a large body and ",                                  100,71,72, 50},
{"small white wings.",                                           30,72, 0, 50},
{"small green wings.",                                           80,72, 0, 50},
{"small transparent wings.",                                    100,72, 0, 50}
};
#endif

/* Classes.							*/
class_type class[MAX_CLASS] = {
/*	  HP Dis Src Stl Fos bth btb sve S  I  W  D Co Ch  Spell Exp  spl, Arm, XPR
 */
{"Warrior",9, 25, 16, 1, 23, 80, 60, 20, 6,-2,-2, 2, 2,-1, NONE,0,0,99,30},
{"Mage",   1, 30, 20, 2, 20, 34, 20, 36,-3, 4, 0, 1,-2, 1, MAGE,30, 1, 14,3},
{"Priest", 2, 25, 16, 2, 32, 48, 35, 30,-2,-3, 4,-1, 0, 2, PRIEST,20, 1, 7,10},
{"Rogue",  6, 50, 32, 7, 12, 60, 66, 30, 3, 2,-2, 5, 1,-1, MAGE,0, 5, 17,20},
{"Ranger", 4, 30, 24, 3, 24, 56, 72, 30, 2, 2, 0, 1, 1, 1, MAGE,40, 3, 12, 8},
{"Paladin",6, 20, 12, 1, 38, 68, 40, 24, 4,-3, 1, 0, 2, 2, PRIEST,35, 1, 17,4},
{"Demigod",
          12, 20, 20, 0, 18, 75,  0, 50, 4,-4, 2, 2, 1, 1, PRIEST,40, 4,15,20},
{"Sage",   2, 40, 22, 1, 22, 42, 60, 32,-2, 0, 2, 5,-1, 0, SAGE,15, 1,20, 13},
{"Jester", 4, 40, 25, 4, 24, 50, 55, 30, 1,-2, 2, 3, 1, 4, MAGE,25, 5, 15,12},
{"Ninja",  2, 20, 25, 3, 18, 65, 65, 20, 2, 0, 0, 3, 0,-1, SAGE,30, 5, 12,4},
{"Healer", 5, 30, 20, 3, 14, 45, 50, 25, 0, 0, 2, 3, 1, 0, PRIEST,10, 1, 0,15},
{"Wizard",-1, 20, 20, 3, 14,  0,  0, 45,-5, 6, 2,-1,-3,-1, MAGE,20, 1,255, 1}, 
{"Monk",   4, 25, 24, 4, 10, 65,  0, 40, 2,-3, 0, 4, 0, 0, NONE,25,0,255, 20}
};

/* Arm specifies the maximum weight of armor that this class can wear */

/* making it 16 bits wastes a little space, but saves much signed/unsigned
   headaches in its use */
/* CLA_MISC_HIT is identical to CLA_SAVE, which takes advantage of
   the fact that the save values are independent of the class */
int16 class_level_adj[MAX_CLASS][MAX_LEV_ADJ] = {
/*	       bth    bthb   device  disarm   save/misc hit  */
/* Warrior */ {	5,	4,	2,	2,	3 },
/* Mage    */ { 2,	2,	4,	3,	3 },
/* Priest  */ { 2,	2,	4,	3,	3 },
/* Rogue   */ { 3,	4,	3,	4,	3 },
/* Ranger  */ { 3,	4,	3,	3,	3 },
/* Paladin */ { 3,	3,	3,	2,	3 },
/* Demigod */ { 4,      0,      4,      1,      4 },
/* Sage    */ { 2,      2,      4,      3,      3 },
/* Jester  */ { 3,      3,      3,      3,      3 },
/* Ninja   */ { 3,      4,      2,      3,      3 },
/* Healer  */ { 2,      3,      3,      3,      3 },
/* Wizard  */ { 0,      0,      6,      3,      5 },
/* Monk    */ { 4,      0,      4,      2,      4 }
};

int32u spell_learned = 0;	/* bit mask of spells learned */
int32u spell_worked = 0;	/* bit mask of spells tried and worked */
int32u spell_forgotten = 0;	/* bit mask of spells learned but forgotten */
int8u spell_order[32];		/* order spells learned/remembered/forgotten */

/* Warriors don't have spells, so there is no entry for them.  Note that
   this means you must always subtract one from the py.misc.pclass before
   indexing into magic_spell[]. */
#ifdef MACGAME
spell_type (*magic_spell)[31];
#else
spell_type magic_spell[MAX_CLASS-1][31] = {
  {		  /* Mage	   */
     {	1,  1, 22,   1},
     {	1,  1, 23,   1},
     {	1,  2, 24,   1},
     {	1,  2, 26,   1},
     {	3,  3, 25,   2},
     {	3,  3, 25,   1},
     {	3,  3, 27,   2},
     {	3,  4, 30,   1},
     {	5,  4, 30,   6},
     {	5,  5, 30,   8},
     {	5,  5, 30,   5},
     {	5,  5, 35,   6},
     {	7,  6, 35,   9},
     {	7,  6, 85,  10},
     {	7,  6, 40,  12},
     {	9,  7, 44,  19},
     {	9,  7, 45,  19},
     {	9,  7, 75,  22},
     {	9,  7, 45,  19},
     { 11,  7, 45,  25},
     { 11,  7, 99,  19},
     { 13,  7, 50,  22},
     { 15,  9, 50,  25},
     { 17,  9, 50,  31},
     { 19, 12, 55,  38},
     { 21, 12, 58,  44},
     { 23, 12, 60,  50},
     { 25, 12, 63,  63},
     { 27, 18, 66,  88},
     { 31, 21, 69, 125},
     { 33, 25, 72, 200},
   },
   {		  /* Priest	   */
     {	1,  1, 10,   1},
     {	1,  2, 15,   1},
     {	1,  2, 20,   1},
     {	1,  2, 25,   1},
     {	3,  2, 25,   1},
     {	3,  3, 27,   2},
     {	3,  3, 27,   2},
     {	3,  3, 75,   3},
     {	5,  4, 29,   4},
     {	5,  4, 30,   5},
     {	5,  4, 32,   5},
     {	5,  5, 34,   5},
     {	7,  5, 36,   6},
     {	7,  5, 38,   7},
     {	7,  6, 38,   9},
     {	7,  7, 38,   9},
     {	9,  6, 38,  10},
     {	9,  7, 38,  10},
     {	9,  7, 40,  10},
     { 11,  8, 42,  10},
     { 11,  8, 42,  12},
     { 11,  9, 55,  15},
     { 13, 10, 45,  15},
     { 13, 11, 45,  16},
     { 15, 12, 50,  20},
     { 15, 14, 50,  22},
     { 17, 14, 55,  32},
     { 21, 15, 58,  38},
     { 25, 16, 62,  75},
     { 29, 17, 66,  90},
     { 33, 18, 70, 125},
   },
   {		  /* Rogue	   */
     { 99, 99,	0,   0},
     {	5,  1, 30,   1},
     {	6,  1, 35,   1},
     {	7,  2, 40,   2},
     {  8,  2, 45,   2},
     {  9,  3, 50,   3},
     { 10,  3, 55,   4},
     { 11,  4, 60,   3},
     { 99, 99,	0,   0},
     { 12,  4, 65,   4},
     { 13,  5, 70,   5},
     { 14,  5, 75,   6},
     { 99, 99,	0,   0},
     { 15,  6, 90,   7},
     { 99, 99,	0,   0},
     { 99, 99,	0,   0},
     { 16,  7, 85,   9},
     { 17,  8, 90,  11},
     { 99, 99,	0,   0},
     { 99, 99,	0,   0},
     { 18,  9, 99,  19},
     { 99, 99,	0,   0},
     { 99, 99,	0,   0},
     { 99, 99,	0,   0},
     { 99, 99,	0,   0},
     { 99, 99,	0,   0},
     { 99, 99,	0,   0},
     { 99, 99,	0,   0},
     { 99, 99,	0,   0},
     { 99, 99,	0,   0},
     { 99, 99,	0,   0},
   },
   {		   /* Ranger	    */
     {	3,  1, 30,   1},
     {	3,  2, 35,   2},
     {	3,  2, 35,   2},
     {	5,  3, 35,   2},
     {	5,  3, 40,   2},
     {	5,  4, 45,   3},
     {	7,  5, 40,   6},
     {	7,  6, 40,   5},
     {	9,  7, 40,   7},
     {	9,  8, 45,   8},
     { 11,  8, 40,  10},
     { 11,  9, 45,  10},
     { 13, 10, 50,  12},
     { 13, 11, 90,  13},
     { 15, 12, 50,  15},
     { 15, 13, 50,  15},
     { 17, 17, 55,  15},
     { 17, 17, 90,  17},
     { 21, 17, 55,  17},
     { 21, 19, 60,  18},
     { 23, 25, 95,  20},
     { 23, 20, 60,  20},
     { 25, 20, 60,  20},
     { 25, 21, 65,  20},
     { 27, 21, 65,  22},
     { 29, 23, 95,  23},
     { 31, 25, 70,  25},
     { 33, 25, 75,  38},
     { 35, 25, 80,  50},
     { 37, 30, 95, 100},
   },
   {		  /* Paladin	   */
     {	1,  1, 30,   1},
     {	2,  2, 35,   2},
     {	3,  3, 35,   3},
     {	5,  3, 35,   5},
     {	5,  4, 35,   5},
     {	7,  5, 40,   6},
     {	7,  5, 40,   6},
     {	9,  7, 90,   7},
     {	9,  7, 40,   8},
     {	9,  8, 40,   8},
     { 11,  9, 40,  10},
     { 11, 10, 45,  10},
     { 11, 10, 45,  10},
     { 13, 10, 45,  12},
     { 13, 11, 45,  13},
     { 15, 13, 45,  15},
     { 15, 15, 50,  15},
     { 17, 15, 50,  17},
     { 17, 15, 50,  18},
     { 19, 15, 50,  19},
     { 19, 15, 50,  19},
     { 21, 17, 50,  20},
     { 23, 17, 50,  20},
     { 25, 20, 50,  20},
     { 27, 21, 50,  22},
     { 29, 22, 50,  24},
     { 31, 24, 60,  25},
     { 33, 28, 60,  31},
     { 35, 32, 70,  38},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
   },
   {          /* Demigod */
     {  4,  1, 25,   1},
     {  5,  1, 27,   1},
     {  6,  2, 29,   1},
     {  7,  2, 31,   1},
     {  8,  3, 33,   2},
     {  9,  4, 35,   2},
     { 10,  5, 37,   2},
     { 11,  6, 39,   2},
     { 12,  7, 41,   3},
     { 13,  8, 43,   3},
     { 14,  9, 45,   3},
     { 15, 10, 47,   4},
     { 16, 11, 49,   4},
     { 17, 12, 51,   5},
     { 18, 13, 53,   5},
     { 19, 14, 55,   6},
     { 20, 15, 57,   7},
     { 21, 16, 59,   8},
     { 22, 17, 61,   9},
     { 23, 18, 63,  10},
     { 24, 19, 65,  11},
     { 25, 20, 67,  12},
     { 26, 21, 69,  13},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
   },
   {      /* Sage */
     {  1,  1, 17,   1},
     {  1,  1, 19,   1},
     {  1,  2, 21,   1},
     {  3,  2, 23,   1},
     {  3,  2, 25,   2},
     {  3,  2, 27,   2},
     {  5,  3, 60,   2},
     {  5,  3, 31,   2},
     {  5,  4, 33,   3},
     {  7,  4, 35,   3},
     {  7,  5, 37,   3},
     {  9,  5, 39,   4},
     {  9,  5, 41,   5},
     { 11,  5, 50,   6},
     { 11,  6, 80,   7},
     { 13,  6, 43,   8},
     { 13,  7, 45,   9},
     { 15,  7, 47,  10},
     { 15,  8, 49,  11},
     { 17,  8, 51,  12},
     { 17,  8, 53,  13},
     { 19,  9, 55,  14},
     { 21,  9, 57,  15},
     { 23, 11, 59,  17},
     { 25, 13, 61,  20},
     { 27, 15, 63,  30},
     { 29, 17, 65,  50},
     { 31, 21, 67,  80},
     { 33, 25, 69, 120},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0}
   },
   {         /* Jester */
     { 99, 99, 99,   0},
     {  5,  1, 40,   1},
     {  5,  1, 42,   1},
     {  6,  2, 44,   2},
     {  6,  2, 46,   2},
     {  7,  3, 48,   3}, 
     {  7,  3, 50,   3},
     {  8,  4, 52,   4},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     {  9,  5, 54,   5},
     { 10,  6, 58,   6},
     { 11,  7, 60,   7},
     { 12,  8, 95,   8},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 14, 10, 66,  10},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 15, 11, 68,   0},
     { 16, 12, 95,   0},
     { 17, 13, 70,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0}
   },
   {      /* Ninja */
     {  5,  1, 50,   1},
     {  6,  1, 51,   1},
     {  7,  2, 52,   1},
     {  8,  2, 53,   1},
     {  9,  2, 54,   2},
     { 10,  2, 55,   2},
     { 11,  3, 56,   2},
     { 12,  3, 57,   2},
     { 13,  4, 58,   3},
     { 14,  4, 59,   3},
     { 15,  5, 60,   3},
     { 16,  5, 61,   4},
     { 17,  5, 62,   5},
     { 18,  5, 63,   6},
     { 19,  6, 64,   7},
     { 20,  6, 65,   8},
     { 21,  7, 66,   9},
     { 22,  7, 67,  10},
     { 23,  8, 68,  11},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0}
   },
   {       /* Healer */
     {  1,  1, 20,   1},
     {  1,  1, 20,   1},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     {  1,  1, 35,   1},
     {  3,  3, 40,   1},
     {  3,  3, 40,   1},
     {  2,  1, 22,   1},
     {  7,  3, 29,   2},
     {  9,  8, 50,   3},
     {  4,  2, 32,   3},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     {  5,  3, 35,   4},
     { 99, 99, 99,   0},
     { 12, 10, 60,   8},
     {  6,  4, 40,   5},
     { 99, 99, 99,   0},
     {  8,  5, 46,   4},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 10,  7, 54,   5},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 15, 12, 70,  12},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0},
     { 99, 99, 99,   0}
   },
   {		  /* Wizard	   */
     {	1,  1, 12,   1},
     {	1,  1, 14,   1},
     {	1,  1, 16,   1},
     {	2,  1, 18,   1},
     {	2,  2, 20,   2},
     {	2,  2, 22,   1},
     {	3,  2, 24,   2},
     {	3,  2, 26,   1},
     {	3,  3, 28,   6},
     {	4,  3, 30,   8},
     {	4,  3, 32,   5},
     {	4,  3, 34,   6},
     {	5,  4, 36,   9},
     {	5,  4, 80,  10},
     {	6,  4, 40,  12},
     {	6,  5, 42,  19},
     {	7,  5, 44,  19},
     {	7,  5, 46,  22},
     {	8,  5, 48,  19},
     {  9,  6, 50,  25},
     { 10,  6, 85,  19},
     { 11,  6, 50,  22},
     { 12,  7, 52,  25},
     { 13,  7, 54,  31},
     { 14,  8, 56,  38},
     { 15,  9, 58,  44},
     { 17, 10, 61,  50},
     { 19, 12, 63,  63},
     { 21, 14, 65,  88},
     { 23, 16, 67, 125},
     { 27, 20, 70, 200},
   },
 };
#endif

char *spell_names[100] = {
  /* Mage Spells */
  "Magic Missile",  "Detect Monsters",	"Phase Door",  "Light Area",
  "Cure Light Wounds",	"Find Hidden Traps/Doors",  "Stinking Cloud",
  "Confusion",	"Lightning Bolt",  "Magical Sphere", "Sleep I",
  "Cure Poison",  "Teleport Self",  "Magic Warp",  "Frost Bolt",
  "Turn Stone to Mud",	"Create Food",	"Recharge Item",  "Acid Ball",
  "Polymorph Other",  "Identify",  "Sleep II",	 "Fire Bolt",  "Slow Monster",
  "Frost Ball",	 "Solar Ball", "Teleport Other","Haste Self",
  "Fire Ball", "Word of Destruction", "Globe of Invunerability",
  /* Priest Spells, start at index 31 */
  "Detect Evil",  "Cure Light Wounds",	"Bless",  "Remove Fear", "Call Light",
  "Find Traps",	 "Detect Doors/Stairs",	 "Return Home",	 "Rule Creatures",
  "Portal",  "Cure Medium Wounds",  "Chant",  "Sanctuary",  "Create Food",
  "Remove Curse",  "Resist Heat and Cold",  "Neutralize Poison",
  "Orb of Draining",  "Cure Serious Wounds",  "Sense Invisible",
  "Protection from Evil",  "Earthquake",  "Sense Surroundings",
  "Cure Critical Wounds",  "Turn Undead",  "Slow Others","Dispel Undead",
  "Heal",  "Dispel Evil",  "Glyph of Warding",	"Holy Shield",
  /* Sage Incantations, start at index 62 */
  "Detect Evil","Detect Monsters","Light Cures","Light Area",
  "Distant Touch","Find Doors/Traps","Travel Afar","Find Treasure",
  "Light Hallway","Recharge Item","Sense Invisible","Escape","Detect Room",
  "Power Vision","Insight","Minor Wave","Typical Cures","Find Food",
  "Light Sphere","Mass Hypnosis","Slow Monsters","Change Creatures",
  "Elemental Shield","Blast Wave","Heavy Cures","Elemental Wave",
  "Repel Evil","Repel Many","Force Destiny"
};

/* Each type of character starts out with a few provisions.	*/
/* Note that the entries refer to elements of the object_list[] array*/
/* 351 = Food Ration, 372 = Wooden Torch, 123 = Cloak, 318 = Beginners-Majik,
   103 = Soft Leather Armor, 30 = Stiletto, 322 = Beginners Handbook,
   329 = Wise Words */

int16u player_init[MAX_CLASS][5] = {
		{ 351, 372, 123,  30, 103},	/* Warrior	 */
		{ 351, 372, 123,  30, 318},	/* Mage		 */
		{ 351, 372, 123,  30, 322},	/* Priest	 */
		{ 351, 372, 123,  30, 318},	/* Rogue	 */
		{ 351, 372, 123,  30, 318},	/* Ranger	 */
		{ 351, 372, 123,  30, 322},	/* Paladin	 */
		{ 351, 372, 123,  30, 322},	/* Demigod	 */
		{ 351, 372, 330,  74, 329},	/* Sage       	 */
                { 351, 372, 123,  30, 318},     /* Jester        */  
                { 351, 372, 123,  30, 329},     /* Ninja         */  
                { 351, 372, 123,  30, 322},     /* Healer        */
                { 351, 372, 123, 319, 318},     /* Wizard        */
                { 351, 268, 351, 268, 371}      /* Monk          */ 
};

