{*Vectors.Inc**************************************************************

 Basic Vector Math...

 Created            : 31/01/93
 Last Change        : 09/04/93
 Revisions          : 0.001 changed 'unit vectors' into 'vectors.inc'

 *************************************************************************}

function VecLen(A : Vec) : Flt;

begin
   Veclen := Sqrt(Sqr(A[0])+Sqr(A[1])+Sqr(A[2]));
end;

function VecDot(A,B : Vec) : Flt;

begin
  VecDot := A[0]*B[0]+A[1]*B[1]+A[2]*B[2];
end;

procedure VecCopy(A:vec; var B : vec);

begin
  B[0]:=A[0]; B[1]:=A[1]; B[2]:=A[2];
end;

procedure VecAdd(A,B:vec; var C : vec);

begin
  C[0]:=A[0]+B[0];
  C[1]:=A[1]+B[1];
  C[2]:=A[2]+B[2];
end;

procedure VecSub(A,B : vec; var C : vec);

begin
  C[0]:=A[0]-B[0];
  C[1]:=A[1]-B[1];
  C[2]:=A[2]-B[2];
end;

procedure VecComb(p : Flt;A : Vec;q : Flt;B:vec; var C : Vec);

begin
  C[0]:=p*A[0]+q*B[0];
  C[1]:=p*A[1]+q*B[1];
  C[2]:=p*A[2]+q*B[2];
end;

procedure VecAddS(p : Flt; A,B:vec; var C:vec);

begin
  C[0]:=p*A[0]+B[0];
  C[1]:=p*A[1]+B[1];
  C[2]:=p*A[2]+B[2];
end;


procedure RayPoint(ray : Tray; t : Flt; var point : Vec);

begin
  VecAddS(t,ray.d,ray.p,point);
end;

procedure VecUnit(var A: Vec);
var
  dummy : Flt;

begin
  dummy := Veclen(A);
  A[0] :=  A[0] / dummy;
  A[1] :=  A[1] / dummy;
  A[2] :=  A[2] / dummy;
end;

procedure VecScale(p : Flt; var A : vec);

begin
  A[0] := A[0] * p;
  A[1] := A[1] * p;
  A[2] := A[2] * p;
end;

procedure VecCross(A, B : vec; var C: vec);

begin
  C[0] := A[1] * B[2] - A[2] * B[1];
  C[1] := A[2] * B[0] - A[0] * B[2];
  C[2] := A[0] * B[1] - A[1] * B[0];
end;

procedure VecNegate(var A: Vec);

begin
  A[0] := -A[0];
  A[1] := -A[1];
  A[2] := -A[2];
end;
