#include <stdio.h>
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <math.h>
#include "define.h" 
#include "global.h" 
#include "structure.h" 
#define MAXROW 100
#define MAXCOL 100



Frame      cachemainframe, filename_frame;
Window      cache_panel, read_options_panel, 
            filename_panel;

Panel_item  Schoice, Achoice,Gchoice, imagename, dirname,affimageplane, 
	    donebutton, plottername, quitbutton, clearbutton,
            X_coord_project_pt, Y_coord_project_pt, Z_coord_project_pt,
            X_min, X_max, Y_min, Y_max, Z_min, Z_max,
            scalefac, Nb_Rows, Nb_Cols;

char filedesc[60], fileimage[60], nameplotter[60];

static float info[] = {0.0,0.0,0.0,0.0,0.0,0.0,0.0};

struct description descx;

float   viewx, viewy, viewz, nybeg, nyend, nxbeg, nxend, 
	nzbeg, nzend, ffact ,fzmin, fzmax;

float   *odf;
unsigned char    *od;
short   *ods;
int     *odi;
FILE    *fpi, *fpd;
int	fnorow,fnocol, plotflag, random_flag, groundframe_flag, 
	param_flag, flag_break, done_flag, flag_plan_mem,
	first_time_flag;
int     flag_in_cache = FALSE;
int     cache_win_open = FALSE;
int     affcache_clear_flag = TRUE;    


extern int Confirm();
extern int read_desc();

void init_variables(){
  char  strg1[60], strg2[6], strg3[6], strg4[6], strg5[6], strg6[6],
        strg7[6], strg8[6], strg9[6] , strg10[6] , strg11[10] , 
        strg12[6], strg13[6], strg14[6], strg15[6],  strg16[6], 
        strg17[6], strg18[6], plotcmd[60];


      strcpy(strg2, (char *)panel_get_value(X_coord_project_pt));
      viewx = (float)atoi(strg2);
      strcpy(strg3, (char *)panel_get_value(Y_coord_project_pt));
      viewy = (float)atoi(strg3);
      strcpy(strg4, (char *)panel_get_value(Z_coord_project_pt));
      viewz = (float)atoi(strg4);
      strcpy(strg5, (char *)panel_get_value( X_min));
      nxbeg = (float)atoi(strg5);
      strcpy(strg6, (char *)panel_get_value( X_max));
      nxend = (float)atoi(strg6);
      strcpy(strg7, (char *)panel_get_value( Y_min));
      nybeg = (float)atoi(strg7);
      strcpy(strg8, (char *) panel_get_value( Y_max));
      nyend = (float)atoi(strg8);
      strcpy(strg9, (char *)panel_get_value( Z_min));
      fzmin = (float)atoi(strg9);
      strcpy(strg10, (char *)panel_get_value( Z_max));
      fzmax = (float)atoi(strg10);
      strcpy(strg12, (char *)panel_get_value( Nb_Rows));
      fnorow = (float)atoi(strg12);
      strcpy(strg13, (char *)panel_get_value( Nb_Cols));
      fnocol = (float)atoi(strg13);
      strcpy(strg11, (char *)panel_get_value( scalefac));
      ffact = (float)atof(strg11);
      if (!groundframe_flag)  info[6] = 0.0;

}





Panel_setting options_proc(pitem, pevent)
Panel_item pitem;
Event *pevent; 
{ 
  Panel_item nitem;

  void done_proc();

  window_set(read_options_panel, PANEL_CARET_ITEM, pitem, 0);    
  if (event_id(pevent) == '\03'){  
    panel_advance_caret(read_options_panel);
    return(PANEL_PREVIOUS);  
  }
  else if (event_id(pevent) == '\r'){
      done_proc(pitem, pevent);
  }
  else if ((event_id(pevent) == '\t') || 
	    (event_id(pevent) == '\n'))
         return(PANEL_NEXT);


}

 

void choice_options_proc(pitem, pvalue, pevent)
Panel_item pitem;
int pvalue;
Event *pevent; 
{

  if ((pitem ==  Schoice) && (pvalue == 1)) param_flag = TRUE;
  else if ((pitem == Achoice) && (pvalue == 1)) random_flag = TRUE;
  else if ((pitem == Gchoice)  && (pvalue == 1)){
         info[6] = 1.0;
	 groundframe_flag = TRUE;
  }
}


void clear_proc(item, event)
Panel_item item;
Event *event;
{
    if (!affcache_clear_flag){
	closepl();
	affcache_clear_flag = TRUE;
    }
    
}


void quit_proc(item, event)
Panel_item item;
Event *event;
{
    if (!affcache_clear_flag) clear_proc();
    affcache_clear_flag = TRUE;
    flag_plan_mem = FALSE;
    if (Confirm("quit ?") == 1){
	window_destroy(cachemainframe);
    }
    flag_in_cache = FALSE;
}


short FCT(x, y)
float x, y;
{
    short z;
    int ix, iy;

  ix = x+0.5;
  iy = y+0.5;
  if (ix > descx.ncolonne) return(0);
  if (ix < 0) return(0);
  if (iy > descx.nligne) return(0);
  if (iy < 0) return(0); 
  switch (descx.type) {
     case -1:
      case 0:
      case 6: z = (short)(od[iy*descx.ncolonne + ix] * ffact);
	      break;
      case 1: z = (ods[iy*descx.ncolonne + ix] * ffact);
	      break;
      case 2: z = (short)(odi[iy*descx.ncolonne + ix] * ffact);
	      break;
      case 3:
      case 4:
      case 5: z = (short)(odf[iy*descx.ncolonne + ix] * ffact);
	      break;
  }
  if (random_flag)
    if (random() & 1) z = z + (random() & 7);
    else z = z - (random() & 7);
  return (z);
}


void done_proc(item, event)
Panel_item item;
Event *event;
{
  int size;

    init_variables();
    size = descx.nligne * descx.ncolonne;
    switch (descx.type){
	case -1:
	case 6:
	case 0: if (flag_plan_mem){
		    od = (unsigned char *) dir_image[index_image[0]].image;
	        }
	        else{
		    od = (unsigned char *) malloc(size);
		    fread (od, 1, size, fpi);
		}
		break;   
	case 1: if (flag_plan_mem){
		   ods = (short *) dir_image[index_image[0]].image; 
	        }
	        else{
		    ods = (short *) malloc(size);
		    fread (ods, 1, sizeof(*ods), fpi);  
		}
		break;
	case 2: if (flag_plan_mem){
		    odi = (int *) dir_image[index_image[0]].image;
	        }
	        else{
		    odi = (int *) malloc(size);
		    fread (odi, 1, sizeof(*odi), fpi);   
		}
		break;
	case 3:
	case 4:
	case 5: if (flag_plan_mem){
		    odf = (float *) dir_image[index_image[0]].image;
	        }
	        else{
		    odf = (float *) malloc(size * sizeof (float));
		    fread (odf, 1, sizeof(*odf), size, fpi);
		}
		break;   
    }
    fclose(fpi);

    if (!affcache_clear_flag) clear_proc();
    affcache_clear_flag = FALSE;
    openpl();
    network(viewx, viewy, viewz, fzmin, fzmax, nxbeg, nxend, nybeg,nyend,fnorow,fnocol, info, FCT);
    preclosepl();
}




void create_panel_items(){

    char strxmin[40], strxmax[40];
    char strymin[40], strymax[40];
    char strzmin[60], strzmax[60];
    char defzmin[15], defzmax[15], defxmin[15], 
	 defxmax[15],defymin[15], defymax[15];
    float defscale;

    defscale = 0.127500;
    sprintf(strxmin, "View Volume Xmax(int,>= 0 .. < %d): ", descx.ncolonne);
    sprintf(strxmax, "View Volume Xmax(int,> 0 .. =< %d): ", descx.ncolonne);

    sprintf(strymin, "View Volume Ymax(int,>= 0 .. < %d): ", descx.nligne);
    sprintf(strymax, "View Volume Ymax(int,> 0 .. =< %d): ", descx.nligne);

    sprintf(strzmin, "View Volume Zmin(>= min_pixel * scale_fac): ");
    sprintf(strzmax, "View Volume Zmax(=< max_pixel * scale_fac): ");
    sprintf(defzmin, "%f",descx.mini[0]*defscale);
    sprintf(defzmax, "%f",descx.maxi[0]*defscale);
    strcpy(defxmin, "0");
    sprintf(defxmax, "%d",descx.ncolonne);
    strcpy(defymin, "0");
    sprintf(defymax, "%d",descx.nligne);
    groundframe_flag = param_flag = random_flag = done_flag = FALSE;

    X_coord_project_pt = panel_create_item(read_options_panel, PANEL_TEXT,
                                  PANEL_LABEL_STRING, "X coord of projection point (int): ",
                                  PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
				  PANEL_VALUE, "100",
				  PANEL_NOTIFY_STRING, "\r\t\03",
                                  PANEL_VALUE_DISPLAY_LENGTH, 60,
				  PANEL_NOTIFY_PROC, options_proc,
                                  PANEL_LABEL_X, ATTR_COL(0),
                                  PANEL_LABEL_Y, ATTR_ROW(1), 
				  0);
    Y_coord_project_pt = panel_create_item(read_options_panel, PANEL_TEXT,
                                  PANEL_LABEL_STRING, "Y coord of projection point (int): ",
				  PANEL_VALUE, "100",
                                  PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
				  PANEL_NOTIFY_STRING, "\r\t\03",
                                  PANEL_VALUE_DISPLAY_LENGTH, 60,
				  PANEL_NOTIFY_PROC, options_proc,
                                  PANEL_LABEL_X, ATTR_COL(0),
                                  PANEL_LABEL_Y, ATTR_ROW(2), 
				  0);
    Z_coord_project_pt = panel_create_item(read_options_panel, PANEL_TEXT,
                                  PANEL_LABEL_STRING, "Z coord of projection point (int): ",
				  PANEL_VALUE, "40",
                                  PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
				  PANEL_NOTIFY_STRING, "\r\t\03",
                                  PANEL_VALUE_DISPLAY_LENGTH, 60,
				  PANEL_NOTIFY_PROC, options_proc,
                                  PANEL_LABEL_X, ATTR_COL(0),
                                  PANEL_LABEL_Y, ATTR_ROW(3), 
				  0);


    X_min = panel_create_item(read_options_panel, PANEL_TEXT,
                                  PANEL_LABEL_STRING,strxmin, 
				  PANEL_VALUE, "0",
                                  PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
				  PANEL_NOTIFY_STRING, "\r\t\03",
                                  PANEL_VALUE_DISPLAY_LENGTH, 60,
				  PANEL_NOTIFY_PROC, options_proc,
                                  PANEL_LABEL_X, ATTR_COL(0),
                                  PANEL_LABEL_Y, ATTR_ROW(4), 
				  0);

    X_max = panel_create_item(read_options_panel, PANEL_TEXT,
                                  PANEL_LABEL_STRING, strxmax,
				  PANEL_VALUE, defxmax,
                                  PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
				  PANEL_NOTIFY_STRING, "\r\t\03",
                                  PANEL_VALUE_DISPLAY_LENGTH, 60,
				  PANEL_NOTIFY_PROC, options_proc,
                                  PANEL_LABEL_X, ATTR_COL(0),
                                  PANEL_LABEL_Y, ATTR_ROW(5), 
				  0);

    Y_min = panel_create_item(read_options_panel, PANEL_TEXT,
                                  PANEL_LABEL_STRING, strymin,
				  PANEL_VALUE, "0",
                                  PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
				  PANEL_NOTIFY_STRING, "\r\t\03",
                                  PANEL_VALUE_DISPLAY_LENGTH, 60,
				  PANEL_NOTIFY_PROC, options_proc,
                                  PANEL_LABEL_X, ATTR_COL(0),
                                  PANEL_LABEL_Y, ATTR_ROW(6), 
				  0);
    Y_max = panel_create_item(read_options_panel, PANEL_TEXT,
                                  PANEL_LABEL_STRING, strymax,
				  PANEL_VALUE, defymax,
                                  PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
				  PANEL_NOTIFY_STRING, "\r\t\03",
                                  PANEL_VALUE_DISPLAY_LENGTH, 60,
				  PANEL_NOTIFY_PROC, options_proc, 
                                  PANEL_LABEL_X, ATTR_COL(0),
                                  PANEL_LABEL_Y, ATTR_ROW(7),  
				  0);

    Z_min = panel_create_item(read_options_panel, PANEL_TEXT,
                                  PANEL_LABEL_STRING, strzmin,
				  PANEL_VALUE, defzmin,
                                  PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
				  PANEL_NOTIFY_STRING, "\r\t\03",
                                  PANEL_VALUE_DISPLAY_LENGTH, 60,
				  PANEL_NOTIFY_PROC, options_proc,
                                  PANEL_LABEL_X, ATTR_COL(0),
                                  PANEL_LABEL_Y, ATTR_ROW(8), 
				  0);

    Z_max = panel_create_item(read_options_panel, PANEL_TEXT,
                                  PANEL_LABEL_STRING, strzmax,
				  PANEL_VALUE, defzmax,
                                  PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
				  PANEL_NOTIFY_STRING, "\r\t\03",
                                  PANEL_VALUE_DISPLAY_LENGTH, 60,
				  PANEL_NOTIFY_PROC, options_proc,
                                  PANEL_LABEL_X, ATTR_COL(0),
                                  PANEL_LABEL_Y, ATTR_ROW(9), 
				  0);

     scalefac = panel_create_item(read_options_panel, PANEL_TEXT,
                                  PANEL_LABEL_STRING, "Scaling Factor (float,  < 1.00):",
				  PANEL_VALUE, "0.127500",
                                  PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
				  PANEL_NOTIFY_STRING, "\r\t\03",
                                  PANEL_VALUE_DISPLAY_LENGTH, 60,
				  PANEL_NOTIFY_PROC, options_proc, 
                                  PANEL_LABEL_X, ATTR_COL(0),
                                  PANEL_LABEL_Y, ATTR_ROW(10),
				  0);

    Nb_Rows = panel_create_item(read_options_panel, PANEL_TEXT,
                                  PANEL_LABEL_STRING, "Grid Lines(int, < 200): ",
				  PANEL_VALUE, "100",
                                  PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
				  PANEL_NOTIFY_STRING, "\r\t\03",
                                  PANEL_VALUE_DISPLAY_LENGTH, 60,
				  PANEL_NOTIFY_PROC, options_proc,
                                  PANEL_LABEL_X, ATTR_COL(0),
                                  PANEL_LABEL_Y, ATTR_ROW(11), 
				  0);

    Nb_Cols = panel_create_item(read_options_panel, PANEL_TEXT,
                                  PANEL_LABEL_STRING, "Grid Columns(int, < 200): ",
				  PANEL_VALUE, "100",
                                  PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
				  PANEL_NOTIFY_STRING, "\r\t\03",
                                  PANEL_VALUE_DISPLAY_LENGTH, 60,
				  PANEL_NOTIFY_PROC, options_proc,
                                  PANEL_LABEL_X, ATTR_COL(0),
                                  PANEL_LABEL_Y, ATTR_ROW(12), 
				  0);

    Gchoice = panel_create_item(cache_panel, PANEL_CYCLE,
                                   PANEL_LABEL_STRING,"  Ground_frame",
				   PANEL_CHOICE_STRINGS,
				   "ON","OFF",0,
                                   PANEL_NOTIFY_PROC, choice_options_proc,
				  PANEL_LABEL_X, ATTR_COL(20),
                                  PANEL_LABEL_Y, ATTR_ROW(0), 
                                   0);
    Achoice = panel_create_item(cache_panel, PANEL_CYCLE,
                                   PANEL_LABEL_STRING,"  Random",
				   PANEL_CHOICE_STRINGS,
				   "OFF","ON",0,
                                   PANEL_NOTIFY_PROC, choice_options_proc,
                                   0);
    donebutton = panel_create_item(cache_panel, PANEL_BUTTON,
                                   PANEL_LABEL_IMAGE,
                                   panel_button_image(cache_panel,
                                   "PARAM OK!", 0, 0),
                                   PANEL_NOTIFY_PROC, done_proc,
                                   PANEL_LABEL_X, ATTR_COL(0),
                                   PANEL_LABEL_Y, ATTR_ROW(1), 
                                   0);
    clearbutton = panel_create_item(cache_panel, PANEL_BUTTON,
                                   PANEL_LABEL_IMAGE,
                                   panel_button_image(cache_panel,
                                   " CLEAR  ", 0, 0),
                                   PANEL_NOTIFY_PROC, clear_proc,
                                   PANEL_LABEL_X, ATTR_COL(32),
                                   PANEL_LABEL_Y, ATTR_ROW(1), 
                                   0);
    quitbutton = panel_create_item(cache_panel, PANEL_BUTTON,
                                   PANEL_LABEL_IMAGE,
                                   panel_button_image(cache_panel,
                                   "  QUIT  ", 0, 0),
                                   PANEL_NOTIFY_PROC, quit_proc,
                                   PANEL_LABEL_X, ATTR_COL(70),
                                   PANEL_LABEL_Y, ATTR_ROW(1), 
                                   0);
    window_fit_height(read_options_panel);                  
}




void create_cache_panel(){

    window_set(cache_panel, WIN_SHOW, TRUE, 0);
    window_set(read_options_panel, WIN_SHOW, TRUE, 0); 
    create_panel_items(); 

}



Panel_setting show_options_proc(item, event)
  Panel_item item;
  Event *event;
{
  char imagefile[60];
  int j;
  if (event_id(event) == '\03'){
       flag_break = TRUE; 
       window_return(NULL); 
       window_destroy(filename_frame);
       return; 
  }
  else if (event_id(event) == '\t') return(PANEL_NEXT);
  else if (event_id(event) == '\r'){
       strcpy(imagefile, (char *)panel_get_value(dirname));
       if (*imagefile != '\0')
	 strcat(imagefile, (char *)panel_get_value(imagename));
       else strcpy(imagefile, (char *)panel_get_value(imagename));
       strcpy(fileimage, imagefile);       
       strcpy(filedesc, imagefile); 
       if (((fpi = fopen(strcat(fileimage, ".ima"), "r")) == NULL)
           || ((fpd = fopen(strcat(filedesc, ".des"), "r")) == NULL)){
         panel_set_value(imagename, "\0");
       }
       else {
/* OLD DESCRIPTOR....
           fread(&descx, sizeof(descx), 1, fpd); 
*/
	    j = read_desc(fpd, &descx);
	    switch (j){
		case -1: write_erreur(104);
			return;
		case 0: write_erreur(103);
			return;
	    }	

	    fclose(fpd);
	    if ((descx.nligne < 0) || (descx.ncolonne < 0)){
	    sprintf(buf,"error reading graycount\n");
	    write_master(buf);
	    }
	    sprintf(buf, " \"%s\"\n", imagefile);
	    write_master(buf);
	    window_return(NULL);
	    window_destroy(filename_frame);
	    return;
	    
       }

  }      
}


void create_filename_panel(){


    filename_frame = window_create(frame, FRAME,
                                   WIN_X, 500, WIN_Y, 500,
 				   FRAME_NO_CONFIRM, TRUE,
                                   0);

    filename_panel = window_create(filename_frame, PANEL, 
                                   WIN_X, 0, WIN_Y, 0,
				   WIN_SHOW, TRUE,
                                   WIN_HEIGHT, 100,
				   WIN_WIDTH, 200,
                                   0);
    dirname = panel_create_item(filename_panel, PANEL_TEXT,
                                  PANEL_LABEL_STRING, "DirName: ",
				  PANEL_SHOW_ITEM, TRUE,
                                  PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
				  PANEL_NOTIFY_STRING, "\r\t\03",
                                  PANEL_VALUE_DISPLAY_LENGTH, 60,
				  PANEL_NOTIFY_PROC, show_options_proc,
				  0);
    imagename = panel_create_item(filename_panel, PANEL_TEXT,
				  PANEL_SHOW_ITEM, TRUE,
                                  PANEL_LABEL_STRING, "FileName: ",
                                  PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
				  PANEL_NOTIFY_STRING, "\r\t\03",
                                  PANEL_VALUE_DISPLAY_LENGTH, 60,
				  PANEL_NOTIFY_PROC, show_options_proc,
                                  0); 
    window_fit(filename_panel);
    window_fit(filename_frame);  
    window_loop(filename_frame);
}



void ask_plane_proc(item, event)
Panel_item item;
Event *event;
{
    char strval[20], strfac[15];

	sprintf(buf, mastertabs[151]);
	write_master(buf);
	fromto(FROM, DEFAUT);
        if (flag_break) return;
	sprintf(buf, "--> %d\n", index_image[0]);
	write_master(buf);
	if (dir_image[index_image[0]].image == NULL){
	   write_erreur(1);
	   return;
	}
	flag_plan_mem = TRUE;
	descx.type = dir_desc[index_image[0]].type;
	descx.nligne = dir_desc[index_image[0]].nligne;
	descx.ncolonne = dir_desc[index_image[0]].ncolonne;
	descx.maxi[0] = dir_desc[index_image[0]].mmax;
	descx.mini[0] = dir_desc[index_image[0]].mmin;
	descx.ecart[0] = dir_desc[index_image[0]].ecart;
	descx.mu[0] = dir_desc[index_image[0]].mu;
	if (!first_time_flag){
	    ffact = 0.1275;
	    sprintf(strfac, "%f", ffact);
	    panel_set_value(scalefac, strfac);
	    panel_set_value(X_min, "0");
	    sprintf(strval,"%d",descx.ncolonne);
	    panel_set_value(X_max,strval); 
	    panel_set_value(Y_min, "0");
	    sprintf(strval,"%d",descx.nligne);;
	    panel_set_value(Y_max, strval);
	    sprintf(strval,"%f",descx.mini[0]*ffact);
	    panel_set_value(Z_min, strval);
	    sprintf(strval,"%f",descx.maxi[0]*ffact);
	    panel_set_value(Z_max, strval);
	}
	first_time_flag = FALSE;

    
}


void ask_file_proc(item, event)
Panel_item item;
Event *event;
{
    char strval[20], strfac[15];

    sprintf(buf, mastertabs[151]);
    write_master(buf);
    create_filename_panel();
    if (flag_break) return;
    flag_plan_mem = FALSE;
    if (!first_time_flag){
	    ffact = 0.1275;
	    sprintf(strfac, "%f", ffact);
	    panel_set_value(scalefac, strfac);
	    panel_set_value(X_min, "0");
	    sprintf(strval,"%d",descx.ncolonne);
	    panel_set_value(X_max,strval); 
	    panel_set_value(Y_min, "0");
	    sprintf(strval,"%d",descx.nligne);;
	    panel_set_value(Y_max, strval);
	    sprintf(strval,"%f",descx.mini[0] * ffact);
	    panel_set_value(Z_min, strval);
	    sprintf(strval,"%f",descx.maxi[0] * ffact);
	    panel_set_value(Z_max, strval);
    }
    first_time_flag = FALSE;
}

						

 caddr_t proc_cache_file(m, mi)
 Menu m;
 Menu_item mi;
{
    Menu cachemenu;
    
    if (flag_bother){
	hproc_cache_file();
	return;
    }
    if (flag_help) hproc_cache_file();
    if (flag_in_cache){
	flag_in_cache = FALSE;
	return;
    }
    else flag_in_cache = TRUE;
    first_time_flag = TRUE;
    affcache_clear_flag = TRUE;
    ask_file_proc();
    if (flag_break) {
	flag_in_cache = FALSE;
	interruption();
	return;
    }
    cachemainframe = window_create(frame, FRAME, 
			      FRAME_LABEL, "param_cache",
			      FRAME_EMBOLDEN_LABEL, TRUE,
			      FRAME_SHOW_LABEL, TRUE,
			      WIN_X, 0, WIN_Y, 350,
			      WIN_SHOW, TRUE,
			      FRAME_NO_CONFIRM, TRUE,
                              0);
    cache_panel = window_create(cachemainframe, PANEL,
                                WIN_X, 0, WIN_Y, 0,
				WIN_HEIGHT, 50, 
                                PANEL_LAYOUT, PANEL_HORIZONTAL,
				WIN_SHOW, FALSE,
                                0);

    read_options_panel = window_create(cachemainframe, PANEL, 
				      WIN_BELOW, cache_panel,
                                      WIN_HEIGHT, 300,
				      WIN_SHOW, FALSE,
                                      0);
    cachemenu = (Menu) window_get(cachemainframe, WIN_MENU, 0);
    menu_set(cachemenu, MENU_REMOVE, 1,
		MENU_ACTION_ITEM, "quit*", quit_proc,
		0);
    window_set(cachemainframe, WIN_MENU, cachemenu, 0);
    create_cache_panel();
    affimageplane = panel_create_item(cache_panel, PANEL_BUTTON,
                                   PANEL_LABEL_IMAGE,
                                   panel_button_image(cache_panel,
                                   "new image", 0, 0),
                                   PANEL_NOTIFY_PROC, ask_file_proc,
				   PANEL_SHOW_ITEM, TRUE,
                                   PANEL_LABEL_X, ATTR_COL(0),
                                   PANEL_LABEL_Y, ATTR_ROW(0), 
                                   0);
    window_fit_height(cachemainframe); 
}




caddr_t proc_cache_imageplane(m, mi)
 Menu m;
 Menu_item mi;
{
        Menu cachemenu;

    if (flag_bother){
	hproc_cache_imageplane();
	return;
    }
    if (flag_help) hproc_cache_imageplane();
    if (flag_in_cache){
	flag_in_cache = FALSE;
	return;
    }
    else flag_in_cache = TRUE;
    first_time_flag = TRUE;
    affcache_clear_flag = TRUE;
    ask_plane_proc();
    if (flag_break) {
	flag_in_cache = FALSE;
	interruption();
	return;
    }
    cachemainframe = window_create(frame, FRAME, 
			      FRAME_LABEL, "param_cache",
			      WIN_X, 0, WIN_Y, 350,
			      FRAME_EMBOLDEN_LABEL, TRUE,
			      FRAME_SHOW_LABEL, TRUE,
			      FRAME_NO_CONFIRM, TRUE,
			      WIN_SHOW, TRUE,
                              0);
    cache_panel = window_create(cachemainframe, PANEL, 
                                WIN_X, 0, WIN_Y, 0,
				WIN_HEIGHT, 50,
                                PANEL_LAYOUT, PANEL_HORIZONTAL,
				WIN_SHOW, FALSE,
                                0);
    read_options_panel = window_create(cachemainframe, PANEL, 
				      WIN_BELOW, cache_panel,
                                      WIN_HEIGHT, 300,
				      WIN_SHOW, FALSE,
                                      0);
    cachemenu = (Menu) window_get(cachemainframe, WIN_MENU, 0);
    menu_set(cachemenu, MENU_REMOVE, 1,
		MENU_ACTION_ITEM, "quit*", quit_proc,
		0);
    window_set(cachemainframe, WIN_MENU, cachemenu, 0);
    create_cache_panel();
    affimageplane = panel_create_item(cache_panel, PANEL_BUTTON,
                                   PANEL_LABEL_IMAGE,
                                   panel_button_image(cache_panel,
                                   "another plane", 0, 0),
                                   PANEL_NOTIFY_PROC, ask_plane_proc,
				   PANEL_SHOW_ITEM, TRUE,
                                   PANEL_LABEL_X, ATTR_COL(0),
                                   PANEL_LABEL_Y, ATTR_ROW(0), 
                                   0);
    window_fit_height(cachemainframe);
}



