#include <stdio.h>
#include <strings.h>
#include <fcntl.h> 
#include <suntool/sunview.h>
#include <suntool/textsw.h>
#include <suntool/panel.h>
#include <suntool/scrollbar.h>
#include <sys/time.h>
#include "type.h"
#include "structure.h"
#include "global.h"

Window  mainframe, choicepanel, buttonpanel, textwin;
Panel_item Bedit, Bscan, Bquit, Bfile, Cquit, Cbin, Cbyt, Cint,
           Cshort, Cfloat, Ccmpcart, Ccmppol, Crgb, Cmessage,
           Ccreate, Cmodify, Csave, Cquit1, Cquit2;
char nomfile[30];
FILE *fp;
extern int Confirm();


int desc_scan_flag=FALSE;
int desc_edit_flag=FALSE;
int flag_newfile=FALSE;
int flag_edittool=FALSE;

void newfile_proc()
{
    panel_set(Cmessage, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set(Cbin, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set(Cbyt, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set(Cint, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set(Cshort, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set(Ccmppol, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set(Ccmpcart, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set(Cfloat, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set(Crgb, PANEL_SHOW_ITEM, TRUE, 0);
}


void editfile_proc(pitem, pevent)
Panel_item pitem ;
Event  *pevent;
{
  if (!desc_scan_flag){
    desc_edit_flag = TRUE;

    panel_set(Bscan, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set(Bquit, PANEL_SHOW_ITEM, FALSE, 0);
    strcpy(nomfile, (char *)panel_get_value(Bfile));
    if (strcmp (nomfile, "") != 0){
	strcat(nomfile, ".des");
	fp = fopen(nomfile, "r"); 
	if (fp == NULL) {
	    flag_newfile = TRUE;
	    newfile_proc();
	}
	else {
	    window_set(textwin, TEXTSW_FILE, nomfile, 0);
	    panel_set(Cquit1, PANEL_SHOW_ITEM, TRUE, 0);
	    panel_set(Csave, PANEL_SHOW_ITEM, TRUE, 0);
	}	
    }
	
  }
}

void selectfiledone_proc()
{
    panel_set(Cmessage, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set(Cbin, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set(Cbyt, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set(Cint, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set(Cshort, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set(Ccmppol, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set(Ccmpcart, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set(Cfloat, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set(Crgb, PANEL_SHOW_ITEM, FALSE, 0);
    window_set(textwin, TEXTSW_FILE, nomfile, 0);
    panel_set(Cquit1, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set(Csave, PANEL_SHOW_ITEM, TRUE, 0);
}



void saveedit_proc(pitem, pevent)
Panel_item pitem ;
Event  *pevent;
{
    flag_newfile = FALSE;
    desc_edit_flag = FALSE;
    textsw_store_file(textwin, nomfile, 0, 0); 
}


void quitedit_proc(pitem, pevent)
Panel_item pitem ;
Event  *pevent;
{
    char cmd[60];

    if (flag_newfile){
	fclose(fp);
	strcpy(cmd, "rm ");
        strcat(cmd,nomfile); 
	system(cmd);
    }
    flag_newfile = FALSE;
    desc_edit_flag = FALSE; 

    panel_set(Cquit1, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set(Csave, PANEL_SHOW_ITEM, FALSE, 0);
    textsw_reset(textwin, 0, 0);
    panel_set(Bscan, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set(Bquit, PANEL_SHOW_ITEM, TRUE, 0);

}


void quitscan_proc(pitem, pevent)
Panel_item pitem ;
Event  *pevent;
{
    desc_scan_flag = FALSE;
    panel_set(Cquit2, PANEL_SHOW_ITEM, FALSE, 0);
    window_set(textwin, TEXTSW_READ_ONLY,FALSE, 0); 
    panel_set(Bedit, PANEL_SHOW_ITEM, TRUE, 0);
    textsw_reset(textwin, 0, 0);


}

void quittool_proc(pitem, pevent)
Panel_item pitem ;
Event  *pevent;
{
    flag_newfile = FALSE;
    flag_edittool = FALSE;
    desc_scan_flag = FALSE;
    desc_edit_flag = FALSE;
    if (Confirm("quit desctool?") == 1){
	window_destroy(mainframe);	
    }
    
}

void scan_proc(pitem, pevent)
Panel_item pitem ;
Event  *pevent;
{
   FILE *fp1;

 if (!desc_edit_flag){
    strcpy(nomfile, (char *)panel_get_value(Bfile));
    if (strcmp (nomfile, "") != 0){
	 strcat(nomfile, ".des");

	 fp1 = fopen(nomfile,"r");
	 if (fp1 != NULL){
	     desc_scan_flag = TRUE;
	     fclose(fp1);
	     panel_set(Cquit2, PANEL_SHOW_ITEM, TRUE, 0);
	     panel_set(Bedit, PANEL_SHOW_ITEM, FALSE, 0);
	     window_set(textwin, TEXTSW_FILE, nomfile, 0);
	     window_set(textwin, TEXTSW_READ_ONLY,TRUE, 0); 
	 }
	 
    }
 }
}


static void selectfile_proc(pitem, pevent)
Panel_item pitem ;
Event  *pevent;
{
  struct timeval tp;
  struct timezone tzp;
  char *date;
  long clock;

    gettimeofday(&tp, &tzp);
    clock = tp.tv_sec;
    date= (char *) calloc(26, sizeof(char));
    strcpy (date," "); 
    strcat(date,asctime (localtime(&clock)));
    fclose(fp);
    fp=fopen(nomfile, "w");
    if (pitem == Cbyt) fprintf(fp,"Type: byte\nRow-Count:  \nColumn-Count:  \nMaximum[0]: \nMinimum[0]:  \nAvg-Value[0]:  \nStd-Deviation[0]:  \nDate:%sComments: \n\n",date);

    else if (pitem == Cbin) fprintf(fp,"Type: binary\nRow-Count:  \nColumn-Count:  \nMaximum[0]:  \nMinimum[0]:  \nAvg-Value[0]:  \nStd-Deviation[0]:  \nDate:%sComments:  \n\n",date  );

    else if (pitem == Cint) fprintf(fp,"Type: int\nRow-Count:  \nColumn-Count:  \nMaximum[0]:  \nMinimum[0]:  \nAvg-Value[0]:  \nStd-Deviation[0]:  \nDate:%sComments:  \n\n",date  );  

    else if (pitem == Cshort) fprintf(fp,"Type: short\nRow-Count:  \nColumn-Count:  \nMaximum[0]:  \nMinimum[0]:  \nAvg-Value[0]:  \nStd-Deviation[0]:  \nDate:%sComments:  \n\n",date  ); 
 
    else if (pitem == Cfloat) fprintf(fp,"Type: float\nRow-Count:  \nColumn-Count:  \nMaximum[0]:  \nMinimum[0]:  \nAvg-Value[0]:  \nStd-Deviation[0]:  \nDate:%sComments:  \n\n",date  ); 

    else if (pitem == Ccmpcart) fprintf(fp,"Type: complex-cartesian\nRow-Count:  \nColumn-Count:  \nMaximum[0]:  \nMaximum[1]:  \nMinimum[0]:  \nMinimum[1]:  \nAvg-Value[0]:  \nAvg-Value[1]:  \nStd-Deviation[0]:  \nStd-Deviation[1]: \nDate:%sComments:  \n\n",date  ); 

    else if (pitem == Ccmpcart) fprintf(fp,"Type: complex-cartesian\nRow-Count:  \nColumn-Count:  \nMaximum[0]:  \nMaximum[1]:  \nMinimum[0]:  \nMinimum[1]:  \nAvg-Value[0]:  \nAvg-Value[1]:  \nStd-Deviation[0]:  \nStd-Deviation[1]:  \nDate:%sComments:  \n\n", date  );
 
    else if (pitem == Ccmppol) fprintf(fp,"Type: complex-polar\nRow-Count:  \nColumn-Count:  \nMaximum[0]:  \nMaximum[1]:  \nMinimum[0]:  \nMinimum[1]:  \nAvg-Value[0]:  \nAvg-Value[1]:  \nStd-Deviation[0]:  \nStd-Deviation[1]:  \nDate:%sComments:  \n\n",date  );

    else if (pitem == Crgb) fprintf(fp,"Type: rgb\nRow-Count:  \nColumn-Count:  \nMaximum[0]:  \nMaximum[1]:  \nMaximum[2]:  \nMinimum[0]:  \nMinimum[1]:  \nMinimum[2]:  \nAvg-Value[0]:  \nAvg-Value[1]:  \nAvg-Value[2]:  \nStd-Deviation[0]:  \nStd-Deviation[1]:  \nStd-Deviation[2]:  \nDate:%sComments:  \n\n",date  );

     fclose(fp); 
     selectfiledone_proc();
}

void create_pitems(){
    Bfile = panel_create_item(buttonpanel, PANEL_TEXT,
                              PANEL_LABEL_STRING, "File:",
                              PANEL_VALUE_DISPLAY_LENGTH, 30,
                              0);
    Bedit = panel_create_item(buttonpanel, PANEL_BUTTON,
                              PANEL_LABEL_IMAGE,
			      panel_button_image(buttonpanel, 
                              "EDIT DESC", 0, 0),
                              PANEL_NOTIFY_PROC, editfile_proc,
                              0);
    Bscan = panel_create_item(buttonpanel, PANEL_BUTTON,
                              PANEL_LABEL_IMAGE,
			      panel_button_image(buttonpanel, 
                              "SHOW DESC", 0, 0),
                              PANEL_NOTIFY_PROC, scan_proc,
                              0);
    Bquit = panel_create_item(buttonpanel, PANEL_BUTTON,
                              PANEL_LABEL_IMAGE,
			      panel_button_image(buttonpanel, 
                              "QUIT TOOL", 0, 0),
                              PANEL_NOTIFY_PROC, quittool_proc,
                              0);
    Csave = panel_create_item(choicepanel, PANEL_BUTTON,
                              PANEL_LABEL_IMAGE,
			      panel_button_image(choicepanel, 
                              "SAVE", 0, 0), 
			      PANEL_SHOW_ITEM, FALSE,
                              PANEL_NOTIFY_PROC, saveedit_proc,
                              0);
    Cquit1 = panel_create_item(choicepanel, PANEL_BUTTON,
                              PANEL_LABEL_IMAGE,
			      panel_button_image(choicepanel, 
                              "QUIT EDIT", 0, 0), 
			      PANEL_SHOW_ITEM, FALSE,
                              PANEL_NOTIFY_PROC, quitedit_proc,
                              0);
    Cquit2 = panel_create_item(choicepanel, PANEL_BUTTON,
                              PANEL_LABEL_IMAGE,
			      panel_button_image(choicepanel, 
                              "QUIT SHOW", 0, 0), 
			      PANEL_SHOW_ITEM, FALSE,
                              PANEL_NOTIFY_PROC, quitscan_proc,
                              0);
    Cmessage = panel_create_item(choicepanel, PANEL_MESSAGE,
				PANEL_LABEL_X, ATTR_COL(0),
				PANEL_LABEL_Y, ATTR_ROW(0),
				PANEL_LABEL_STRING, paneltabs[501],
				PANEL_SHOW_ITEM, FALSE,
				0); 
    Cbin = panel_create_item(choicepanel, PANEL_BUTTON,
                              PANEL_LABEL_IMAGE,
			      panel_button_image(choicepanel, 
                              "binary", 0, 0),
			      PANEL_LABEL_X, ATTR_COL(0),
			      PANEL_LABEL_Y, ATTR_ROW(1),
                              PANEL_SHOW_ITEM, FALSE,
                              PANEL_NOTIFY_PROC, selectfile_proc,
                              0);
    Cbyt = panel_create_item(choicepanel, PANEL_BUTTON,
                              PANEL_LABEL_IMAGE,
			      panel_button_image(choicepanel, 
                              "byte", 0, 0), PANEL_SHOW_ITEM, FALSE,
                              PANEL_NOTIFY_PROC, selectfile_proc,
                              0);
    Cint = panel_create_item(choicepanel, PANEL_BUTTON,
                              PANEL_LABEL_IMAGE,
			      panel_button_image(choicepanel, 
                              "int", 0, 0), 
                              PANEL_SHOW_ITEM, FALSE,
                              PANEL_NOTIFY_PROC, selectfile_proc,
                              0);
    Cshort = panel_create_item(choicepanel, PANEL_BUTTON,
                              PANEL_LABEL_IMAGE,
			      panel_button_image(choicepanel, 
			      "short", 0, 0), 
			      PANEL_SHOW_ITEM, FALSE,
                              PANEL_NOTIFY_PROC, selectfile_proc,
                              0);    
    Cfloat = panel_create_item(choicepanel, PANEL_BUTTON,
                              PANEL_LABEL_IMAGE,
			      panel_button_image(choicepanel, 
                              "float", 0, 0), 
			      PANEL_SHOW_ITEM, FALSE,
                              PANEL_NOTIFY_PROC, selectfile_proc,
                              0);
    Ccmpcart = panel_create_item(choicepanel, PANEL_BUTTON,
                              PANEL_LABEL_IMAGE,
			      panel_button_image(choicepanel, 
                              "comp-cart", 0, 0), 
                              PANEL_SHOW_ITEM, FALSE,
                              PANEL_NOTIFY_PROC, selectfile_proc,
                              0);
    Ccmppol = panel_create_item(choicepanel, PANEL_BUTTON,
                              PANEL_LABEL_IMAGE,
			      panel_button_image(choicepanel, 
                              "comp-pol", 0, 0), 
			      PANEL_SHOW_ITEM, FALSE,
                              PANEL_NOTIFY_PROC, selectfile_proc,
                              0);
    Crgb = panel_create_item(choicepanel, PANEL_BUTTON,
                              PANEL_LABEL_IMAGE,
			      panel_button_image(choicepanel, 
                              "rgb", 0, 0), 
			      PANEL_SHOW_ITEM, FALSE,
                              PANEL_NOTIFY_PROC, selectfile_proc,
                              0);


     window_fit_height(buttonpanel);
     window_fit_height(choicepanel);

}


void create_edit_frame(){
    buttonpanel = window_create(mainframe, PANEL, 0);
    choicepanel = window_create(mainframe, PANEL, 
                                WIN_BELOW, buttonpanel,
                                WIN_X, 0, WIN_Y, 32, 0); 
    create_pitems();

    textwin = window_create(mainframe, TEXTSW, 
			    TEXTSW_MENU, NULL,
                            TEXTSW_STORE_SELF_IS_SAVE, TRUE, 0);
   flag_newfile = FALSE; 
   desc_edit_flag = FALSE; 
   desc_scan_flag = FALSE; 
}


caddr_t proc_desctool(m, mi)
Menu m;
Menu_item mi;
{
    Menu desctoolmenu;


    if (flag_bother){
	hproc_desctool();
	return;
    }
    if (flag_help) hproc_desctool();
    if (flag_edittool) return;
    flag_edittool = TRUE;
    mainframe = window_create(frame, FRAME, FRAME_LABEL, "desc tool",
			      WIN_X, 0, WIN_Y, 400,
			      WIN_COLUMNS, 80, WIN_ROWS, 20, 
			      FRAME_NO_CONFIRM, TRUE,
			      WIN_SHOW, TRUE,
                             0);
    desctoolmenu = (Menu) window_get(mainframe, WIN_MENU, 0);
    menu_set(desctoolmenu, MENU_REMOVE, 1,
		MENU_ACTION_ITEM, "quit*", quittool_proc, 0);
   window_set(mainframe, WIN_MENU, desctoolmenu, 0);
   create_edit_frame();

}


/* read from the ASCII '.desc' file and update the struct for
   descriptor
*/


 int read_desc(fp, desc_to_init)
FILE *fp;
struct description *desc_to_init;
{

    char carlu1[26], carlu2[26], line[80];

    short typ;
    int i, j, nbval, nombre, index;
    int row_initialized, column_initialized, type_initialized;

 struct description *buf, buf2; 

    buf = (struct description *) calloc(1,sizeof (struct description));    
    j=fscanf(fp,"%s",carlu1);
    i=0;
    row_initialized = column_initialized = type_initialized = FALSE;
    while (j != EOF){

       if (strcmp(carlu1, "Type:")==0){
          j=fscanf(fp,"%s",carlu1 );

          if (strcmp(carlu1,"binary")== 0) buf->type = -1;
          else if (strcmp(carlu1,"byte")==0) buf->type = 0;
          else if (strcmp(carlu1,"int")==0) buf->type = 2;
          else if (strcmp(carlu1,"short")==0) buf->type = 1;
          else if (strcmp(carlu1,"float")==0) buf->type = 3;
          else if (strcmp(carlu1,"cartesian-complex")==0) buf->type = 4;
          else if (strcmp(carlu1,"cartesian-polar")==0) buf->type = 5;
          else  buf->type = 6;
	  type_initialized = TRUE;
       } 
       else if (strcmp(carlu1,"Row-Count:")==0){
              j=fscanf(fp,"%hd",&(buf->nligne) ); 
		row_initialized = TRUE;
       }
       else if (strcmp(carlu1,"Column-Count:")==0){
              j=fscanf(fp,"%hd",&(buf->ncolonne) ); 
		column_initialized = TRUE;
       }
       else if (strcmp(carlu1,"Date:")==0){
              if (strcmp(fgets(buf->date, 26, fp ), "\n"))
		  strcpy(buf->date, "\0"); 
       }
       else if (strcmp(carlu1,"Comments:")==0){
              j=fscanf(fp,"%s",carlu2 );
              while (j != EOF){
                   strcat(buf->comment , " ");  
                   strcat(buf->comment , carlu2);  
                   j=fscanf(fp,"%s",carlu2 );
	      }
       }
       else if (strcmp(carlu1,"Std-Deviation[0]:")==0){
              j=fscanf(fp,"%f\n", &(buf->ecart[0]) );
       }
       else if (strcmp(carlu1,"Std-Deviation[1]:")==0){
              j=fscanf(fp,"%f", &(buf->ecart[1]) );
       }
       else if (strcmp(carlu1,"Std-Deviation[2]:")==0){
              j=fscanf(fp,"%f", &(buf->ecart[2]) );
       }
       else if (strcmp(carlu1,"Std-Deviation[3]:")==0){
              j=fscanf(fp,"%f", &(buf->ecart[3]) );
       }
       else if (strcmp(carlu1,"Std-Deviation[4]:")==0){
              j=fscanf(fp,"%f", &(buf->ecart[4]) );
       }
       else if (strcmp(carlu1,"Std-Deviation[5]:")==0){
              j=fscanf(fp,"%f", &(buf->ecart[5]) );
       }
       else if (strcmp(carlu1,"Avg-Value[0]:")==0){
              j=fscanf(fp, "%f", &(buf->mu[0]) );
       }
       else if (strcmp(carlu1,"Avg-Value[1]:")==0){
              j=fscanf(fp,"%f", &(buf->mu[1]) );
       }
       else if (strcmp(carlu1,"Avg-Value[2]:")==0){
              j=fscanf(fp,"%f", &(buf->mu[2]) );
       }
       else if (strcmp(carlu1,"Avg-Value[3]:")==0){
              j=fscanf(fp,"%f", &(buf->mu[3]) );
       }
       else if (strcmp(carlu1,"Avg-Value[4]:")==0){
              j=fscanf(fp,"%f", &(buf->mu[4]) );
       }
       else if (strcmp(carlu1,"Avg-Value[5]:")==0){
              j=fscanf(fp,"%f", &(buf->mu[5]) );
       }
       else if (strcmp(carlu1,"Avg-Value[6]:")==0){
              j=fscanf(fp,"%f", &(buf->mu[6]) );
       }
       else if (strcmp(carlu1,"Maximum[0]:")==0){
              j=fscanf(fp,"%f", &(buf->maxi[0]) );
       }
       else if (strcmp(carlu1,"Maximum[1]:")==0){
              j=fscanf(fp,"%f", &(buf->maxi[1]) );
       }
       else if (strcmp(carlu1,"Maximum[2]:")==0){
              j=fscanf(fp,"%f", &(buf->maxi[2]) );
       }
       else if (strcmp(carlu1,"Maximum[3]:")==0){
              j=fscanf(fp,"%f", &(buf->maxi[3]) );
       }
       else if (strcmp(carlu1,"Maximum[4]:")==0){
              j=fscanf(fp,"%f", &(buf->maxi[4]) );
       }
       else if (strcmp(carlu1,"Maximum[5]:")==0){
              j=fscanf(fp,"%f", &(buf->maxi[5]) );
       }
       else if (strcmp(carlu1,"Minimum[0]:")==0){
              j=fscanf(fp,"%f", &(buf->mini[0]) );
       }
       else if (strcmp(carlu1,"Minimum[1]:")==0){
              j=fscanf(fp,"%f", &(buf->mini[1]) );
       }
       else if (strcmp(carlu1, "Minimum[2]:")==0){
              j=fscanf(fp,"%f", &(buf->mini[2]) );
       }
       else if (strcmp(carlu1,"Minimum[3]:")==0){
              j=fscanf(fp,"%f", &(buf->mini[3]) );
       }
       else if (strcmp(carlu1,"Minimum[4]:")==0){
              j=fscanf(fp,"%f", &(buf->mini[4]) );
       }
       else if (strcmp(carlu1,"Minimum[5]:")==0){
              j=fscanf(fp,"%f", &(buf->mini[5]) );
       }
       else return(0);

       j=fscanf(fp,"%s",carlu1);

    }
    if ((!row_initialized) || (!column_initialized) || (!type_initialized))
    return(-1);
   *desc_to_init = *buf;
   cfree(buf);
   return(1);
}

/* 
Routine which writes on to the descriptor file, the descriptor info is conatined in buf and the file pointer of the file is 'fp'
*/


int write_desc(fp, buf)
 FILE *fp;
struct description buf;
{
 char nomf1[25];
 short typ;
    typ=(int)(buf).type;
    switch (typ){
      case -1: fprintf(fp,"Type: binary\n");
               fprintf(fp,"Row-Count: %d\n",(int)(buf).nligne);
               fprintf(fp,"Column-Count: %d\n",(int)(buf).ncolonne);
               fprintf(fp,"Maximum[0]: %8f\n",(float)(buf).maxi[0]);
               fprintf(fp,"Minimum[0]: %8f\n",(float)(buf).mini[0]);
               fprintf(fp,"Avg-Value[0]: %8f\n",(float)(buf).mu[0]);
               fprintf(fp,"Std-Deviation[0]: %8f\n",(float)(buf).ecart[0]);
               fprintf(fp,"Date: %s\n",(buf).date);
               fprintf(fp, "Comments: %s\n",(buf).comment); 
               break;
       case 0: fprintf(fp,"Type: byte\n");
               fprintf(fp,"Row-Count: %d\n",(int)(buf).nligne);
               fprintf(fp,"Column-Count: %d\n",(int)(buf).ncolonne);
               fprintf(fp,"Maximum[0]: %8f\n",(float)(buf).maxi[0]);
               fprintf(fp,"Minimum[0]: %8f\n",(float)(buf).mini[0]);
               fprintf(fp,"Avg-Value[0]: %8f\n",(float)(buf).mu[0]);
               fprintf(fp,"Std-Deviation[0]: %8f\n",(float)(buf).ecart[0]);
               fprintf(fp,"Date: %s\n",(buf).date);

               fprintf(fp, "Comments: %s\n",(buf).comment);
               break;
       case 1: fprintf(fp,"Type: short\n"); 
               fprintf(fp,"Row-Count: %d\n",(int)(buf).nligne);
               fprintf(fp,"Column-Count: %d\n",(int)(buf).ncolonne);
               fprintf(fp,"Maximum[0]: %8f\n",(float)(buf).maxi[0]);
               fprintf(fp,"Minimum[0]: %8f\n",(float)(buf).mini[0]);
               fprintf(fp,"Avg-Value[0]: %8f\n",(float)(buf).mu[0]);
               fprintf(fp,"Std-Deviation[0]: %8f\n",(float)(buf).ecart[0]);
               fprintf(fp,"Date: %s\n",(buf).date);
               fprintf(fp, "Comments: %s\n",(buf).comment); 
               break;
       case 2: fprintf(fp,"Type: int\n");
               fprintf(fp,"Row-Count: %d\n",(int)(buf).nligne);
               fprintf(fp,"Column-Count: %d\n",(int)(buf).ncolonne); 
               fprintf(fp,"Maximum[0]: %8f\n",(float)(buf).maxi[0]);
               fprintf(fp,"Minimum[0]: %8f\n",(float)(buf).mini[0]);
               fprintf(fp,"Avg-Value[0]: %8f\n",(float)(buf).mu[0]);
               fprintf(fp,"Std-Deviation[0]: %8f\n",(float)(buf).ecart[0]);
               fprintf(fp,"Date: %s\n",(buf).date);
               fprintf(fp, "Comments: %s\n",(buf).comment);
               break;
       case 3: fprintf(fp,"Type: float\n");
               fprintf(fp,"Row-Count: %d\n",(int)(buf).nligne);
               fprintf(fp,"Column-Count: %d\n",(int)(buf).ncolonne);
               fprintf(fp,"Maximum[0]: %8f\n",(float)(buf).maxi[0]);
               fprintf(fp,"Minimum[0]: %8f\n",(float)(buf).mini[0]);
               fprintf(fp,"Avg-Value[0]: %8f\n",(float)(buf).mu[0]);
               fprintf(fp,"Std-Deviation[0]: %8f\n",(float)(buf).ecart[0]);
               fprintf(fp,"Date: %s\n",(buf).date);
               fprintf(fp, "Comments: %s\n",(buf).comment);
               break;
       case 4: fprintf(fp,"Type: cartesian-complex\n");
               fprintf(fp,"Row-Count: %d\n",(int)(buf).nligne);
               fprintf(fp,"Column-Count: %d\n",(int)(buf).ncolonne);
               fprintf(fp,"Minimum[0]: %8f\n",(float)(buf).mini[0]);
               fprintf(fp,"Minimum[1]: %8f\n",(float)(buf).mini[1]);
               fprintf(fp,"Maximum[0]: %8f\n",(float)(buf).maxi[0]);
               fprintf(fp,"Maximum[1]: %8f\n",(float)(buf).maxi[1]);
               fprintf(fp,"Avg-Value[0]: %8f\n",(float)(buf).mu[0]);
               fprintf(fp,"Avg-Value[1]: %8f\n",(float)(buf).mu[1]);
               fprintf(fp,"Std-Deviation[0]: %8f\n",(float)(buf).ecart[0]);
               fprintf(fp,"Std-Deviation[1]: %8f\n",(float)(buf).ecart[1]);
               fprintf(fp,"Date: %s\n",(buf).date);
               fprintf(fp, "Comments: %s\n",(buf).comment);
               break;
       case 5: fprintf(fp,"Type: polar-complex\n");
               fprintf(fp,"Row-Count: %d\n",(int)(buf).nligne);
               fprintf(fp,"Column-Count: %d\n",(int)(buf).ncolonne);
               fprintf(fp,"Minimum[0]: %8f\n",(float)(buf).mini[0]);
               fprintf(fp,"Minimum[1]: %8f\n",(float)(buf).mini[1]);
               fprintf(fp,"Maximum[0]: %8f\n",(float)(buf).maxi[0]);
               fprintf(fp,"Maximum[1]: %8f\n",(float)(buf).maxi[1]);
               fprintf(fp,"Avg-Value[0]: %8f\n",(float)(buf).mu[0]);
               fprintf(fp,"Avg-Value[1]: %8f\n",(float)(buf).mu[1]);
               fprintf(fp,"Std-Deviation[0]: %8f\n",(float)(buf).ecart[0]);
               fprintf(fp,"Std-Deviation[1]: %8f\n",(float)(buf).ecart[1]);  
               fprintf(fp,"Date: %s\n",(buf).date);
               fprintf(fp, "Comments: %s\n",(buf).comment);
               break;
       case 6: fprintf(fp,"Type: rgb\n");
               fprintf(fp,"Row-Count: %d\n",(int)(buf).nligne);
               fprintf(fp,"Column-Count: %d\n",(int)(buf).ncolonne);
               fprintf(fp,"Minimum[0]: %8f\n",(float)(buf).mini[0]);
               fprintf(fp,"Minimum[1]: %8f\n",(float)(buf).mini[1]);
               fprintf(fp,"Minimum[2]: %8f\n",(float)(buf).mini[2]);
               fprintf(fp,"Minimum[3]: %8f\n",(float)(buf).mini[3]);
               fprintf(fp,"Minimum[4]: %8f\n",(float)(buf).mini[4]);
               fprintf(fp,"Minimum[5]: %8f\n",(float)(buf).mini[5]);
               fprintf(fp,"Maximum[0]: %8f\n",(float)(buf).maxi[0]);
               fprintf(fp,"Maximum[1]: %8f\n",(float)(buf).maxi[1]);
               fprintf(fp,"Maximum[2]: %8f\n",(float)(buf).maxi[2]);
               fprintf(fp,"Maximum[3]: %8f\n",(float)(buf).maxi[3]);
               fprintf(fp,"Maximum[4]: %8f\n",(float)(buf).maxi[4]);
               fprintf(fp,"Maximum[5]: %8f\n",(float)(buf).maxi[5]);
               fprintf(fp,"Avg-Value[0]: %8f\n",(float)(buf).mu[0]);
               fprintf(fp,"Avg-Value[1]: %8f\n",(float)(buf).mu[1]);
               fprintf(fp,"Avg-Value[2]: %8f\n",(float)(buf).mu[2]);
               fprintf(fp,"Avg-Value[3]: %8f\n",(float)(buf).mu[3]);
               fprintf(fp,"Avg-Value[4]: %8f\n",(float)(buf).mu[4]);
               fprintf(fp,"Avg-Value[5]: %8f\n",(float)(buf).mu[5]);
               fprintf(fp,"Std-Deviation[0]: %8f\n",(float)(buf).ecart[0]);
               fprintf(fp,"Std-Deviation[1]: %8f\n",(float)(buf).ecart[1]);
               fprintf(fp,"Std-Deviation[2]: %8f\n",(float)(buf).ecart[2]);
               fprintf(fp,"Std-Deviation[3]: %8f\n",(float)(buf).ecart[3]);
               fprintf(fp,"Std-Deviation[4]: %8f\n",(float)(buf).ecart[4]);
               fprintf(fp,"Std-Deviation[5]: %8f\n",(float)(buf).ecart[5]);  
               fprintf(fp,"Date: %s\n",(buf).date);
               fprintf(fp, "Comments: %s\n",(buf).comment);  
               break;
    }
    fclose(fp);
return(1);
}





