/* SCCS @(#)reg_growingTOOL.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                   reg_growingTOOL.layout.c                           */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   reg_growingTOOL.layout.c                            */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Region Growing Tool)                     */
/*                                                                      */
/* AUTHORS      :   Rene Lutz, Marianne Logean                          */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "reg_growingTOOL.layout.h"
#include "libwidgets/widgetstructure.h"
#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;
extern Widget gLabowidget;

extern Colormap init_color_lin();
extern void install_win_colormap();

/********************************************************
/   Creation Function for Segmentation
/*******************************************************/

Widget
build_Segmentation(reg_growing_widget, tab_widgets)
    Widget reg_growing_widget;
    xs_struc_reg_growing *tab_widgets;
{
        Widget Frame_Segmentation;
	Widget Segmentation_bb;
	Widget Segmentation_label;
	Widget RadioBox;
	Widget RadioButton_1;
	Widget RadioButton_2;
	Widget RadioButton_3;
	Widget RadioButton_4;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Frame_Segmentation Widget */ 

	Frame_Segmentation = 
	  XmCreateFrame(reg_growing_widget,"Frame_Segmentation", NULL, 0);

	/* Creating Segmentation_bb Widget */ 

	n = 0;
	XtSetArg(args[n],XmNwidth, 80); n++;
	XtSetArg(args[n],XmNheight, 70); n++;

	Segmentation_bb = 
	     XmCreateBulletinBoard(Frame_Segmentation,"Tolerance_bb",args,n);

  	XtManageChild(Segmentation_bb);

	/* Creating Segmentation_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx, 10); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[570],
			XmSTRING_DEFAULT_CHARSET)); n++;
	
	Segmentation_label = 
	  XmCreateLabel(Segmentation_bb,"Segmentation_label",args,n);

	XtManageChild(Segmentation_label);

	/* Creating RadioBox Widget */ 

	n = 0;
	XtSetArg(args[n],XmNy, 28); n++;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNnumColumns,2); n++;

	RadioBox = XmCreateRadioBox(Segmentation_bb,"RadioBox",args,n);

  	XtManageChild(RadioBox);

	/* Creating RadioButton_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[571],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,True); n++;
	
	RadioButton_1 = XmCreateToggleButton(RadioBox,"RadioButton_1",args,n);
        tab_widgets->tabsegmentation[0] = RadioButton_1;

	/* Adding Callbacks for RadioButton_1 */ 

	XtAddCallback(RadioButton_1,XmNvalueChangedCallback,
			Choose_Segmentation, tab_widgets);

	XtManageChild(RadioButton_1);

	/* Creating RadioButton_2 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[572],
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_2 = XmCreateToggleButton(RadioBox,"RadioButton_2",args,n);

        tab_widgets->tabsegmentation[1] = RadioButton_2;

	/* Adding Callbacks for RadioButton_2 */ 

	XtAddCallback(RadioButton_2,XmNvalueChangedCallback,
			Choose_Segmentation, tab_widgets);

	XtManageChild(RadioButton_2);


	/* Creating RadioButton_3 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[573],
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_3 = XmCreateToggleButton(RadioBox,"RadioButton_3",args,n);
        tab_widgets->tabsegmentation[2] = RadioButton_3;

	/* Adding Callbacks for RadioButton_3 */ 

	XtAddCallback(RadioButton_3,XmNvalueChangedCallback,
			Choose_Segmentation, tab_widgets);

	XtManageChild(RadioButton_3);


	/* Creating RadioButton_4 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[574],
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_4 = 
	   XmCreateToggleButton(RadioBox,"RadioButton_4",args,n);
        tab_widgets->tabsegmentation[3] = RadioButton_4;

	/* Adding Callbacks for RadioButton_4 */ 

	XtAddCallback(RadioButton_4,XmNvalueChangedCallback,
			Choose_Segmentation, tab_widgets);

	XtManageChild(RadioButton_4);

	return (Frame_Segmentation);
}


/********************************************************
/   Creation Function for Connexity
/*******************************************************/

Widget
build_Connexity(reg_growing_widget, tab_widgets)
    Widget reg_growing_widget;
    xs_struc_reg_growing *tab_widgets;
{
        Widget Frame_Connexity;
	Widget Connexity_bb;
	Widget Connexity_label;
	Widget RadioBox;
	Widget RadioButton_1;
	Widget RadioButton_2;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Frame_Connexity Widget */ 

	Frame_Connexity = 
	  XmCreateFrame(reg_growing_widget,"Frame_Connexity", NULL, 0);

	/* Creating Connexity_bb Widget */ 

	n = 0;
	XtSetArg(args[n],XmNwidth, 80); n++;
	XtSetArg(args[n],XmNheight, 70); n++;

	Connexity_bb = 
	     XmCreateBulletinBoard(Frame_Connexity,"Connexity_bb",args,n);

  	XtManageChild(Connexity_bb);

	/* Creating Connexity_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx, 10); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[575],
			XmSTRING_DEFAULT_CHARSET)); n++;
	
	Connexity_label = 
	  XmCreateLabel(Connexity_bb,"Connexity_label",args,n);

	XtManageChild(Connexity_label);

	/* Creating RadioBox Widget */ 

	n = 0;
	XtSetArg(args[n],XmNy, 28); n++;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNnumColumns,1); n++;

	RadioBox = XmCreateRadioBox(Connexity_bb,"RadioBox",args,n);

  	XtManageChild(RadioBox);

	/* Creating RadioButton_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("4",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,True); n++;
	
	RadioButton_1 = XmCreateToggleButton(RadioBox,"RadioButton_1",args,n);
        tab_widgets->tabconnexity[0] = RadioButton_1;

	/* Adding Callbacks for RadioButton_1 */ 

	XtAddCallback(RadioButton_1,XmNvalueChangedCallback,
			Choose_Connexity, tab_widgets);

	XtManageChild(RadioButton_1);

	/* Creating RadioButton_2 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("8",
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_2 = XmCreateToggleButton(RadioBox,"RadioButton_2",args,n);

        tab_widgets->tabconnexity[1] = RadioButton_2;

	/* Adding Callbacks for RadioButton_2 */ 

	XtAddCallback(RadioButton_2,XmNvalueChangedCallback,
			Choose_Connexity, tab_widgets);

	XtManageChild(RadioButton_2);


	return (Frame_Connexity);
}


/********************************************************
/   Creation Function for Tolerance
/*******************************************************/

Widget
build_Tolerance(reg_growing_widget, tab_widgets)
    Widget reg_growing_widget;
    xs_struc_reg_growing *tab_widgets;
{
        Widget Frame_Tolerance;
	Widget Tolerance_bb;
	Widget Tolerance_label;
	Widget Tolerance_text;
        char *valuestring;

	Arg args[MAX_ARGS];
	int n;

	/* Creating Frame_Tolerance Widget */ 

	Frame_Tolerance = 
	  XmCreateFrame(reg_growing_widget,"Frame_Tolerance", NULL, 0);

	/* Creating Tolerance_bb Widget */ 

	n = 0;
	XtSetArg(args[n],XmNwidth, 80); n++;
	XtSetArg(args[n],XmNheight, 70); n++;

	Tolerance_bb = 
	     XmCreateBulletinBoard(Frame_Tolerance,"Tolerance_bb",args,n);

  	XtManageChild(Tolerance_bb);

	/* Creating Tolerance_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx, 10); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[588],
			XmSTRING_DEFAULT_CHARSET)); n++;
	
	Tolerance_label = 
	   XmCreateLabel(Tolerance_bb,"Tolerance_label",args,n);

	XtManageChild(Tolerance_label);

	/* Creating Tolerance_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx, 30); n++;
	XtSetArg(args[n],XmNy, 30); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	Tolerance_text = 
	    XmCreateText(Tolerance_bb,"Tolerance_text",args,n);

	valuestring = (char *) malloc (4);

	sprintf (valuestring, "%d", 10);
	XmTextSetString (Tolerance_text, valuestring);

        tab_widgets->tolerance = Tolerance_text;

	XtManageChild(Tolerance_text);

	return (Frame_Tolerance);
}





/********************************************************
/   Creation Function for Trace
/*******************************************************/

Widget
build_Trace(reg_growing_widget, tab_widgets)
    Widget reg_growing_widget;
    xs_struc_reg_growing *tab_widgets;
{
        Widget Frame_Trace;
	Widget Trace_bb;
	Widget Trace_label;
	Widget RadioBox;
	Widget RadioButton_1;
	Widget RadioButton_2;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Frame_Trace Widget */ 

	Frame_Trace = 
	  XmCreateFrame(reg_growing_widget,"Frame_Trace", NULL, 0);

	/* Creating Trace_bb Widget */ 

	n = 0;
	XtSetArg(args[n],XmNwidth, 80); n++;
	XtSetArg(args[n],XmNheight, 70); n++;

	Trace_bb = 
	     XmCreateBulletinBoard(Frame_Trace,"Trace_bb",args,n);

  	XtManageChild(Trace_bb);

	/* Creating Trace_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx, 10); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[576],
			XmSTRING_DEFAULT_CHARSET)); n++;
	
	Trace_label = 
	  XmCreateLabel(Trace_bb,"Trace_label",args,n);

	XtManageChild(Trace_label);

	/* Creating RadioBox Widget */ 

	n = 0;
	XtSetArg(args[n],XmNy, 28); n++;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNnumColumns,1); n++;

	RadioBox = XmCreateRadioBox(Trace_bb,"RadioBox",args,n);

  	XtManageChild(RadioBox);

	/* Creating RadioButton_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[578],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,True); n++;
	
	RadioButton_1 = XmCreateToggleButton(RadioBox,"RadioButton_1",args,n);
        tab_widgets->tabtrace[0] = RadioButton_1;

	/* Adding Callbacks for RadioButton_1 */ 

	XtAddCallback(RadioButton_1,XmNvalueChangedCallback,
			Choose_Trace, tab_widgets);

	XtManageChild(RadioButton_1);

	/* Creating RadioButton_2 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[577],
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_2 = 
	   XmCreateToggleButton(RadioBox,"RadioButton_2",args,n);

        tab_widgets->tabtrace[1] = RadioButton_2;

	/* Adding Callbacks for RadioButton_2 */ 

	XtAddCallback(RadioButton_2,XmNvalueChangedCallback,
			Choose_Trace, tab_widgets);

	XtManageChild(RadioButton_2);


	return (Frame_Trace);
}



/********************************************************
/   Creation Function for Display
/*******************************************************/

Widget
build_Display(reg_growing_widget, tab_widgets)
    Widget reg_growing_widget;
    xs_struc_reg_growing *tab_widgets;
{
        Widget Frame_Display;
	Widget Display_bb;
	Widget Display_label;
	Widget RadioBox;
	Widget RadioButton_1;
	Widget RadioButton_2;
	Widget RadioButton_3;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Frame_Display Widget */ 

	Frame_Display = 
	  XmCreateFrame(reg_growing_widget,"Frame_Display", NULL, 0);

	/* Creating Display_bb Widget */ 

	n = 0;
	XtSetArg(args[n],XmNwidth, 80); n++;
	XtSetArg(args[n],XmNheight, 70); n++;

	Display_bb = 
	     XmCreateBulletinBoard(Frame_Display,"Display_bb",args,n);

  	XtManageChild(Display_bb);

	/* Creating Display_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx, 10); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[579],
			XmSTRING_DEFAULT_CHARSET)); n++;
	
	Display_label = 
	  XmCreateLabel(Display_bb,"Display_label",args,n);

	XtManageChild(Display_label);

	/* Creating RadioBox Widget */ 

	n = 0;
	XtSetArg(args[n],XmNy, 28); n++;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNnumColumns,3); n++;

	RadioBox = XmCreateRadioBox(Display_bb,"RadioBox",args,n);

  	XtManageChild(RadioBox);

	/* Creating RadioButton_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[580],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,True); n++;
	
	RadioButton_1 = XmCreateToggleButton(RadioBox,"RadioButton_1",args,n);
        tab_widgets->tabdisplay[0] = RadioButton_1;

	/* Adding Callbacks for RadioButton_1 */ 

	XtAddCallback(RadioButton_1,XmNvalueChangedCallback,
			Choose_Display, tab_widgets);

	XtManageChild(RadioButton_1);

	/* Creating RadioButton_2 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[581],
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_2 = XmCreateToggleButton(RadioBox,"RadioButton_2",args,n);

        tab_widgets->tabdisplay[1] = RadioButton_2;

	/* Adding Callbacks for RadioButton_2 */ 

	XtAddCallback(RadioButton_2,XmNvalueChangedCallback,
			Choose_Display, tab_widgets);

	XtManageChild(RadioButton_2);


	/* Creating RadioButton_3 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[582],
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_3 = XmCreateToggleButton(RadioBox,"RadioButton_3",args,n);
        tab_widgets->tabdisplay[2] = RadioButton_3;

	/* Adding Callbacks for RadioButton_3 */ 

	XtAddCallback(RadioButton_3,XmNvalueChangedCallback,
			Choose_Display, tab_widgets);

	XtManageChild(RadioButton_3);


	return (Frame_Display);
}



xs_struc_reg_growing *
build_reg_growing_widget(reg_growingwidget, reg_growingseparator)
    Widget reg_growingwidget;
    Widget reg_growingseparator;  
{
	Widget reg_growing_widget;
	Widget Segmentation_frame;
	Widget Connexity_frame;
	Widget Tolerance_frame;
	Widget Trace_frame;
	Widget Display_frame;
	Widget reg_growing_APPLY;

        xs_struc_reg_growing *tab_widgets;
	Arg args[MAX_ARGS];
	int n;

	tab_widgets = (xs_struc_reg_growing *) malloc (sizeof (xs_struc_reg_growing));
	
	/* Creating reg_growing_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget,reg_growingseparator); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 1); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition, 28); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 1); n++;

	reg_growing_widget = 
	   XmCreateForm(reg_growingwidget,"reg_growing_widget",args,n);

	Segmentation_frame = 
	    build_Segmentation(reg_growing_widget, tab_widgets);

        n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetValues(Segmentation_frame, args, n);
        XtManageChild(Segmentation_frame);

	Connexity_frame = 
	    build_Connexity(reg_growing_widget, tab_widgets);

        n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition, 46); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNtopWidget,Segmentation_frame); n++;
	XtSetValues(Connexity_frame, args, n);
        XtManageChild(Connexity_frame);

	Tolerance_frame = build_Tolerance(reg_growing_widget, tab_widgets);

        n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNtopWidget,Connexity_frame); n++;
	XtSetValues(Tolerance_frame, args, n);
        XtManageChild(Tolerance_frame);

	Trace_frame = build_Trace(reg_growing_widget, tab_widgets);

        n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,47); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNtopWidget, Segmentation_frame); n++;
	XtSetValues(Trace_frame, args, n);
        XtManageChild(Trace_frame);

	Display_frame = build_Display(reg_growing_widget, tab_widgets);

        n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNtopWidget, Tolerance_frame); n++;
	XtSetValues(Display_frame, args, n);
        XtManageChild(Display_frame);


	/* Creating reg_growing_APPLY Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNbottomPosition,98); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[586],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 5); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition, 95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;


	reg_growing_APPLY = XmCreatePushButton(reg_growing_widget, 
					       "reg_growing_APPLY",args,n);
	XtManageChild(reg_growing_APPLY);


        /* Adding Callbacks for reg_growing_APPLY */ 

	XtAddCallback(reg_growing_APPLY, XmNactivateCallback, 
		      reg_growing_APPLY_callb, tab_widgets);

	XtManageChild(reg_growing_widget);
	return(tab_widgets);
}

void 
Build_reg_growing()
{
	Widget reg_growing_mainwidget;
	Widget reg_growing_separator;
	Widget reg_growing_command;
	Widget reg_growing_LOAD;
	Widget Frame_Save;
	Widget BulletinBoard_Save;
	Widget Label_Save;
	Widget reg_growing_CONTOUR;
	Widget reg_growing_REGION;
	Widget reg_growing_QUIT;
	Widget ScrolledWindow_1;
	Widget ScrolledWindow_2;
	Widget drawing_1;
	Widget drawing_2;
	Colormap my_colormap;
        xs_struc_reg_growing *tab_widgets; 
	Arg args[MAX_ARGS];
	int n;

	/* Creating reg_growing_mainwidget Widget */ 

	n = 0;
        XtSetArg(args[n],XmNwidth,800); n++;
        XtSetArg(args[n],XmNheight,480); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNdialogTitle, 
		XmStringLtoRCreate(labeltabs[7], 
				   XmSTRING_DEFAULT_CHARSET)); n++;

	reg_growing_mainwidget =
	    XmCreateFormDialog(gLabowidget,
			       "reg_growing_mainwidget",args,n);

	/* Creating reg_growing_command Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;

	reg_growing_command = XmCreateForm(reg_growing_mainwidget,
					   "reg_growing_command",args,n);
	XtManageChild(reg_growing_command);

	/* Creating reg_growing_LOAD Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[585],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,4); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,24); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,20); n++;

	reg_growing_LOAD = XmCreatePushButton(reg_growing_command, 
					      "reg_growing_LOAD",args,n);
	XtManageChild(reg_growing_LOAD);


	/* Creating Frame_Save Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,28); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,72); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	Frame_Save = 
	   XmCreateFrame(reg_growing_command,"Frame_Save",args,n);

	XtManageChild(Frame_Save);
	
	/* Creating BulletinBoard_Save Widget */ 

	n = 0;
	XtSetArg(args[n],XmNwidth, 196); n++;

	BulletinBoard_Save = 
	   XmCreateBulletinBoard(Frame_Save,"BulletinBoard_Save",args,n);

	XtManageChild(BulletinBoard_Save);
	
	/* Creating Label_Save Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx, 20); n++;
	XtSetArg(args[n],XmNy, 7); n++;
	XtSetArg(args[n],XmNwidth, 35); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[286],
			XmSTRING_DEFAULT_CHARSET)); n++;
	Label_Save = 
	   XmCreateLabel(BulletinBoard_Save,"Label_Save",args,n);

	XtManageChild(Label_Save);
	
	/* Creating reg_growing_CONTOUR Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx, 70); n++;
	XtSetArg(args[n],XmNwidth, 100); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[583],
			XmSTRING_DEFAULT_CHARSET)); n++;

	reg_growing_CONTOUR = 
	     XmCreatePushButton(BulletinBoard_Save,
				"reg_growing_CONTOUR",args,n);
	XtManageChild(reg_growing_CONTOUR);


	/* Creating reg_growing_REGION Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx, 190); n++;
	XtSetArg(args[n],XmNwidth, 100); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[584],
			XmSTRING_DEFAULT_CHARSET)); n++;

	reg_growing_REGION = 
	      XmCreatePushButton(BulletinBoard_Save,
				 "reg_growing_REGION",args,n);
	XtManageChild(reg_growing_REGION);


	/* Creating reg_growing_QUIT Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[313],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,76); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,96); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 20); n++;

	reg_growing_QUIT = 
	    XmCreatePushButton(reg_growing_command,
			       "reg_growing_QUIT",args,n);
	XtManageChild(reg_growing_QUIT);

	/* Adding Callbacks for reg_growing_QUIT */ 

	XtAddCallback(reg_growing_QUIT, XmNactivateCallback,
		      reg_growing_QUIT_callb, reg_growing_mainwidget);

	/* Creating reg_growing_separator Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget, reg_growing_command); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;

	reg_growing_separator = 
	  XmCreateSeparator(reg_growing_mainwidget,
			    "reg_growing_separator",args,n);

	XtManageChild(reg_growing_separator);

	/* Parameters of region growing: */

	tab_widgets = build_reg_growing_widget(reg_growing_mainwidget,
					    reg_growing_separator);
	     

	/* Adding Callbacks for reg_growing_LOAD */ 

	XtAddCallback(reg_growing_LOAD,
		XmNactivateCallback,reg_growing_LOAD_callb, tab_widgets);

	
	/* Adding Callbacks for reg_growing_CONTOUR */ 

	XtAddCallback(reg_growing_CONTOUR,
		XmNactivateCallback,reg_growing_CONTOUR_callb, tab_widgets);


	/* Adding Callbacks for reg_growing_REGION */ 

	XtAddCallback(reg_growing_REGION,
		XmNactivateCallback,reg_growing_REGION_callb, tab_widgets);


	/* Windows of region growing */
	
        /* initialisation de la colormap associee */

        my_colormap = init_color_lin(); 


	/* Creating ScrolledWindow_1 Widget */ 

	n = 0;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
	XtSetArg(args[n], XmNrightPosition, 64);n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);n++;
	XtSetArg(args[n], XmNleftPosition, 29);n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_WIDGET);n++;
	XtSetArg(args[n], XmNbottomWidget,reg_growing_separator); n++;
	XtSetArg(args[n], XmNscrollingPolicy, XmAUTOMATIC);n++;
	ScrolledWindow_1 = XtCreateManagedWidget("ScrolledWindow_1", 
					  xmScrolledWindowWidgetClass,
					  reg_growing_mainwidget, args, n);

	n = 0;
	XtSetArg(args[n], XmNwidth, 256);n++;
	XtSetArg(args[n], XmNheight, 256);n++;
	drawing_1 = XtCreateWidget("drawing_1", xmDrawingAreaWidgetClass,
				   ScrolledWindow_1, args, n);
	XtManageChild(drawing_1);

	tab_widgets->drawing_widget[0] = drawing_1;
	
	XtAddEventHandler((Widget) drawing_1, 
			EnterWindowMask | LeaveWindowMask,False,
 			(XtEventHandler)install_win_colormap, my_colormap);

	n = 0;
	XtSetArg(args[n], XmNworkWindow, drawing_1); n++;
	XtSetValues(ScrolledWindow_1, args, n);
	XtManageChild(ScrolledWindow_1);


	/* Creating ScrolledWindow_2 Widget */ 

	n = 0;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);n++;
	XtSetArg(args[n], XmNleftPosition, 65);n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_WIDGET);n++;
	XtSetArg(args[n], XmNbottomWidget,reg_growing_separator); n++;
	XtSetArg(args[n], XmNscrollingPolicy, XmAUTOMATIC);n++;
	ScrolledWindow_2 = XtCreateManagedWidget("ScrolledWindow_2", 
						 xmScrolledWindowWidgetClass,
						 reg_growing_mainwidget, args, n);

	n = 0;
	XtSetArg(args[n], XmNwidth, 256);n++;
	XtSetArg(args[n], XmNheight, 256);n++;
	drawing_2 = XtCreateWidget("drawing_2", xmDrawingAreaWidgetClass,
				   ScrolledWindow_2, args, n);
	XtManageChild(drawing_2);

	tab_widgets->drawing_widget[1] = drawing_2;

	XtAddEventHandler((Widget) drawing_2, 
			EnterWindowMask | LeaveWindowMask,False,
 			(XtEventHandler)install_win_colormap, my_colormap);

	n = 0;
	XtSetArg(args[n], XmNworkWindow, drawing_2); n++;
	XtSetValues(ScrolledWindow_2, args, n);
	XtManageChild(ScrolledWindow_2);


	XtManageChild(reg_growing_mainwidget);
	
      }


