/* SCCS @(#)geometrie4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      geometrie4.c                                    */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   geometrie4.c                                        */
/*                                                                      */
/* DESCRIPTION  :   Geometric operations                                */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <math.h>

#define EPSILON 0.0000001


/*****************************************************************************/

int sym_x (imageIn, imageOut, type, colonne, ligne)
    float *imageIn, **imageOut;
    int type, colonne, ligne;
{
    int elem, taille;
    float *b;

    unsigned char *u, *cu;
    short *s, *cs;
    int *i, *ci;
    float *f, *cf;
    int k, l;

    elem = element (type);
    taille = colonne * ligne;

    /* Allocation of memory space for the resultant image */
    *imageOut = (float *) malloc (taille * elem);

    if (!*imageOut) return (-1);

    b = *imageOut;
    
    switch (type) {
    case -1:
    case 0: 
        u = (unsigned char *) b;
        cu = (unsigned char *)imageIn + taille;
        for (k=0; k<ligne; k++) {
	    cu -= colonne; 
            for (l=0; l<colonne; l++) {
                *u = *(cu + l);
                u++;
            }
	}
        break;
    case 1: 
        s = (short *) b;
        cs = (short *)imageIn + taille;
        for (k=0; k<ligne; k++) {
	    cs -= colonne; 
            for (l=0; l<colonne; l++) {
                *s = *(cs + l);
                s++;
            }
	}
        break;
    case 2: 
        i = (int *) b;
        ci = (int *)imageIn + taille;
        for (k=0; k<ligne; k++) {
	    ci -= colonne; 
            for (l=0; l<colonne; l++) {
                *i = *(ci + l);
                i++;
            }
	}
        break;
    case 3: 
        f = (float *) b;
        cf = (float *)imageIn + taille;
        for (k=0; k<ligne; k++) {
	    cf -= colonne; 
            for (l=0; l<colonne; l++) {
                *f = *(cf + l);
                f++;
            }
	}
        break;
    }
    return (0);
}



/*****************************************************************************/


int sym_y (imageIn, imageOut, type, colonne, ligne)
    float *imageIn, **imageOut;
    int type, colonne, ligne;
{
    int elem, taille;
    float *b;

    unsigned char *u, *cu;
    short *s, *cs;
    int *i, *ci;
    float *f, *cf;
    int k, l;

    elem = element (type);
    taille = colonne * ligne;

    /* Allocation of memory space for the resultant image */
    *imageOut = (float *) malloc (taille * elem);

    if (!*imageOut) return (-1);

    b = *imageOut;

    switch (type) {
    case -1:
    case 0: 
        u = (unsigned char *) b;
        cu = (unsigned char *) imageIn;
        for (k=0; k<ligne; k++) {
            for (l=1; l<=colonne; l++) {
                *u = *(cu + colonne - l);
                u++;
            }
            cu += colonne;
	}
        break;
    case 1: 
        s = (short *) b;
        cs = (short *) imageIn;
        for (k=0; k<ligne; k++) {
            for (l=1; l<=colonne; l++) {
                *s = *(cs + colonne-l);
                s++;
            }
            cs += colonne;
	}
        break;
    case 2: 
        i = (int *) b;
        ci = (int *) imageIn;
        for (k=0; k<ligne; k++) {
            for (l=1; l<=colonne; l++) {
                *i = *(ci + colonne-l);
                i++;
            }
            ci += colonne;
	}
        break;
    case 3: 
        f = (float *) b;
        cf = (float *) imageIn;
        for (k=0; k<ligne; k++) {
            for (l=1; l<=colonne; l++) {
                *f = *(cf + colonne-l);
                f++;
            }
            cf += colonne;
	}
        break;
    }
    return (0);
}



/*****************************************************************************/


int transpose (imageIn, imageOut, type, colonne, ligne)
    float *imageIn, **imageOut;
    int type, colonne, ligne;
{
    int elem, taille;
    float *b;

    unsigned char *u, *cu;
    short *s, *cs;
    int *i, *ci;
    float *f, *cf;
    int k, l;

    elem = element (type);
    taille = colonne * ligne;

    /* Allocation of memory space for the resultant image */
    *imageOut = (float *) malloc (taille * elem);

    if (!*imageOut) return (-1);

    b = *imageOut;
    
    switch (type) {
    case -1:
    case 0: 
        u = (unsigned char *) b;
        cu = (unsigned char *) imageIn;
        for (k=0; k<colonne; k++)
            for (l=k; l<taille; l+=colonne) {
                *u = *(cu + l);
                u++;
            }
        break;
    case 1: 
        s = (short *) b;
        cs = (short *) imageIn;
        for (k=0; k<colonne; k++)
            for (l=k; l<taille; l+=colonne) {
                *s = *(cs + l);
                s++;
            }
        break;
    case 2: 
        i = (int *) b;
        ci = (int *) imageIn;
        for (k=0; k<colonne; k++)
            for (l=k; l<taille; l+=colonne) {
                *i = *(ci + l);
                i++;
            }
        break;
    case 3: 
        f = (float *) b;
        cf = (float *) imageIn;
        for (k=0; k<colonne; k++)
            for (l=k; l<taille; l+=colonne) {
                *f = *(cf + l);
                f++;
            }
        break;
    }
    return (0);
}



/****************************************************************************/
/*									    */
/* funtion for affine transformation of an image using linear interpolation */
/*									    */
/****************************************************************************/

int AffineTransf(InImage,DimInX, DimInY, OutImage, DimOutX, DimOutY,
                  TransfMat, ContentP)
    float *InImage, **OutImage;
    int DimInX, DimInY, DimOutX, DimOutY, ContentP;
    float TransfMat[3][2];
{
    float mat00, mat01, mat02, mat10, mat11, mat12, det;
    float Xf1, Yf1, Xf2, Yf2, Xf2prime, Yf2prime, fi, fj;
    int i, j, index; 
    int Xvali, Yvali, DimOutX1, DimOutY1, DimInX1, DimInY1; 
    int indexX1, indexY1, indexX2, indexY2;
    
    /* Allocation of memory space for the resultant image */
    *OutImage = (float *) malloc(DimOutX * DimOutY * sizeof(float));
    
    DimOutX1=DimOutX -1;
    DimOutY1=DimOutY -1;
    DimInX1=DimInX -1;
    DimInY1=DimInY -1;
    if (ContentP == 1){
	det = TransfMat[0][0] * TransfMat[1][1] - TransfMat[1][0] * TransfMat[0][1];
        if (fabs(det) < EPSILON) return(-1);

        mat00 = TransfMat[1][1]/det; 
        mat01 = - TransfMat[1][0]/det; 
        mat10 = - TransfMat[0][1]/det;
        mat11 = TransfMat[0][0]/det;
        mat02 = (TransfMat[1][0] * TransfMat[2][1] - TransfMat[2][0] * TransfMat[1][1]) / det;
        mat12 = (TransfMat[0][1] * TransfMat[2][0] - TransfMat[0][0] * TransfMat[2][1]) /det;
    }
    else{
        mat00 = TransfMat[0][0]; 
        mat01 = TransfMat[1][0]; 
        mat02 = TransfMat[2][0];
        mat10 = TransfMat[0][1]; 
        mat11 = TransfMat[1][1];
        mat12 = TransfMat[2][1]; 
	
    }
    for(i=0; (i < DimOutY); ++i){
        fi = (float)i; 
	Xf1 = fi*mat01 + mat02;
	Yf1 = fi*mat11 + mat12;
        index= DimOutX * i;
        for(j=0; (j < DimOutX); ++j){
	   fj = (float) j;
	   Xf2 = fj*mat00 + Xf1; 
	   Yf2 = fj*mat10 + Yf1;
           indexX1 = (int)Xf2; 
           indexY1 = (int)Yf2; 
           if ((( indexX1 < 0) || indexX1 > DimInX1) || (( indexY1 < 0) || (indexY1 > DimInY1))){
		*(*OutImage + index + j)=0.0;
	   }
           else{
	       Xf2= Xf2 - (float)indexX1;
	       Yf2= Yf2 - (float)indexY1;
               indexX2 = indexX1;
               indexY2 = indexY1;
               Xf2prime = 1 - Xf2;
               Yf2prime = 1 - Yf2;
		*(*OutImage + index + j) = (float) (  (Yf2prime * 
       (   (Xf2prime * ((float)(*(InImage+DimInX*indexY1 + indexX1))))
         + (Xf2 * ((float)(*(InImage+DimInX*indexY1 + indexX2))))
       )
   )   
+   
   (Yf2 *
       (   (Xf2prime * ((float)(*(InImage+DimInX*indexY2 + indexX1))))
         + (Xf2 * ((float)(*(InImage+DimInX*indexY2 + indexX2))))
       )
   )
+   0.5);
	   }
	}
    }
}

