/* SCCS @(#)padding4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      padding4.c                                      */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   padding4.c                                          */
/*                                                                      */
/* DESCRIPTION  :   Padding operations                                  */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <math.h>

#include "type.h"

/*****************************************************************************/

int padding_prolong (imageIn, colonne, ligne, type, imageOut, pad)
    float *imageIn, **imageOut;    
    int colonne, ligne, type;
    struct paddi *pad;
{
    int elem, taille, dx, dy;
    register int i, j;
    float *b;

    dx = (pad->colonne - colonne) / 2;
    dy = (pad->ligne - ligne) / 2;

    elem = element (type);
    taille = pad->ligne * pad->colonne;
    
    /* Allocation of memory space for the resultant image */
    *imageOut = (float *) malloc (taille * elem);

    if (!*imageOut) return (-1);

    b = *imageOut;

    switch (type) {
	case -1:
	case 0 : {
	    unsigned char *imdep, *im, *t, val;
	    imdep = (unsigned char *) imageIn;	    
	    im = (unsigned char *) b;

	    /* remplissage de la gauche et de la droite */
	    t = im + dy * pad->colonne;
	    for (j=0; j<ligne; j++){
		val = *imdep;
		for (i=0; i<dx; i++){
		    *t = val;
		    t++;
		}
		for (i=0; i<colonne; i++) {
		    *t = *imdep;
		    t++;  imdep++;
		}
		val = *(imdep - 1);
		for (i=0;i<(pad->colonne - colonne - dx);i++){
		    *t = val;
		    t++;
		}
	    }
	    /* remplissage du haut et du bas */
	    for (i=0; i<pad->colonne; i++){
		t = im;
		val = *(t + dy * pad->colonne);
		for (j=0; j<dy; j++){
		    *t = val;
		    t += pad->colonne;
		}
		t += (pad->colonne * ligne);
		val = *(t - pad->colonne);
		for (j=0; j<(pad->ligne - ligne - dy); j++){
		    *t = val;
		    t += pad->colonne;
		}
		im++;
	    }
	    break;
	}    
	case 1 : {
	    short *imdep, *im, *t, val;
	    imdep = (short *)imageIn;	    
	    im = (short *) b;

	    /* remplissage de la gauche et de la droite */
	    t = im + dy * pad->colonne;
	    for (j=0; j<ligne; j++){
		val = *imdep;
		for	(i=0; i<dx; i++){
		    *t = val;
		    t++;
		}
		for (i=0; i<colonne; i++) {
		    *t = *imdep;
		    t++;  imdep++;
		}
		val = *(imdep - 1);
		for (i=0;i<(pad->colonne - colonne - dx);i++){
		    *t = val;
		    t++;
		}
	    }
	    /* remplissage du haut et du bas */
	    for (i=0; i<pad->colonne; i++){
		t = im;
		val = *(t + dy * pad->colonne);
		for (j=0; j<dy; j++){
		    *t = val;
		    t += pad->colonne;
		}
		t += (pad->colonne * ligne);
		val = *(t - pad->colonne);
		for (j=0; j<(pad->ligne - ligne - dy); j++){
		    *t = val;
		    t += pad->colonne;
		}
		im++;
	    }
	    break;
	}    
	case 2 : {
	    int *imdep, *im, *t, val;
	    imdep = (int *)imageIn;	    
	    im = (int *) b;

	    /* remplissage de la gauche et de la droite */
	    t = im + dy * pad->colonne;
	    for (j=0; j<ligne; j++){
		val = *imdep;
		for	(i=0; i<dx; i++){
		    *t = val;
		    t++;
		}
		for (i=0; i<colonne; i++) {
		    *t = *imdep;
		    t++;  imdep++;
		}
		val = *(imdep - 1);
		for (i=0;i<(pad->colonne - colonne - dx);i++){
		    *t = val;
		    t++;
		}
	    }
	    /* remplissage du haut et du bas */
	    for (i=0; i<pad->colonne; i++){
		t = im;
		val = *(t + dy * pad->colonne);
		for (j=0; j<dy; j++){
		    *t = val;
		    t += pad->colonne;
		}
		t += (pad->colonne * ligne);
		val = *(t - pad->colonne);
		for (j=0; j<(pad->ligne - ligne - dy); j++){
		    *t = val;
		    t += pad->colonne;
		}
		im++;
	    }
	    break;
	}    
	case 3 : {
	    float *imdep, *im, *t, val;
	    imdep = (float *)imageIn;	    
	    im = (float *) b;

	    /* remplissage de la gauche et de la droite */
	    t = im + dy * pad->colonne;
	    for (j=0; j<ligne; j++){
		val = *imdep;
		for	(i=0; i<dx; i++){
		    *t = val;
		    t++;
		}
		for (i=0; i<colonne; i++) {
		    *t = *imdep;
		    t++;  imdep++;
		}
		val = *(imdep - 1);
		for (i=0;i<(pad->colonne - colonne - dx);i++){
		    *t = val;
		    t++;
		}
	    }
	    /* remplissage du haut et du bas */
	    for (i=0; i<pad->colonne; i++){
		t = im;
		val = *(t + dy * pad->colonne);
		for (j=0; j<dy; j++){
		    *t = val;
		    t += pad->colonne;
		}
		t += (pad->colonne * ligne);
		val = *(t - pad->colonne);
		for (j=0; j<(pad->ligne - ligne - dy); j++){
		    *t = val;
		    t += pad->colonne;
		}
		im++;
	    }
	    break;
	}
    }
    return(0);
}


/*****************************************************************************/

int padding_period (imageIn, colonne, ligne, type, imageOut, pad)
    float *imageIn, **imageOut;
    int colonne, ligne, type;
    struct paddi *pad;
{
    int elem, taille, dx, dy;
    register int i, j;
    float *b;

    dx = (pad->colonne - colonne) / 2;
    dy = (pad->ligne - ligne) / 2;

    elem = element (type);
    taille = pad->ligne * pad->colonne;

    /* Allocation of memory space for the resultant image */
    *imageOut = (float *) malloc (taille * elem);

    if (!*imageOut) return (-1);

    b = *imageOut;

    switch (type) {
	case -1:
	case 0 : {
	    unsigned char *imdep, *im, *t_dep, *t_arr, *t;
	    imdep = (unsigned char *) imageIn;
	    im = (unsigned char *) b;

	    t_arr = im + dy * pad->colonne + dx;
	    for (j=0; j<ligne; j++){
		t_dep = imdep;
		/* recopie de l'image */
		for (i=0; i<colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
		/* remplissage de la droite */
		imdep = t_dep;
		t = t_arr;
		t_dep = t_arr - colonne;
		for (i=0;i<(pad->colonne - colonne - dx);i++){
		    *t_arr = *t_dep;
		    t_arr++;  t_dep++; 
		}
		/* remplissage de la gauche */
		t_dep = t - (dx % colonne);
		t = t_arr;
		t_arr = t_arr - pad->colonne;
		for (i=0; i<dx; i++){
		    *t_arr = *t_dep;
		    t_arr++;  t_dep++; 
		}
		t_arr = t + dx;
	    }
	    /* remplissage du bas */
	    t_dep = im + dy * pad->colonne;
	    t_arr = t_dep + ligne * pad->colonne;
	    t = t_arr;
	    for (j=0; j < (pad->ligne - ligne - dy); j++){
		for (i=0; i < pad->colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
	    }		
	    /* remplissage du haut */
	    t_dep = t - (dy % ligne) * pad->colonne;
	    t_arr = im;
	    for (j=0; j < dy; j++){
		for (i=0; i < pad->colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
	    }
	    break;
        }
	case 1:{
	    short *imdep, *im, *t_dep, *t_arr, *t;
	    imdep = (short *)imageIn;
	    im = (short *)b;

	    t_arr = im + dy * pad->colonne + dx;
	    for (j=0; j<ligne; j++){
		t_dep = imdep;
		/* recopie de l'image */
		for (i=0; i<colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
		/* remplissage de la droite */
		imdep = t_dep;
		t = t_arr;
		t_dep = t_arr - colonne;
		for (i=0;i<(pad->colonne - colonne - dx);i++){
		    *t_arr = *t_dep;
		    t_arr++;  t_dep++; 
		}
		/* remplissage de la gauche */
		t_dep = t - (dx % colonne);
		t = t_arr;
		t_arr = t_arr - pad->colonne;
		for (i=0; i<dx; i++){
		    *t_arr = *t_dep;
		    t_arr++;  t_dep++; 
		}
		t_arr = t + dx;
	    }
	    /* remplissage du bas */
	    t_dep = im + dy * pad->colonne;
	    t_arr = t_dep + ligne * pad->colonne;
	    t = t_arr;
	    for (j=0; j < (pad->ligne - ligne - dy); j++){
		for (i=0; i < pad->colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
	    }		
	    /* remplissage du haut */
	    t_dep = t - (dy % ligne) * pad->colonne;
	    t_arr = im;
	    for (j=0; j < dy; j++){
		for (i=0; i < pad->colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
	    }
	    break;
	}
	case 2:{
	    int *imdep, *im, *t_dep, *t_arr, *t;
	    imdep = (int *)imageIn;
	    im = (int *) b;

	    t_arr = im + dy * pad->colonne + dx;
	    for (j=0; j<ligne; j++){
		t_dep = imdep;
		/* recopie de l'image */
		for (i=0; i<colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
		/* remplissage de la droite */
		imdep = t_dep;
		t = t_arr;
		t_dep = t_arr - colonne;
		for (i=0;i<(pad->colonne - colonne - dx);i++){
		    *t_arr = *t_dep;
		    t_arr++;  t_dep++; 
		}
		/* remplissage de la gauche */
		t_dep = t - (dx % colonne);
		t = t_arr;
		t_arr = t_arr - pad->colonne;
		for (i=0; i<dx; i++){
		    *t_arr = *t_dep;
		    t_arr++;  t_dep++; 
		}
		t_arr = t + dx;
	    }
	    /* remplissage du bas */
	    t_dep = im + dy * pad->colonne;
	    t_arr = t_dep + ligne * pad->colonne;
	    t = t_arr;
	    for (j=0; j < (pad->ligne - ligne - dy); j++){
		for (i=0; i < pad->colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
	    }		
	    /* remplissage du haut */
	    t_dep = t - (dy % ligne) * pad->colonne;
	    t_arr = im;
	    for (j=0; j < dy; j++){
		for (i=0; i < pad->colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
	    }
	    break;
	}
	case 3:{
	    float *imdep, *im, *t_dep, *t_arr, *t;
	    imdep = (float *)imageIn;
	    im = (float *) b;

	    t_arr = im + dy * pad->colonne + dx;
	    for (j=0; j<ligne; j++){
		t_dep = imdep;
		/* recopie de l'image */
		for (i=0; i<colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
		/* remplissage de la droite */
		imdep = t_dep;
		t = t_arr;
		t_dep = t_arr - colonne;
		for (i=0;i<(pad->colonne - colonne - dx);i++){
		    *t_arr = *t_dep;
		    t_arr++;  t_dep++; 
		}
		/* remplissage de la gauche */
		t_dep = t - (dx % colonne);
		t = t_arr;
		t_arr = t_arr - pad->colonne;
		for (i=0; i<dx; i++){
		    *t_arr = *t_dep;
		    t_arr++;  t_dep++; 
		}
		t_arr = t + dx;
	    }
	    /* remplissage du bas */
	    t_dep = im + dy * pad->colonne;
	    t_arr = t_dep + ligne * pad->colonne;
	    t = t_arr;
	    for (j=0; j < (pad->ligne - ligne - dy); j++){
		for (i=0; i < pad->colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
	    }		
	    /* remplissage du haut */
	    t_dep = t - (dy % ligne) * pad->colonne;
	    t_arr = im;
	    for (j=0; j < dy; j++){
		for (i=0; i < pad->colonne; i++){
		    *t_arr = *t_dep;
		    t_dep++;  t_arr++;
		}
	    }
	    break;
	}
    }
    return(0);
}
	    


/*****************************************************************************/

int padding_const (imageIn, colonne, ligne, type, imageOut, pad)
    float *imageIn, **imageOut;
    int colonne, ligne, type;
    struct paddi *pad;
{
    int elem, taille, dx, dy;
    register int i, j;
    float *b;

    dx = (pad->colonne - colonne) / 2;
    dy = (pad->ligne - ligne) / 2;

    elem = element (type);
    taille = pad->ligne * pad->colonne;

    /* Allocation of memory space for the resultant image */
    *imageOut = (float *) malloc (taille * elem);

    if (!*imageOut) return (-1);

    b = *imageOut;

    switch (type) {
	case -1:
	case 0 : {
	    unsigned char *imdep, *im, *t, val;
	    imdep = (unsigned char *) imageIn;	    
	    im = (unsigned char *) b;

	    for (i=0; i < pad->colonne * dy; i++) {
		*im = pad->valeur;
		im++;
	    }
	    for (j=0; j < ligne; j++){
		for (i=0; i < dx; i++){
		    *im = pad->valeur;
		    im++;
		}
		for (i=0; i < colonne; i++){
		    *im = *imdep;    /*Program received signal 11, Segmentation fault*/
/*program terminated by signal SEGV (no mapping at the fault address)*/
		    im++;  imdep++;
		}
		for (i=0;i < pad->colonne - colonne - dx;i++){
		    *im = pad->valeur;
		    im++; 
		}
	    }
	    for(i=0;i<pad->colonne*(pad->ligne-ligne-dy);i++){
		*im = pad->valeur;
		im++;
	    }
	    break;
	}    
	case 1 : {
	    short *imdep, *im, *t, val;
	    imdep = (short *)imageIn;	    
	    im = (short *) b;

	    for (i=0; i < pad->colonne * dy; i++) {
		*im = pad->valeur;
		im++;
	    }
	    for (j=0; j < ligne; j++){
		for (i=0; i < dx; i++){
		    *im = pad->valeur;
		    im++;
		}
		for (i=0; i < colonne; i++){
		    *im = *imdep;
		    im++;  imdep++;
		}
		for (i=0;i < pad->colonne - colonne - dx;i++){
		    *im = pad->valeur;
		    im++; 
		}
	    }
	    for(i=0;i<pad->colonne*(pad->ligne-ligne-dy);i++){
		*im = pad->valeur;
		im++;
	    }
	    break;
	}    
	case 2 : {
	    int *imdep, *im, *t, val;
	    imdep = (int *)imageIn;	    
	    im = (int *) b;
	    for (i=0; i < pad->colonne * dy; i++) {
		*im = pad->valeur;
		im++;
	    }
	    for (j=0; j < ligne; j++){
		for (i=0; i < dx; i++){
		    *im = pad->valeur;
		    im++;
		}
		for (i=0; i < colonne; i++){
		    *im = *imdep;
		    im++;  imdep++;
		}
		for (i=0;i < pad->colonne - colonne - dx;i++){
		    *im = pad->valeur;
		    im++; 
		}
	    }
	    for(i=0;i<pad->colonne*(pad->ligne-ligne-dy);i++){
		*im = pad->valeur;
		im++;
	    }
	    break;
	}    
	case 3 : {
	    float *imdep, *im, *t, val;
	    imdep = (float *)imageIn;	    
	    im = (float *) b;
	    for (i=0; i < pad->colonne * dy; i++) {
		*im = pad->valeur;
		im++;
	    }
	    for (j=0; j < ligne; j++){
		for (i=0; i < dx; i++){
		    *im = pad->valeur;
		    im++;
		}
		for (i=0; i < colonne; i++){
		    *im = *imdep;
		    im++;  imdep++;
		}
		for (i=0;i < pad->colonne - colonne - dx;i++){
		    *im = pad->valeur;
		    im++; 
		}
	    }
	    for(i=0;i<pad->colonne*(pad->ligne-ligne-dy);i++){
		*im = pad->valeur;
		im++;
	    }
	    break;
	}
    }
    return(0);
}

