/* SCCS @(#)transform4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      transform4.c                                    */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   transform4.c                                        */
/*                                                                      */
/* DESCRIPTION  :   Transform operation                                 */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <math.h>
#include <stdio.h>
#include <malloc.h>

#define PI  3.14159265358979323846
#define PI2 6.28318530717958647692


/*      Program implementing the Fast Fourier Transform

  Ref  : Subroutines four_2d,FFTS0,CSTB,BRTB,BIRV,OPTC of the Spider
         Manual.
         latest and last version.
*/


int FindPowerTwo(Dim)
   int Dim;
  {
      int i,j;
      
      j=Dim;
      i= -1;
      do
	{
	   j = j >> 1;
           i++;
	} while (j > 0);
      return(i);
  }
 





/*  FUNCTION CSTB: cos/sin tables, returns a struct TwoTab.
    ------------------------------------------------------------
    calculates the sine ,cosine tables .
  
    **Parameters**
    Dim         :Data Length.
    Inv         :integer which indicates the  type of transform..
                 negative value => inverse transform.
                 positive value => forward transform.
    CosTab      :Array containing the Cosine Table.
    SinTab      :Array containing the Sine Table.

    **Returns**
    0 if executed without errors.
   -2 if there is not enough space in the memory.
*/

int CSTB(Dim, Inv, CosTab, SineTab)
   int Dim,Inv;
   double **CosTab, **SineTab;
  {
     double Val, Argu;
     int i;
   
     *SineTab=(double*) malloc(Dim*sizeof(double));
     *CosTab=(double*) malloc(Dim*sizeof(double));
   if ((*SineTab == NULL) || (*CosTab == NULL))
    {
        return(-2);
    }
   Val = (PI2) /(double) Dim; 
   if (Inv < 0)
     Val= -Val;
   for (i=0; i < Dim; ++i)
    {
	Argu=i*Val;
       *(*SineTab+i)=sin(Argu);
       *(*CosTab+i)=cos(Argu);
    }
   return(0);
  }
  




/*  FUNCTION BRTB: returns the bit reversal table.
    --------------------------------------------------------------
    generates the bit reversal table .

    **Parameters**
    Dim         : Data Length.
    DimP        : 2 ** DimP = Dim; 
                  Remark:no check in the function BRTB  to see if
                         the above equality is verified. 

    **Returns**
    an array  which is the bit reversal table.
*/

int *BRTB(Dim, DimP)
    int DimP,Dim;
   {
       int *Table, i, i1, j, j2, buf;

      Table=(int*) malloc(Dim*sizeof(int)); /* !!! TEST!!! */
      for (i=0; i < Dim; ++i)
      {
          i1=i;
          buf=0;
          for (j=0; j != DimP; j++)  /* no change for 0th place*/
          { 
              j2=i1 >> 1;
	      buf=(buf << 1) + i1 - (j2 << 1);
              i1=j2;
	  }
          *(Table+i)=buf;
      }  
      return (Table);
   }

  





/*  PROCEDURE FFTS0: radix 2 1-D DFT, returns a struct TwoTab
    -------------------------------------------------------------
    executes the butterfly operations for the radix 2 two
    dimensional discrete Fourier transform (DFT).

    **Parameters**
    RealTab     : 1-D Data Array (real part).
                  overwritten with output values.
    ImagTab     : 1-D Data Array (imaginary part).The input array 
                  is overwritten with output values. 
    CosTab      : Cosine Table.
    SineTab     : Sine Table.
    BitTable    : Array containing the bit reversal table.
    Inv         :integer which indicates the  type of transform..
                 negative value => inverse transform.
                 positive value => forward transform.

*/

void FFTS0(RealTab, ImagTab, Dim, SineTab, CosTab, DimP,BitTable,Inv)
    double *RealTab, *ImagTab;
    double *SineTab, *CosTab;
    int Dim, DimP, *BitTable, Inv;
   {
        register int index_sc,nb_stage,Dim1;
        register int index1,index2,k,i,j;
        double tab1r,tab1i,tab2r,tab2i,S,C,RT1,RT2,IT1,IT2,f;
        char car;

        Dim1=Dim >> 1;
        k=0;
        j=0;
        for (nb_stage=0; nb_stage != DimP; nb_stage++)
           {
              do
                {
                   index_sc= *(BitTable+j);
                   S= *(SineTab+index_sc);
                   C= *(CosTab+index_sc);
                   for (i=0; i < Dim1; i++) 
                      {
                  	 index1= k;
                         index2=index1+Dim1;

                         RT1=  *(RealTab+index1);
                         RT2=  *(RealTab+index2);
                         IT1=  *(ImagTab+index1);
                         IT2=  *(ImagTab+index2);
                         tab1r= RT2*C + IT2*S;
                         tab1i= IT2*C - RT2*S;
                         *(RealTab+index2)= RT1 - tab1r;
                         *(ImagTab+index2)= IT1 - tab1i;
                         *(RealTab+index1)= RT1 + tab1r;
                         *(ImagTab+index1)= IT1 + tab1i;
                     
                         k++;
		      }
                     k+=Dim1;
                     j+=2;     
		  } while (k < (Dim-1));
              k=0;
              j=0;
              Dim1 = Dim1 >> 1;
	   }
         if (Inv < 0)     
            for (i=0; i < Dim; ++i)
               {
                 *(RealTab+i)= *(RealTab+i)/Dim;
                 *(ImagTab+i)= *(ImagTab+i)/Dim;
               }  
         for (i = 1 ; i < Dim-1 ; i++)
	    {
               j= *(BitTable+i);
               if (j > i)
                 {
	            f = *(RealTab+i);
                    *(RealTab+i) = *(RealTab+j);
                    *(RealTab+j) = f;
                    f = *(ImagTab+i);
                    *(ImagTab+i) = *(ImagTab+j);
                    *(ImagTab+j) = f;
                 }
            }
      
   }





/*  FUNCTION four_2d: radix 2 2-D DFT, returns an error code.
    -------------------------------------------------------------
    executes the radix 2 two dimensional discrete Fourier 
    transform (DFT).

    **Parameters**
    InTabReal   : 1-D input array containing the real part of the 
                  image.
    InTabImagin : 1-D input array containing the imaginary part of 
                  the image.
    OutTabReal  : 1-D output array containing the real part of the 
                  image.
    OutTabImagin: 1-D output array containing the imaginary part of
                  the image. 
    DimX        : Horizontal dimension of the input/output images,
                  expressed in terms of powers of 2. 
    DimY        : Vertical dimension of the input/output images,
                  expressed in terms of powers of 2.
    TypTransf   : Parameter to specify the transform..
                  TypTransf = 1 --> forward transform.
                  TypTransf = -1 --> inverse transform.
                  TypTransf = 2 --> optical fourier forward
                                    transform.
                  TypTransf = -2 --> optical fourier inverse
                                   transform.

    **ErrorCode**
   -  0  => No Error.
*/             


int four_2d(RInTab, IInTab, ROutTab, IOutTab, DimX, DimY, TypTrans)
      float *RInTab, *IInTab;
      float **ROutTab, **IOutTab;
      int DimX, DimY, TypTrans;
{
       /*begin ffts2 */
          void FileImageR();

          int DimXP, DimYP, DimXH, DimYH, DimXxDimY, *BitRevTable;
          register int i, j, k, k0, k1, k2, k3, l;
          register double  optfac0, optfac1, ValR, ValI, FactNorm, FactNorm2, fn;
          double *CosT, *SinT, *INtab, *RNtab, *Itab, *Rtab,  *I1tab, *R1tab, buffer;
          double *InTabReal, *InTabImagin;
	  double **OutTabReal, **OutTabImagin;

          DimXxDimY=DimX*DimY;
	  
          /* Allocation of memory space for the resultant image */
          *ROutTab=(float*) malloc(DimXxDimY*sizeof(float));

	  if (!*ROutTab) return (-1);

          /* Allocation of memory space for the resultant image */
          *IOutTab=(float*) malloc(DimXxDimY*sizeof(float));
 
	  if (!*IOutTab) return (-1);

          /* Allocation of memory space */
          InTabReal=(double*) malloc(DimXxDimY*sizeof(double));

	  if (!InTabReal) return (-1);

          /* Allocation of memory space */
          InTabImagin=(double*) malloc(DimXxDimY*sizeof(double));

	  if (!InTabImagin) return (-1);
	  for(i= 0; (i < DimXxDimY); ++i){
	      *(InTabReal + i) = (double) *(RInTab + i);
	      *(InTabImagin + i) = (double) *(IInTab + i);
 	  }

          RNtab=(double*) malloc(DimXxDimY*sizeof(double));
          INtab=(double*) malloc(DimXxDimY*sizeof(double));
          if ((RNtab == NULL) || (INtab == NULL)) return(-5);
          
          FactNorm2= (sqrt((double)DimX * DimY));
          FactNorm= 1.00000000000000000 / FactNorm2;
          fn= FactNorm; 
          DimXP=FindPowerTwo(DimX);
          if (DimX != DimY) DimYP=FindPowerTwo(DimY);
          else DimYP=DimXP;
          if (CSTB(DimX, TypTrans, &CosT, &SinT) == -2) return(-4);

          Itab=(double*) malloc(DimX*sizeof(double));
          Rtab=(double*) malloc(DimX*sizeof(double));
          if ((Rtab == NULL) || (Itab == NULL)) return(-3);

          DimXH=DimX/2 ;
          DimYH=DimY/2 ;
 
          BitRevTable=BRTB(DimX,DimXP);
          switch (TypTrans){   
                 case 2:  /* tf optique direct suivant les lignes */
                          optfac0= -1.0000000000000000;
                          for (j=0; j < DimY; ++j)  
                             {
                                k1= DimX*j;
                                k2= k1+DimX;

                                optfac0= -optfac0;
                                optfac1= optfac0;
                                for (i=0; i < DimX; ++i)
                                   {  
                                      k= k1+i;
                                      *(Rtab+i)= *(InTabReal+k) * optfac1;
                                      *(Itab+i)= *(InTabImagin+k) * optfac1;
                                      optfac1= -optfac1;
         	                   }  
                                FFTS0(Rtab, Itab, DimX, SinT, CosT, DimXP, BitRevTable,TypTrans);
                                *(RNtab+k1)= *(Rtab);
                                *(INtab+k1)= *(Itab);
                                for (i=1; i < DimXH; ++i)
                                   {
                                      k= k1+i;
                                      l= k2-i;
                                     
                                      buffer= *(Rtab+i);
                                      *(RNtab+k)= buffer;
                                      *(RNtab+l)= buffer;
                                      buffer= *(Itab+i);
                                      *(INtab+k)= buffer;
                                      *(INtab+l)= - buffer;
	 	                   }
                                k=k1+DimXH;
                                *(RNtab+k)= *(Rtab+DimXH);
                                *(INtab+k)= *(Itab+DimXH);
       	                      }
	                   break;
                            
                  case 1:  /* tf pour les autres suivant les lignes */
	                   for (j=0; j < DimY; ++j)  
                              {
                                 k1= DimX*j;
                                 k2= k1+DimX;
                                    
                                 for (i=0; i < DimX; ++i)
                                    {
                                       k= k1+i;
                                       
                                       *(Rtab+i)= *(InTabReal+k);
                                       *(Itab+i)= *(InTabImagin+k);
		                    }
                                 FFTS0(Rtab, Itab, DimX, SinT, CosT, DimXP, BitRevTable,TypTrans);
                                 *(RNtab+k1)= *(Rtab);
                                 *(INtab+k1)= *(Itab);
                                 for (i=1; i < DimXH; ++i)
                                    {
                                       k= k1+i;
                                       l= k2-i;
                                
                                       buffer= *(Rtab+i);
                                       *(RNtab+k)=buffer;
                                       *(RNtab+l)= buffer;
                                       buffer= *(Itab+i);
                                       *(INtab+k)= buffer;
                                       *(INtab+l)= - buffer;
		                    }
                                 k=k1+DimXH;
                                 *(RNtab+k)= *(Rtab+DimXH);
                                 *(INtab+k)= *(Itab+DimXH);
                              }          
                           break;
                                                             
               	 case -2: optfac0= 1.0000000000;
                          optfac1=optfac0;
                           for (i=0; i < DimX; ++i)
                              {
                                 *(Rtab+i)= *(InTabReal+i)*optfac1;
                                 *(Itab+i)= *(InTabImagin+i)*optfac1;
                                 optfac1= -optfac1;
		               }
                           FFTS0(Rtab, Itab, DimX, SinT, CosT, DimXP, BitRevTable,TypTrans);
                           for (i=0; i < DimX; ++i)
                              {
                                 *(RNtab+i)= *(Rtab+i);
                                 *(INtab+i)= *(Itab+i);
        	              }

                          for (j=1; j < DimYH; ++j)  
                              {
                                 optfac0= -optfac0;
                                 optfac1= optfac0;
                                 k1= DimX*j;   /*convert * to + ??? */
                                 k0=DimXxDimY-k1;
                                 for (i=0; i < DimX; ++i)
                                    {
                                       k= k1+i;
                                       *(Rtab+i)= *(InTabReal+k)*optfac1;
                                       *(Itab+i)= *(InTabImagin+k)*optfac1;
                                       optfac1= -optfac1;
		                    }
                                 FFTS0(Rtab, Itab, DimX, SinT, CosT, DimXP, BitRevTable,TypTrans);
                                 for (i=0; i < DimX; ++i)
                                    {
                                       k= k1+i;
                                       k2= k0+i;
                                       buffer= *(Rtab+i);
                                       *(RNtab+k)= buffer;
                                       *(RNtab+k2)= buffer;
                                       buffer= *(Itab+i);
                                       *(INtab+k)= buffer;
                                       *(INtab+k2)= - buffer;
		                    }
			      }
                                 
                              optfac0= -optfac0;
                              optfac1= optfac0;
                              k1= DimX*DimYH;
                              for (i=0; i < DimX; ++i)
                                 {
                                    k= k1+i;
                                    *(Rtab+i)= *(InTabReal+k)*optfac1;
                                    *(Itab+i)= *(InTabImagin+k)*optfac1;
                                    optfac1= -optfac1;
	                         }
                              FFTS0(Rtab, Itab, DimX, SinT, CosT, DimXP, BitRevTable,TypTrans);
                              for (i=0; i < DimX; ++i)
                                 {
                                    k= k1+i;
                                    *(RNtab+k)= *(Rtab+i);
                                    *(INtab+k)= *(Itab+i);
                                 }
                           break;

               	 default:  for (i=0; i < DimX; ++i)
                              {
                                 *(Rtab+i)= *(InTabReal+i);
                                 *(Itab+i)= *(InTabImagin+i);
		               }
                           FFTS0(Rtab, Itab, DimX, SinT, CosT, DimXP, BitRevTable,TypTrans);
                           for (i=0; i < DimX; ++i)
                              {
                                 *(RNtab+i)= *(Rtab+i);
                                 *(INtab+i)= *(Itab+i);
        	              }

                          for (j=1; j < DimYH; ++j)  
                              {
                                 k1= DimX*j; /* convert  * to + ??? */
                                 k0=DimXxDimY-k1;
                                 for (i=0; i < DimX; ++i)
                                    {
                                       k= k1+i;
                                       *(Rtab+i)= *(InTabReal+k);
                                       *(Itab+i)= *(InTabImagin+k);
		                    }
                                 FFTS0(Rtab, Itab, DimX, SinT, CosT, DimXP, BitRevTable,TypTrans);
                                 for (i=0; i < DimX; ++i)
                                    {
                                       k= k1+i;
                                       k2=k0+i;
                                       buffer= *(Rtab+i);
                                       *(RNtab+k)= buffer;
                                       *(RNtab+k2)= buffer;
                                       buffer= *(Itab+i);
                                       *(INtab+k)= buffer;
                                       *(INtab+k2)= - buffer;
		                    }
			      }

                              k1= DimX*DimYH;
                              for (i=0; i < DimX; ++i)
                                 {
                                    k= k1+i;
                                    *(Rtab+i)= *(InTabReal+k);
                                    *(Itab+i)= *(InTabImagin+k);
	                         }
                              FFTS0(Rtab, Itab, DimX, SinT, CosT, DimXP, BitRevTable,TypTrans);
                              for (i=0; i < DimX; ++i)
                                 {
                                    k= k1+i;
                                    *(RNtab+k)= *(Rtab+i);
                                    *(INtab+k)= *(Itab+i);
                                 }
                           break;
	  }


          BitRevTable=BRTB(DimY,DimYP);
          if (DimX != DimY) CSTB(DimY,TypTrans,&CosT,&SinT);    
          switch (TypTrans){ 
                 case -1: 
                           for (j=0; j < DimX; ++j)  
                              {
                                 *(Rtab)= *(RNtab+j);
                                 *(Itab)= *(INtab+j);
                                 for (i=1; i < DimYH; ++i)
                                    {
                                       k=DimY-i;
                                       k1= DimX*i+j;
                                       buffer= *(RNtab+k1);
                                       *(Rtab+i)=  buffer ;
                                       *(Rtab+k)=  buffer;
                                       buffer= *(INtab+k1);
                                       *(Itab+i)=  buffer ; 
                                       *(Itab+k)=  - buffer ; 
	                            }  
                                 i=DimX*DimYH+j;    
                                 *(Rtab+DimYH)= *(RNtab+i);
                                 *(Itab+DimYH)= *(INtab+i);
                                 FFTS0(Rtab, Itab, DimY, SinT, CosT, DimYP,BitRevTable,TypTrans);                                          
                                 *(RNtab+j)= *(Rtab) * FactNorm2;
                                 *(INtab+j)= *(Itab) * FactNorm2;  
                                 for (i=1; i < DimX; ++i)
                                    {
                                       k= DimX*i;
                                       k1= k+j;
                                          
                                       *(RNtab+k1)= *(Rtab+i) * FactNorm2;
                                       *(INtab+k1)= *(Itab+i) * FactNorm2;   
		                    }  
       	                      }
                           break;     
	         

                 case -2:  
                           optfac0=  -FactNorm2;   
                           for (j=0; j < DimX; ++j)  
                              {
                                 optfac0= -optfac0;
                                 optfac1= optfac0;
                                 *(Rtab)= *(RNtab+j);
                                 *(Itab)= *(INtab+j);
                                 for (i=1; i < DimYH; ++i)
                                    {
                                       k=DimY-i;
                                       k1= DimX*i+j;

                                       buffer= *(RNtab+k1);
                                       *(Rtab+i)=  buffer ;
                                       *(Rtab+k)=  buffer;
                                       buffer= *(INtab+k1);
                                       *(Itab+i)=  buffer ; 
                                       *(Itab+k)=  - buffer ; 
	                            }  
                                 i=DimX*DimYH+j;     
                                 *(Rtab+DimYH)= *(RNtab+i);
                                 *(Itab+DimYH)= *(INtab+i);
                                 FFTS0(Rtab, Itab, DimY, SinT, CosT, DimYP,BitRevTable,TypTrans);
                                 for (i=0; i < DimY; ++i)
                                    {
                                       k= DimX*i+j;         
                                       *(RNtab+k)= *(Rtab+i)  * optfac1 ;
                                       *(INtab+k)= *(Itab+i)  * FactNorm2 ;
                                       optfac1= -optfac1;
                                          
		                    }  
       	                      }
                           break; 

                  case 2:       
                           FactNorm=fn;
                           for (i=0; i < DimY; ++i)
                              {
                                 k= DimX*i;
                                 *(Rtab+i)= *(RNtab+k);
                                 *(Itab+i)= *(INtab+k);
	                      }
                           FFTS0(Rtab, Itab, DimY, SinT, CosT, DimYP, BitRevTable,TypTrans);
                           FactNorm2= FactNorm;
                           for (i=0; i < DimY; ++i)
                              {
                                 k= DimX*i;         
                                 *(RNtab+k)= *(Rtab+i) * FactNorm2;      
                                 *(INtab+k)= *(Itab+i) * FactNorm2;
                                 FactNorm2= -FactNorm2;   
	                      }
                           for (j=1; j < DimXH; ++j){
                                 FactNorm= -FactNorm;
                                 for (i=0; i < DimY; ++i)
                                    {
                                       k= DimX*i+j;
                                       *(Rtab+i)= *(RNtab+k);
                                       *(Itab+i)= *(INtab+k);
		                    }
                                 FFTS0(Rtab, Itab, DimY, SinT, CosT, DimYP, BitRevTable,TypTrans);
                                 l= DimX-j;

                                 buffer= *(Rtab) * FactNorm;
                                 *(RNtab+j)=buffer;
                                 *(RNtab+l)= buffer;
                                 buffer= *(Itab) * FactNorm;   
                                 *(INtab+j)= buffer;
                                 *(INtab+l)= -buffer;  
                                 FactNorm2= -FactNorm;
                                 for (i=1; i < DimY; ++i)
                                    {
                                       k= DimX*i+j;
                                       k1=DimX*(DimY-i)+l;

                                       buffer= *(Rtab+i) * FactNorm2;      
                                       *(RNtab+k)= buffer;      
                                       *(RNtab+k1)= buffer;
                                       buffer= *(Itab+i) * FactNorm2;      
                                       *(INtab+k1)= - buffer;   
                                       *(INtab+k)= buffer;
                                       FactNorm2= -FactNorm2;
		                    }  
			   }
                           for (i=0; i < DimY; ++i){
                               k= DimX*i+DimXH;
                               *(Rtab+i)= *(RNtab+k);
                               *(Itab+i)= *(INtab+k);
		           }
                           FFTS0(Rtab, Itab, DimY, SinT, CosT, DimYP, BitRevTable,TypTrans);
                           FactNorm= -FactNorm;
                           *(RNtab+DimXH)= *(Rtab) * FactNorm;   
                           *(INtab+DimXH)= *(Itab) * FactNorm;   
                           FactNorm2= -FactNorm;
                           for (i=1; i < DimY; ++i){
                              k= DimX*i+DimXH;
                              *(RNtab+k)= *(Rtab+i) * FactNorm2;  
                              *(INtab+k)= *(Itab+i) * FactNorm2;
                              FactNorm2= -FactNorm2;   
		           }      
                           break;
	                       
                 default:       
                           k3 = DimX*DimY;
                           for (i=0; i < DimY; ++i)
                              {
                                 k= DimX*i;
                                 *(Rtab+i)= *(RNtab+k);
                                 *(Itab+i)= *(INtab+k);
	                      }
                           FFTS0(Rtab, Itab, DimY, SinT, CosT, DimYP, BitRevTable,TypTrans);
                           for (i=0; i < DimY; ++i)
                              {
                                 k= DimX*i;         
                                 *(RNtab+k)= *(Rtab+i) * FactNorm;      
                                 *(INtab+k)= *(Itab+i) * FactNorm;   
	                      }
                           for (j=1; j < DimXH; ++j){
                                 for (i=0; i < DimY; ++i)
                                    {
                                       k= DimX*i+j;
                                       *(Rtab+i)= *(RNtab+k);
                                       *(Itab+i)= *(INtab+k);
		                    }
                                 FFTS0(Rtab, Itab, DimY, SinT, CosT, DimYP, BitRevTable,TypTrans);
                                 l= DimX-j;

                                 buffer= *(Rtab) * FactNorm;
                                 *(RNtab+j)=buffer;
                                 *(RNtab+l)= buffer;
                                 buffer= *(Itab) * FactNorm;   
                                 *(INtab+j)= buffer;
                                 *(INtab+l)= -buffer;  
                                 for (i=1; i < DimY; ++i)
                                    {
                                       k0= DimX*i;
                                       k= k0+j;
                                       k1= k3-k0+l;

                                       buffer= *(Rtab+i) * FactNorm;      
                                       *(RNtab+k)= buffer;      
                                       *(RNtab+k1)= buffer;
                                       buffer= *(Itab+i) * FactNorm;      
                                       *(INtab+k1)= - buffer;   
                                       *(INtab+k)= buffer;
		                    }  
			   }
                           for (i=0; i < DimY; ++i){
                               k= DimX*i+DimXH;
                               *(Rtab+i)= *(RNtab+k);
                               *(Itab+i)= *(INtab+k);
		           }
                           FFTS0(Rtab, Itab, DimY, SinT, CosT, DimYP, BitRevTable,TypTrans);
                           *(RNtab+DimXH)= *(Rtab) * FactNorm;   
                           *(INtab+DimXH)= *(Itab) * FactNorm;   
                           for (i=1; i < DimY; ++i){
                              k= DimX*i+DimXH;
                              *(RNtab+k)= *(Rtab+i) * FactNorm;  
                              *(INtab+k)= *(Itab+i) * FactNorm;   
		           }      
                           break;

	  }

	  for ( i = 0; (i < DimXxDimY); ++i){
	      *(*IOutTab + i)= (float) *(INtab + i);
	      *(*ROutTab + i)= (float) *(RNtab + i);
	  }
	  free(INtab);
	  free(RNtab);
	  free(InTabReal);
	  free(InTabImagin);
	  
          return(0);
     }





