/* SCCS @(#)meahiscal.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       meahiscal.layout.c                             */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   meahiscal.layout.c                                  */
/*                                                                      */
/* DESCRIPTION  :   Measures calculate histogram parameters             */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <math.h>

#include "widgetstructure.h"
#include "meahiscal.layout.h"

#include "../define.h"
#include "../global.h"

#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;


void 
HISTO_param_SET_callb (options_OK, Paramprepro, callData)
	Widget options_OK;
	xs_struc_paramprepro *Paramprepro;
	caddr_t callData;
{
	char stitre[30];
	sprintf(stitre, "%d", (int)(rint(dir_desc[index_image[0]].mmax)
					-rint(dir_desc[index_image[0]].mmin)+1));
	XmTextSetString (Paramprepro->alpha, stitre);
	sprintf(stitre, "%d", (int)rint(dir_desc[index_image[0]].mmin));
	XmTextSetString (Paramprepro->line, stitre);
	sprintf(stitre, "%d", (int)rint(dir_desc[index_image[0]].mmax));
	XmTextSetString (Paramprepro->colon, stitre);
}


/********************************************************
/   Creation Function for Meahiscal_param_widget 
/*******************************************************/

xs_struc_paramprepro * 
build_Meahiscal_param_widget(meahiscal)
	Widget meahiscal;
{
	Widget Meahiscal_param_widget;
	Widget param_SET;
	Widget min_limit_label;
	Widget max_limit_label;
	Widget receptors_label;
	Widget min_limit_text;
	Widget max_limit_text;
	Widget receptors_text;
	xs_struc_paramprepro *Paramprepro;
	Arg args[MAX_ARGS];
	int n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));

	Paramprepro->GenerParamparent = meahiscal;

	/* Creating Meahiscal_param_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,246); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,185); n++;
	XtSetArg(args[n],XmNx,27); n++;
	XtSetArg(args[n],XmNy,19); n++;
	XtSetArg(args[n],XmNdialogTitle, 
	XmStringLtoRCreate(panel_titres[121], XmSTRING_DEFAULT_CHARSET)); n++;

	Meahiscal_param_widget =
		XmCreateForm(meahiscal,"Meahiscal_param_widget",args,n);

	Paramprepro->parent = Meahiscal_param_widget;


	/* Creating param_SET Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNbottomPosition,95); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[106],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 20); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition, 80); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 83); n++;

	param_SET = XmCreatePushButton(Meahiscal_param_widget, 
				       "param_SET",args,n);

	XtManageChild(param_SET);

	/* Adding Callbacks for param_SET */ 

	XtAddCallback(param_SET,XmNactivateCallback,
		HISTO_param_SET_callb, Paramprepro);

	/* Creating min_limit_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[203],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,2); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,10); n++;

	min_limit_label = 
	   XmCreateLabel(Meahiscal_param_widget,"min_limit_label",args,n);
	XtManageChild(min_limit_label);

	/* Creating max_limit_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[204],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,2); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,35); n++;

	max_limit_label = 
	   XmCreateLabel(Meahiscal_param_widget,"max_limit_label",args,n);
	XtManageChild(max_limit_label);

	/* Creating receptors_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[205],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,2); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,60); n++;

	receptors_label = 
	   XmCreateLabel(Meahiscal_param_widget,"receptors_label",args,n);
	XtManageChild(receptors_label);

	/* Creating min_limit_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,min_limit_label); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,20); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	min_limit_text = 
	   XmCreateText(Meahiscal_param_widget,"min_limit_text",args,n);
	XtManageChild(min_limit_text);

	Paramprepro->line = min_limit_text;

	/* Creating max_limit_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,max_limit_label); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,45); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	max_limit_text = 
	   XmCreateText(Meahiscal_param_widget,"max_limit_text",args,n);
	XtManageChild(max_limit_text);

	Paramprepro->colon = max_limit_text;

	/* Creating receptors_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,receptors_label); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,70); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	receptors_text = 
	   XmCreateText(Meahiscal_param_widget,"receptors_text",args,n);
	XtManageChild(receptors_text);

	Paramprepro->alpha = receptors_text;

	XtManageChild(Meahiscal_param_widget);

	return(Paramprepro);
}
