/* SCCS @(#)progsmgauss.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       progsmgauss.layout.c                           */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   progsmgauss.layout.c                                */
/*                                                                      */
/* DESCRIPTION  :   Processing Gray Scale Morphology                    */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "progsmgauss.layout.h"
#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;

/********************************************************
/   Creation Function for PRO_gsm_gaussian 
/*******************************************************/

xs_struc_paramprepro
* build_PRO_gsm_gaussian(progsmgauss)
	Widget progsmgauss;
{
	Widget PRO_gsm_gaussian;
	Widget X_text;
	Widget PRO_gauss;
	Widget x_label;
	Widget Amplitude_Label;
	Widget y_Label;
	Widget Amplitude_Text;
	Widget Y_Text;
	xs_struc_paramprepro *Paramprepro;
	Arg args[MAX_ARGS];
	int n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));

	/* Creating PRO_gsm_gaussian Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,220); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,233); n++;
	XtSetArg(args[n],XmNx,31); n++;
	XtSetArg(args[n],XmNy,8); n++;

	PRO_gsm_gaussian = XmCreateForm(progsmgauss,"PRO_gsm_gaussian",args,n);
	XtManageChild(PRO_gsm_gaussian);

	Paramprepro->parent = PRO_gsm_gaussian;

	/* Creating X_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,30); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,68); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,57); n++;
	XtSetArg(args[n],XmNvalue, "1"); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	X_text = XmCreateText(PRO_gsm_gaussian,"X_text",args,n);
	XtManageChild(X_text);

	Paramprepro->line = X_text;

	/* Creating PRO_gauss Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[220],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PRO_gauss = XmCreateLabel(PRO_gsm_gaussian,"PRO_gauss",args,n);
	XtManageChild(PRO_gauss);

	/* Creating x_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[214],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightPosition,28); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,45); n++;

	x_label = XmCreateLabel(PRO_gsm_gaussian,"x_label",args,n);
	XtManageChild(x_label);

	/* Creating Amplitude_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[221],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,20); n++;

	Amplitude_Label = 
	    XmCreateLabel(PRO_gsm_gaussian,"Amplitude_Label",args,n);
	XtManageChild(Amplitude_Label);

	/* Creating y_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[215],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,70); n++;

	y_Label = XmCreateLabel(PRO_gsm_gaussian,"y_Label",args,n);
	XtManageChild(y_Label);

	/* Creating Amplitude_Text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,30); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,68); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,32); n++;
	XtSetArg(args[n],XmNvalue, "4"); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	Amplitude_Text = 
	         XmCreateText(PRO_gsm_gaussian,"Amplitude_Text",args,n);
	XtManageChild(Amplitude_Text);

	Paramprepro->alpha = Amplitude_Text;

	/* Creating Y_Text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,28); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,68); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,82); n++;
	XtSetArg(args[n],XmNvalue, "1"); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	Y_Text = XmCreateText(PRO_gsm_gaussian,"Y_Text",args,n);
	XtManageChild(Y_Text);

	Paramprepro->colon = Y_Text;

	return(Paramprepro);
}
