/* usage.c
 * Print out usage instructions and exit.
 *
 * Peter Webb, Summer 1990
 */

#include <stdio.h>

#include "extern.h"

static char *opt_txt[] = {
  "Order of the files specifies the type of conversion (from-file, to-file)",
  "Currently only conversion to HDF is supported.",
  "-hdf file                        HDF file",
  "-tiff file                       TIFF file",
  "-gif file                        GIF file",
  "-fits file                       FITS file",
  "-xwd file                        X Window dump file",
  "-sunrast file                    Sun Raster file",
  "-raw8 file                       8-bit raw format",
#ifdef XGUI
  "-noGUI                        Don't start the graphical user interface",
  "Also recognizes the standard X command line options, for example:",
  "-geometry =WxH+Xorg+Yorg      Geometry",
  "-fn font-name                 Font specification",
  "-display host:display         X server to use",
#endif
  NULL
};

void usage()
{
  int i = 0;

  fprintf(stderr, "Usage: %s -<type> file -<type> file\n", ProcName);

  while (opt_txt[i] != NULL)
    fprintf(stderr, "  %s\n", opt_txt[i++]);
      
  exit(-1);
}
