
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)abort.c	1.4	(NCSA)	10/6/87";
#endif lint

#include	<signal.h>
#include	<stdio.h>

/*
 *	abort(message, subject, user,cname, exitcode)
 *
 *	Dump a core file and leave it in "cname" suffixed with
 *	the pid of the current process.  Mail "message" to user
 *	saying where the core dump is  with "Subject"
 *	and then terminate with "exitcode" as an exit code.
 *
 *	Based on Ray Essick's nfabort routine
 */

extern char *malloc ();

prog_abort(message, subject, user, cname, exitcode)
char   *message;
char   *subject;
char   *user;
char   *cname;
int     exitcode;
{
    int     mypid;
    int     pid;
    int     rpid;
    int     retcode;
    char    pbuf[256];					/* char buffer */
    char	*p;						/* for message */
	char	*p2;
	char	pbuf2[256];
	char	hname[256];
	FILE	*pip, *popen();

	gethostname(hname, sizeof(hname));

    if (message == NULL)				/* empty */
		message = "";					/* fake one */
    if (cname == NULL || *cname == '\0')		/* make one */
		cname = "core";
    if (subject == NULL || *subject == '\0')		/* title */
		subject = "PROGRAM ABORT";

    mypid = getpid ();

    switch (pid = fork ())
    {
	case -1: 					/* couldn't fork! */
	    fprintf (stderr, "abort() unable to log dump\n");
	    fflush (stderr);
							/* dump core anyway */
	case 0: 					/* child */
	    umask (0);
		signal(SIGIOT,SIG_DFL);
	    abort ();					/* die quick */

	default: 					/* parent */
	    while ((rpid = wait (&retcode)) != pid && rpid != -1);
	    sprintf (pbuf, "/bin/mv core %s.%s.%d", cname, hname, mypid);
	    system (pbuf);				/* move it */
	    sprintf (pbuf, "/bin/chmod 666 %s.%s.%d", cname, hname, mypid);
	    system (pbuf);				/* un-protect it */
	    sprintf (pbuf, "Core image left in %s.%s.%d\n", cname, hname, mypid);
	    p = malloc (strlen (message) + strlen (pbuf) + 4);
	    if (p == NULL)				/* no space */
			p = message;				/* write something */
	    else
			sprintf (p, "%s%s", message, pbuf);

		p2 = pbuf2;

		printf(p);

		if (user == NULL)
			exit(exitcode);

		(void)sprintf(p2,"/usr/ucb/Mail -s \"%s\" %s",subject,user);
		
		pip = popen(p2,"w");

		if (pip != NULL) {
			fprintf(pip,p);
			pclose(pip);
		}
		exit (exitcode);
    }
}
