
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)emulate.c	1.7	(NCSA)	8/12/87";
#endif lint

/*
** Emulation Menu
*/

#include <sys/types.h>
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
#include <sunwindow/notify.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include "session.h"

/*
** used by keyboard handler
*/

caddr_t send_ec();
caddr_t send_el();
caddr_t send_ip();
caddr_t send_ao();
caddr_t send_br();
caddr_t scr_lck();

caddr_t (*tel_fns[6])() = { send_ec, send_el, send_ip, send_ao, send_br,
							scr_lck };

/*
** build the menu
*/

Menu emulmenu;
init_emulate_menu()
{

	extern struct Pixfont *zzbold;
	Menu_item le_proc();
	caddr_t send_ipn();
	caddr_t send_ayt();
	caddr_t send_hn();
	caddr_t togg_le();
	caddr_t term_reset();

	emulmenu = menu_create(MENU_FONT,zzbold,
						   MENU_ITEM,
						   MENU_STRING,"Send 'FTP IP Number'",			/* 1 */
						   MENU_ACTION_PROC,send_ipn,
						   MENU_INACTIVE,TRUE,0,

						   MENU_ITEM,
						   MENU_STRING,"Send 'FTP Hostname'",			/* 2 */
						   MENU_ACTION_PROC,send_hn,
						   MENU_INACTIVE,TRUE,0,

						   MENU_ITEM,
						   MENU_STRING,"",						/* 3 */
						   MENU_INACTIVE,TRUE,0,

						   MENU_ITEM,
						   MENU_STRING,"Send 'Are You There?'",	/* 4 */
						   MENU_ACTION_PROC,send_ayt,
						   MENU_INACTIVE,TRUE,0,

						   MENU_ITEM,
						   MENU_STRING,"Send 'Abort Output'",	/* 5 */
						   MENU_ACTION_PROC,send_ao,
						   MENU_INACTIVE,TRUE,0,

						   MENU_ITEM,
						   MENU_STRING,"Send 'Interrupt Process'",	/* 6 */
						   MENU_ACTION_PROC,send_ip,
						   MENU_INACTIVE,TRUE,0,

						   MENU_ITEM,
						   MENU_STRING,"Send 'Break'",	/* 7 */
						   MENU_ACTION_PROC,send_br,
						   MENU_INACTIVE,TRUE,0,

						   MENU_ITEM,
						   MENU_STRING,"Send 'Erase Character'",	/* 8 */
						   MENU_ACTION_PROC,send_ec,
						   MENU_INACTIVE,TRUE,0,

						   MENU_ITEM,
						   MENU_STRING,"Send 'Erase Line'",	/* 9 */
						   MENU_ACTION_PROC,send_el,
						   MENU_INACTIVE,TRUE,0,

						   MENU_ITEM,
						   MENU_STRING,"Enable Line Mode",		/* 10 */
						   MENU_ACTION_PROC,togg_le,
						   MENU_GEN_PROC, le_proc,
						   MENU_INACTIVE,TRUE,0,

						   MENU_ITEM,
						   MENU_STRING,"",						/* 11 */
						   MENU_INACTIVE,TRUE,0,				

						   MENU_ITEM,
						   MENU_STRING,"Reset Terminal",		/* 12 */
						   MENU_ACTION_PROC,term_reset,
						   MENU_INACTIVE,TRUE,0,
						   0);
}

/*
** mark menu as inactive
*/

invalidate_emul_menu()
{

	int i;

	for (i = (int)menu_get(emulmenu, MENU_NITEMS); i > 0; --i)
		menu_set(menu_get(emulmenu, MENU_NTH_ITEM, i),
				 MENU_INACTIVE,TRUE,0);

}

/*
** mark menu as active
*/

validate_emul_menu()
{

	int i;

	for (i = (int)menu_get(emulmenu, MENU_NITEMS); i > 0; --i)
		menu_set(menu_get(emulmenu, MENU_NTH_ITEM, i),
				 MENU_INACTIVE,FALSE,0);

	/*
	** reinactivate blank entries
	*/

	menu_set(menu_get(emulmenu,MENU_NTH_ITEM,3),MENU_INACTIVE,TRUE);
	menu_set(menu_get(emulmenu,MENU_NTH_ITEM,11),MENU_INACTIVE,TRUE);
}

/*
** procedure to toggle enable/disable message
*/

Menu_item le_proc(mi, op)
Menu_item mi;
Menu_generate op;
{

	switch (op) {
		case MENU_DISPLAY:
			if (Session.s_echo)
				menu_set(mi,MENU_STRING,"Enable Line Mode",0);
			else
				menu_set(mi,MENU_STRING,"Disable Line Mode",0);
			
			break;
		
		case MENU_DISPLAY_DONE:
		case MENU_NOTIFY:
		case MENU_NOTIFY_DONE:
		break;
	}
	return mi;
}

/*
** figure out selection from this menu
*/

Notify_value emulatehandler(item, event)
Panel_item item;
Event *event;
{
	extern Panel menubar;

	/*
	** only process menu on right button down
	*/

	switch (event_id(event)) {

		case MS_RIGHT:
			if (event_is_up(event))
				return;
			menu_show(emulmenu,menubar,event,0);
			break;

		default:
			kbdhandler(Session.s_canvas, event);
			return;
	}

}

/*
** notify procedure for item one -- send ip #
*/

caddr_t send_ipn(m, mi)
Menu m;
Menu_item mi;
{
	struct hostent *hp; 
	struct in_addr s;
	char ftpmsg[260];

	if (Session.s_valid) {

		strcpy(ftpmsg, "ftp ");

		gethostname(&ftpmsg[4], 256);
		hp = gethostbyname(&ftpmsg[4]);

		if (hp == (struct hostent *)0) {
			syserr("gethostbyname");
			return;
		}

		bcopy(hp->h_addr, (char *)&s, hp->h_length);
		strcpy(&ftpmsg[4], inet_ntoa(s));
		strcat(ftpmsg,"\r\n");

		if (!Session.s_echo)
			flushlbuf();

		netwrite(Session.s_winval,ftpmsg,strlen(ftpmsg));

		if (!Session.s_echo)
			VSwrite(Session.s_winval,ftpmsg,strlen(ftpmsg));
	}
}

/*
** notify procedure for item two -- send hostname
*/

caddr_t send_hn(m, mi)
Menu m;
Menu_item mi;
{
	char ftpmsg[260];

	strcpy(ftpmsg,"ftp ");

	if (Session.s_valid) {
		gethostname(&ftpmsg[4], 256);
		strcat(ftpmsg,"\r\n");

		if (!Session.s_echo)
			flushlbuf();

		netwrite(Session.s_winval,ftpmsg,strlen(ftpmsg));

		if (!Session.s_echo)
			VSwrite(Session.s_winval,ftpmsg,strlen(ftpmsg));
	}
}

/*
** notify procedure for item 4 -- send telnet AYT sequence
*/

caddr_t send_ayt(m, mi)
Menu m;
Menu_item mi;
{
	char s[2];

	s[0] = 0377;
	s[1] = 0366;

	netwrite(Session.s_winval, s, 2);
}

/*
** notify procedure for item 5 -- send telnet AO sequence
*/

caddr_t send_ao(m, mi)
Menu m;
Menu_item mi;
{
	char s[2];

	s[0] = 0377;
	s[1] = 0365;

	netwrite(Session.s_winval, s, 2);
}

/*
** notify procedure for item 6 -- send telnet IP sequence
*/

caddr_t send_ip(m, mi)
Menu m;
Menu_item mi;
{
	char s[2];

	s[0] = 0377;
	s[1] = 244;

	netwrite(Session.s_winval, s, 2);
}

/*
** notify procedure for item 7 -- send telnet BR sequence
*/

caddr_t send_br(m, mi)
Menu m;
Menu_item mi;
{
	char s[2];

	s[0] = 0377;
	s[1] = 243;

	netwrite(Session.s_winval, s, 2);
}

/*
** notify procedure for item 8 -- send telnet EC sequence
*/

caddr_t send_ec(m, mi)
Menu m;
Menu_item mi;
{
	char s[2];

	s[0] = 0377;
	s[1] = 247;

	netwrite(Session.s_winval, s, 2);
}

/*
** notify procedure for item 9 -- send telnet EL sequence
*/

caddr_t send_el(m, mi)
Menu m;
Menu_item mi;
{
	char s[2];

	s[0] = 0377;
	s[1] = 248;

	netwrite(Session.s_winval, s, 2);
}

/*
** notify procedure for item 10 -- enable/disable line mode
*/

caddr_t togg_le(m, mi)
Menu m;
Menu_item mi;
{
	char s[3];

	s[0] = 0377;
	s[2] = 1;

	Session.s_echo = !Session.s_echo;
	if (Session.s_echo)
		s[1] = 253;				/* do */
	else
		s[1] = 254;				/* don't */

	netwrite(Session.s_winval, s, 3);
		
}

/*
** notify procedure for item 12 -- reset terminal
*/

caddr_t term_reset(m, mi)
Menu m;
Menu_item mi;
{
	VSreset(Session.s_winval);
}

caddr_t scr_lck()
{
	Session.s_lock = 1;
}
