.bp 1
.so include.n
.he ````
.fo ````
.po 
.nh
.ls 2
.sp 2
.ce
Appendix D
.ce
Examples
.sp 10
Following are several examples of metrics investigated with muTENSOR. They
are the Schwarzschild metric, the Robertson-Walker metric, the Hauser metric,
the Harrison metric and the Kerr metric. Each of these was run on an IBM
AT personal computer; the user input is italicised.
.fo ``-1.%-``
.bp 1
.ls 1
.nf
.cs 1 24
\fRExample 1

muSIMP\-83 4.12 (01/18/85)
MS\-DOS Version
Copyright (C) 1982 The SOFT WAREHOUSE
Licensed by MICROSOFT Corp.
muTENSOR version v3.75 (4.12) 20:10:59  11\-10\-1987
Copyright (C) 1986, 1987 University of Toronto

\fI
.ne 2
%COMMENT
.br
.fi
This muTensor script computes the Ricci tensor for a  spherically
symmetric  metric,  which  is  later  to become the Schwarzschild
metric. We then show that it is a vacuum solution.
Also computed is the Kretschmann scalar.
.br
Below is the line-element in the usual form.
We set the muMATH  system  control  flags  to  fully  expand  all
expressions.
.br
.nf
%

TRGEXPD: NUMDEN: 0$

PWREXPD: 6$

NUMNUM:DENDEN:DENNUM:EXPBAS:BASEXP:30$

ds: f\(**d(t)^2\-d(r)^2/f\-r^2\(**d(th)^2\-r^2\(**SIN(th)^2\(**d(ph)^2;

\fR
@: f (d (t))\*U2\*D \- r\*U2\*D (SIN (th))\*U2\*D (d (ph))\*U2\*D \- r\*U2\*D (d (th))\*U2\*D \- (d (r))\*U2\*D/f

\fI
DEPENDS (f(r))$

.ne 2
%COMMENT
.br
.fi
We  define  the  explicit  form  of  the   Schwarzschild   metric
coefficient for later substitution. 
.br
.nf
%

.(b M
LET (f,1\-2\(**m/r);

\fR
@: 1 \- 2 m/r
.)b

\fI
.ne 2
%COMMENT
.br
.fi
Compute the metric from the line-element, and compute  the  Ricci
tensor. 
.br
.nf
%

.(b M
METRIC(ds);
\fR
computing g
INVERT finished

Elapsed time: 0.93s

@: g
.)b

\fI
.(b M
RICCI();
\fR
computing RIC
computing R
computing C1
CHRISTOFFEL1 finished
computing C2
CHRISTOFFEL2 finished
RIEMANN finished

Elapsed time: 23.01s

@: RIC
.)b

\fI
.ne 2
%COMMENT
.br
.fi
Evaluate the metric coefficients and  display  the  (empty)  Ricci
tensor.
.br
.nf
%

.(b M
MAPFI(EVSUBLET (RIC));
\fR(3 3)
Elapsed time: 2.2s

@: RIC
.)b
\fR
.(b M
\fI
RIC[];
\fR
TYPE:           RICCI
PROTECTION:     2
INDEXED:        TENSOR
MULTIPLIER:     1
COORDS:         (t r th ph)
CONCOV:         (\-1 \-1)
INDICES:        (2 (0 0) (3 3))
SYMMETRY:       ((1 1 2))

@: RIC
.)b

\fI
.ne 2
%COMMENT
.br
.fi
Compute the Kretschmann scalar by fully contracting  the  Riemann
tensor.  A ^  symbol indicates that the attached index is to be
raised or lowered via a metric contraction. The resulting  object
is  stored  as  a  new  entity in the system, and attached to the
parent (R#P seen in the directory below). 
.br
.nf
%
.(b M

kr :: R[a,b,c,d] \(** R[^a,^b,^c,^d];

\fR
kr \(eq R\*Da \*U\*Db \*U\*Dc \*U\*Dd \*U R\*Ua \*D\*Ub \*D\*Uc \*D\*Ud \*D

computing R#P
SHIFT finished
\(**
Elapsed time: 22.63s

@: \-8 f/r\*U4\*D + 4 f\*U2\*D/r\*U4\*D + 4 (f\*Dr\*U)\*U2\*D/r\*U2\*D + 4/r\*U4\*D + (f\*Dr,2\*U)\*U2\*D

.)b
\fI
.(b M
EVSUBLET (kr);
\fR

@: 48 m\*U2\*D/r\*U6\*D
.)b

\fI
.ne 2
%COMMENT
.br
.fi
Simplify  the  Riemann  tensor  with  the  Schwarzschild   metric
coefficients.
.br
.nf
%

.(b M
MAPFI (EVSUBLET (R));
\fR(2 3 2 3)
Elapsed time: 2.15s

@: R
.)b
\fR
.(b M
\fI
R[];
\fR
^:              (FALSE R R#P)
TYPE:           RIEMANN
PROTECTION:     2
INDEXED:        TENSOR
MULTIPLIER:     1
COORDS:         (t r th ph)
CONCOV:         (\-1 \-1 \-1 \-1)
INDICES:        (4 (0 0 0 0) (3 3 3 3))
SYMMETRY:       ((\-1 1 2) (\-1 3 4) (2 1 3))

.)b

R\*D0 \*U\*D1 \*U\*D0 \*U\*D1 \*U \(eq 2 m/r\*U3\*D


R\*D0 \*U\*D2 \*U\*D0 \*U\*D2 \*U \(eq \-m/r + 2 m\*U2\*D/r\*U2\*D


R\*D0 \*U\*D3 \*U\*D0 \*U\*D3 \*U \(eq \-m (SIN (th))\*U2\*D/r + 2 m\*U2\*D (SIN (th))\*U2\*D/r\*U2\*D


R\*D1 \*U\*D2 \*U\*D1 \*U\*D2 \*U \(eq m r/(\-2 m r + r\*U2\*D)


R\*D1 \*U\*D3 \*U\*D1 \*U\*D3 \*U \(eq m r*(SIN (th))\*U2\*D/(\-2 m r + r\*U2\*D)


R\*D2 \*U\*D3 \*U\*D2 \*U\*D3 \*U \(eq \-2 m r*(SIN (th))\*U2\*D


@: R

\fI
.(b M
DIR();
\fR
  name      type       elements prot  coordinates   concov
  R#P       RIEMANN        6     W    (t r th ph)   (1 1 1 1)
  RIC       RICCI          0     W    (t r th ph)   (\-1 \-1)
  R         RIEMANN        6     W    (t r th ph)   (\-1 \-1 \-1 \-1)
  C2        CHRISTOFFEL2   9     W    (t r th ph)   (1 \-1 \-1)
  C1        CHRISTOFFEL1   9     W    (t r th ph)   (\-1 \-1 \-1)
  g#INV     METRIC         4     W    (t r th ph)   (1 1)
  g         METRIC         4     W    (t r th ph)   (\-1 \-1)

 7 object(s),     Total elements: 38

@: TRUE
.)b
\fR
.fo ``-2.%-``
.bp 1
\fRExample 2

muSIMP\-83 4.12 (01/18/85)
MS\-DOS Version
Copyright (C) 1982 The SOFT WAREHOUSE
Licensed by MICROSOFT Corp.
muTENSOR version v3.75 (4.12) 20:10:59  11\-10\-1987
Copyright (C) 1986, 1987 University of Toronto
\fI
.ne 2
%COMMENT
.br
.fi
This muTensor script computes the Weyl conformal curvature tensor 
for the Robertson\-Walker metric to  show  that  the  solution  is
conformally flat. 
We set the muMATH  system  control  flags  to  fully  expand  all
expressions, and convert COS(X)^2 to 1 \- SIN (X)^2.
  
This script was run on an IBM AT.
.br
.nf
%

DENNUM:NUMNUM:DENDEN:EXPBAS:BASEXP:30$

NUMDEN:0$

TRGSQ:4$

.(b M
COORDS : '(t om th ph)&
\fR
@: (t, om, th, ph)
.)b
\fI
.ne 2
%COMMENT
.br
.fi
Below is the line-element in the usual form. We let the  function
s(om) remain general. 
.br
.nf
%

.(b M
ds1 : d(t)^2\-rt^2\(**(d(om)^2+s^2\(**(d(th)^2+SIN(th)^2\(**d(ph)^2));

\fR
@: \-s\*U2\*D rt\*U2\*D (SIN (th))\*U2\*D (d (ph))\*U2\*D \- s\*U2\*D rt\*U2\*D (d (th))\*U2\*D \- rt\*U2\*D (d (om))\*U2\*D + (d (t


	))\*U2\*D

.)b
\fI
DEPENDS (rt(t));

DEPENDS (s(om));

.ne 2
%COMMENT
.br
.fi
Define  the  general  form  of  s(om)  and  substitute  into  the
line-element.
.br
.nf
%

LET (s, SIN(k^(1/2)\(**om)/k^(1/2));

\fR
@: SIN (k\*U(1/2)\*D om)/k\*U(1/2)\*D
\fR
.(b M
\fI
ds1: EVSUBLET (ds1);

\fR
@: \-rt\*U2\*D (SIN (th))\*U2\*D (SIN (k\*U(1/2)\*D om))\*U2\*D (d (ph))\*U2\*D/k \- rt\*U2\*D (SIN (k\*U(1/2)\*D om))\*U2\*D


	(d (th))\*U2\*D/k \- rt\*U2\*D (d (om))\*U2\*D + (d (t))\*U2\*D

.)b
\fI
.ne 2
%COMMENT
.br
.fi
Compute the metric tensor from the line-element and  compute  the
Weyl tensor. 
.br
.nf
%

.(b M
METRIC(ds1);
\fR
computing g
INVERT finished

Elapsed time: 1.76s

@: g
.)b
\fI
.(b M
WEYL();
\fR
computing C
computing R
computing C1
CHRISTOFFEL1 finished
computing C2
CHRISTOFFEL2 finished
RIEMANN finished
computing RIC
RICCI finished
computing RICSC
RICCISC finished
\(**\(** this space is conformally flat

Elapsed time: 58.83s

@: C
.)b
\fI
.ne 2
%COMMENT
.br
.fi
Compute the Einstein tensor and raise its first index to form the 
object called 'G#B'. Note the two independent field equations of 
an isotropic fluid. 
.br
.nf
%

.(b M
EINSTEIN();
\fR
computing G

Elapsed time: 3.3s

@: G
.)b

\fI
.(b M
SHIFT(G[^A,B]);
\fR
computing G#B

Elapsed time: 1.7s


@: G\*Ua \*D\*Db \*U
.)b

\fR
.(b M
\fI
G#B[];
\fR
TYPE:           EINSTEIN
PROTECTION:     2
INDEXED:        TENSOR
MULTIPLIER:     1
COORDS:         (t om th ph)
CONCOV:         (1 \-1)
INDICES:        (2 (0 0) (3 3))
.)b


G\*U0 \*D\*D0 \*U \(eq \-3 k/rt\*U2\*D \- 3 (rt\*Dt\*U)\*U2\*D/rt\*U2\*D


G\*U1 \*D\*D1 \*U \(eq \-k/rt\*U2\*D \- (rt\*Dt\*U)\*U2\*D/rt\*U2\*D \- 2 rt\*Dt,2\*U/rt


G\*U2 \*D\*D2 \*U \(eq \-k/rt\*U2\*D \- (rt\*Dt\*U)\*U2\*D/rt\*U2\*D \- 2 rt\*Dt,2\*U/rt


G\*U3 \*D\*D3 \*U \(eq \-k/rt\*U2\*D \- (rt\*Dt\*U)\*U2\*D/rt\*U2\*D \- 2 rt\*Dt,2\*U/rt


@: G#B

\fI
.(b M
DIR();
\fR
  name      type       elements prot  coordinates   concov
  G#B       EINSTEIN       4     W    (t om th ph)  (1 \-1)
  G         EINSTEIN       4     W    (t om th ph)  (\-1 \-1)
  C         WEYL           0     W    (t om th ph)  (\-1 \-1 \-1 \-1)
  RIC       RICCI          4     W    (t om th ph)  (\-1 \-1)
  R         RIEMANN        6     W    (t om th ph)  (\-1 \-1 \-1 \-1)
  C2        CHRISTOFFEL2   12    W    (t om th ph)  (1 \-1 \-1)
  C1        CHRISTOFFEL1   12    W    (t om th ph)  (\-1 \-1 \-1)
  g#INV     METRIC         4     W    (t om th ph)  (1 1)
  g         METRIC         4     W    (t om th ph)  (\-1 \-1)

 9 object(s),     Total elements: 50
@: TRUE
.)b
\fR
.fo ``-3.%-``
.bp 1
\fRExample 3

muSIMP\-83 4.12 (01/18/85)
MS\-DOS Version
Copyright (C) 1982 The SOFT WAREHOUSE
Licensed by MICROSOFT Corp.
muTENSOR version v3.75 (4.12) 20:10:59  11\-10\-1987
Copyright (C) 1986, 1987 University of Toronto
\fI
.ne 2
%COMMENT
.br
.fi
This muTensor script computes the Ricci tensor for  the  Harrison
II\-A\-7  metric to show that it is a vacuum solution. This example
is  from  d'Inverno,  R.A.,  (1980).  "General   Relativity   and
Gravitation", vol 1., 493. 
The total running\-time on an IBM AT is about 12 min 32 sec.

We set the muMATH  system  control  flags  to  fully  expand  all
expressions.
.br
.nf
%

NUMNUM: DENDEN: DENNUM: EXPBASE: BASEXP: 30$

NUMDEN:2$

PWREXPD: 6$

COORDS : '(t x y w)$   % define the coordinates %
\fR
@: (t, x, y, w)
\fI
.ne 2
%COMMENT
.br
.fi
Below is the line-element in a slightly modified form  from  that
in  the  reference  above. In particular, w\ \(eq\ x/l, where x is the
original coordinate and l is a constant. We have also substituted
s^2\ \(eq\ v^2\ \-\ 1 and j\ \(eq\ w\ \-\ 1  into  the  line-element.  This  is
neccesssary  to  prevent  expression  swell  that would swamp the
system.
.br
.nf
%

.(b M
ds : \-p^(1+a)\(**q^(1+2/a)\(**w^(\-1\-1/a)\(**d(t)^2
	   +p^(2+a)\(**q^(1+2/a)\(**w^(\-1/a)\(**d(x)^2
	   +p^(\-a)\(**q^(\-1)\(**w^(1/a)\(**d(y)^2
	   +l^2\(**p^(3+a)\(**q^(1+2/a)\(**w^(\-2\-1/a)\(**(s^2)/j\(**d(w)^2;

\fR
@: s\*U2\*D p\*U3\*D p\*Ua\*D q q\*U(2/a)\*D l\*U2\*D (d (w))\*U2\*D/(w\*U2\*D w\*U(1/a)\*D j) \- p p\*Ua\*D q q\*U(2/a)\*D (d (t))\*U2\*D/(w


	w\*U(1/a)\*D) + p\*U2\*D p\*Ua\*D q q\*U(2/a)\*D (d (x))\*U2\*D/w\*U(1/a)\*D + w\*U(1/a)\*D (d (y))\*U2\*D/(p\*Ua\*D q)

.)b
\fI
.ne 2
%COMMENT
.br
.fi
We substitute f and  h  as  place\-holders  for  q^(2/a)  and  p^a
respectively.  f and h have no properties whatsoever, that we can
do this is  a  consequence  of  the  fact  mentioned  below:  the
explicit form of p and q is not required. 
.br
.nf
%

LET (q^(2/a), f);
\fR
@: f
\fI
LET (p^a, h);
\fR
@: h
\fI

ds: EVSUBLET (ds);
\fR
@: s\*U2\*D p\*U3\*D q l\*U2\*D f h (d (w))\*U2\*D/(w\*U2\*D w\*U(1/a)\*D j) \- p q f h (d (t))\*U2\*D/(w w\*U(1/a)\*D) + p\*U2\*D


	q f h (d (x))\*U2\*D/w\*U(1/a)\*D + w\*U(1/a)\*D (d (y))\*U2\*D/(q h)

\fI
LET (a^2, 3);
\fR
@: 3
\fI
.ne 2
%COMMENT
.br
.fi
Define the derivatives of p(x,t) and q(w). We will not  need  the
explicit form of p or q. 
.br
.nf
%

DEPENDS (p(x,t))$

DEPENDS (q(w))$

DEPENDS (f(w))$

GRADEF (p,x, x/(6\(**l^2));
\fR
@: p
\fI
GRADEF (p,t, 1/(a\(**l));
\fR
@: p
\fI
GRADEF (q,w, q\(**v/w);
\fR
@: q
\fI
GRADEF (f,w, 2\(**a/3\(**f/q\(**DIF(q,w));
\fR
@: f
\fI
GRADEF (h,x, a\(**h/p\(**DIF(p,x));
\fR
@: h
\fI
GRADEF (h,t, a\(**h/p\(**DIF(p,t));
\fR
@: h
\fI
GRADEF (v,w, (s^2)/(4\(**w)\(**(2\(**v/j+4/a));
\fR
@: v
\fI
GRADEF (s,w, v\(**DIF(v,w)/s);
\fR
@: s
\fI
DEPENDS (j(w))$

GRADEF (j,w,1);

.ne 2
%COMMENT
.br
.fi
Compute the metric from the line-element, the Christoffel symbols 
and the Riemann curvature tensor. 
.br
.nf
%
\fR
computing g
INVERT finished

Elapsed time: 3.35s

@: g
\fI
BASEXP:\-30$

.(b M
CHRISTOFFEL2();
\fR
computing C2
computing C1
CHRISTOFFEL1 finished

Elapsed time: 1m  0.63s

@: C2
.)b
\fI
.(b M
RIEMANN();
\fR
computing R

Elapsed time: 4m  9.96s

@: R
.)b
\fI
.ne 2
%COMMENT
.br
.fi
Delete  the  Christoffel  symbols  to  regain  enough  memory  to
continue the calculation in. 
.br
.nf
%

REM(C1,C2)$

.(b M
RICCI();
\fR
computing RIC

Elapsed time: 3m  24.76s

@: RIC
.)b
\fI
.ne 2
%COMMENT
.br
.fi
Change flags to cause common denominators to be made.
.br
.nf
%

DENNUM: BASEXP:\-30$

LET (v^2,s^2+1);
\fR
@: 1 + s\*U2\*D
\fI
LET (j,w\-1);
\fR
@: \-1 + w
\fI
.ne 2
%COMMENT
.br
.fi
Force common denominatoring of the Ricci  tensor  components  and
make substitutions for v^2 and j. 
.br
.nf
%
.(b M
MAPFI (EXPD (RIC));
\fR

Elapsed time: 2m  45.27s

@: RIC
.)b
\fI

.(b M
MAPFI (EVSUBLET (RIC));
\fR
Elapsed time: 1m  6.63s

@: RIC
.)b
\fI
.(b M
MAPFI(EVSUBLET (RIC));
\fR
Elapsed time: 0.99s

@: RIC
.)b
\fR
.(b M
\fI
RIC[];
\fR
TYPE:           RICCI
PROTECTION:     2
INDEXED:        TENSOR
MULTIPLIER:     1
COORDS:         (t x y w)
CONCOV:         (\-1 \-1)
INDICES:        (2 (0 0) (3 3))
SYMMETRY:       ((1 1 2))

@: RIC
.)b

\fI
.(b M
DIR();
\fR
  name      type       elements prot  coordinates   concov
  RIC       RICCI          0     W    (t x y w)     (\-1 \-1)
  R         RIEMANN        12    W    (t x y w)     (\-1 \-1 \-1 \-1)
  g#INV     METRIC         4     W    (t x y w)     (1 1)
  g         METRIC         4     W    (t x y w)     (\-1 \-1)

 4 object(s),     Total elements: 20
@: TRUE
.)b
\fI
RECLAIM();
\fR
@: 150237
\fR
.fo ``-4.%-``
.bp 1

\fRExample 4

muSIMP\-83 4.12 (01/18/85)
MS\-DOS Version
Copyright (C) 1982 The SOFT WAREHOUSE
Licensed by MICROSOFT Corp.
muTENSOR version v3.75 (4.12) 20:10:59  11\-10\-1987
.ne 2
\fI
%COMMENT
.br
.fi
This muTensor script evaluates the Ricci tensor  for  the  Hauser
metric  to show that the metric is indeed a vacuum solution. This
example is from d'Inverno, R.A.,  Frick,  I.  (1982).  Gen.  Rel.
Grav., 10, 835. 
The total running\-time on an IBM AT is about 15 min 16 sec.

We set the muMATH  system  control  flags  to  fully  expand  all
expressions.
.br
.nf
%

PWREXPD: 6$

COORDS : '(u r x y)&
\fR
@: (u, r, x, y)
\fI
.ne 2
%COMMENT
.br
.fi
Below is the line-element for the metric. The explicit  form  for
the functions b(x,u), c(x,u) and p(x,u) will be substituted after 
the  metric  is  computed.  The  function  f(x,u)  is  not  given
explicitly, only side relations for its partial  derivatives  are
provided. 
.br
.nf
%

ds:  \-2\(**p^2\(**(b^2+c^2)\(**d(u)^2+2\(**p\(**d(u)\(**d(r)\-4\(**p\(**(r\(**b+2\(**c\(**p)\(**d(u)\(**d(x)
	   +(16\(**x\(**p^2\(**(b^2+c^2)+4\(**p\(**(2\(**b\(**p\-r\(**c))\(**d(u)\(**d(y)\-8\(**x\(**p\(**d(r)\(**d(y)
	   \-2\(**(r^2+p^2)\(**d(x)^2+16\(**x\(**p\(**(r\(**b+2\(**c\(**p)\(**d(x)\(**d(y)
	   \-2\(**(r^2+p^2+8\(**x\(**p\(**(2\(**b\(**p\-r\(**c)+16\(**x^2\(**p^2\(**(b^2+c^2))\(**d(y)^2;

\fR
@: 16 b r x p d (x) d (y) \- 4 b r p d (u) d (x) \- 32 b x p\*U2\*D (d (y))\*U2\*D + 8 b


	p\*U2\*D d (u) d (y) + 16 c r x p (d (y))\*U2\*D \- 4 c r p d (u) d (y) + 32 c x p\*U2\*D d


	(x) d (y) \- 8 c p\*U2\*D d (u) d (x) \- 8 x p d (r) d (y) + 2 p d (r) d (u) +


	16 b\*U2\*D x p\*U2\*D d (u) d (y) \- 32 b\*U2\*D x\*U2\*D p\*U2\*D (d (y))\*U2\*D \- 2 b\*U2\*D p\*U2\*D (d (u))\*U2\*D + 16 c\*U2\*D


	x p\*U2\*D d (u) d (y) \- 32 c\*U2\*D x\*U2\*D p\*U2\*D (d (y))\*U2\*D \- 2 c\*U2\*D p\*U2\*D (d (u))\*U2\*D \- 2 r\*U2\*D (d (x)


	)\*U2\*D \- 2 r\*U2\*D (d (y))\*U2\*D \- 2 p\*U2\*D (d (x))\*U2\*D \- 2 p\*U2\*D (d (y))\*U2\*D

\fI
.ne 2
%COMMENT
.br
.fi
Define the side relations for the partial derivatives of f(x,u). 
.br
.nf
%

DEPENDS (f(x,u))$

GRADEF (f,x,\-2\(**u/x\(**DIF(f,u));
\fR
@: f
\fI
GRADEF (f,u,fu);
\fR
@: f
\fI
GRADEF (fu,u,\-3\(**f/(16\(**k));
\fR
@: fu
\fI
GRADEF (fu,x,DIF(f,x,u));
\fR
@: fu
\fI
.ne 2
%COMMENT
.br
.fi
Define the partial derivativs for k(u,x).
.br
.nf
%

DEPENDS (k(u,x))$

GRADEF (k,u, 2\(**u);
\fR
@: k
\fI
GRADEF (k,x, 16\(**x^3);
\fR
@: k
\fI
.ne 2
%COMMENT
.br
.fi
Replace all  occurrences  of  r^2  with  s\-p^2,  where  s  is  an
undefined  function of u,x,r. The actual form of s is not needed.
This substitution causes the determinant of the metric  to  be  a
simple product, simplifying the form of the inverse metric. 
.br
.nf
%

LET (r^2, s \- p^2);
\fR
@: s \- p\*U2\*D
\fI
DEPENDS (s(u,x,r))$

.ne 2
%COMMENT
.br
.fi
Define the partial derivatives of s(u,x,r).
.br
.nf
%

GRADEF (s,u, 4\(**a^2\(**x^3\(**f\(**DIF(f,u));
\fR
@: s
\fI
GRADEF (s,r, 2\(**r);
\fR
@: s
\fI

GRADEF (s,x, 4\(**a^2\(**x^3\(**f\(**DIF(f,x)+3\(**2\(**a^2\(**x^2\(**f^2);
\fR
@: s
\fI
.ne 2
%COMMENT
.br
.fi
Compute the metric tensor from the line-element.
.br
.nf
%

.(b M
METRIC (ds);
\fR
computing g
COFACTOR finished
DETERM finished
INVERT finished

Elapsed time: 1m  3.82s

@: g
.)b
\fI
.ne 2
%COMMENT
.br
.fi
Force simplification of the denominator of the metric inverse and 
replace.
.br
.nf
%

DET: 1/MULTIPLIER (g#INV);
\fR
@: \-8 r\*U2\*D p\*U4\*D \- 4 r\*U4\*D p\*U2\*D \- 4 p\*U6\*D
\fI
DET: EVSUBLET (DET, r^2, s\-p^2);
\fR
@: \-4 s\*U2\*D p\*U2\*D
\fI
MULTIPLIER (g#INV, 1/DET);
\fR
@: \-1/(4 s\*U2\*D p\*U2\*D)
\fI
.ne 2
%COMMENT
.br
.fi
Apply substitutions to the metric and its inverse.
.br
.nf
%

.(b M
MAPFI (EVSUBLET (g));
\fR(3 3)
Elapsed time: 1.04s

@: g
.)b
\fI
.(b M
MAPFI (EVSUBLET (g#INV));
\fR(3 3)
Elapsed time: 8.02s

@: g#INV
.)b
\fI
.ne 2
%COMMENT
.br
.fi
Define the functions b(u,x), c(u,x), p(u,x). (These are defined in
terms of f(u,x)).
.br
.nf
%
\fI
b : u \(** DIF(f,u)/(x\(**f) \- 3/(4\(**x);
\fR
@: u fu/(x f) \- 3/4/x
\fI
c : \-2\(**x\(**DIF(f,u)/f;
\fR
@: \-2 x fu/f
\fI
p : a^3\(**x^(3/2)\(**f;
\fR
@: a\*U3\*D x\*U(3/2)\*D f
\fI
.ne 2
%COMMENT
.br
.fi
Replace all occurances of u^2 with k \- 4 x^4, where k is  defined
above. (k is actually defined as u^2 + 4 x^4). 
Also replace a^4 with 2. This is an artifice to avoid a muMATH bug.
.br
.nf
%

LET (u^2, k\-4\(**x^4);
\fR
@: k \- 4 x\*U4\*D
\fI
LET (a^4, 2);            % a \(eq 2^(1/4)%
\fR
@: 2
\fI
LET (r^2, s \- p^2);
\fR
@: s \- 2 a\*U2\*D x\*U3\*D f\*U2\*D
\fI
.ne 2
%COMMENT
.br
.fi
Apply the above definitions to the metric and its inverse.
.br
.nf
%

.(b M
MAPFI(EVAL (g));
\fR(3 3)
Elapsed time: 5.6s

@: g
.)b
\fI
.(b M
MAPFI(EVAL (g#INV));
\fR(3 3)
Elapsed time: 2.63s

@: g#INV
.)b
\fI
.(b M
MAPFI(EVSUBLET (g));
\fR(3 3)
Elapsed time: 4.61s

@: g
.)b
\fI
.(b M
MAPFI(EVSUBLET (g#INV));
\fR(3 3)
Elapsed time: 2.41s

@: g#INV
.)b
\fI

.ne 2
%COMMENT
.br
.fi
Compute the Christoffel symbols and the Riemann curvature tensor.
.br
.nf
%

.(b M
CHRISTOFFEL1();
\fR
computing C1

Elapsed time: 1m  1.4s

@: C1
.)b
\fI
.(b M
MAPFI(EVSUBLET (C1));
\fR(3 3 2)
Elapsed time: 30.98s

@: C1
.)b
\fI

.(b M
CHRISTOFFEL2();
\fR
computing C2

Elapsed time: 1m  57.1s

@: C2
.)b
\fI
.(b M
MAPFI(EVSUBLET (C2));
\fR(3 3 3)
Elapsed time: 1m  0.25s

@: C2
.)b
\fI
.(b M
RIEMANN();
\fR
computing R

Elapsed time: 7m  4.8s

@: R
.)b
\fI
.(b M
MAPFI(EVSUBLET (R));
\fR(2 3 2 3)
Elapsed time: 1m  28.05s

@: R
.)b
\fI
.(b M
MAPFI(EVSUBLET (R));
\fR(2 3 2 3)
Elapsed time: 16.59s

@: R
.)b
\fR
.(b M
\fI
R[];
\fR
TYPE:           RIEMANN
PROTECTION:     2
INDEXED:        TENSOR
MULTIPLIER:     1
COORDS:         (u r x y)
CONCOV:         (\-1 \-1 \-1 \-1)
INDICES:        (4 (0 0 0 0) (3 3 3 3))
SYMMETRY:       ((\-1 1 2) (\-1 3 4) (2 1 3))
.)b



R\*D0 \*U\*D2 \*U\*D0 \*U\*D3 \*U \(eq \-12 a\*U2\*D u x\*U5\*D f\*U2\*D/k\*U2\*D + 12 a\*U3\*D r x\*U(11/2)\*D f/k\*U2\*D \- 3/2 a\*U3\*D r x\*U(3/2)\*D f/k


R\*D0 \*U\*D2 \*U\*D2 \*U\*D3 \*U \(eq \-96 a\*U2\*D x\*U8\*D f\*U2\*D/k\*U2\*D + 12 a\*U2\*D x\*U4\*D f\*U2\*D/k \- 24 a\*U3\*D r u x\*U(9/2)\*D f/k\*U2\*D


R\*D0 \*U\*D3 \*U\*D0 \*U\*D3 \*U \(eq 24 a\*U2\*D x\*U7\*D f\*U2\*D/k\*U2\*D \- 3 a\*U2\*D x\*U3\*D f\*U2\*D/k + 6 a\*U3\*D r u x\*U(7/2)\*D f/k\*U2\*D

.(b M

R\*D0 \*U\*D3 \*U\*D2 \*U\*D3 \*U \(eq \-48 a\*U2\*D u x\*U6\*D f\*U2\*D/k\*U2\*D + 48 a\*U3\*D r x\*U(13/2)\*D f/k\*U2\*D \- 6 a\*U3\*D r x\*U(5/2)\*D f/k


R\*D2 \*U\*D3 \*U\*D2 \*U\*D3 \*U \(eq \-384 a\*U2\*D x\*U9\*D f\*U2\*D/k\*U2\*D + 48 a\*U2\*D x\*U5\*D f\*U2\*D/k \- 96 a\*U3\*D r u x\*U(11/2)\*D f/k\*U2\*D
.)b

@: R
\fI
.ne 2
%COMMENT
.br
.fi
Delete the Christoffel symbols to free  memory  to  continue  the
calculation.
.br
.nf
%

REM(C1,C2)$

.ne 2
%COMMENT
.br
.fi
Compute the Ricci tensor.
.br
.nf
%


.(b M
RICCI();
\fR
computing RIC
\(**\(** this metric is a vacuum solution.

Elapsed time: 28.4s

@: RIC
.)b
\fR

.(b M
\fI
RIC[];
\fR
TYPE:           RICCI
PROTECTION:     2
INDEXED:        TENSOR
MULTIPLIER:     1
COORDS:         (u r x y)
CONCOV:         (\-1 \-1)
INDICES:        (2 (0 0) (3 3))
SYMMETRY:       ((1 1 2))

@: RIC
.)b
\fI

.ne 2
%COMMENT
.br
.fi
Show a directory of all objects currently in the system.
.br
.nf
%

.(b M
DIR();
\fR
  name      type       elements prot  coordinates   concov
  RIC       RICCI          0     W    (u r x y)     (\-1 \-1)
  R         RIEMANN        6     W    (u r x y)     (\-1 \-1 \-1 \-1)
  g#INV     METRIC         8     W    (u r x y)     (1 1)
  g         METRIC         8     W    (u r x y)     (\-1 \-1)

 4 object(s),     Total elements: 22

@: TRUE
.)b
\fI
RECLAIM();
\fR
@: 157750
\fR
.fo ``-5.%-``
.bp 1
\fRExample 5

muSIMP\-83 4.12 (01/18/85)
MS\-DOS Version
Copyright (C) 1982 The SOFT WAREHOUSE
Licensed by MICROSOFT Corp.
muTENSOR version v3.75 (4.12) 20:10:59  11\-10\-1987
Copyright (C) 1986, 1987 University of Toronto

\fI
.ne 2
%COMMENT
.br
.fi
This  muTENSOR  script  evaluates  the Ricci tensor  for the Kerr
metric in Boyer\-Lindquist coordinates to show that the  metric is
indeed a vacuum solution.
The total cpu running\-time on an IBM AT is about 22 min 40 sec.

Below is the line-element for the metric. The functions  delta(r)
and  rho2(r,th) will remain unevaluated until the Ricci tensor is
computed, however, the derivatives of  these  functions  will  be
evaluated. 
We first turn on the flag which starts the virtual memory system
to illustrate the systems use.
.br
.nf
%

ON (USEDISK)$

ds : \- delta/rho2\(**(d(t)\-a\(**SIN(th)^2\(**d(ph))^2
 + SIN(th)^2/rho2\(**((r^2+a^2)\(**d(ph)\-a \(** d(t))^2
 + rho2/delta \(** d(r)^2+rho2\(**d(th)^2;
\fR     
@: \-delta (\-a (SIN (th))\*U2\*D d (ph) + d (t))\*U2\*D/rho2 + rho2 (d (th))\*U2\*D + rho2 (d 


  (r))\*U2\*D/delta + (\-a d (t) + a\*U2\*D d (ph) + r\*U2\*D d (ph))\*U2\*D (SIN (th))\*U2\*D/rho2
\fI    
.ne 2
%COMMENT
.br
.fi
Define the  general  functions  delta(r),  rho2(r,th)  and  their
derivatives.
.br
.nf
%

DEPENDS (delta(r))$

DEPENDS (rho2(r,th))$

GRADEF (rho2,r, 2\(**r);
\fR     
@: rho2
\fI    
GRADEF (delta,r, 2\(**r\-2\(**m);
\fR     
@: delta
\fI    
GRADEF (rho2,th, \-2\(**a^2\(**SIN(th)\(**COS(th));
\fR     
@: rho2
\fI    
.ne 2
%COMMENT
.br
.fi
Compute the metric tensor from the line-element, and simplify the 
inverse metric. 
.br
.nf
%

.(b M
METRIC (ds);
\fR     
computing g
COFACTOR finished.
DETERM finished.
INVERT finished.

Elapsed time: 11.59s

@: g
.)b
\fI    
PWREXPD:6$

TRGEXPD:2$

NUMNUM:DENDEN:EXPBAS:30$

DENNUM:BASEXP:30$

.ne 2
%COMMENT
.br
.fi
The let rule below is vitally important. It causes sufficient
simplification as to allow the calculation to proceed without
actually needing the virtual memory system. It also speeds the calculation
by a factor of 12.
.br
.nf
%

LET (r^2,SIN(th)^2\(**a^2\-a^2+rho2);
\fR     
@: rho2 + a\*U2\*D (SIN (th))\*U2\*D \- a\*U2\*D
\fI    
DENNUM:BASEXP:\-30$

.(b M
MAPFI(EVSUBLET (g));
\fR(3 3)
Elapsed time: 6.26s

@: g
.)b
\fI    
.(b M
MAPFI(EXPD (g));
\fR(3 3)
Elapsed time: 0.93s

@: g
.)b
\fI    
.(b M
MAPFI(EVSUBLET (g#INV));
\fR(3 3)
Elapsed time: 2m  20.78s

@: g#INV
.)b
\fI    
.(b M
MAPFI(EXPD (g#INV));
\fR(3 3)
Elapsed time: 1.32s

@: g#INV
.)b

\fI    
.ne 2
%COMMENT
.br
.fi
Display the simplified forms of the metric and its inverse.
.br
.nf
%
\fR
.(b M
\fI
g[];
\fR     
PNAME:          g
INDEXED:        TENSOR
COORDS:         (t r th ph)
INDICES:        (2 (0 0) (3 3))
CONCOV:         (\-1 \-1)
MULTIPLIER:     1
TYPE:           METRIC
SYMMETRY:       (((1) 1 2))
^:              (TRUE g g#INV d1)
||:             0
.)b

g\*D0 \*U\*D0 \*U \(eq (\-delta + a\*U2\*D (SIN (th))\*U2\*D)/rho2

g\*D0 \*U\*D3 \*U \(eq (a delta*(SIN (th))\*U2\*D \- a rho2*(SIN (th))\*U2\*D \- a\*U3\*D (SIN (th))\*U4\*D)/rho2

g\*D1 \*U\*D1 \*U \(eq rho2/delta

g\*D2 \*U\*D2 \*U \(eq rho2

g\*D3 \*U\*D3 \*U \(eq (\-a\*U2\*D delta*(SIN (th))\*U4\*D + 2 a\*U2\*D rho2*(SIN (th))\*U4\*D + a\*U4\*D (SIN (th))\*U6\*D + 

   rho2\*U2\*D (SIN (th))\*U2\*D)/rho2

@: g

\fR
.(b M
\fI
g#INV[];
\fR     
PNAME:          g
INDEXED:        TENSOR
COORDS:         (t r th ph)
INDICES:        (2 (0 0) (3 3))
CONCOV:         (1 1)
MULTIPLIER:     1
TYPE:           METRIC
SYMMETRY:       (((1) 1 2))
.)b

g\*U0 \*D\*U0 \*D \(eq (a\*U2\*D delta rho2*(SIN (th))\*U4\*D \- 2 a\*U2\*D rho2\*U2\*D (SIN (th))\*U4\*D \- a\*U4\*D rho2*(SIN 

   (th))\*U6\*D \- rho2\*U3\*D (SIN (th))\*U2\*D)/(delta rho2\*U2\*D (SIN (th))\*U2\*D)

g\*U0 \*D\*U3 \*D \(eq (a delta rho2*(SIN (th))\*U2\*D \- a rho2\*U2\*D (SIN (th))\*U2\*D \- a\*U3\*D rho2*(SIN (th)

   )\*U4\*D)/(delta rho2\*U2\*D (SIN (th))\*U2\*D)

g\*U1 \*D\*U1 \*D \(eq delta/rho2

g\*U2 \*D\*U2 \*D \(eq 1/rho2

g\*U3 \*D\*U3 \*D \(eq (delta rho2 \- a\*U2\*D rho2*(SIN (th))\*U2\*D)/(delta rho2\*U2\*D (SIN (th))\*U2\*D)

@: g#INV

\fI    
DENNUM: BASEXP: 30$

.ne 2
%COMMENT
.br
.fi
Compute the first  and  second  Christoffel  symbols.  The  first
Christoffel  symbols  are  symmetric  in  their  first and second
indices, the second Christoffel symbols are  symmetric  in  their
second and third indices, and have a contravariant first index. 
.br
.nf
%

.(b M
CHRISTOFFEL1();
\fR     
computing C1

Elapsed time: 46.63s

@: C1
.)b
\fI    
.(b M
MAPFI(EVSUBLET (C1));
\fR(3 3 2)
Elapsed time: 24.39s

@: C1
.)b
\fI    
.(b M
CHRISTOFFEL2();
\fR     
computing C2

Elapsed time: 1m  59.19s

@: C2
.)b
\fI    
.(b M
MAPFI(EVSUBLET (C2));
\fR(3 2 3)
Elapsed time: 25.92s

@: C2
.)b
\fI    
.ne 2
%COMMENT
.br
.fi
Compute the fully covariant Riemann curvature tensor. This object 
has the full Riemann symmetry. 
.br
.nf
%

.(b M
RIEMANN();
\fR     
computing R

Elapsed time: 5m  34.55s

@: R
.)b
\fI    
.(b M
MAPFI(EVSUBLET (R));
\fR(2 3 2 3)
Elapsed time: 57.17s

@: R
.)b
\fI    
.ne 2
%COMMENT
.br
.fi
Compute  the  fully  covariant  Ricci  tensor.  This  object   is
symmetric in its two indices. 
.br
.nf
%

.(b M
RICCI();
\fR     
computing RIC

Elapsed time: 5m  44.94s

@: RIC
.)b
\fI    
.ne 2
%COMMENT
.br
.fi
Display the first (unsimplified) component of the  Ricci tensor. 
.br
.nf
%

RIC[0,0];
\fR     
@: \-2 delta r m/rho2\*U3\*D + delta/rho2\*U2\*D \- 2 a\*U2\*D delta/rho2\*U3\*D + 2 a\*U2\*D delta*(COS (


   th))\*U2\*D/rho2\*U3\*D + 2 a\*U2\*D delta*(SIN (th))\*U2\*D/rho2\*U3\*D \- 2 a\*U2\*D r m*(SIN (th))\*U2\*D/rho2\*U3\*D


   + 2 a\*U2\*D delta\*U2\*D/rho2\*U4\*D \- 2 a\*U2\*D delta\*U2\*D (COS (th))\*U2\*D/rho2\*U4\*D \- 2 a\*U2\*D delta\*U2\*D (SIN (


   th))\*U2\*D/rho2\*U4\*D + a\*U2\*D (SIN (th))\*U2\*D/rho2\*U2\*D + 2 a\*U4\*D (COS (th))\*U2\*D (SIN (th))\*U2\*D/rho2\*U3\*D 


   \- 2 a\*U4\*D (SIN (th))\*U2\*D/rho2\*U3\*D + 3 a\*U4\*D (SIN (th))\*U4\*D/rho2\*U3\*D + 2 a\*U6\*D (COS (th))\*U2\*D (


   SIN (th))\*U4\*D/rho2\*U4\*D \- 2 a\*U6\*D (SIN (th))\*U4\*D/rho2\*U4\*D + 2 a\*U6\*D (SIN (th))\*U6\*D/rho2\*U4\*D \- 


   delta\*U2\*D/rho2\*U3\*D
\fI    
.ne 2
%COMMENT
.br
.fi
Force the system to convert each term of the Ricci tensor into a
quotient.
.br
.nf
%

.(b M
MAPFI(EXPD (RIC));
\fR(3 3)
Elapsed time: 1m  8.54s

@: RIC
.)b
\fI    
.ne 2
%COMMENT
.br
.fi
Ignore the denominator of each term and use only the numerator in
future calculations.
.br
.nf
%

.(b M
MAPFI(NUM (RIC));
\fR(3 3)
Elapsed time: 7.96s

@: RIC
.)b
\fI    
PWREXPD:6$  TRGSQ: 4$
NUMNUM:DENDEN:EXPBAS:DENNUM:BASEXP:30$

.ne 2
%COMMENT
.br
.fi
Now define the functions delta(r) and rho2(r,th).
.br
.nf
%

delta: r^2 \- 2\(**m\(**r + a^2;
\fR     
@: \-2 r m + a\*U2\*D + r\*U2\*D
\fI    
rho2: r^2 + a^2 \(** COS (th)^2;
\fR     
@: \-a\*U2\*D (SIN (th))\*U2\*D + a\*U2\*D + r\*U2\*D
\fI    
.ne 2
%COMMENT
.br
.fi
Simplify the Ricci tensor with the above definitions.
.br
.nf
%

.(b M
MAPFI(RIC);
\fR(3 3)
Elapsed time: 2m  48.52s

@: RIC
.)b
\fI    
.ne 2
%COMMENT
.br
.fi
Display the entire Ricci tensor. No values imply that it is zero.
.br
.nf
%

.(b M
RIC[];
\fR     
OFFLOADFILE:    (OFFLOAD MEM FALSE)
PNAME:          RIC
INDEXED:        TENSOR
COORDS:         (t r th ph)
INDICES:        (2 (0 0) (3 3))
CONCOV:         (\-1 \-1)
MULTIPLIER:     1
TYPE:           RICCI
SYMMETRY:       (((1) 1 2))

@: RIC
.)b
\fI    
.ne 2
%COMMENT
.br
.fi
Display a directory of all objects defined in the system.
.br
.nf
%

.(b M
DIR();
\fR     
  name     type       elements prot  coordinates   concov
  RIC      RICCI          0\(**    W    (t r th ph)   (\-1 \-1)
  R        RIEMANN        13\(**   W    (t r th ph)   (\-1 \-1 \-1 \-1)
  C2       CHRISTOFFEL2   20\(**   W    (t r th ph)   (1 \-1 \-1)
  C1       CHRISTOFFEL1   20\(**   W    (t r th ph)   (\-1 \-1 \-1)
  g#INV    METRIC         5     W    (t r th ph)   (1 1)
  g        METRIC         5     W    (t r th ph)   (\-1 \-1)

 6 object(s),     Total elements: 63

@: TRUE
.)b
\fR
