
/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/

#include <gl.h>
#include <device.h>

#include "fdefs.h"

#include "fvars_ext.com"

int gx_ptts0(idims,hbuff,cbuff,palette,fmat)
int idims[4];
unsigned char hbuff[],cbuff[];
unsigned char palette[PALBUFSIZE][3];
float fmat[][3];
{
	int err_ret,num_bytes;
	int num_vert,num_poly;
	unsigned char *rptr[6];
	unsigned char *hptr1,*hptr2,*hptr3;
	unsigned char *cptr1,*cptr2,*cptr3;
	unsigned char *hbuf_ptr,*cbuf_ptr;
	Coord lrsize,btsize,nfsize;
	Screencoord near,far;
	Coord rnear,rfar,ttz;
	VERTEX_STRUCT *vstruct;
	POLY_STRUCT *pstruct;
	float sx,sy,sz;
	float siz_ratio;
	int ix,iy,iscl;
	int *ifo;
	register int i;
	int hcvals[5];
	float fvals[12];
	short dev,val;
	int xsiz,ysiz,hzsiz,czsiz;
	int xsiz3;
	short br,bg,bb;

	err_ret = 0;

	xsiz = idims[0];
	ysiz = idims[1];
	hzsiz = idims[2];
	czsiz = idims[3];
	xsiz3 = xsiz * 3;

	num_vert = xsiz * 2;
	num_poly = (xsiz - 1) * 2;

	num_bytes = num_vert * sizeof(VERTEX_STRUCT);
	vstruct = (VERTEX_STRUCT *)malloc(num_bytes);
	if (!vstruct){
		puts("Not enough memory for vstruct\n");
		exit(1);
	}

	num_bytes = num_poly * sizeof(POLY_STRUCT);
	pstruct = (POLY_STRUCT *)malloc(num_bytes);
	if (!pstruct){
		puts("Not enough memory for pstruct\n");
		exit(1);
	}

	num_bytes = num_poly * sizeof(int) * 3;
	ifo = (int *)malloc(num_bytes);
	if (!ifo){
		puts("Not enough memory for ifo\n");
		exit(1);
	}

	zbuffer(TRUE);
	concave(FALSE);

	lrsize = 1.33333333;
	btsize = 1.0;
/*	nfsize = 1.0;						*/
/*	ortho(-lrsize,lrsize,-btsize,btsize,-nfsize,nfsize); 	*/

	rnear = 5.0;
	rfar = 100.0;
	ttz = -6.5;
	loadmatrix(idmatrix);
	mmode(MVIEWING);
	window(-lrsize,lrsize,-btsize,btsize,rnear,rfar);

	loadmatrix(idmatrix); 
	translate(0.0,0.0,ttz);

/*
	near =  0;
	far  =  32767;
	setdepth(near,far); 
*/
	lsetdepth(0, 0x7fffff);

	iscl = max((xsiz-1),(ysiz-1));
	sx = 1.0 / (float)iscl;
	sy = sx;
	sz = 1.0 / 255.0;

	br = (short)fmat[BKC][0];
	bg = (short)fmat[BKC][1];
	bb = (short)fmat[BKC][2];

	RGBcolor(br,bg,bb);
	clear();
	zclear();

	pushmatrix();
	translate(fmat[TRA][0],fmat[TRA][1],fmat[TRA][2]);
	rot(fmat[ROT][2], 'z');
	rot(fmat[ROT][1], 'y');
	rot(fmat[ROT][0], 'x');
	scale(sx,sy,sz);
	scale(fmat[SCA][0],fmat[SCA][1],fmat[SCA][2]);

	hcvals[0] = xsiz;
	hcvals[1] = ysiz;
	hbuf_ptr = &hbuff[0] + xsiz;
	cbuf_ptr = &cbuff[0] + xsiz3;
	for(iy = (ysiz - 2); iy > 0; iy--){
		if (qtest()){
			dev = qread(&val);
			if (dev == REDRAW){
				qenter(REDRAW,WID);
				err_ret = 1;
				break;
			}
			else if (dev == ESCKEY){
				qenter(ESCKEY,WID);
				err_ret = 1;
				break;
			}
		}
		hptr1 = hbuf_ptr + xsiz;
		hptr2 = hbuf_ptr;

		cptr1 = cbuf_ptr + xsiz3;
		cptr2 = cbuf_ptr;

		hcvals[4] = iy;
		rptr[0] = hptr1;
		rptr[1] = hptr2;
		rptr[3] = cptr1;
		rptr[4] = cptr2;
		gx_pttb0(rptr,hcvals,vstruct,pstruct,ifo);
		gx_pttd0(vstruct,pstruct,ifo,num_vert,num_poly);

		hbuf_ptr = hbuf_ptr + xsiz;
		cbuf_ptr = cbuf_ptr + xsiz3;
	}

	popmatrix();

	free(pstruct);
	free(vstruct);

	return(err_ret);
}

int gx_pttb0(rptr,hcvals,vstruct,pstruct,rlist)
unsigned char *rptr[];
int hcvals[];
VERTEX_STRUCT vstruct[];
POLY_STRUCT pstruct[];
int rlist[];
{
	register int i;
	unsigned char *hbuf1,*hbuf2,*hbuf3;
	unsigned char *cbuf1,*cbuf2,*cbuf3;
	unsigned char *cptr;
	int iy1,iy2,iy3,icv,icp,icr,i1,j,j1;
	int num_vert,num_poly;
	int *vbuf[3],num_bytes;
	int swflag,rv0,rv1,rv2,rv3;
	int hbuf_size,xsiz,ysiz,row_num;
	float xtrans,ytrans;

	hbuf_size = hcvals[0];
	xsiz     = hbuf_size;
	ysiz     = hcvals[1];
	row_num  = hcvals[4];

	hbuf1 = rptr[0];
	hbuf2 = rptr[1];

	cbuf1 = rptr[3];
	cbuf2 = rptr[4];

	num_vert = hbuf_size * 2;
	num_poly = (hbuf_size - 1) * 2;
	swflag = 0;

	xtrans = (float)(xsiz - 1) / 2.0;
	ytrans = (float)(ysiz - 1) / 2.0;

	num_bytes = hbuf_size * sizeof(int);
	vbuf[0] = (int *)malloc(num_bytes);
	vbuf[1] = (int *)malloc(num_bytes);

	iy1 = row_num - 1;
	iy2 = row_num;

	icv = 0;
	j = iy1;
	j1 = j - iy1;
	cptr = &cbuf1[0];
	for(i=0; i<hbuf_size; i++){
		vbuf[j1][i] = icv;
		vstruct[icv].v[0] = (float)i - xtrans;
		vstruct[icv].v[1] = (float)j - ytrans;
		vstruct[icv].v[2] = (float)hbuf1[i];
		vstruct[icv].cv[0] = (long)(*cptr++);
		vstruct[icv].cv[1] = (long)(*cptr++);
		vstruct[icv].cv[2] = (long)(*cptr++);
		icv++;
	}
	j = iy2;
	j1 = j - iy1;
	cptr = &cbuf2[0];
	for(i=0; i<hbuf_size; i++){
		vbuf[j1][i] = icv;
		vstruct[icv].v[0] = (float)i - xtrans;
		vstruct[icv].v[1] = (float)j - ytrans;
		vstruct[icv].v[2] = (float)hbuf2[i];
		vstruct[icv].cv[0] = (long)(*cptr++);
		vstruct[icv].cv[1] = (long)(*cptr++);
		vstruct[icv].cv[2] = (long)(*cptr++);
		icv++;
	}

	icr = 0;
	icp = 0;
	for(j=0; j<1; j++){
		j1 = j + 1;
		for(i=0; i < (hbuf_size - 1); i++){
			i1 = i + 1;
			rv0 = vbuf[j][i];
			rv1 = vbuf[j1][i];
			rv2 = vbuf[j1][i1];
			rv3 = vbuf[j][i1];
			if(swflag){
				pstruct[icp++].vs = icr;
				rlist[icr++] = rv2;
				rlist[icr++] = rv3;
				rlist[icr++] = rv0;
				pstruct[icp++].vs = icr;
				rlist[icr++] = rv1;
				rlist[icr++] = rv2;
				rlist[icr++] = rv0;
				swflag = 0;
			}
			else{
				pstruct[icp++].vs = icr;
				rlist[icr++] = rv1;
				rlist[icr++] = rv3;
				rlist[icr++] = rv0;
				pstruct[icp++].vs = icr;
				rlist[icr++] = rv1;
				rlist[icr++] = rv2;
				rlist[icr++] = rv3;
				swflag = 1;
			}
		}
	}

	free(vbuf[1]);
	free(vbuf[0]);
	return(0);
}

int gx_pttd0(vstruct,pstruct,rlist,num_vert,num_poly)
VERTEX_STRUCT vstruct[];
POLY_STRUCT pstruct[];
int rlist[];
int num_vert,num_poly;
{
	int i;
	int vi,vr1,vr2,vr3,vcr1,vcr2,vcr3;

	for(i=0; i<num_poly; i++){
		vi = pstruct[i].vs;
		vr1 = rlist[vi++];
		vr2 = rlist[vi++];
		vr3 = rlist[vi];

		vcr1 = vstruct[vr1].lut;
		vcr2 = vstruct[vr2].lut;
		vcr3 = vstruct[vr3].lut;

		bgnpolygon();
			c3i(vstruct[vr1].cv);
			v3f(vstruct[vr1].v);
			c3i(vstruct[vr2].cv);
			v3f(vstruct[vr2].v);
			c3i(vstruct[vr3].cv);
			v3f(vstruct[vr3].v);
		endpolygon();

	}

	return(0);
}
