Dore Renderer Driver
--------------------

File: dore_ren.c

Renderer: Dore, from Stardent Inc.

Primitives:
	Intrinsic:
		sphere, cylinder, torus, text, polygon, polyline, 
		polymarker, mesh, bezier patch
	Emulated:
		triangle strip emulated as mesh

Attributes: color, backcull, text-height

Lights: light (at infinity for dynamic renderer), ambient light

Camera handling: complete.

Auxiliary functions: ren_free, ren_dump, ren_setup, and ren_shutdown fully 
	implemented.  ren_reset is a noop.

Hooks:
	ren_dore_objhook returns the Dore object corresponding to a
	given gob:

		DtObject ren_dore_objhook(thisgob)
		gob thisgob;

Comments:
	This 'renderer' is actually an interface into the Dore geometry
	database. 

	Traversal of both the model and lighting dags is done within Dore;
	gobs are transfered to the renderer at definition time and retained 
	there.

	At setup time, if the "open_device" parameter is 0, Dore is not
	initialized (on the assumption that the UI has done so).  Otherwise
	Dore is initialized.  The actual device specified is ignored;
	the Dore device "ardentx11" is always used.

	If the "renderer" parameter is "dore-production" (i.e. if the
	Lisp variable 'p3d-renderer' has that value at initialization time)
	the Dore Production renderer (which is currently a ray tracer) will
	be used.  Otherwise, the Real Time Renderer is used.

	If the Lisp variable 'p3d-hints' contains an assoc list which includes
	a pair containing the symbol 'depth-cue and T, depth cueing will be
	used.  Intensity varies from 100% at the hither clipping plane to
	50% at the yon clipping plane.
