/****************************************************************************
 * colortable.c
 * Author Julie Roskies
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/

#include <stdio.h>
#include <math.h>
#include "struct_defs.h"
#include "err_defs.h"
#include "color_defs.h"

#define CMAXINP 50 	/* maximum length of color input line */

static int loindex, hiindex;

/* Reads in a table of color values */
void add_c_table (c_file, thismodel)
FILE *c_file;
Model *thismodel;

{
	int ind;	/* array index */
	int c;		/* counts succesful conversions of sscanf */
	float r, g, b, a;
        char s[CMAXINP];	/* holds a line of input */

	ger_debug("add_c_table:");

	/* Memory allocation for the color table */
	if ( !(thismodel->color_table= 
			(Color *)malloc(CTABSIZ * sizeof(Color)) ) )
		ger_fatal (
		  "add_c_table: unable to allocate %d bytes",
		  CTABSIZ * sizeof(Color) );

	loindex= CTABSIZ;
	hiindex= 0;

	 while (fgets(s, CMAXINP, c_file)) {
	       	c = sscanf (s, "%d %f %f %f %f", &ind, &r, &g, &b, &a);
		thismodel->color_table[ind].r= r;
		thismodel->color_table[ind].g= g;
		thismodel->color_table[ind].b= b;
		if (c == 5)		/* checking that there is an alpha */
	      	thismodel->color_table[ind].a= a;
		else thismodel->color_table[ind].a= 1.0;
		if (ind < loindex)
		    loindex= ind;
		if (ind > hiindex)
		    hiindex= ind;
              }
}	

static int interpolate (scalar, minscalar, maxscalar)  
float scalar;
float minscalar;
float maxscalar;
{
	float ratio = (hiindex - loindex + 1) / (maxscalar - minscalar);
	float c_distance = scalar - minscalar;

	if (scalar > maxscalar) {
	    fprintf(stderr, "%f out of scalar range, using max value\n", scalar);	
	    return hiindex;
	    } 
	if (scalar < minscalar) {
	    fprintf(stderr, "%f out of scalar range, using min value\n", scalar);	
	    return loindex;
	    } 
	if (scalar == maxscalar)
	    return hiindex;      /* highest scalar will always go out of bounds */
	else
	    return floor( ratio * c_distance + loindex);
}
void add_vertex_color (scalar_data, thismodel, minsca, maxsca)
FILE *scalar_data;
Model *thismodel;
float minsca, maxsca;
{
	float sca;
	int i, ind;
        Vertex *thisvertex;

	ger_debug("add_vertex_color:");

	/* Initializes thisvertex pointer to point to first vertex */
	thisvertex = thismodel->vertex_list;

	/* Fills up vertex_list, vertex by vertex */
	for (i = 0; i<thismodel->vertex_count; i++) {
		fscanf (scalar_data, "%f", &sca);
		ind= interpolate(sca, minsca, maxsca);
		thisvertex->color= create_color();
		thisvertex->color->r = thismodel->color_table[ind].r;	       
		thisvertex->color->g = thismodel->color_table[ind].g;	       
		thisvertex->color->b = thismodel->color_table[ind].b;	       
		thisvertex->color->a = thismodel->color_table[ind].a;
		thisvertex++;
		 }
}
