/* ================================================================== 
    Data.c   This file contains the functions that take care of
    the data structures-  reading the information in, storing it,
    and printing it out.         
   ==================================================================*/

#include "3DHull_structs.h"
#include "3DHull_macros.h"

/*--------------------------------------------------------------------
     Get_from reads the vertices in and puts them in a circular,
  doubly linked list of tvertex structures.  The duplicate pointer is
  set to NULL.
  --------------------------------------------------------------------*/ 
get_from(vl, nv)
struct rvertex *vl;
int nv;
{

        register struct tvertex *new;
	int i;
	struct rvertex *nextv;

	nextv = vl ;
	for (i = 0 ; i < nv ; i++ )	{
		ALLOCATE( new, struct tvertex );
                new->v[X] = nextv->v[X];
                new->v[Y] = nextv->v[Y];
                new->v[Z] = nextv->v[Z];
                new->vnum = 0;
		new->order = 0;
                new->duplicate = NULL;
                new->mark = !MARKED;
                ADD_QUEUE( vertices, new );
		nextv++ ;
                }

}


		
/*-------------------------------------------------------------------
	Send_back sends salem vertex/face information for the computed hull.
  	Allocated space for the convex hull algorithm is also free'd.
  --------------------------------------------------------------------*/
sl_object_data()
{
	register struct tvertex *temp_v, *tvn;
	struct tedge *temp_e, *ten;
        register struct tface   *temp_f, *tfn;
	int	i=0;
 
	temp_v = vertices; 
        temp_f = faces   ;
     	     do {                                 
		if (temp_v->order != 0)		{
			temp_v->vnum = i++;
			sl_vertex( (double) temp_v->v[X],
				(double) temp_v->v[Y], (double) temp_v->v[Z] );
			}
                temp_v = temp_v->next;
                } while ( temp_v != vertices );

             do {                           
		sl_triangle(temp_f->vert[0]->vnum, temp_f->vert[1]->vnum, 
				temp_f->vert[2]->vnum) ;
                temp_f = temp_f->next;
                } while ( temp_f != faces );

/* give back all the memory you took */
	temp_v = vertices->next;
	     do	{
		tvn = temp_v->next;
		DEL_QUEUE(vertices,temp_v);
		temp_v = tvn;
		} while ( temp_v != vertices );
	temp_e = edges->next;
	     do	{
		ten = temp_e->next;
		DEL_QUEUE(edges,temp_e);
		temp_e = ten;
		} while ( temp_e != edges );
	temp_f = faces->next;
	     do	{
		tfn = temp_f->next;
		DEL_QUEUE(faces,temp_f);
		temp_f = tfn;
		} while ( temp_f != faces );
}
