/*====================================================================
    macros.h
 
 	macros used to access data structures and perform quick tests.

  ====================================================================*/

/* general-purpose macros */
#define swap(t,x,y)	{ t = x; x = y; y = t; }

#define ALLOCATE(p,type)if ((p=(type *) malloc (sizeof(type))) == NULL) {\
				printf ("Out of Memory!\n");\
				exit(0);\
			}

#define FREE(p)		if (p) { free ((char *) p); p = NULL; }


#define ADD_QUEUE( head, p )  { if ( head )  { \
                                    p->next = head->next; \
                                    p->prev = head; \
                                    head->next = p; \
                                    p->next->prev = p; \
                                    } \
                                else  \
                                    head->next = head->prev = head = p; \
                              }

#define DEL_QUEUE( head, p )  { if ( head )  { \
                                     if ( head == head->next ) \
                                          head = NULL;  \
                                     else if ( p == head ) \
                                          head = head->next; \
                                     p->next->prev = p->prev;  \
                                     p->prev->next = p->next;  \
                                     FREE( p ); \
                                     } \
                              }

#define volume( vol, f, vt )  {  double x1, y1, z1, x4, y4, z4; \
                                 x1 = f->vert[0]->v[0]; \
                                 y1 = f->vert[0]->v[1]; \
                                 z1 = f->vert[0]->v[2]; \
                                 x4 = vt->v[0] - x1; \
                                 y4 = vt->v[1] - y1; \
                                 z4 = vt->v[2] - z1; \
                                 vol = f->p[X]*x4 + f->p[Y]*y4 + f->p[Z]*z4;\
                              }
