#define MAXLINE 256
#define MAXHISTORY 100

#include <stdio.h>
#include <ctype.h>

struct	hline	{
	int		cnt;
	char	ctext[MAXLINE];
	};

struct History	{
	struct hline alines[MAXHISTORY];
	int hlineno, htot;
	} ;

static struct History history;
static struct History *hp = &history;

int do_history();

initialize_history()
{
	register_client("history", do_history,	" history [NN]");
	notranscribe_last_client();
	hp->hlineno = hp->htot = 0;
}

static char*
fail(s)
char	*s;
{
	fprintf(stderr,"history failed: %s\n",s);
	return NULL;
}

char *
expand_history(s,t)
char *s,*t;
{
	int i,j;
	char te[MAXLINE], p1[MAXLINE], p2[MAXLINE], *sp, special, *p1p, *p2p;
	char *hpt, *tp;
	struct hline *hel;

	sp = s;
	te[0] = '\0';
	tp = te;
	for (i = 0; isdigit(*sp); i++ ) *tp++ = *sp++;
	if ((i != 0) || (s[0] == '!')) 	{
		if (i != 0)	{
			j = 1 + hp->htot - atoi(te) ;
			if ((j < 0) || (j > MAXHISTORY)) return fail(s);
		}
		else	{ sp++; j = 1 ;}
		j =  (j > hp->hlineno) ? MAXHISTORY +hp->hlineno -j: hp->hlineno-j;
	}
	else {
		te[0] = '\0';
		for (i = 0, tp = te; isalnum(*sp); i++) *tp++ = *sp++;
		if (i == 0) return fail(s);
		else	{
			*tp++ = '\0';
			for (j = hp->hlineno - 1 ; j != hp->hlineno ; j-- ) {
				if (j < 0) j += MAXHISTORY;
				if (!strncmp(hp->alines[j].ctext,te,strlen(te))) break;
			}
			if (j == hp->hlineno) return fail(s);
		}
	}
	hel = &hp->alines[j];
	if ((*sp++) != ':')	{ strcpy(t,hel->ctext); return --sp; }
		
	if ((*sp++) == 's') {	/* history with a substitution */
		p1p = p1;	strcpy(p1,"");
		p2p = p2;	strcpy(p2,"");
		for (special = *sp++; (*sp)&&(*sp != special); ) *p1p++ = *sp++;
		*p1p = '\0';
		if ((*sp) == special) sp++; /* digest special */
		while ((*sp) && (*sp !=special)) *p2p++ = *sp++;
		*p2p = '\0';
		for ( i = 0, hpt = hel->ctext ; *hpt ; i++, hpt++ )	
			if (!strncmp(hpt,p1,strlen(p1)))	{
				strcpy(t,"");
				tp = t;	hpt = hel->ctext;
				for ( j = i ; i > 0 ; i-- ) *tp++ = *hpt++;
					/* strncpy(t,hel->ctext, i); */
				for (i=0, p2p = p2; i < strlen(p2); i++ )
					*tp++ = *p2p++;
					/*strncat(t,p2,strlen(p2));*/
				i = j + strlen(p1), hpt += strlen(p1); 
				for ( ; i <= strlen(hel->ctext); i++ )
					*tp++ = *hpt++;
					/*strcat(t,hpt+strlen(p1));*/
				if (*sp == special) sp++;
				return sp;
			}
	}
	return fail(s);
}

record_history(c)
char	c;
{
	struct hline	*hl = &(hp->alines[hp->hlineno]);
	hl->ctext[hl->cnt++] = c;
	if (c == '\0') {
		if (++hp->hlineno == MAXHISTORY) hp->hlineno = 0;
		hp->alines[hp->hlineno].cnt = 0;
		hp->htot++;
	}
}

backup_history() {
	hp->alines[hp->hlineno].cnt--;
}

do_history(argc,argv)
int argc;
char **argv;
{
	int i,j,nlines;
	i = hp->hlineno;
	if (argc > 1)	{
		nlines = atoi(argv[1]);
		if ((nlines > MAXHISTORY) || (nlines < 0))
			nlines = MAXHISTORY;
		}
	else	nlines = MAXHISTORY;
	j = hp->htot + 1 - nlines ;
	do	{
		if (j > 0) printf(" %d\t%s\n",j,hp->alines[i].ctext);
		j++;
		if (++i == MAXHISTORY) i = 0;
		}	while (j <= hp->htot);
}

history_num()
{
	return(1 + hp->htot);
}
