#include "salem.h"

int    read_files();
int    transcript();
int    shell_escape();

initialize_files()
{
	register_client("files",  read_files,   "files file [file...]");
	register_client("transcript",transcript,"transcript [w|a] file");
	notranscribe_last_client();
	register_client("!", shell_escape, "!<csh command>");
}

read_files(argc,argv)
int     argc;
char    **argv;
{
        int     i;
        FILE*   fp;
        if (argc < 2) ERR_RET(" Usage: files file [file...]")
        else for (i = argc - 1; i > 0; i--) {
                if ((fp = fopen(argv[i],"r")) == NULL) error(argv[i]);
                else push_input(fp);
        	}
}

push_input(fp)
FILE* fp;
{
	inputstack_t	*new;
	new = (inputstack_t*) malloc(sizeof(inputstack_t));
	if (!new) fatal("out of memory");
	new->fp = fp;
	new->is_a_tty = isatty(fileno(fp));
	new->link = Input_stack;
	Input_stack = new;
}

pop_input() 
{
	inputstack_t	*old;
	old = Input_stack;
	Input_stack = Input_stack->link;
	free(old);
}

transcribe(argc,argv) 
int argc; 
char** argv; 
{
	int	i, diff;
	if ((argc <= 0)||(!Transcript_fp)) return;
	if (Last_transcript_tick == 0) Last_transcript_tick = Last_tick;
	diff = Last_tick - Last_transcript_tick;
	if (diff > Time_quantum) fprintf(Transcript_fp,"wait %d\n",diff+1);
	Last_transcript_tick = Last_tick;
	for (i = 0; i < argc; i++)
		if ((argv[i][0] == '\0') || (strpbrk(argv[i],"$ \t")))
			fprintf(Transcript_fp,"\"%s\" ",argv[i]);
		else fprintf(Transcript_fp,"%s ",argv[i]);
	fprintf(Transcript_fp,"\n");
}

transcript(argc,argv)
int     argc;
char    **argv;
{
        char*   mode = "w";
        if (argc > 3) ERR_RET("Usage: transcript [w|a] file")
        if (Transcript_fp) fclose(Transcript_fp);
        if (argc > 1) {
                if (argc == 3) mode = argv[1];
                if ((Transcript_fp = fopen(argv[argc - 1],mode)) == NULL) {
                        fprintf(stderr,"transcript: can't open %s mode %s\n",
                                argv[argc - 1],mode);
                	}
        	}
}

shell_escape(argc,argv)
int     argc;
char    **argv;
{
        char    buf[MAXLINE];
	varcat(argc-1,argv+1,buf);
        system(buf);
}
