#include "salem.h"

initialize_exit()
{
	register_client("quit",	clean_exit,	"exit salem");
}

sym_t* 
lookup(string,table)
char	*string;
sym_t	*table;
{
	for( ; table->name ; table++ )
		if (!strncmp(string,table->name,strlen(string))) return(table);
	return((sym_t*)NULL);
}

clean_exit()
{
	gexit();
	fclose(Transcript_fp);
	exit(0);
}

error(msg)
char	*msg;
{
	char	buf[256];
	sprintf(buf,"%s",msg);
	perror(buf);
}

fatal(msg)
char*msg;
{
	error(msg);
	gexit();
	exit(1);
}

FILE *my_fopen(fname, dirname )
char *fname, *dirname;
{
	FILE *file_in;
	char filename[MAXLINE];
	if ((file_in = fopen(fname,"r")) == NULL)	{
		sprintf(filename,"%s/%s",dirname,fname);
		file_in = fopen(filename,"r");
		}
	return(file_in);
}

char* strdup(s)
char	*s;
{
	return (s == NULL)? "" : strcpy(malloc(strlen(s)+1),s);
}

char* varcat(argc,argv,buf)
int		argc;
char	**argv,*buf;
{
	int		i;
	char	*p = buf,*q;

	for (i = 0; i < argc; i++) {
		q = argv[i];
		if (i > 0) *p++ = ' ';
		while (*p = *q++) p++;
	}
	*p = 0;
	return buf;
}

strptrcmp(p0,p1)
char	**p0,**p1;
{ return strcmp(*p0,*p1); }

/* makes argv into sorted list of unique elements and returns new argc */
argsort(argc,argv)
int		argc;
char	**argv;
{
	int		i,j;

	qsort(argv+1,argc-1,sizeof(argv[0]),strptrcmp);
	i = j = 1;
	while (j < argc) {
		argv[i] = argv[j];
		do j++; while ((j < argc) && (!strcmp(argv[i],argv[j])));
		i++;
	}
	return i;
}
